/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.preferences;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ColorButton {
    static int xSize = 42;
    static int ySize = 27;
    static int borderX = 7;
    static int borderY = 6;
    Button button;
    RGB rgb;

    public ColorButton(Composite parent, int style) {
        this.button = new Button(parent, style);
        this.button.setSize(xSize, ySize);
        this.rgb = new RGB(255, 0, 0);
        this.setImage();
    }

    private void setImage() {
        Point point = this.button.getSize();
        PaletteData paletteData = new PaletteData(new RGB[]{this.rgb, new RGB(0, 0, 0)});
        ImageData imageData = new ImageData(point.x - 2 * borderX, point.y - 2 * borderY, 1, paletteData);
        int i = 0;
        while (i < point.x - 2 * borderX) {
            imageData.setPixel(i, 0, 1);
            imageData.setPixel(i, point.y - 2 * borderY - 1, 1);
            ++i;
        }
        i = 0;
        while (i < point.y - 2 * borderY) {
            imageData.setPixel(0, i, 1);
            imageData.setPixel(point.x - 2 * borderX - 1, i, 1);
            ++i;
        }
        this.button.setImage(new Image((Device)this.button.getShell().getDisplay(), imageData));
    }

    public void setColor(RGB rgbIn) {
        this.rgb = rgbIn;
        this.setImage();
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(new RGB(red, green, blue));
    }

    public Shell getShell() {
        return this.button.getShell();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public Color getColor() {
        return new Color((Device)Display.getCurrent(), this.rgb);
    }

    public void setLayoutData(Object layoutData) {
        this.button.setLayoutData(layoutData);
    }

    public void addListener(int eventType, Listener listener) {
        this.button.addListener(eventType, listener);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }
}

