/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.plugin.install.handler;

import com.rsi.idldt.plugin.install.handler.IDLPluginInstallHandlerFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.IPluginEntry;
import org.osgi.framework.Bundle;

public class IDLPluginInstallHandler
extends BaseInstallHandler {
    public void pluginsDownloaded(IPluginEntry[] plugins) throws CoreException {
        super.pluginsDownloaded(plugins);
        this.archivePlugins(plugins);
    }

    private void archivePlugins(IPluginEntry[] plugins) {
        int index = 0;
        while (index < plugins.length) {
            String identifier = plugins[index].getVersionedIdentifier().getIdentifier();
            File file = null;
            Bundle bundle = Platform.getBundle((String)identifier);
            if (bundle != null) {
                try {
                    file = FileLocator.getBundleFile((Bundle)bundle);
                }
                catch (IOException iOException) {}
                if (file == null) {
                    return;
                }
                String filepath = file.getParent();
                Path pluginsDir = new Path(filepath);
                File pdir = pluginsDir.toFile();
                File[] list = pdir.listFiles(new IDLPluginInstallHandlerFileFilter(identifier, plugins[index].getVersionedIdentifier().toString()));
                int index1 = 0;
                while (index1 < list.length) {
                    if (list[index1].isDirectory()) {
                        File archive = new File(pdir, String.valueOf(list[index1].getName()) + ".zip");
                        IDLPluginInstallHandler.createZipFromDirectory(list[index1].getPath(), archive.getPath());
                        try {
                            IDLPluginInstallHandler.deleteDirTree(list[index1], true, true);
                        }
                        catch (Exception exception) {}
                    }
                    ++index1;
                }
            }
            ++index;
        }
    }

    public void configureCompleted(boolean success) throws CoreException {
        String identifier = "com.rsi.idldt.toolpalette";
        Bundle bundle = Platform.getBundle((String)identifier);
        if (bundle != null) {
            IPluginEntry[] plugins = this.feature.getPluginEntries();
            int index = 0;
            while (index < plugins.length) {
                try {
                    String fileName = plugins[index].getVersionedIdentifier() + ".vexpsrch";
                    File tempFile = bundle.getBundleContext().getDataFile(fileName);
                    if (!tempFile.exists()) {
                        tempFile.createNewFile();
                    } else {
                        tempFile.setLastModified(System.currentTimeMillis());
                    }
                }
                catch (IOException iOException) {}
                ++index;
            }
        }
    }

    private static void deleteDirTree(File dir, boolean delete_dir, boolean delete_root) throws FileNotFoundException, IllegalArgumentException {
        File[] filelist = dir.listFiles();
        File tmpFile = null;
        if (filelist != null) {
            int count = 0;
            while (count < filelist.length) {
                tmpFile = filelist[count];
                if (tmpFile.isDirectory()) {
                    IDLPluginInstallHandler.deleteDirTree(tmpFile, delete_dir, true);
                } else if (tmpFile.isFile()) {
                    tmpFile.delete();
                }
                ++count;
            }
        }
        if (delete_dir && delete_root) {
            dir.delete();
        }
    }

    private static void createZipFromDirectory(String inputDir, String outputPath) {
        try {
            FileOutputStream fos = new FileOutputStream(outputPath);
            ZipOutputStream zos = new ZipOutputStream(fos);
            File dir = new File(inputDir);
            if (dir.exists() && dir.isDirectory()) {
                IDLPluginInstallHandler.archiveDirectory(zos, dir, inputDir);
            }
            zos.close();
        }
        catch (Exception exception) {}
    }

    private static void archiveDirectory(ZipOutputStream zos, File directory, String theBaseDir) throws Exception {
        String baseDir = theBaseDir;
        if (directory.isDirectory() && directory.exists()) {
            File[] list = directory.listFiles();
            if (!baseDir.endsWith(File.separator)) {
                baseDir = String.valueOf(baseDir) + File.separator;
            }
            int index = 0;
            while (index < list.length) {
                if (list[index].isDirectory()) {
                    IDLPluginInstallHandler.archiveDirectory(zos, list[index], baseDir);
                } else {
                    IDLPluginInstallHandler.addFileEntry(zos, list[index], baseDir);
                    IDLPluginInstallHandler.addFileToZip(zos, list[index], baseDir);
                }
                ++index;
            }
        }
    }

    private static void addFileEntry(ZipOutputStream zos, File file, String baseDir) throws IOException {
        String fileEntry = file.getPath().substring(baseDir.length() - 1).replace(File.separatorChar, '/');
        ZipEntry zipEntry = new ZipEntry(fileEntry);
        zipEntry.setTime(file.lastModified());
        zos.putNextEntry(zipEntry);
    }

    private static void addFileToZip(ZipOutputStream zos, File file, String baseDir) throws IOException {
        int nRead;
        FileInputStream fis = new FileInputStream(file.getPath());
        byte[] buffer = new byte[1024];
        while ((nRead = fis.read(buffer, 0, buffer.length)) > 0) {
            zos.write(buffer, 0, nRead);
        }
        fis.close();
    }
}

