/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.outputlog;

import com.rsi.idldt.actions.OpenLocalFileAction;
import com.rsi.idldt.internal.ui.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;

public class IDLOutputLogSaveAction
extends ActionDelegate
implements IViewActionDelegate {
    private IConsoleView consoleView;
    private static String m_filterPath = null;

    public void init(IViewPart view) {
        if (view instanceof IConsoleView) {
            this.consoleView = (IConsoleView)view;
        }
    }

    public void run(IAction action) {
        IConsole console;
        if (this.consoleView != null && (console = this.consoleView.getConsole()) instanceof MessageConsole) {
            MessageConsole messageConsole = (MessageConsole)console;
            this.saveAs(messageConsole.getDocument());
        }
    }

    private void saveAs(IDocument document) {
        if (m_filterPath == null) {
            m_filterPath = OpenLocalFileAction.getFilterPath();
        }
        Shell shell = this.consoleView.getSite().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterPath(m_filterPath);
        dialog.setFileName(Messages.OutputLogSaveAction_DefaultFileName);
        String path = dialog.open();
        if (path != null) {
            m_filterPath = dialog.getFilterPath();
            File file = new File(path);
            boolean doSave = true;
            if (file.exists()) {
                try {
                    doSave = this.askForOverwritePermission(shell, file);
                    if (doSave && !file.delete()) {
                        MessageBox box = new MessageBox(shell, 33);
                        box.setText(Messages.SaveAction_ErrorMsgBoxText);
                        box.setMessage(Messages.bind(Messages.SaveAction_ErrorMsgBoxMessage, file.getAbsolutePath()));
                        doSave = false;
                    }
                }
                catch (Exception e) {
                    this.showError(shell, e);
                    doSave = false;
                }
            }
            if (doSave) {
                try {
                    FileOutputStream fout = new FileOutputStream(file);
                    new PrintStream(fout).print(document.get());
                    fout.close();
                }
                catch (Exception e) {
                    this.showError(shell, e);
                }
            }
        }
    }

    private boolean askForOverwritePermission(Shell shell, File file) {
        boolean doSave = true;
        String osName = System.getProperty("os.name");
        if (osName.compareToIgnoreCase("Mac OS X") != 0) {
            MessageBox box = new MessageBox(shell, 200);
            box.setText(Messages.SaveAction_OverwriteMsgBoxText);
            box.setMessage(Messages.bind(Messages.SaveAction_OverwriteMsgBoxMessage, file.getName()));
            doSave = box.open() == 64;
        }
        return doSave;
    }

    private void showError(Shell shell, Exception e) {
        MessageBox box = new MessageBox(shell, 33);
        box.setText(Messages.SaveAction_ShowErrorMsgBoxText);
        box.setMessage(Messages.bind(Messages.SaveAction_ShowErrorMsgBoxMessage, e.getMessage()));
        box.open();
    }
}

