/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.outputlog;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.outputlog.IDLOutputLog;
import java.util.HashSet;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;

public class IDLOutputLogPageParticipant
implements IConsolePageParticipant {
    public void init(IPageBookViewPage page, IConsole console) {
        IOutputLogHandler log = IDLProcessManager.getLogWindowHandler();
        if (log != null && log instanceof IDLOutputLog) {
            IDLOutputLog outputLog = (IDLOutputLog)log;
            outputLog.setControl(page.getControl());
        }
        if (IDLDTCorePlugin.isIDLWorkbenchProduct()) {
            this.removeToolbarItems(page);
            this.removeContextMenuItems(page);
        }
    }

    public void dispose() {
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private void removeToolbarItems(IPageBookViewPage page) {
        IPageSite pageSite = page.getSite();
        IWorkbenchPage workbenchPage = pageSite.getPage();
        IViewPart viewPart = workbenchPage.findView("org.eclipse.ui.console.ConsoleView");
        IViewSite viewSite = viewPart.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        boolean isGroupMarker = false;
        boolean doRemove = false;
        IContributionItem[] contributionItems = toolBarManager.getItems();
        int i = 0;
        while (i < contributionItems.length) {
            isGroupMarker = contributionItems[i].isGroupMarker();
            if (isGroupMarker) {
                doRemove = contributionItems[i].getId().equalsIgnoreCase("fixedGroup");
            }
            if (!isGroupMarker && doRemove) {
                toolBarManager.remove(contributionItems[i]);
            }
            ++i;
        }
        actionBars.updateActionBars();
    }

    private void removeContextMenuItems(IPageBookViewPage page) {
        MenuListener menuListener = new MenuListener(){

            public void menuShown(MenuEvent e) {
                HashSet<String> removalSet = new HashSet<String>(2);
                removalSet.add("org.eclipse.ui.edit.cut");
                removalSet.add("org.eclipse.ui.edit.paste");
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    ActionContributionItem aci;
                    String def;
                    Object o = items[i].getData();
                    if (o instanceof ActionContributionItem && removalSet.contains(def = (aci = (ActionContributionItem)o).getAction().getActionDefinitionId())) {
                        IContributionManager manager = aci.getParent();
                        manager.remove((IContributionItem)aci);
                        manager.update(true);
                        removalSet.remove(def);
                    }
                    ++i;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        };
        page.getControl().getMenu().addMenuListener(menuListener);
    }
}

