/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.outputlog;

import com.rsi.idldt.ui.IDLEditorUtilities;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class IDLOutputLogFileHyperlink
implements IHyperlink {
    String m_fileInfo;

    public IDLOutputLogFileHyperlink(String fileInfo) {
        this.m_fileInfo = fileInfo;
    }

    public void linkActivated() {
        if (this.m_fileInfo == null) {
            return;
        }
        String filename = null;
        String lineStr = null;
        if (Character.isDigit(this.m_fileInfo.charAt(0))) {
            int space = this.m_fileInfo.indexOf(32);
            if (space < 0 || space >= this.m_fileInfo.length() - 1) {
                return;
            }
            filename = this.m_fileInfo.substring(space + 1);
            lineStr = this.m_fileInfo.substring(0, space);
        } else {
            String[] str = this.m_fileInfo.split(", Line ");
            if (str.length < 1) {
                return;
            }
            filename = str[0];
            if (str.length > 1) {
                lineStr = str[1];
            }
        }
        int len = filename.length();
        if (len < 4) {
            return;
        }
        IEditorPart editor = IDLEditorUtilities.openNativeFileInEditor(filename, null);
        if (lineStr != null && editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            IEditorInput editorInput = editor.getEditorInput();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
            try {
                int line = Integer.valueOf(lineStr) - 1;
                int nlines = document.getNumberOfLines();
                if (line >= nlines) {
                    line = nlines - 1;
                }
                int offset = document.getLineOffset(line);
                textEditor.selectAndReveal(offset, 0);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

