/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.outputlog;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.core.utils.Rectangle;
import com.rsi.idldt.outputlog.IDLOutputLogFileHyperlink;
import com.rsi.idldt.proeditor.pro.ProWordFinder;
import com.rsi.idldt.ui.IDLHelpUtilities;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class IDLOutputLog
implements IOutputLogHandler,
ControlListener,
IPropertyChangeListener {
    MessageConsole idlConsole = this.createConsole();
    private MessageConsoleStream stdoutStream = this.idlConsole.newMessageStream();
    private MessageConsoleStream stderrStream = this.idlConsole.newMessageStream();
    private MessageConsoleStream stdinStream = this.idlConsole.newMessageStream();
    private static StyledText textControl;
    private Rectangle consoleRect = new Rectangle(80, 24);
    private boolean m_bSuppressOutput;
    private static final String PREF_CONSOLE_WRAP = "Console.wrap";
    private static final String PREF_CONSOLE_WIDTH = "Console.width";
    private static final String PREF_CONSOLE_TAB_WIDTH = "Console.console_tab_width";
    private static final String PREF_CONSOLE_LIMIT_CONSOLE_OUTPUT = "Console.limitConsoleOutput";
    private static final String PREF_CONSOLE_HIGH_WATER_MARK = "Console.highWaterMark";
    private static final String PREF_CONSOLE_LOW_WATER_MARK = "Console.lowWaterMark";
    private static final String PREF_CONSOLE_SYS_OUT_COLOR = "org.eclipse.debug.ui.outColor";
    private static final String PREF_CONSOLE_SYS_IN_COLOR = "org.eclipse.debug.ui.inColor";
    private static final String PREF_CONSOLE_SYS_ERR_COLOR = "org.eclipse.debug.ui.errorColor";
    private static final String PREF_CONSOLE_OPEN_ON_OUT = "DEBUG.consoleOpenOnOut";
    private static final String PREF_CONSOLE_OPEN_ON_ERR = "DEBUG.consoleOpenOnErr";
    private static final String PREF_CONSOLE_BAKGROUND_COLOR = "org.eclipse.debug.ui.consoleBackground";
    private static final String PREF_CONSOLE_FONT = "org.eclipse.debug.ui.consoleFont";

    public void setControl(Control c) {
        textControl = (StyledText)c;
        if (textControl != null) {
            textControl.addControlListener((ControlListener)this);
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        if (store.getBoolean(PREF_CONSOLE_WRAP)) {
            this.idlConsole.setConsoleWidth(store.getInt(PREF_CONSOLE_WIDTH));
        }
        this.idlConsole.setTabWidth(store.getInt(PREF_CONSOLE_TAB_WIDTH));
        if (store.getBoolean(PREF_CONSOLE_LIMIT_CONSOLE_OUTPUT)) {
            int highWater = store.getInt(PREF_CONSOLE_HIGH_WATER_MARK);
            int lowWater = store.getInt(PREF_CONSOLE_LOW_WATER_MARK);
            this.idlConsole.setWaterMarks(lowWater, highWater);
        }
        this.idlConsole.setFont(JFaceResources.getFont((String)PREF_CONSOLE_FONT));
        Color color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_BAKGROUND_COLOR);
        this.idlConsole.setBackground(color);
        boolean activateOnOut = store.getBoolean(PREF_CONSOLE_OPEN_ON_OUT);
        this.stdoutStream.setActivateOnWrite(activateOnOut);
        boolean activateOnErr = store.getBoolean(PREF_CONSOLE_OPEN_ON_ERR);
        this.stderrStream.setActivateOnWrite(activateOnErr);
        color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_SYS_OUT_COLOR);
        this.stdoutStream.setColor(color);
        color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_SYS_ERR_COLOR);
        this.stderrStream.setColor(color);
        color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_SYS_IN_COLOR);
        this.stdinStream.setColor(color);
        this.wireUpF1ContextHelp();
    }

    protected void wireUpF1ContextHelp() {
        StyledText styledText = textControl;
        styledText.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                IDLOutputLog.showHelp();
            }
        });
    }

    public static void showHelp() {
        String helpTopic = null;
        if (textControl.getSelectionCount() > 0) {
            Point selRange = textControl.getSelectionRange();
            helpTopic = textControl.getTextRange(selRange.x, selRange.y);
        }
        if (helpTopic == null) {
            int caretOffset = textControl.getCaretOffset();
            IRegion region = textControl.getCharCount() - 1 < caretOffset ? null : ProWordFinder.findWord(textControl, caretOffset, true);
            if (region == null || region.getLength() <= 0) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.rsi.idldt.ui.view_console");
                return;
            }
            helpTopic = textControl.getTextRange(region.getOffset(), region.getLength());
        }
        IDLHelpUtilities.helpTopic(helpTopic);
    }

    public StyledText getControl() {
        return textControl;
    }

    public Rectangle getTTYSize() {
        return this.consoleRect;
    }

    public void idlOutput(IIDLProcessProxy idl, int context, String s) {
        if (!this.m_bSuppressOutput) {
            this.print(context == 0 ? this.stdoutStream : this.stderrStream, s);
        }
    }

    public void setSuppressOutput(boolean value) {
        this.m_bSuppressOutput = value;
    }

    public void echoAfterPrompt(IIDLProcessProxy idl, String s) {
        String prompt = idl.getCurrentPrompt();
        if (prompt == null) {
            this.print(this.stdinStream, String.valueOf(s) + "\n");
        } else {
            this.print(this.stdinStream, String.valueOf(prompt) + s + "\n");
        }
    }

    public void transfer(IOutputLogHandler log) {
    }

    public void controlMoved(ControlEvent e) {
    }

    public void computeConsoleRect() {
        int width = 80;
        int height = 24;
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean fixedWidth = store.getBoolean(PREF_CONSOLE_WRAP);
        if (fixedWidth) {
            width = store.getInt(PREF_CONSOLE_WIDTH);
        }
        if (textControl != null) {
            org.eclipse.swt.graphics.Rectangle rect = textControl.getClientArea();
            GC gc = new GC((Drawable)textControl.getParent());
            gc.setFont(textControl.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            if (!fixedWidth) {
                width = rect.width / fontMetrics.getAverageCharWidth();
            }
            height = rect.height / fontMetrics.getHeight();
            gc.dispose();
        }
        if (width == 0) {
            return;
        }
        this.consoleRect.width = width;
        this.consoleRect.height = height;
    }

    public void controlResized(ControlEvent e) {
        this.computeConsoleRect();
        this.setTTYSize(this.consoleRect);
    }

    private IConsoleManager getConsoleManager() {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        return consolePlugin.getConsoleManager();
    }

    private MessageConsole createConsole() {
        IConsoleManager consoleManager = this.getConsoleManager();
        MessageConsole console = new MessageConsole("", null);
        consoleManager.addConsoles(new IConsole[]{console});
        IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
        final String msgPrefix = ps.getString("IDL_MSG_PREFIX");
        console.addPatternMatchListener(new IPatternMatchListener(){

            public int getCompilerFlags() {
                return 0;
            }

            public String getLineQualifier() {
                return "  At: ";
            }

            public String getPattern() {
                return "  At: .*\\.\\w{3,4}(, Line [0-9]*)*";
            }

            public void connect(TextConsole tconsole) {
            }

            public void disconnect() {
            }

            public void matchFound(PatternMatchEvent event) {
                int offset = event.getOffset() + 6;
                int length = event.getLength() - 6;
                try {
                    String fileInfo = IDLOutputLog.this.idlConsole.getDocument().get(offset, length);
                    IDLOutputLog.this.idlConsole.addHyperlink((IHyperlink)new IDLOutputLogFileHyperlink(fileInfo), offset, length);
                }
                catch (BadLocationException badLocationException) {}
            }
        });
        console.addPatternMatchListener(new IPatternMatchListener(){

            public int getCompilerFlags() {
                return 0;
            }

            public String getLineQualifier() {
                return "\\Q" + msgPrefix + "\\E";
            }

            public String getPattern() {
                return "\\Q" + msgPrefix + "\\E[ ]*[_!A-Z].*[ ]+[0-9]+[\n]?[ ](.+\\.pro)|(.+[\n]?.+\\.pro)";
            }

            public void connect(TextConsole tconsole) {
            }

            public void disconnect() {
            }

            public void matchFound(PatternMatchEvent event) {
                int offset = event.getOffset();
                int length = event.getLength();
                try {
                    String fileInfo = IDLOutputLog.this.idlConsole.getDocument().get(offset, length);
                    int i = 0;
                    while (i < length - 1) {
                        char c = fileInfo.charAt(i);
                        if (c == ' ' && Character.isDigit(c = fileInfo.charAt(i + 1))) {
                            fileInfo = fileInfo.substring(i + 1);
                            fileInfo = fileInfo.replaceAll("\\n  ", "");
                            IDLOutputLog.this.idlConsole.addHyperlink((IHyperlink)new IDLOutputLogFileHyperlink(fileInfo), offset += i + 1, length -= i + 1);
                            break;
                        }
                        ++i;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        });
        return console;
    }

    public void setTTYSize(Rectangle rect) {
        IDLProcessManager.setTTYSize((Rectangle)rect);
    }

    private void print(final MessageConsoleStream stream, final String s) {
        if (stream == null) {
            return;
        }
        Thread t = new Thread(null, new Runnable(){

            public void run() {
                stream.print(s);
            }
        }, "IDLOutputLog");
        t.start();
        try {
            t.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        IPreferenceStore store;
        String property = event.getProperty();
        IPreferenceStore iPreferenceStore = store = event.getSource() instanceof IPreferenceStore ? (IPreferenceStore)event.getSource() : null;
        if (property.equals(PREF_CONSOLE_WRAP) || property.equals(PREF_CONSOLE_WIDTH)) {
            boolean fixedWidth = store.getBoolean(PREF_CONSOLE_WRAP);
            if (fixedWidth) {
                int width = store.getInt(PREF_CONSOLE_WIDTH);
                this.idlConsole.setConsoleWidth(width);
            } else {
                this.idlConsole.setConsoleWidth(-1);
            }
            this.computeConsoleRect();
            this.setTTYSize(this.consoleRect);
            return;
        }
        if (property.equals(PREF_CONSOLE_LIMIT_CONSOLE_OUTPUT) || property.equals(PREF_CONSOLE_HIGH_WATER_MARK) || property.equals(PREF_CONSOLE_LOW_WATER_MARK)) {
            boolean limitBufferSize = store.getBoolean(PREF_CONSOLE_LIMIT_CONSOLE_OUTPUT);
            if (limitBufferSize) {
                int lowWater;
                int highWater = store.getInt(PREF_CONSOLE_HIGH_WATER_MARK);
                if (highWater > (lowWater = store.getInt(PREF_CONSOLE_LOW_WATER_MARK))) {
                    this.idlConsole.setWaterMarks(lowWater, highWater);
                }
            } else {
                this.idlConsole.setWaterMarks(-1, -1);
            }
            return;
        }
        if (property.equals(PREF_CONSOLE_TAB_WIDTH)) {
            int tabWidth = store.getInt(PREF_CONSOLE_TAB_WIDTH);
            this.idlConsole.setTabWidth(tabWidth);
            return;
        }
        if (property.equals(PREF_CONSOLE_OPEN_ON_OUT)) {
            boolean activateOnOut = store.getBoolean(PREF_CONSOLE_OPEN_ON_OUT);
            if (this.stdoutStream != null) {
                this.stdoutStream.setActivateOnWrite(activateOnOut);
            }
            return;
        }
        if (property.equals(PREF_CONSOLE_OPEN_ON_ERR)) {
            boolean activateOnErr = store.getBoolean(PREF_CONSOLE_OPEN_ON_ERR);
            if (this.stderrStream != null) {
                this.stderrStream.setActivateOnWrite(activateOnErr);
            }
            return;
        }
        if (property.equals(PREF_CONSOLE_SYS_OUT_COLOR)) {
            if (this.stdoutStream != null) {
                Color color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_SYS_OUT_COLOR);
                this.stdoutStream.setColor(color);
            }
            return;
        }
        if (property.equals(PREF_CONSOLE_SYS_ERR_COLOR)) {
            if (this.stderrStream != null) {
                Color color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_SYS_ERR_COLOR);
                this.stderrStream.setColor(color);
            }
            return;
        }
        if (property.equals(PREF_CONSOLE_SYS_IN_COLOR)) {
            if (this.stdinStream != null) {
                Color color = DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_SYS_IN_COLOR);
                this.stdinStream.setColor(color);
            }
            return;
        }
        if (property.equals(PREF_CONSOLE_FONT)) {
            this.idlConsole.setFont(JFaceResources.getFont((String)PREF_CONSOLE_FONT));
            return;
        }
        if (property.equals(PREF_CONSOLE_BAKGROUND_COLOR)) {
            this.idlConsole.setBackground(DebugUIPlugin.getPreferenceColor((String)PREF_CONSOLE_BAKGROUND_COLOR));
            return;
        }
    }
}

