/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.macros;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.views.CommandLineView;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class MacroAction
extends Action
implements ISelectionListener {
    private IWorkbenchWindow m_window;
    private ITextSelection m_selection;
    private String m_command;
    private boolean m_silent = true;

    public MacroAction(String text, IWorkbenchWindow window, String command) {
        super(text);
        this.m_window = window;
        if (command != null) {
            this.setCommand(command);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.m_selection = (ITextSelection)selection;
        }
    }

    private IEditorPart getActiveEditor() {
        if (this.m_window == null) {
            return null;
        }
        IWorkbenchPage activePage = this.m_window.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    private IPath editorPath() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor == null) {
            return new Path("");
        }
        IEditorInput editorInput = activeEditor.getEditorInput();
        IPath path = IDLEditorUtilities.getEditorsAbsolutePath(editorInput);
        return path != null ? path : new Path("");
    }

    private int getLineOfCaret() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor == null) {
            return 0;
        }
        ITextEditor textEditor = (ITextEditor)activeEditor.getAdapter(ITextEditor.class);
        IEditorInput editorInput = activeEditor.getEditorInput();
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        if (textEditor instanceof ProEditor) {
            int caret = ((ProEditor)textEditor).getCaretOffset();
            try {
                return document.getLineOfOffset(caret);
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }
        ITextSelection select = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        int caret = select.getEndLine() + 1;
        return caret;
    }

    public void run() {
        StringBuffer buffer = new StringBuffer();
        int length = this.m_command.length();
        int i = 0;
        while (i < length) {
            block20: {
                char c;
                block19: {
                    c = this.m_command.charAt(i);
                    if (c != '%' || i >= length - 1) break block19;
                    c = Character.toUpperCase(this.m_command.charAt(++i));
                    switch (c) {
                        case 'F': {
                            buffer.append(this.editorPath().toOSString());
                            break;
                        }
                        case 'P': {
                            buffer.append(this.editorPath().removeLastSegments(1).addTrailingSeparator().toOSString());
                            break;
                        }
                        case 'N': {
                            buffer.append(this.editorPath().removeFileExtension().lastSegment());
                            break;
                        }
                        case 'B': {
                            buffer.append(this.editorPath().lastSegment());
                            break;
                        }
                        case 'S': {
                            if (this.m_selection != null && !this.m_selection.isEmpty()) {
                                buffer.append(this.m_selection.getText());
                                break;
                            }
                            break block20;
                        }
                        case 'L': {
                            buffer.append(this.getLineOfCaret());
                            break;
                        }
                        case '?': {
                            if (this.m_window == null) {
                                return;
                            }
                            InputDialog dialog = new InputDialog(this.m_window.getShell(), Messages.IDLMacrosDialogTitle, Messages.IDLMacrosDialogText, null, null);
                            if (dialog.open() == 0) {
                                buffer.append(dialog.getValue());
                                break;
                            }
                            return;
                        }
                        case '%': {
                            buffer.append('%');
                            break;
                        }
                    }
                    break block20;
                }
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            if (buffer.charAt(buffer.length() - 1) != '\n') {
                buffer.append('\n');
            }
            String cmd = buffer.toString();
            if (this.m_silent) {
                IStatusLineManager statusLineManager = UIPlugin.getStatusLineManager();
                if (statusLineManager != null) {
                    statusLineManager.setMessage(cmd);
                }
                IDLProcessManager.queueSilentExecuteString((String)cmd);
            } else {
                CommandLineView.getInstance().doDropTextIntoCommandLine(cmd, 0);
            }
        }
    }

    public String getCommand() {
        return this.m_command;
    }

    public void setCommand(String command) {
        this.m_command = command.replaceAll("\r\n", " & ");
        if ((this.m_command.indexOf("%s") >= 0 || this.m_command.indexOf("%S") >= 0) && this.m_window != null) {
            this.m_window.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        }
        this.setDescription(String.valueOf(Messages.IDLMacrosCommand) + " " + command);
        this.setToolTipText(command);
    }

    public boolean isSilent() {
        return this.m_silent;
    }

    public void setSilent(boolean silent) {
        this.m_silent = silent;
    }
}

