/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui.views;

import com.rsi.idldt.core.utils.Tracer;
import com.rsi.jdml.KeyboardEvent;
import java.util.AbstractList;
import java.util.Vector;

public class KeyBuffer {
    private final AbstractList<KeyboardEvent> m_keyBuffer;

    public KeyBuffer(int initialSize) {
        this.m_keyBuffer = new Vector<KeyboardEvent>(initialSize);
    }

    public void add(KeyboardEvent e) {
        this.m_keyBuffer.add(e);
        Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)("add: " + this));
    }

    public boolean isEmpty() {
        return this.m_keyBuffer.isEmpty();
    }

    public void remove(int i) {
        this.m_keyBuffer.remove(i);
        Tracer.trace((boolean)Tracer.IS_DEBUGGING, (String)("rem: " + this));
    }

    public KeyboardEvent get(int i) {
        return this.m_keyBuffer.get(i);
    }

    public int size() {
        return this.m_keyBuffer.size();
    }

    public String toString() {
        String s = "[KeyBuffer: ";
        int size = this.size();
        if (size == 0) {
            s = String.valueOf(s) + "empty]";
        } else {
            int i = 0;
            while (i < size) {
                KeyboardEvent e = this.get(i);
                char c = e.getCharacter();
                s = c > '\u001f' && c < '\u0080' ? String.valueOf(s) + c : String.valueOf(s) + "0x" + Integer.toHexString(c);
                s = String.valueOf(s) + " ";
                ++i;
            }
            s = String.valueOf(s) + "]";
        }
        return s;
    }
}

