/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui.views;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCUMember;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMListener;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.views.IDLOutlineContentProvider;
import com.rsi.idldt.internal.ui.views.IDLOutlineLabelProvider;
import com.rsi.idldt.internal.ui.views.ViewToggleAction;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class IDLOutlinePage
extends ContentOutlinePage
implements IPropertyChangeListener,
IIDLDOMListener,
IIDLProcessListener {
    private ProEditor m_editor;
    private IEditorInput m_input;
    private boolean m_linkingEnabled;
    private ViewerComparator m_comparator;
    private ViewToggleAction m_sortAction;
    private ViewToggleAction m_linkAction;
    private IIDLCUMember m_previousNode = null;
    static final String IDL_OUTLINE_PAGE_SORT = "IDL_OUTLINE_PAGE_SORT";
    static final String IDL_OUTLINE_PAGE_NOLINK = "IDL_OUTLINE_PAGE_NOLINK";

    public IDLOutlinePage(IDocumentProvider documentProvider, ProEditor editor) {
        this.m_editor = editor;
        UIPreferenceManager.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.rsi.idldt.ui.view_outline_page");
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new IDLOutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new IDLOutlineLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setAutoExpandLevel(2);
        viewer.setInput((Object)this.m_input);
        IDLProcessManager.addProcessListener((IIDLProcessListener)this);
        this.addAsDOMListener();
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            this.m_sortAction = new ViewToggleAction(Messages.ViewActionSort_Label, UIPlugin.getImageDescriptor("icons/alpha_mode.gif"), IDL_OUTLINE_PAGE_SORT, true);
            toolBarManager.add((IAction)this.m_sortAction);
            this.m_linkAction = new ViewToggleAction(Messages.ViewActionLinkWithEditor_Label, UIPlugin.getImageDescriptor("icons/synced.gif"), IDL_OUTLINE_PAGE_NOLINK, false);
            toolBarManager.add((IAction)this.m_linkAction);
        }
        IPreferenceStore iStore = UIPreferenceManager.getPreferenceStore();
        boolean isSortingEnabled = iStore.getBoolean(IDL_OUTLINE_PAGE_SORT);
        this.setSortingEnabled(isSortingEnabled);
        boolean isLinkingDisabled = iStore.getBoolean(IDL_OUTLINE_PAGE_NOLINK);
        this.setLinkingEnabled(!isLinkingDisabled);
    }

    public IEditorInput getInput() {
        return this.m_input;
    }

    public void setInput(IEditorInput editorInput) {
        TreeViewer viewer;
        this.m_input = editorInput;
        if (editorInput != null && (viewer = this.getTreeViewer()) != null) {
            viewer.setInput((Object)this.m_input);
        }
    }

    public void setLinkingEnabled(boolean enabled) {
        this.m_linkingEnabled = enabled;
        this.m_linkAction.setChecked(enabled);
        if (enabled) {
            int offset = this.m_editor.getCaretOffset();
            this.selectNodeByEditorOffset(offset);
        }
    }

    public void setSortingEnabled(boolean enabled) {
        if (enabled && this.m_comparator == null) {
            this.m_comparator = new ViewerComparator(){

                public int compare(Viewer v, Object s1, Object s2) {
                    IDOMNode d1 = (IDOMNode)s1;
                    IDOMNode d2 = (IDOMNode)s2;
                    if (d1 == null || d2 == null) {
                        return 0;
                    }
                    return d1.getElementName().compareToIgnoreCase(d2.getElementName());
                }
            };
        }
        this.getTreeViewer().setComparator(enabled ? this.m_comparator : null);
        this.m_sortAction.setChecked(enabled);
    }

    private void selectNodeByEditorOffset(int offset) {
        IIDLRoutine node;
        IIDLCompilationUnit cu = IDLEditorUtilities.getEditorsCompilationUnit(this.m_input);
        IIDLRoutine iIDLRoutine = node = cu != null ? cu.getRoutineClosestTo(offset) : null;
        if (node != null) {
            if (this.m_previousNode == node) {
                this.m_previousNode = null;
                return;
            }
            TreeViewer viewer = this.getTreeViewer();
            StructuredSelection ss = (StructuredSelection)viewer.getSelection();
            if (ss == null || !node.equals(ss.getFirstElement())) {
                viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection select = event.getSelection();
        if (select instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)select;
            Object o = ss.getFirstElement();
            if (o instanceof IIDLCUMember) {
                this.m_previousNode = (IIDLCUMember)o;
                ProEditorUtilities.openEditorToNode((IDOMNode)o);
            }
        } else if (this.m_linkingEnabled && select instanceof TextSelection) {
            int offset = ((TextSelection)select).getOffset();
            this.selectNodeByEditorOffset(offset);
        }
        super.selectionChanged(event);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object prop;
        String propName = event.getProperty();
        if (propName.equals(IDL_OUTLINE_PAGE_SORT)) {
            Object prop2 = event.getNewValue();
            if (prop2 != null) {
                boolean isSortingEnabled = (Boolean)prop2;
                this.setSortingEnabled(isSortingEnabled);
            }
        } else if (propName.equals(IDL_OUTLINE_PAGE_NOLINK) && (prop = event.getNewValue()) != null) {
            boolean isLinkingDisabled = (Boolean)prop;
            this.setLinkingEnabled(!isLinkingDisabled);
        }
    }

    public void dispose() {
        UIPreferenceManager.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeAsDOMListener();
        super.dispose();
    }

    private void addAsDOMListener() {
        IIDLDOMManager DOMManager = IDLDOMManager.getActiveManager();
        if (DOMManager != null) {
            DOMManager.addListener((IIDLDOMListener)this);
        }
    }

    private void removeAsDOMListener() {
        IIDLDOMManager DOMManager = IDLDOMManager.getActiveManager();
        if (DOMManager != null) {
            DOMManager.removeListener((IIDLDOMListener)this);
        }
    }

    public void IDLDOMChanged(IIDLDOMManager DOMManager) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                TreeViewer viewer = IDLOutlinePage.this.getTreeViewer();
                if (viewer != null && !viewer.getControl().isDisposed()) {
                    viewer.refresh(true);
                }
            }
        });
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        this.addAsDOMListener();
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }
}

