/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui.views;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class IDLOutlineLabelProvider
implements ILabelProvider {
    private static final String ICONPATH_COMPILATION_UNIT = "icons/pro_file.gif";
    private static final String ICONPATH_PROCEDURE = "icons/procedure.gif";
    private Image m_fileImage = this.createImage("icons/pro_file.gif");
    private Image m_procedureImage = this.createImage("icons/procedure.gif");

    private Image createImage(String location) {
        ImageDescriptor id = UIPlugin.getImageDescriptor(location);
        Image image = id.createImage();
        return image;
    }

    public Image getImage(Object element) {
        if (element instanceof IIDLCompilationUnit) {
            return this.m_fileImage;
        }
        if (element instanceof IIDLRoutine) {
            return this.m_procedureImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IIDLRoutine) {
            String cuName;
            int idxDefine;
            IIDLCompilationUnit cu;
            IIDLRoutine m = (IIDLRoutine)element;
            String name = m.getElementName();
            int index = name.indexOf("::");
            if (index > 0 && (cu = m.getCompilationUnit()) != null && (idxDefine = (cuName = cu.getElementName()).indexOf("__")) == index && cuName.regionMatches(true, 0, name, 0, idxDefine)) {
                name = name.substring(index, name.length());
            }
            if (m.isFunction()) {
                name = String.valueOf(name) + "( )";
            }
            return name;
        }
        if (element instanceof IDOMNode) {
            return ((IDOMNode)element).getElementName();
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.m_fileImage.dispose();
        this.m_procedureImage.dispose();
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

