/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui.views;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.views.CommandLineView;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CommandLineViewResetSessionAction
extends Action
implements IMenuCreator {
    private Menu _menu;
    CommandLineView _view;

    public CommandLineViewResetSessionAction(CommandLineView commandLineView) {
        this._view = commandLineView;
        this.setText(Messages.CommandLineView_ResetMenuText);
        this.setToolTipText(Messages.CommandLineView_ResetToolTip);
        this.setImageDescriptor(UIPlugin.getImageDescriptor("icons/reset.gif"));
        this.setMenuCreator(this);
    }

    public void dispose() {
    }

    public void run() {
        new ResetAction().run();
    }

    public Menu getMenu(Control parent) {
        this._menu = new Menu(parent);
        ResetAction resetAction = new ResetAction();
        ActionContributionItem resetItem = new ActionContributionItem((IAction)resetAction);
        resetItem.fill(this._menu, 0);
        FullResetAction fullResetAction = new FullResetAction();
        ActionContributionItem fullResetItem = new ActionContributionItem((IAction)fullResetAction);
        fullResetItem.fill(this._menu, 1);
        return this._menu;
    }

    public Menu getMenu(Menu parent) {
        return this._menu;
    }

    private class FullResetAction
    extends Action {
        public FullResetAction() {
            this.setText(Messages.CommandLineView_FullResetMenuText);
            this.setToolTipText(Messages.CommandLineView_FullResetToolTip);
        }

        public void run() {
            IIDLProcessProxy process;
            IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
            boolean confirm = ps.getBoolean("IDLDT_COMMAND_LINE_CONFIRM_FULL_RESET");
            boolean doit = true;
            if (confirm) {
                MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CommandLineView_FullResetConfirmTitle, (String)Messages.CommandLineView_FullResetConfirmMessage, (String)Messages.CommandLineView_DontAskMeAgain, (boolean)false, (IPreferenceStore)ps, (String)"IDLDT_COMMAND_LINE_CONFIRM_FULL_RESET");
                boolean bl = doit = dlg.getReturnCode() == 0;
            }
            if (doit && (process = CommandLineViewResetSessionAction.this._view.getIDLProcessProxy()) != null) {
                process.queueSilentExecuteString(".FULL_RESET_SESSION", true);
                process.getLogWindowHandler().echoAfterPrompt(process, ".FULL_RESET_SESSION");
            }
        }
    }

    private class ResetAction
    extends Action {
        public ResetAction() {
            this.setText(Messages.CommandLineView_ResetMenuText);
            this.setToolTipText(Messages.CommandLineView_ResetToolTip);
        }

        public void run() {
            IIDLProcessProxy process;
            IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
            boolean confirm = ps.getBoolean("IDLDT_COMMAND_LINE_CONFIRM_RESET");
            boolean doit = true;
            if (confirm) {
                MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CommandLineView_ResetConfirmTitle, (String)Messages.CommandLineView_ResetConfirmMessage, (String)Messages.CommandLineView_DontAskMeAgain, (boolean)false, (IPreferenceStore)ps, (String)"IDLDT_COMMAND_LINE_CONFIRM_RESET");
                boolean bl = doit = dlg.getReturnCode() == 0;
            }
            if (doit && (process = CommandLineViewResetSessionAction.this._view.getIDLProcessProxy()) != null) {
                process.queueSilentExecuteString(".RESET_SESSION", true);
                process.getLogWindowHandler().echoAfterPrompt(process, ".RESET_SESSION");
            }
        }
    }
}

