/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui.views;

import com.rsi.idldt.core.ICommandHistory;
import com.rsi.idldt.core.ICommandLineHandler;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.internal.ui.CommandLineSourceViewerConfiguration;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.views.CommandLineViewClearAction;
import com.rsi.idldt.internal.ui.views.CommandLineViewResetSessionAction;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.pro.ProWordFinder;
import com.rsi.idldt.proeditor.utils.ProPairMatcher;
import com.rsi.idldt.ui.IDLHelpUtilities;
import com.rsi.idldt.ui.TreeUtils;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import com.rsi.jdml.KeyboardEvent;
import com.rsi.jdml.PlatformSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.IThemeManager;

public class CommandLineView
extends ViewPart
implements ICommandLineHandler,
IPropertyChangeListener,
IIDLProcessListener,
ISizeProvider,
ICompletionListener,
IDocumentListener {
    private static final String CONTENT_ASSIST_COMMAND_ID0 = "com.rsi.idldt.ui.commands.cmdLine.ContentAssist";
    private static final String CONTENT_ASSIST_COMMAND_ID1 = "org.eclipse.ui.edit.text.contentAssist.proposals";
    private static final char[] BRACKETS = new char[]{'(', ')', '[', ']', '{', '}'};
    private CommandLineSourceViewerConfiguration m_sourceViewerConfig;
    StyledText m_cmdLine;
    private ContentAssistant m_contentAssistant;
    private Color m_background = null;
    Label m_promptLabel;
    Composite m_parent;
    IIDLProcessProxy m_idlProcess = IDLProcessManager.getActiveProcess();
    private boolean m_isCreated;
    Action m_cutAction;
    Action m_copyAction;
    Action m_pasteAction;
    SourceViewer m_cmdViewer;
    private ProPairMatcher m_bracketMatcher;
    private MatchingCharacterPainter m_bracketMatcherPainter;
    private IPreferenceStore m_editorPrefStore;
    private boolean m_bShowingContentAssist = false;
    private Vector<String> m_cmdBuffer;
    protected CommandLineView m_instance = this;
    private static HashMap<IWorkbenchWindow, CommandLineView> m_instances = new HashMap();
    private String m_prevTabPhrase = "";
    boolean m_bResetNewTabPhrase = true;
    private boolean m_IsDragAndDropInstalled;
    protected Object m_TextDragAndDropToken;
    CommandLineViewResetSessionAction m_resetAction = null;
    CommandLineViewClearAction m_clearAction = null;
    protected boolean m_bDragStartedFromThisCommandLineView = false;
    private DragSource m_dragSource;
    private DropTarget m_dropTarget;
    private ControlDecoration m_controlDecoration;
    private FieldDecoration m_fieldDecoration;

    public static CommandLineView getInstance() {
        try {
            IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            CommandLineView instance = m_instances.get(wbWindow);
            return instance;
        }
        catch (Exception exception) {
            if (m_instances.size() > 0) {
                Collection<CommandLineView> views = m_instances.values();
                CommandLineView instance = (CommandLineView)((Object)views.toArray()[0]);
                return instance;
            }
            return null;
        }
    }

    protected IWorkbenchWindow getWorkbenchWindow(Composite parent) {
        IWorkbenchWindow[] wbws;
        Shell ourShell = parent.getShell();
        IWorkbenchWindow[] iWorkbenchWindowArray = wbws = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = wbws.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbw = iWorkbenchWindowArray[n2];
            if (wbw.getShell() == ourShell) {
                return wbw;
            }
            ++n2;
        }
        return wbws[wbws.length - 1];
    }

    public void createPartControl(Composite parent) {
        IWorkbenchWindow wbWindow = this.getWorkbenchWindow(parent);
        m_instances.put(wbWindow, this.m_instance);
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener((IPropertyChangeListener)this);
        IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
        this.m_editorPrefStore = new ProEditor().getPrefStore();
        ps.addPropertyChangeListener((IPropertyChangeListener)this);
        this.m_editorPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("com.rsi.idldt.ui.commandLineFont");
        this.m_parent = parent;
        GridLayout layout = new GridLayout(2, false);
        this.m_parent.setLayout((Layout)layout);
        this.m_promptLabel = new Label(this.m_parent, 0);
        this.m_promptLabel.setFont(font);
        String prompt = ps.getString("IDL_PROMPT");
        if (prompt.length() == 0) {
            prompt = Messages.InitialPrompt;
        }
        this.m_promptLabel.setText(prompt);
        this.m_cmdViewer = new SourceViewer(this.m_parent, null, 2048);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.m_cmdViewer.getControl(), "com.rsi.idldt.ui.view_command_line");
        Document document = new Document();
        this.m_cmdViewer.setDocument((IDocument)document);
        document.addDocumentListener((IDocumentListener)this);
        boolean enableBracketMatching = this.m_editorPrefStore.getBoolean("matchingBrackets");
        this.m_bracketMatcher = new ProPairMatcher(BRACKETS);
        this.m_bracketMatcherPainter = new MatchingCharacterPainter((ISourceViewer)this.m_cmdViewer, (ICharacterPairMatcher)this.m_bracketMatcher);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.m_editorPrefStore, (String)"matchingBracketsColor");
        this.m_bracketMatcherPainter.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), rgb));
        if (enableBracketMatching) {
            this.m_cmdViewer.addPainter((IPainter)this.m_bracketMatcherPainter);
        }
        TextViewerUndoManager undoManager = new TextViewerUndoManager(25);
        undoManager.connect((ITextViewer)this.m_cmdViewer);
        this.m_cmdViewer.setUndoManager((IUndoManager)undoManager);
        this.m_cmdLine = this.m_cmdViewer.getTextWidget();
        this.initContentAssistDecoration();
        this.m_cmdLine.setFont(font);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.m_cmdLine.setLayoutData((Object)gridData);
        this.m_cmdLine.setDoubleClickEnabled(true);
        if (this.m_sourceViewerConfig == null) {
            this.m_sourceViewerConfig = new CommandLineSourceViewerConfiguration(this);
            boolean enable = ps.getBoolean("IDLDT_COMMAND_LINE_ENABLE_COLORING");
            if (!enable) {
                this.m_sourceViewerConfig.setEnableColoring(enable);
            }
            this.m_contentAssistant = (ContentAssistant)this.m_sourceViewerConfig.getContentAssistant((ISourceViewer)this.m_cmdViewer);
        }
        this.m_cmdViewer.configure((SourceViewerConfiguration)this.m_sourceViewerConfig);
        this.m_contentAssistant.addCompletionListener((ICompletionListener)this);
        this.handleBackgroundColorPreference();
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_cmdViewer);
        final Action undoAction = new Action(){

            public void run() {
                CommandLineView.this.m_cmdViewer.doOperation(1);
            }
        };
        Action redoAction = new Action(){

            public void run() {
                CommandLineView.this.m_cmdViewer.doOperation(2);
            }
        };
        this.m_cutAction = new Action(){

            public void run() {
                CommandLineView.this.m_cmdViewer.doOperation(3);
            }
        };
        ISharedImages images = this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.m_cutAction.setText(Messages.CommandLineView_CutText);
        this.m_cutAction.setToolTipText(Messages.CommandLineView_CutText);
        this.m_cutAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_CUT"));
        this.m_cutAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.m_copyAction = new Action(){

            public void run() {
                CommandLineView.this.m_cmdViewer.doOperation(4);
            }
        };
        this.m_copyAction.setText(Messages.CommandLineView_CopyText);
        this.m_copyAction.setToolTipText(Messages.CommandLineView_CopyText);
        this.m_copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.m_copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_pasteAction = new Action(){

            public void run() {
                CommandLineView.this.m_cmdViewer.doOperation(5);
            }
        };
        this.m_pasteAction.setText(Messages.CommandLineView_PasteText);
        this.m_pasteAction.setToolTipText(Messages.CommandLineView_PasteText);
        this.m_pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.m_pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.hookContextMenu((Viewer)this.m_cmdViewer);
        this.createToolBar();
        this.m_cmdLine.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                CommandLineView.this.handleVerifyKey(event);
            }
        });
        this.m_cmdLine.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                UIPlugin.getContextManager().activateContext("com.rsi.idldt.ui.cmdLineContext", true);
                CommandLineView.this.updateContentAssistToolTip();
                if (CommandLineView.this.m_instance != IDLProcessManager.getCommandLineHandler()) {
                    IDLProcessManager.setCommandLineHandler((ICommandLineHandler)CommandLineView.this.m_instance);
                }
            }

            public void focusLost(FocusEvent e) {
                UIPlugin.getContextManager().activateContext("com.rsi.idldt.ui.cmdLineContext", false);
            }
        });
        this.m_cmdLine.setFocus();
        this.m_cmdViewer.addPostSelectionChangedListener(new ISelectionChangedListener((IUndoManager)undoManager, redoAction){
            private final /* synthetic */ IUndoManager val$undoManager;
            private final /* synthetic */ Action val$redoAction;
            {
                this.val$undoManager = iUndoManager;
                this.val$redoAction = action2;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                undoAction.setEnabled(this.val$undoManager.undoable());
                this.val$redoAction.setEnabled(this.val$undoManager.redoable());
                boolean canCut = CommandLineView.this.m_cmdViewer.canDoOperation(3);
                CommandLineView.this.m_cutAction.setEnabled(canCut);
                boolean canCopy = CommandLineView.this.m_cmdViewer.canDoOperation(4);
                CommandLineView.this.m_copyAction.setEnabled(canCopy);
            }
        });
        IViewSite site = this.getViewSite();
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redoAction);
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.m_cutAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.m_copyAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_pasteAction);
        this.wireUpF1ContextHelp();
        this.installDragAndDrop();
        IDLProcessManager.setCommandLineHandler((ICommandLineHandler)this);
        IDLProcessManager.addProcessListener((IIDLProcessListener)this);
        this.m_isCreated = true;
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.m_clearAction = new CommandLineViewClearAction(this);
        mgr.add((IAction)this.m_clearAction);
        this.m_resetAction = new CommandLineViewResetSessionAction(this);
        mgr.add((IAction)this.m_resetAction);
    }

    public void doDropTextIntoCommandLine(String text, int dropOffset) {
        int dropLength = 0;
        try {
            this.m_cmdViewer.getDocument().replace(dropOffset, dropLength, text);
            if (text.indexOf(10) == -1) {
                int newDropOffset = dropOffset + text.length();
                Point ptCursor = this.m_cmdLine.getLocationAtOffset(newDropOffset);
                this.m_cmdLine.getCaret().setLocation(ptCursor);
                this.m_cmdLine.getCaret().setVisible(true);
                this.m_cmdViewer.setRangeIndication(newDropOffset, 0, true);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void wireUpF1ContextHelp() {
        StyledText styledText = this.m_cmdLine;
        styledText.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                CommandLineView.this.showHelp();
            }
        });
    }

    public void enableContentAssistAutoInsert(boolean value) {
        this.m_sourceViewerConfig.enableContentAssistAutoInsert(value);
        if (this.m_contentAssistant != null) {
            this.m_contentAssistant.enableAutoInsert(value);
        }
    }

    public void showHelp() {
        IDocument document = this.m_cmdViewer.getDocument();
        ISelection selection = this.m_cmdViewer.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        int offset = ((ITextSelection)selection).getOffset();
        IRegion region = ProWordFinder.findWord(document, offset, true);
        if (region == null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.rsi.idldt.ui.view_command_line");
            return;
        }
        int length = region.getLength();
        if (length <= 0) {
            return;
        }
        try {
            String name = document.get(region.getOffset(), length);
            IDLHelpUtilities.helpTopic(name);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    public void dispose() {
        super.dispose();
        this.m_isCreated = false;
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener((IPropertyChangeListener)this);
        if (IDLProcessManager.getCommandLineHandler() == this) {
            IDLProcessManager.setCommandLineHandler(null);
        }
        if (this.m_background != null) {
            this.m_background.dispose();
        }
        if (this.m_dropTarget != null) {
            this.m_dropTarget.dispose();
        }
        if (this.m_dragSource != null) {
            this.m_dragSource.dispose();
        }
        this.removeInstance();
        this.m_instance = null;
    }

    protected void removeInstance() {
        Collection<CommandLineView> views = m_instances.values();
        Set<IWorkbenchWindow> windows = m_instances.keySet();
        int i = 0;
        IWorkbenchWindow foundWindow = null;
        for (CommandLineView v : views) {
            if (v == this.m_instance) {
                foundWindow = (IWorkbenchWindow)windows.toArray()[i];
                break;
            }
            ++i;
        }
        if (foundWindow != null) {
            m_instances.remove(foundWindow);
        }
    }

    public void setFocus() {
        this.m_cmdLine.setFocus();
    }

    public void setSelectionStart() {
        if (this.m_cmdLine != null) {
            this.m_cmdLine.setSelection(0);
        }
    }

    public void setSelectionEnd() {
        if (this.m_cmdLine != null) {
            this.m_cmdLine.setSelection(this.m_cmdLine.getCharCount());
        }
    }

    private void eraseText(boolean toEnd) {
        if (this.m_cmdLine != null) {
            int offset = this.m_cmdLine.getCaretOffset();
            String command = this.m_cmdLine.getText();
            if (command == null || offset < 0) {
                return;
            }
            int beginIndex = toEnd ? 0 : offset;
            int endIndex = toEnd ? offset : command.length();
            command = command.substring(beginIndex, endIndex);
            this.m_cmdLine.setText(command);
            this.m_cmdLine.setSelection(toEnd ? this.m_cmdLine.getCharCount() : 0);
        }
    }

    public void eraseToStart() {
        this.eraseText(false);
    }

    public void eraseToEnd() {
        this.eraseText(true);
    }

    public void documentChanged(DocumentEvent event) {
        Display d;
        boolean bContainsCR;
        String text = event.getText();
        boolean bl = bContainsCR = text.indexOf(10) > -1;
        if (bContainsCR && (d = PlatformUI.getWorkbench().getDisplay()) != null && !d.isDisposed()) {
            d.asyncExec(new Runnable(){

                public void run() {
                    CommandLineView.this.handleMultiLinePaste();
                }
            });
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    void handleVerifyKey(VerifyEvent e) {
        if (!e.doit) {
            return;
        }
        if (this.m_bShowingContentAssist && (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.character == '\r')) {
            return;
        }
        if (!this.m_bShowingContentAssist && e.character != '\t') {
            this.m_bResetNewTabPhrase = true;
        }
        if (e.character == '\r' && e.stateMask == 0) {
            String cmd = this.m_cmdLine.getText();
            this.m_cmdLine.setText("");
            e.doit = false;
            if (this.isExpectingTextLine()) {
                this.sendTextLine(cmd);
                return;
            }
            if (this.m_cmdBuffer == null) {
                this.m_cmdBuffer = new Vector();
            }
            this.m_cmdBuffer.add(cmd);
        }
        if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 99 && this.isExecuting()) {
            this.requestAbort();
            e.doit = false;
            return;
        }
        if (e.character == '\t' && e.stateMask == 0) {
            boolean bAllowTabMatch;
            String strState = this.m_idlProcess.getStateManager().getStateName();
            boolean bl = bAllowTabMatch = !this.m_bShowingContentAssist && !strState.equals("Waiting For Keyboard") && !strState.equals("Waiting For IO Line");
            if (bAllowTabMatch) {
                boolean bNewTabPhrase;
                String cmdPhrase;
                if (this.m_bResetNewTabPhrase) {
                    cmdPhrase = this.m_cmdLine.getText();
                    bNewTabPhrase = true;
                } else {
                    cmdPhrase = this.m_prevTabPhrase;
                    bNewTabPhrase = false;
                }
                ICommandHistory cmdHistory = this.m_idlProcess.getCommandHistory();
                String cmdMatch = cmdHistory.getCommandMatch(cmdPhrase, bNewTabPhrase);
                if (cmdMatch.length() > 0) {
                    this.m_prevTabPhrase = cmdPhrase;
                    this.m_cmdLine.setText("");
                    this.m_cmdLine.insert(cmdMatch);
                    this.m_cmdLine.setCaretOffset(cmdMatch.length());
                    this.m_bResetNewTabPhrase = false;
                }
                e.doit = false;
                return;
            }
        }
        if (this.isBufferingKeys()) {
            return;
        }
        if (this.isExpectingKey()) {
            KeyboardEvent ks = new KeyboardEvent(e.keyCode, e.character);
            if (this.isKeyValid(ks)) {
                this.sendKey(ks);
                e.doit = false;
                return;
            }
            if (!this.isExpectingTextLine()) {
                e.doit = false;
                return;
            }
        }
    }

    void handleMultiLinePaste() {
        if (!this.isExpectingTextLine()) {
            return;
        }
        String text = this.m_cmdViewer.getDocument().get();
        int length = (text = text.replace('\r', '\n')).length();
        if (length == 0) {
            return;
        }
        String[] s = text.split("\n+");
        int i = 0;
        while (i < s.length - 1) {
            String sTrim = s[i].trim();
            if (sTrim.length() > 0) {
                this.sendTextLine(s[i]);
                try {
                    if (sTrim.charAt(0) == '.') {
                        Thread.sleep(200L);
                    }
                    while (this.isExecuting()) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        IDocument document = this.m_cmdViewer.getDocument();
        try {
            if (s.length > 0) {
                if (text.charAt(length - 1) == '\n') {
                    this.sendTextLine(s[s.length - 1]);
                    document.replace(0, document.getLength(), "");
                } else {
                    length = document.getLength() - s[s.length - 1].length();
                    document.replace(0, length, "");
                    int cursorOffset = s[s.length - 1].length();
                    Point ptCursor = this.m_cmdLine.getLocationAtOffset(cursorOffset);
                    this.m_cmdLine.getCaret().setLocation(ptCursor);
                    this.m_cmdLine.getCaret().setVisible(true);
                    this.m_cmdViewer.setRangeIndication(cursorOffset, 0, true);
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void stateChanged(IIDLProcessProxy idl) {
        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)("stateChanged: " + idl.getStateManager().getStateName()));
        this.m_idlProcess = idl;
        if (this.m_cmdBuffer != null && !this.m_cmdBuffer.isEmpty()) {
            int i = 0;
            while (i < this.m_cmdBuffer.size()) {
                String cmd = this.m_cmdBuffer.get(i);
                this.sendTextLine(cmd);
                ++i;
            }
            this.m_cmdBuffer.removeAllElements();
            this.m_cmdBuffer = null;
        }
        this.updateGUI(idl);
    }

    void setEnabled(boolean enabled) {
        if (PlatformSupport.isMac()) {
            this.m_promptLabel.setForeground(Display.getCurrent().getSystemColor(enabled ? 21 : 18));
        } else {
            this.m_promptLabel.setEnabled(enabled);
        }
        this.m_resetAction.setEnabled(enabled);
        this.m_clearAction.setEnabled(enabled);
        UIPlugin.getContextManager().requestActivateSuspendContext(!enabled);
    }

    private void updateGUI(final IIDLProcessProxy idl) {
        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI");
        if (idl == null || !this.m_isCreated) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CommandLineView.this.m_promptLabel == null || CommandLineView.this.m_promptLabel.isDisposed()) {
                    return;
                }
                if (CommandLineView.this.m_cmdLine == null || CommandLineView.this.m_cmdLine.isDisposed()) {
                    return;
                }
                try {
                    if (!idl.isInitialized()) {
                        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI.isNotInitialized");
                        CommandLineView.this.m_cmdLine.setText("");
                        CommandLineView.this.setEnabled(false);
                        PlatformUI.getWorkbench().getDisplay().update();
                    } else if (CommandLineView.this.isBlocked()) {
                        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI.isBlocked");
                    } else if (CommandLineView.this.isExecuting()) {
                        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI.isExecuting");
                        CommandLineView.this.setEnabled(false);
                    } else if (CommandLineView.this.isIdle()) {
                        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI.isIdle");
                        CommandLineView.this.setEnabled(true);
                    } else if (CommandLineView.this.isExpectingKey() || CommandLineView.this.isExpectingTextLine()) {
                        Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI.isExpectingKey|Line");
                        CommandLineView.this.setEnabled(true);
                        if (CommandLineView.this.isExpectingKey() && CommandLineView.this.useBufferedKeys()) {
                            CommandLineView.this.sendKey(null);
                            Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)"# UpdateGUI.isExpectingKey && useBufferedKeys");
                        }
                    }
                }
                catch (SWTException sWTException) {}
            }
        });
    }

    public void promptChanged(IIDLProcessProxy idl, final String p) {
        if (p == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CommandLineView.this.m_promptLabel != null && !CommandLineView.this.m_promptLabel.isDisposed() && !CommandLineView.this.m_promptLabel.getText().equals(p)) {
                    Tracer.trace((boolean)UIPlugin.IS_DEBUGGING, (String)("## ChangePrompt p=" + p));
                    CommandLineView.this.m_promptLabel.setText(p.trim());
                    CommandLineView.this.m_parent.layout(true);
                }
            }
        });
    }

    public void commandRecalled(final String s) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (CommandLineView.this.m_cmdLine != null && !CommandLineView.this.m_cmdLine.isDisposed()) {
                    CommandLineView.this.m_cmdLine.setText("");
                    CommandLineView.this.m_cmdLine.insert(s);
                    CommandLineView.this.m_cmdLine.setCaretOffset(s.length());
                }
            }
        });
    }

    public void transfer(ICommandLineHandler cmdLineHandler) {
    }

    boolean isExecuting() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.isExecuting();
    }

    boolean isIdle() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.isIdle();
    }

    boolean isBlocked() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.isBlocked();
    }

    boolean isExpectingKey() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.isExpectingKey();
    }

    boolean useBufferedKeys() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.useBufferedKeys();
    }

    public void sendKey(KeyboardEvent e) {
        if (this.m_idlProcess == null) {
            return;
        }
        this.m_idlProcess.sendKey(e);
    }

    private boolean isKeyValid(KeyboardEvent e) {
        if (this.m_idlProcess == null) {
            return true;
        }
        return this.m_idlProcess.isKeyValid(e);
    }

    private boolean isBufferingKeys() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.isBufferingKeys();
    }

    boolean isExpectingTextLine() {
        if (this.m_idlProcess == null) {
            return false;
        }
        return this.m_idlProcess.isExpectingTextLine();
    }

    public void sendTextLine(String cmd) {
        if (this.m_idlProcess == null) {
            return;
        }
        if (this.isCommandRnew(cmd)) {
            this.resetDebugModel();
        }
        this.m_idlProcess.sendTextLine(cmd);
    }

    protected boolean isCommandRnew(String cmd) {
        boolean answer = false;
        String rnewCmnd = ".rnew";
        String newcmd = cmd.trim().toLowerCase();
        if (newcmd.length() >= 5 && newcmd.startsWith(rnewCmnd)) {
            if (newcmd.length() == 5) {
                answer = true;
            } else if (Character.isWhitespace(newcmd.charAt(5))) {
                answer = true;
            }
        }
        return answer;
    }

    protected void resetDebugModel() {
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return;
        }
        IDLStackFrame frame = idl.getDebugTarget().getThread().getTopIDLStackFrame();
        if (frame != null) {
            frame.removeAllVariablesInStackFrame();
        }
    }

    public void requestAbort() {
        if (this.m_idlProcess == null) {
            return;
        }
        this.m_idlProcess.requestAbort();
    }

    private void handleBackgroundColorPreference() {
        if (this.m_cmdLine == null) {
            return;
        }
        IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
        boolean useDefault = ps.getBoolean("IDLDT_COMMAND_LINE_USE_DEFAULT_BGCOLOR");
        if (useDefault) {
            this.m_cmdLine.setBackground(null);
        } else {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)ps, (String)"IDLDT_COMMAND_LINE_BACKGROUND_COLOR");
            if (this.m_background != null) {
                this.m_background.dispose();
            }
            this.m_background = new Color((Device)this.m_cmdLine.getDisplay(), rgb);
            this.m_cmdLine.setBackground(this.m_background);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("CHANGE_CURRENT_THEME") || property.equals("com.rsi.idldt.ui.commandLineFont")) {
            IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
            Font font = themeManager.getCurrentTheme().getFontRegistry().get("com.rsi.idldt.ui.commandLineFont");
            this.m_cmdLine.setFont(font);
            this.m_promptLabel.setFont(font);
            this.m_parent.layout(true, true);
            this.firePropertyChange(771);
        } else if (property.equals("IDLDT_COMMAND_LINE_USE_DEFAULT_BGCOLOR") || property.equals("IDLDT_COMMAND_LINE_BACKGROUND_COLOR")) {
            if (this.m_isCreated) {
                this.handleBackgroundColorPreference();
            }
        } else if (property.equals("IDLDT_COMMAND_LINE_ENABLE_COLORING")) {
            if (this.m_isCreated) {
                IPreferenceStore ps = UIPreferenceManager.getPreferenceStore();
                boolean enable = ps.getBoolean("IDLDT_COMMAND_LINE_ENABLE_COLORING");
                this.m_cmdViewer.unconfigure();
                this.m_sourceViewerConfig.setEnableColoring(enable);
                this.m_cmdViewer.configure((SourceViewerConfiguration)this.m_sourceViewerConfig);
                this.m_cmdViewer.refresh();
            }
        } else if (property.equals("matchingBrackets")) {
            if (this.m_isCreated) {
                boolean enableBracketMatching = this.m_editorPrefStore.getBoolean("matchingBrackets");
                if (enableBracketMatching) {
                    this.m_cmdViewer.addPainter((IPainter)this.m_bracketMatcherPainter);
                } else {
                    this.m_cmdViewer.removePainter((IPainter)this.m_bracketMatcherPainter);
                }
                this.m_cmdLine.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CommandLineView.this.m_cmdViewer.invalidateTextPresentation();
                        CommandLineView.this.m_cmdLine.redraw();
                        CommandLineView.this.m_cmdLine.update();
                    }
                });
            }
        } else if (property.equals("matchingBracketsColor")) {
            if (this.m_isCreated) {
                RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.m_editorPrefStore, (String)"matchingBracketsColor");
                this.m_bracketMatcherPainter.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), rgb));
                this.m_cmdLine.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CommandLineView.this.m_cmdViewer.invalidateTextPresentation();
                        CommandLineView.this.m_cmdLine.redraw();
                        CommandLineView.this.m_cmdLine.update();
                    }
                });
            }
        } else if (this.m_isCreated) {
            this.m_cmdLine.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CommandLineView.this.m_cmdViewer.invalidateTextPresentation();
                    CommandLineView.this.m_cmdLine.redraw();
                    CommandLineView.this.m_cmdLine.update();
                }
            });
        }
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
        if (width) {
            return preferredResult;
        }
        Point p = this.m_parent.computeSize(-1, -1);
        return p.y;
    }

    public int getSizeFlags(boolean width) {
        if (width) {
            return 0;
        }
        return 1152;
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        this.m_idlProcess = idl;
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }

    private void hookContextMenu(Viewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommandLineView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.m_cutAction);
        manager.add((IAction)this.m_copyAction);
        manager.add((IAction)this.m_pasteAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void showContentAssist() {
        this.m_bShowingContentAssist = true;
        this.m_cmdViewer.doOperation(13);
    }

    public void clear() {
        this.m_cmdViewer.doOperation(7);
        this.m_cmdViewer.doOperation(6);
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.m_bShowingContentAssist = true;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.m_bShowingContentAssist = false;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    protected void installDragAndDrop() {
        if (this.m_cmdViewer == null || this.m_IsDragAndDropInstalled) {
            return;
        }
        final StyledText st = this.m_cmdViewer.getTextWidget();
        final ISelectionProvider selectionProvider = this.m_cmdViewer.getSelectionProvider();
        this.m_dragSource = new DragSource((Control)st, 3);
        this.m_dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.m_dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
            String fSelectedText;
            Point fSelection;

            public void dragStart(DragSourceEvent event) {
                CommandLineView.this.m_bDragStartedFromThisCommandLineView = true;
                CommandLineView.this.m_TextDragAndDropToken = null;
                try {
                    this.fSelection = st.getSelection();
                    int offset = st.getOffsetAtLocation(new Point(event.x, event.y));
                    Point p = st.getLocationAtOffset(offset);
                    if (p.x > event.x) {
                        --offset;
                    }
                    event.doit = offset >= this.fSelection.x && offset < this.fSelection.y;
                    ISelection selection = selectionProvider.getSelection();
                    this.fSelectedText = selection instanceof ITextSelection ? ((ITextSelection)selection).getText() : st.getSelectionText();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.fSelectedText;
                CommandLineView.this.m_TextDragAndDropToken = this;
            }

            public void dragFinished(DragSourceEvent event) {
                try {
                    if (event.detail == 2) {
                        IRewriteTarget target;
                        Point newSelection = st.getSelection();
                        int length = this.fSelection.y - this.fSelection.x;
                        int delta = 0;
                        if (newSelection.x < this.fSelection.x) {
                            delta = length;
                        }
                        st.replaceTextRange(this.fSelection.x + delta, length, "");
                        if (CommandLineView.this.m_TextDragAndDropToken == null && (target = (IRewriteTarget)CommandLineView.this.getAdapter(IRewriteTarget.class)) != null) {
                            target.endCompoundChange();
                        }
                    }
                }
                finally {
                    CommandLineView.this.m_TextDragAndDropToken = null;
                    CommandLineView.this.m_bDragStartedFromThisCommandLineView = false;
                }
            }
        });
        DropTargetAdapter dropTargetListener = new DropTargetAdapter(){
            private Point fSelection;

            public void dragEnter(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    CommandLineView.this.m_TextDragAndDropToken = null;
                    this.fSelection = st.getSelection();
                    if (event.detail == 16) {
                        event.detail = (event.operations & 2) != 0 ? 2 : ((event.operations & 1) != 0 ? 1 : 0);
                    }
                    if (event.detail == 2 && !CommandLineView.this.m_bDragStartedFromThisCommandLineView) {
                        event.detail = 1;
                    }
                    CommandLineView.this.m_cmdLine.setFocus();
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : ((event.operations & 1) != 0 ? 1 : 0);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback |= 8;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void drop(DropTargetEvent event) {
                if (!TextTransfer.getInstance().isSupportedType(event.currentDataType) && !LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) return;
                }
                try {
                    String text;
                    if (CommandLineView.this.m_TextDragAndDropToken != null && event.detail == 2) {
                        int caretOffset = st.getCaretOffset();
                        if (this.fSelection.x <= caretOffset && caretOffset <= this.fSelection.y) {
                            event.detail = 0;
                            return;
                        }
                        IRewriteTarget target = (IRewriteTarget)CommandLineView.this.getAdapter(IRewriteTarget.class);
                        if (target != null) {
                            target.beginCompoundChange();
                        }
                    }
                    if ((text = TreeUtils.convertTransferDataToString(event.data)) == null) {
                        return;
                    }
                    Point newSelection = st.getSelection();
                    try {
                        int modelOffset = CommandLineView.this.widgetOffset2ModelOffset((ISourceViewer)CommandLineView.this.m_cmdViewer, newSelection.x);
                        CommandLineView.this.m_cmdViewer.getDocument().replace(modelOffset, 0, text);
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    st.setSelectionRange(newSelection.x, text.length());
                    return;
                }
                finally {
                    CommandLineView.this.m_TextDragAndDropToken = null;
                }
            }
        };
        this.m_dropTarget = new DropTarget((Control)this.m_cmdLine, 19);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance()};
        this.m_dropTarget.setTransfer(types);
        this.m_dropTarget.addDropListener((DropTargetListener)dropTargetListener);
        this.m_IsDragAndDropInstalled = true;
    }

    public Object getAdapter(Class required) {
        if (ITextOperationTarget.class.equals((Object)required)) {
            return this.m_cmdViewer == null ? null : this.m_cmdViewer.getTextOperationTarget();
        }
        if (IRewriteTarget.class.equals((Object)required)) {
            if (this.m_cmdViewer != null) {
                SourceViewer extension = this.m_cmdViewer;
                return extension.getRewriteTarget();
            }
            return null;
        }
        return super.getAdapter(required);
    }

    protected final int widgetOffset2ModelOffset(ISourceViewer viewer, int widgetOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        return widgetOffset + viewer.getVisibleRegion().getOffset();
    }

    IIDLProcessProxy getIDLProcessProxy() {
        return this.m_idlProcess;
    }

    private void initContentAssistDecoration() {
        this.m_controlDecoration = new ControlDecoration((Control)this.m_cmdLine, 16512);
        this.m_controlDecoration.setShowOnlyOnFocus(true);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        this.m_fieldDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        this.m_controlDecoration.setImage(this.m_fieldDecoration.getImage());
        this.updateContentAssistToolTip();
    }

    void updateContentAssistToolTip() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        String seq = null;
        seq = bindingService.getBestActiveBindingFormattedFor(CONTENT_ASSIST_COMMAND_ID0);
        if (seq == null) {
            seq = bindingService.getBestActiveBindingFormattedFor(CONTENT_ASSIST_COMMAND_ID1);
        }
        if (seq == null) {
            seq = "";
        }
        this.m_fieldDecoration.setDescription(NLS.bind((String)WorkbenchMessages.ContentAssist_Cue_Description_Key, (Object)seq));
        this.m_controlDecoration.setDescriptionText(this.m_fieldDecoration.getDescription());
    }
}

