/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.jdml.IModalDialogInfo;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ModalResponseRunnable
implements Runnable {
    private boolean m_answer;
    private final IModalDialogInfo m_modalInfo;

    public ModalResponseRunnable(IModalDialogInfo modalInfo) {
        this.m_modalInfo = modalInfo;
    }

    public boolean getAnswer() {
        return this.m_answer;
    }

    public void run() {
        this.m_answer = false;
        Shell shell = IDLDTCorePlugin.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.m_modalInfo.isQuestion()) {
            this.m_answer = MessageDialog.openQuestion((Shell)shell, (String)this.m_modalInfo.getTitle(), (String)this.m_modalInfo.getMessage());
        } else {
            int imageType;
            String[] buttons;
            if (this.m_modalInfo.hasCancel()) {
                buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                switch (this.m_modalInfo.getSeverity()) {
                    case 1: {
                        imageType = 4;
                        break;
                    }
                    case 2: {
                        imageType = 1;
                        break;
                    }
                    default: {
                        imageType = 3;
                        break;
                    }
                }
            } else {
                buttons = new String[]{IDialogConstants.OK_LABEL};
                switch (this.m_modalInfo.getSeverity()) {
                    case 1: {
                        imageType = 4;
                        break;
                    }
                    case 2: {
                        imageType = 1;
                        break;
                    }
                    default: {
                        imageType = 2;
                    }
                }
            }
            MessageDialog dialog = new MessageDialog(shell, this.m_modalInfo.getTitle(), null, this.m_modalInfo.getMessage(), imageType, buttons, 0);
            this.m_answer = dialog.open() == 0;
        }
    }
}

