/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectProperties;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.internal.ui.Messages;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

public class IDLProjectPropertyPage
extends PropertyPage {
    private static final int TOTAL_COLUMNS = 5;
    private Button m_button_runBeginsWithReset;
    private Text m_textRunCommand;
    private Button m_buttonProjectOnIDLPath;
    private Button m_buttonRunBeginsWithBuild;
    private boolean m_bRunCommandIsGood = true;
    private boolean m_bBuildCommandIsGood = true;
    private boolean m_bSaveFilenameIsGood = true;
    private ErrorStack m_errorStack = new ErrorStack();

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.rsi.idldt.ui.properties_idl_project");
        GridLayout overallLayout = new GridLayout();
        overallLayout.numColumns = 5;
        overallLayout.marginHeight = 10;
        overallLayout.marginWidth = 10;
        composite.setLayout((Layout)overallLayout);
        this.m_buttonProjectOnIDLPath = this.createCheckbox(composite, Messages.IDLProjectPropertyPage_OnPath);
        this.createRunCommandComposite(composite);
        this.populateDialog(false);
        return composite;
    }

    private void createRunCommandComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.IDLProjectPropertyPage_RunCommand);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        group.setLayoutData((Object)gridData);
        this.m_button_runBeginsWithReset = this.createCheckbox((Composite)group, Messages.IDLProjectPropertyPage_ExecuteRunBeforeBuild);
        this.m_buttonRunBeginsWithBuild = this.createCheckbox((Composite)group, Messages.IDLProjectPropertyPage_ProjectBuildBeforeRunCommand);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        this.m_textRunCommand = new Text((Composite)group, 18436);
        this.m_textRunCommand.setLayoutData((Object)gd2);
        this.m_textRunCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IDLProjectPropertyPage.this.checkRunCommandError();
            }
        });
        final Link link = new Link((Composite)group, 0);
        String linkText = Messages.IDLProjectPropertyPage_SeeCompileOnSavePreference;
        link.setText("<a href=\"unsed_url\">" + linkText + "</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pageId = "com.rsi.idldt.ui.preferencePage.editor";
                String[] displayIds = new String[]{pageId};
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)pageId, (String[])displayIds, null);
                dialog.open();
            }
        });
    }

    protected void runMasterErrorCheck() {
        if (this.m_bRunCommandIsGood && this.m_bBuildCommandIsGood && this.m_bSaveFilenameIsGood) {
            this.setValid(true);
            this.setMessage(Messages.IDLProjectPropertyPage_IDLProjectProperties, 0);
        } else {
            this.setValid(false);
            this.setMessage(this.m_errorStack.getTop(), 3);
        }
    }

    protected void checkRunCommandError() {
        this.m_bRunCommandIsGood = true;
        this.m_errorStack.removeError(Messages.IDLProjectPropertyPage_MustSpecifyAProjectRunCommand);
        if (this.m_textRunCommand.getText().trim().length() == 0) {
            this.m_errorStack.addError(Messages.IDLProjectPropertyPage_MustSpecifyAProjectRunCommand);
            this.m_bRunCommandIsGood = false;
        }
        this.runMasterErrorCheck();
    }

    private Button createCheckbox(Composite parent, String text) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 5;
        Button button = new Button(parent, 32);
        button.setText(text);
        button.setLayoutData((Object)gd);
        return button;
    }

    private void populateDialog(boolean useDefaults) {
        IDLProjectProperties props = this.getProperties(this.getProject());
        if (props != null) {
            boolean bRunBeginsWithReset;
            boolean bRunBeginsWithBuild;
            String runCommand;
            boolean bOnPath;
            if (useDefaults) {
                bOnPath = props.isDefaultProjectPathManaged();
                runCommand = props.getDefaultRunCommand();
                bRunBeginsWithBuild = props.getDefaultRunBeginsWithBuild();
                bRunBeginsWithReset = props.getDefaultRunExecuteResetSession();
            } else {
                bOnPath = props.isProjectPathManaged();
                runCommand = props.getRunCommand();
                bRunBeginsWithBuild = props.getRunBeginsWithBuild();
                bRunBeginsWithReset = props.isRunBeginsWithReset();
            }
            this.m_button_runBeginsWithReset.setSelection(bRunBeginsWithReset);
            this.m_buttonProjectOnIDLPath.setSelection(bOnPath);
            this.m_buttonRunBeginsWithBuild.setSelection(bRunBeginsWithBuild);
            this.m_textRunCommand.setText(runCommand);
        }
    }

    public boolean performOk() {
        IProject project = this.getProject();
        IDLProjectProperties props = this.getProperties(project);
        if (props != null) {
            props.setProjectPathManagement(this.m_buttonProjectOnIDLPath.getSelection());
            props.setRunBeginsWithReset(this.m_button_runBeginsWithReset.getSelection());
            props.setRunCommand(this.m_textRunCommand.getText());
            props.setRunBeginsWithBuild(this.m_buttonRunBeginsWithBuild.getSelection());
            IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
            IIDLProjectManager projectManager = idl.getProjectManager();
            projectManager.touch(project);
        }
        return super.performOk();
    }

    private IDLProjectProperties getProperties(IProject proj) {
        IDLProjectProperties props;
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)proj.getNature("com.rsi.idldt.core.IDLNature");
            props = nature.getIDLProjectProperties();
        }
        catch (CoreException coreException) {
            props = null;
        }
        return props;
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    protected void performDefaults() {
        IDLProjectProperties props = this.getProperties(this.getProject());
        if (props != null) {
            this.populateDialog(true);
        }
        super.performDefaults();
    }

    protected class ErrorStack {
        private Stack<String> m_stack = new Stack();

        protected ErrorStack() {
        }

        public void addError(String msg) {
            if (this.m_stack.contains(msg)) {
                return;
            }
            this.m_stack.add(msg);
        }

        public void removeError(String msg) {
            if (this.m_stack.contains(msg)) {
                this.m_stack.remove(msg);
            }
        }

        public String getTop() {
            String msg = this.m_stack.pop();
            this.m_stack.push(msg);
            return msg;
        }
    }
}

