/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.actions.ToggleExcludeFromBuildAction;
import com.rsi.idldt.core.IDLProjectCompileProperties;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectProperties;
import com.rsi.idldt.internal.ui.CompileOrderTreeContentProvider;
import com.rsi.idldt.internal.ui.CompileOrderTreeLabelProvider;
import com.rsi.idldt.internal.ui.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class IDLProjectPropertyCompileOrderPage
extends PropertyPage {
    protected Button moveUpButton;
    protected Button moveToTopButton;
    protected Button moveDownButton;
    protected Button moveToBottomButton;
    protected CheckboxTreeViewer viewer;
    protected CompileOrderTreeContentProvider provider;
    private String lastKnownSaveFileName;
    private static int DESCRIPTION_CHARS_WIDTH = 80;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.rsi.idldt.ui.properties_idl_project_build_compile_order");
        Label label = new Label(composite, 64);
        label.setText(Messages.IDLProjectPropertyCompileOrderPage_Description);
        GridData gd = new GridData(1, 2, true, false, 2, 1);
        gd.widthHint = this.convertWidthOfCharToPixels(composite.getFont(), DESCRIPTION_CHARS_WIDTH);
        label.setLayoutData((Object)gd);
        this.viewer = new CheckboxTreeViewer(composite, 2820);
        GridData treeGridData = new GridData();
        treeGridData.heightHint = this.viewer.getTree().getItemHeight();
        treeGridData.verticalAlignment = 4;
        treeGridData.horizontalAlignment = 4;
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        this.viewer.getTree().setLayoutData((Object)treeGridData);
        this.provider = new CompileOrderTreeContentProvider(this.getElement());
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new CompileOrderTreeLabelProvider());
        this.viewer.setInput((Object)"root");
        this.viewer.setCheckedElements(this.provider.getSelectedElements());
        this.createButtonPanel(composite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDLProjectPropertyCompileOrderPage.this.setControlButtonEnablement();
            }
        });
        this.setControlButtonEnablement();
        this.lastKnownSaveFileName = this.getProjectOutputSaveFileName();
        return composite;
    }

    private int convertWidthOfCharToPixels(Font font, int chars) {
        GC gc = new GC((Drawable)font.getDevice());
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)chars);
    }

    private void createButtonPanel(Composite parent) {
        Composite composite = new Composite(parent, 131072);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.moveUpButton = new Button(composite, 0x1000008);
        this.moveUpButton.setText(Messages.IDLProjectPropertyCompileOrderPage_MoveUp);
        this.setButtonLayoutData(this.moveUpButton);
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDLProjectPropertyCompileOrderPage.this.moveSelectedElement((Button)e.getSource());
            }
        });
        this.moveToTopButton = new Button(composite, 0x1000008);
        this.moveToTopButton.setText(Messages.IDLProjectPropertyCompileOrderPage_MoveToTop);
        this.setButtonLayoutData(this.moveToTopButton);
        this.moveToTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDLProjectPropertyCompileOrderPage.this.moveSelectedElement((Button)e.getSource());
            }
        });
        this.moveDownButton = new Button(composite, 0x1000008);
        this.moveDownButton.setText(Messages.IDLProjectPropertyCompileOrderPage_MoveDown);
        this.setButtonLayoutData(this.moveDownButton);
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDLProjectPropertyCompileOrderPage.this.moveSelectedElement((Button)e.getSource());
            }
        });
        this.moveToBottomButton = new Button(composite, 0x1000008);
        this.moveToBottomButton.setText(Messages.IDLProjectPropertyCompileOrderPage_MoveToBottom);
        this.setButtonLayoutData(this.moveToBottomButton);
        this.moveToBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDLProjectPropertyCompileOrderPage.this.moveSelectedElement((Button)e.getSource());
            }
        });
    }

    void moveSelectedElement(final Button source) {
        final Object[] selected = this.viewer.getCheckedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        final IFile file = (IFile)selection.getFirstElement();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (source == IDLProjectPropertyCompileOrderPage.this.moveUpButton) {
                    IDLProjectPropertyCompileOrderPage.this.provider.moveElementUp(file);
                }
                if (source == IDLProjectPropertyCompileOrderPage.this.moveDownButton) {
                    IDLProjectPropertyCompileOrderPage.this.provider.moveElementDown(file);
                }
                if (source == IDLProjectPropertyCompileOrderPage.this.moveToTopButton) {
                    IDLProjectPropertyCompileOrderPage.this.provider.moveElementToTop(file);
                }
                if (source == IDLProjectPropertyCompileOrderPage.this.moveToBottomButton) {
                    IDLProjectPropertyCompileOrderPage.this.provider.moveElementToBottom(file);
                }
                IDLProjectPropertyCompileOrderPage.this.viewer.setCheckedElements(selected);
                IDLProjectPropertyCompileOrderPage.this.viewer.refresh();
                IDLProjectPropertyCompileOrderPage.this.setControlButtonEnablement();
            }
        });
    }

    void setControlButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        IFile file = (IFile)selection.getFirstElement();
        if (file != null) {
            this.moveDownButton.setEnabled(this.provider.canMoveDown(file));
            this.moveToBottomButton.setEnabled(this.provider.canMoveDown(file));
            this.moveUpButton.setEnabled(this.provider.canMoveUp(file));
            this.moveToTopButton.setEnabled(this.provider.canMoveUp(file));
        } else {
            this.moveDownButton.setEnabled(false);
            this.moveToBottomButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveToTopButton.setEnabled(false);
        }
    }

    public boolean performOk() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IDLProjectPropertyCompileOrderPage.this.saveCompileOrderProperties();
            }
        });
        return super.performOk();
    }

    protected void performApply() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IDLProjectPropertyCompileOrderPage.this.saveCompileOrderProperties();
            }
        });
        super.performApply();
    }

    protected void performDefaults() {
        super.performDefaults();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IDLProjectPropertyCompileOrderPage.this.provider.restoreDefaults();
                IDLProjectPropertyCompileOrderPage.this.viewer.refresh();
                IDLProjectPropertyCompileOrderPage.this.viewer.setCheckedElements(IDLProjectPropertyCompileOrderPage.this.provider.getSelectedElements());
                IDLProjectPropertyCompileOrderPage.this.setControlButtonEnablement();
            }
        });
    }

    void saveCompileOrderProperties() {
        Object[] elements = this.provider.getElements(null);
        int count = 0;
        while (count < elements.length) {
            IFile file = (IFile)elements[count];
            IDLProjectCompileProperties.setCompileOrderIndex((IFile)file, (int)(count + 1));
            IDLProjectCompileProperties.setExcludedFromBuild((IFile)file, (!this.viewer.getChecked((Object)file) ? 1 : 0) != 0);
            ToggleExcludeFromBuildAction.update();
            ++count;
        }
    }

    private String getProjectOutputSaveFileName() {
        IDLProjectProperties props;
        IAdaptable element = this.getElement();
        if (element instanceof IProject && (props = this.getProperties((IProject)element)) != null) {
            return props.getSaveFileOutputPath();
        }
        return "";
    }

    private IDLProjectProperties getProperties(IProject proj) {
        IDLProjectProperties props;
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)proj.getNature("com.rsi.idldt.core.IDLNature");
            props = nature.getIDLProjectProperties();
        }
        catch (CoreException coreException) {
            props = null;
        }
        return props;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String currentSaveFileName = this.getProjectOutputSaveFileName();
        if (visible && !this.lastKnownSaveFileName.equals(currentSaveFileName)) {
            this.lastKnownSaveFileName = currentSaveFileName;
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IDLProjectPropertyCompileOrderPage.this.provider.refreshPageData();
                    IDLProjectPropertyCompileOrderPage.this.viewer.refresh();
                    IDLProjectPropertyCompileOrderPage.this.viewer.setCheckedElements(IDLProjectPropertyCompileOrderPage.this.provider.getSelectedElements());
                    IDLProjectPropertyCompileOrderPage.this.setControlButtonEnablement();
                }
            });
        }
    }
}

