/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectBuildCommandsGenerator;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectProperties;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.NonExistentProEditorInput;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IDLVariable;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.texteditor.ITextEditor;

public class IDLProjectBuildPropertyPage
extends PropertyPage {
    private static final int TOTAL_COLUMNS = 5;
    private static boolean m_askedIDL;
    private static boolean m_bHaveDevKitLicense;
    Text m_textSaveFileName;
    Button m_buttonCreateSaveFile;
    private Button m_buttonLicensedSaveFile;
    Button m_browseButton;
    private Button m_button_build_inOPS;
    private Text m_textBuildCommand;
    private Button m_button_normalBuildType;
    private Button m_button_customBuildType;
    private ArrayList<Button> m_radioButtonList = new ArrayList();
    private Button resolveAllFiles;
    Text preBuildCommand;
    Text postBuildCommand;
    private Button restoreReferencedProjects;
    private Button compileProjectFilesButton;
    Button preBuildCommandButton;
    Button postBuildCommandButton;
    private Button executeResetBeforeBuild;
    private Link compileOrderLink;
    Button generateBuildScriptButton;
    private boolean m_bRunCommandIsGood = true;
    private boolean m_bBuildCommandIsGood = true;
    private boolean m_bSaveFilenameIsGood = true;
    private ErrorStack m_errorStack = new ErrorStack();

    static {
        m_bHaveDevKitLicense = false;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.rsi.idldt.ui.properties_idl_project_build");
        GridLayout overallLayout = new GridLayout();
        overallLayout.numColumns = 5;
        overallLayout.marginHeight = 10;
        overallLayout.marginWidth = 10;
        composite.setLayout((Layout)overallLayout);
        this.alternateCreateBuildCommandComposite(composite);
        this.populateDialog(false);
        this.setUpGeneralModifyListeners();
        return composite;
    }

    public void setUpGeneralModifyListeners() {
        Text[] texts;
        Button[] buttons = new Button[]{this.m_buttonCreateSaveFile, this.m_buttonLicensedSaveFile, this.m_button_build_inOPS, this.m_button_normalBuildType, this.m_button_customBuildType, this.resolveAllFiles, this.restoreReferencedProjects, this.compileProjectFilesButton, this.preBuildCommandButton, this.postBuildCommandButton, this.executeResetBeforeBuild};
        Text[] textArray = texts = new Text[]{this.m_textSaveFileName, this.preBuildCommand, this.postBuildCommand, this.m_textBuildCommand};
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            Text text = textArray[n2];
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IDLProjectBuildPropertyPage.this.generateBuildScriptButton.setEnabled(false);
                }
            });
            ++n2;
        }
        textArray = buttons;
        n = buttons.length;
        n2 = 0;
        while (n2 < n) {
            Text button = textArray[n2];
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IDLProjectBuildPropertyPage.this.generateBuildScriptButton.setEnabled(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++n2;
        }
    }

    protected void handleCustomBuildCommandEnablement() {
        if (this.m_button_customBuildType.getSelection()) {
            this.m_textBuildCommand.setEnabled(true);
            this.resolveAllFiles.setEnabled(false);
            this.preBuildCommandButton.setEnabled(false);
            this.preBuildCommand.setEnabled(false);
            this.postBuildCommandButton.setEnabled(false);
            this.postBuildCommand.setEnabled(false);
            this.compileOrderLink.setEnabled(false);
            this.restoreReferencedProjects.setEnabled(false);
            this.compileProjectFilesButton.setEnabled(false);
        } else {
            this.m_textBuildCommand.setEnabled(false);
            this.resolveAllFiles.setEnabled(true);
            this.preBuildCommandButton.setEnabled(true);
            this.preBuildCommand.setEnabled(this.preBuildCommandButton.getSelection());
            this.postBuildCommandButton.setEnabled(true);
            this.postBuildCommand.setEnabled(this.postBuildCommandButton.getSelection());
            this.compileOrderLink.setEnabled(true);
            this.restoreReferencedProjects.setEnabled(true);
            this.compileProjectFilesButton.setEnabled(true);
        }
        this.checkBuildCommandError();
    }

    protected void runMasterErrorCheck() {
        if (this.m_bRunCommandIsGood && this.m_bBuildCommandIsGood && this.m_bSaveFilenameIsGood) {
            this.setValid(true);
            this.setMessage(Messages.IDLProjectPropertyPage_IDLBuildProperties, 0);
        } else {
            this.setValid(false);
            this.setMessage(this.m_errorStack.getTop(), 3);
        }
    }

    protected void checkBuildCommandError() {
        this.m_bBuildCommandIsGood = true;
        this.m_errorStack.removeError(Messages.IDLProjectPropertyPage_MustSpecifyBuildCommand);
        if (this.m_button_customBuildType.getSelection() && this.m_textBuildCommand.getText().trim().length() == 0) {
            this.m_errorStack.addError(Messages.IDLProjectPropertyPage_MustSpecifyBuildCommand);
            this.m_bBuildCommandIsGood = false;
        }
        this.runMasterErrorCheck();
    }

    protected void checkSaveFilenameError() {
        this.m_bSaveFilenameIsGood = true;
        this.m_errorStack.removeError(Messages.IDLProjectPropertyPage_MustSpecifyASaveFileName);
        this.setMessage(Messages.IDLProjectPropertyPage_IDLBuildProperties, 0);
        if (this.m_buttonCreateSaveFile.getSelection() && this.m_textSaveFileName.getText().trim().length() == 0) {
            this.m_errorStack.addError(Messages.IDLProjectPropertyPage_MustSpecifyASaveFileName);
            this.m_bSaveFilenameIsGood = false;
        }
        this.runMasterErrorCheck();
    }

    private int convertWidthOfCharToPixels(Font font, int chars) {
        GC gc = new GC((Drawable)font.getDevice());
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)chars);
    }

    private void alternateCreateBuildCommandComposite(Composite parent) {
        int indentWidth = this.convertWidthOfCharToPixels(parent.getFont(), 3);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        this.m_button_build_inOPS = this.createCheckbox(composite, Messages.IDLProjectPropertyPage_BuildSeparateSession);
        this.executeResetBeforeBuild = this.createCheckbox(composite, Messages.IDLProjectBuildPropertyPage_ExecuteResetBeforeBuildDescription);
        this.m_button_normalBuildType = this.createRadioButton(composite, Messages.IDLProjectBuildPropertyPage_IDLDefaultBuildProcessDescription);
        this.m_button_normalBuildType.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.restoreReferencedProjects = new Button(composite, 32);
        this.restoreReferencedProjects.setText(Messages.IDLProjectBuildPropertyPage_RestoreReferencedSavedFilesDescription);
        GridData buildRefProjData = new GridData(4, 4, true, false, 3, 1);
        buildRefProjData.horizontalIndent = indentWidth;
        this.restoreReferencedProjects.setLayoutData((Object)buildRefProjData);
        this.preBuildCommandButton = new Button(composite, 32);
        this.preBuildCommandButton.setText(Messages.IDLProjectBuildPropertyPage_PreCompileCommandDescription);
        GridData preCompileButtonData = new GridData(4, 4, true, false, 3, 1);
        preCompileButtonData.horizontalIndent = indentWidth;
        this.preBuildCommandButton.setLayoutData((Object)preCompileButtonData);
        this.preBuildCommandButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        IDLProjectBuildPropertyPage.this.preBuildCommand.setEnabled(IDLProjectBuildPropertyPage.this.preBuildCommandButton.getSelection());
                    }
                }
            }
        });
        this.preBuildCommand = new Text(composite, 18436);
        GridData preBuildCmdData = new GridData(4, 4, true, false, 3, 1);
        preBuildCmdData.horizontalIndent = indentWidth * 2;
        this.preBuildCommand.setLayoutData((Object)preBuildCmdData);
        this.compileProjectFilesButton = new Button(composite, 32);
        this.compileProjectFilesButton.setText(Messages.IDLProjectBuildPropertyPage_CompileProjectFilesDescription);
        GridData compileFilesData = new GridData(4, 4, true, false, 3, 1);
        compileFilesData.horizontalIndent = indentWidth;
        this.compileProjectFilesButton.setLayoutData((Object)compileFilesData);
        this.compileProjectFilesButton.setSelection(true);
        this.compileOrderLink = new Link(composite, 0);
        String linkText = Messages.IDLProjectBuildPropertyPage_CompileOrderLinkDesciption;
        this.compileOrderLink.setText("<a href=\"unsed_url\">" + linkText + "</a>");
        this.compileOrderLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)IDLProjectBuildPropertyPage.this.getContainer();
                container.openPage("com.rsi.idldt.ui.propertyPage.idl.compileorder", null);
            }
        });
        GridData linkData = new GridData(4, 4, true, false, 3, 1);
        linkData.horizontalIndent = indentWidth * 2;
        this.compileOrderLink.setLayoutData((Object)linkData);
        this.resolveAllFiles = new Button(composite, 32);
        GridData resolveOnErrorData = new GridData(4, 4, true, false, 3, 1);
        resolveOnErrorData.horizontalIndent = indentWidth;
        this.resolveAllFiles.setText(Messages.IDLProjectBuildPropertyPage_ExecuteResolveAllDescription);
        this.resolveAllFiles.setLayoutData((Object)resolveOnErrorData);
        this.postBuildCommandButton = new Button(composite, 32);
        this.postBuildCommandButton.setText(Messages.IDLProjectBuildPropertyPage_PostCompileCommandDescription);
        GridData postCompileButtonData = new GridData(4, 4, true, false, 3, 1);
        postCompileButtonData.horizontalIndent = indentWidth;
        this.postBuildCommandButton.setLayoutData((Object)postCompileButtonData);
        this.postBuildCommandButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        IDLProjectBuildPropertyPage.this.postBuildCommand.setEnabled(IDLProjectBuildPropertyPage.this.postBuildCommandButton.getSelection());
                    }
                }
            }
        });
        this.postBuildCommand = new Text(composite, 18436);
        GridData postBuildCmdData = new GridData(4, 4, true, false, 3, 1);
        postBuildCmdData.horizontalIndent = indentWidth * 2;
        this.postBuildCommand.setLayoutData((Object)postBuildCmdData);
        GridData customBuildCommandSelectionData = new GridData(4, 4, true, false, 3, 1);
        this.m_button_customBuildType = this.createRadioButton(composite, Messages.IDLProjectPropertyPage_UseCustomBuildCommand);
        this.m_button_customBuildType.setLayoutData((Object)customBuildCommandSelectionData);
        this.m_button_customBuildType.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        IDLProjectBuildPropertyPage.this.handleCustomBuildCommandEnablement();
                    }
                }
            }
        });
        GridData customBuildCommandData = new GridData(4, 4, true, false, 3, 1);
        customBuildCommandData.horizontalIndent = indentWidth;
        this.m_textBuildCommand = new Text(composite, 18436);
        this.m_textBuildCommand.setLayoutData((Object)customBuildCommandData);
        this.m_textBuildCommand.setEnabled(false);
        this.m_textBuildCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IDLProjectBuildPropertyPage.this.checkBuildCommandError();
            }
        });
        this.createSaveFileProperties(composite);
        Label spacer = new Label(composite, 0);
        GridData spacerLayout = new GridData(4, 4, true, false, 3, 1);
        spacer.setLayoutData((Object)spacerLayout);
        this.generateBuildScriptButton = new Button(composite, 0);
        this.generateBuildScriptButton.setText(Messages.IDLProjectBuildPropertyPage_CreateBuildScriptButtonText);
        GridData generateButtonData = new GridData(4, 4, true, false, 1, 1);
        this.generateBuildScriptButton.setLayoutData((Object)generateButtonData);
        this.generateBuildScriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDLProjectBuildPropertyPage.this.viewBuildScriptInEditor();
            }
        });
    }

    protected void viewBuildScriptInEditor() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                NonExistentProEditorInput input = new NonExistentProEditorInput();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)input, UIPlugin.ID_PRO_EDITOR);
                }
                catch (PartInitException partInitException) {}
                ITextEditor editor = (ITextEditor)page.getActiveEditor();
                IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                try {
                    IDLProjectBuildCommandsGenerator g = new IDLProjectBuildCommandsGenerator((IProject)IDLProjectBuildPropertyPage.this.getElement(), true);
                    g.generateCommandsFullBuild();
                    doc.replace(doc.getLength(), 0, g.getViewableScript());
                }
                catch (BadLocationException badLocationException) {}
            }
        });
    }

    protected void determineIfDeveloperHasDevKitLicense() {
        if (m_askedIDL) {
            return;
        }
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null || !idl.isIdle()) {
            return;
        }
        HasDevkitLicense idlCmd = new HasDevkitLicense();
        idl.queueCommand((AbstractIDLCommand)idlCmd);
        while (!idlCmd.hasFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        m_bHaveDevKitLicense = idlCmd.getResult() == 1;
        m_askedIDL = true;
    }

    private void createSaveFileProperties(Composite parent) {
        Composite group = parent;
        this.m_buttonCreateSaveFile = this.createCheckbox(group, Messages.IDLProjectPropertyPage_CreateSaveFile);
        this.m_buttonLicensedSaveFile = this.createCheckbox(group, Messages.IDLProjectPropertyPage_LicensedSaveFile);
        this.determineIfDeveloperHasDevKitLicense();
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 2;
        this.m_textSaveFileName = new Text(group, 18436);
        this.m_textSaveFileName.setLayoutData((Object)gd2);
        this.m_textSaveFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IDLProjectBuildPropertyPage.this.checkSaveFilenameError();
            }
        });
        IAdaptable obj = this.getElement();
        IProject project = (IProject)obj;
        final String startFilter = project.getLocation().toOSString();
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 4;
        gd3.grabExcessHorizontalSpace = false;
        gd3.horizontalSpan = 1;
        this.m_browseButton = new Button(group, 0);
        this.m_browseButton.setText(Messages.IDLProjectPropertyPage_Browse);
        this.m_browseButton.setLayoutData((Object)gd3);
        this.m_browseButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        int flags = 8192;
                        FileDialog dialog = new FileDialog(IDLProjectBuildPropertyPage.this.m_browseButton.getShell(), flags);
                        dialog.setText(Messages.IDLProjectPropertyPage_DialogTitleSaveFile);
                        String filterPath = startFilter;
                        dialog.setFilterPath(filterPath);
                        String[] extensions = new String[]{"*.sav"};
                        dialog.setFilterExtensions(extensions);
                        dialog.open();
                        String name = dialog.getFileName().trim();
                        if (name == null || name.length() <= 0) break;
                        String path = dialog.getFilterPath();
                        if (path != null) {
                            String sep = System.getProperty("file.separator");
                            name = String.valueOf(path) + sep + name;
                        }
                        IDLProjectBuildPropertyPage.this.m_textSaveFileName.setText(name);
                    }
                }
            }
        });
        this.m_buttonCreateSaveFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IDLProjectBuildPropertyPage.this.setSaveFileEnablement();
                if (IDLProjectBuildPropertyPage.this.m_buttonCreateSaveFile.getSelection()) {
                    IDLProjectBuildPropertyPage.this.checkSaveFilenameError();
                }
            }
        });
    }

    protected void setSaveFileEnablement() {
        boolean createSaveFile = this.m_buttonCreateSaveFile.getSelection();
        this.m_textSaveFileName.setEnabled(createSaveFile);
        this.m_browseButton.setEnabled(createSaveFile);
        boolean licensed = this.m_buttonLicensedSaveFile.getSelection();
        this.m_buttonLicensedSaveFile.setEnabled(createSaveFile && (m_bHaveDevKitLicense || licensed));
    }

    private Button createCheckbox(Composite parent, String text) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 5;
        Button button = new Button(parent, 32);
        button.setText(text);
        button.setLayoutData((Object)gd);
        return button;
    }

    private Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        this.m_radioButtonList.add(button);
        return button;
    }

    private void unselectAllRadioButtons() {
        for (Button button : this.m_radioButtonList) {
            button.setSelection(false);
        }
    }

    private void populateDialog(boolean useDefaults) {
        IDLProjectProperties props = this.getProperties(this.getProject());
        if (props != null) {
            boolean execPostCompCmd;
            boolean execPreCompCmd;
            boolean buildBeginsWithReset;
            boolean compileProjectFiles;
            boolean restoreReferencedProjects1;
            String postCompileCommand;
            String preCompileCommand;
            boolean resolveDependencies;
            boolean bLicensedSaveFile;
            String saveFileName;
            boolean bCreateSaveFile;
            boolean bBuildInOPS;
            String build_type;
            String buildCommand;
            this.unselectAllRadioButtons();
            if (useDefaults) {
                buildCommand = props.getDefaultBuildCommand();
                build_type = props.getDefaultBuildType();
                bBuildInOPS = props.isDefaultBuildInSeparateSession();
                bCreateSaveFile = props.isDefaultCreateSaveFile();
                saveFileName = props.getDefaultSaveFileOutputPath();
                bLicensedSaveFile = props.isDefaultCreateLicensedSaveFile();
                resolveDependencies = props.getDefaultResolveDependencies();
                preCompileCommand = props.getDefaultPreCompileCommand();
                postCompileCommand = props.getDefaultPostCompileCommand();
                restoreReferencedProjects1 = props.getDefaultRestoreReferencedProjects();
                compileProjectFiles = props.getDefaultCompileProjectFiles();
                buildBeginsWithReset = props.getDefaultBuildExecuteResetSession();
                execPreCompCmd = props.getDefaultExecutePreCompileCommand();
                execPostCompCmd = props.getDefaultExecutePostCompileCommand();
            } else {
                buildCommand = props.getBuildCommand();
                build_type = props.getBuildType();
                bBuildInOPS = props.isBuildInSeparateSession();
                saveFileName = props.getSaveFileOutputPathWithoutDotSubstitution();
                bLicensedSaveFile = props.isCreateLicensedSaveFile();
                bCreateSaveFile = props.isCreateSaveFile();
                resolveDependencies = props.getResolveDependencies();
                preCompileCommand = props.getPreCompileCommand();
                postCompileCommand = props.getPostCompileCommand();
                restoreReferencedProjects1 = props.getRestoreReferencedProjects();
                compileProjectFiles = props.getCompileProjectFiles();
                buildBeginsWithReset = props.isBuildBeginsWithReset();
                execPreCompCmd = props.getExecutePreCompileCommand();
                execPostCompCmd = props.getExecutePostCompileCommand();
            }
            this.m_buttonCreateSaveFile.setSelection(bCreateSaveFile);
            this.m_buttonLicensedSaveFile.setSelection(bLicensedSaveFile);
            this.setSaveFileEnablement();
            this.m_button_build_inOPS.setSelection(bBuildInOPS);
            if (build_type == null || build_type.trim().length() == 0) {
                this.m_button_normalBuildType.setSelection(true);
            } else if (build_type.equals("custom")) {
                this.m_button_customBuildType.setSelection(true);
            } else if (build_type.equals("default")) {
                this.m_button_normalBuildType.setSelection(true);
            }
            this.m_textSaveFileName.setText(saveFileName);
            this.m_textBuildCommand.setText(buildCommand);
            if (this.m_button_customBuildType.getSelection()) {
                this.checkBuildCommandError();
            }
            if (this.m_buttonCreateSaveFile.getSelection()) {
                this.checkSaveFilenameError();
            }
            this.resolveAllFiles.setSelection(resolveDependencies);
            this.preBuildCommand.setText(preCompileCommand);
            this.postBuildCommand.setText(postCompileCommand);
            this.restoreReferencedProjects.setSelection(restoreReferencedProjects1);
            this.compileProjectFilesButton.setSelection(compileProjectFiles);
            this.executeResetBeforeBuild.setSelection(buildBeginsWithReset);
            this.preBuildCommandButton.setSelection(execPreCompCmd);
            this.postBuildCommandButton.setSelection(execPostCompCmd);
            this.handleCustomBuildCommandEnablement();
        }
    }

    public boolean performOk() {
        IProject project = this.getProject();
        IDLProjectProperties props = this.getProperties(project);
        if (props != null) {
            String buildType = null;
            if (this.m_button_customBuildType.getSelection()) {
                buildType = "custom";
            } else if (this.m_button_normalBuildType.getSelection()) {
                buildType = "default";
            }
            props.setBuildType(buildType);
            props.setBuildCommand(this.m_textBuildCommand.getText());
            props.setBuildInSeparateSession(this.m_button_build_inOPS.getSelection());
            props.setCreateSaveFile(this.m_buttonCreateSaveFile.getSelection());
            props.setCreateLicensedSaveFile(this.m_buttonLicensedSaveFile.getSelection());
            props.setSaveFileOutputPath(this.m_textSaveFileName.getText());
            props.setResolveDependencies(this.resolveAllFiles.getSelection());
            props.setPreCompileCommand(this.preBuildCommand.getText());
            props.setPostCompileCommand(this.postBuildCommand.getText());
            props.setRestoreReferencedProjects(this.restoreReferencedProjects.getSelection());
            props.setCompileProjectFiles(this.compileProjectFilesButton.getSelection());
            props.setBuildBeginsWithReset(this.executeResetBeforeBuild.getSelection());
            props.setExecutePreCompileCommand(this.preBuildCommandButton.getSelection());
            props.setExecutePostCompileCommand(this.postBuildCommandButton.getSelection());
            IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
            IIDLProjectManager projectManager = idl.getProjectManager();
            projectManager.touch(project);
        }
        this.generateBuildScriptButton.setEnabled(true);
        return super.performOk();
    }

    private IDLProjectProperties getProperties(IProject proj) {
        IDLProjectProperties props;
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)proj.getNature("com.rsi.idldt.core.IDLNature");
            props = nature.getIDLProjectProperties();
        }
        catch (CoreException coreException) {
            props = null;
        }
        return props;
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    protected void performDefaults() {
        IDLProjectProperties props = this.getProperties(this.getProject());
        if (props != null) {
            this.populateDialog(true);
        }
        this.generateBuildScriptButton.setEnabled(true);
        super.performDefaults();
    }

    protected class ErrorStack {
        private Stack<String> m_stack = new Stack();

        protected ErrorStack() {
        }

        public void addError(String msg) {
            if (this.m_stack.contains(msg)) {
                return;
            }
            this.m_stack.add(msg);
        }

        public void removeError(String msg) {
            if (this.m_stack.contains(msg)) {
                this.m_stack.remove(msg);
            }
        }

        public String getTop() {
            String msg = this.m_stack.pop();
            this.m_stack.push(msg);
            return msg;
        }
    }

    private static class HasDevkitLicense
    extends AbstractIDLCommand {
        int m_result;
        private volatile boolean m_finished = false;

        public HasDevkitLicense() {
            this.setUpdateDebugModel(false);
        }

        public void activate(IIDLProcessProxy idl) {
            String cmd = "DEFSYSV, '!IDLDT_TempLong', 0L & !IDLDT_TempLong = LMGR('devkit',VERSION=Strmid(!Version.release,0,2))";
            DMLAccess.silentExecuteString((long)idl.getDebugID(), (String)cmd);
            IDLVariable var = new IDLVariable();
            DMLAccess.getIDLVariable((long)idl.getDebugID(), (String)"!IDLDT_TempLong", (IDLVariable)var);
            this.m_result = (Integer)var.getValue();
            this.m_finished = true;
        }

        public boolean hasFinished() {
            return this.m_finished;
        }

        public int getResult() {
            return this.m_result;
        }
    }
}

