/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.actions.OpenLocalFileAction;
import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IGUIHandler;
import com.rsi.idldt.core.internal.interp.commands.SilentExecuteStringCommand;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.ICompilerError;
import com.rsi.idldt.core.utils.WorkspaceUtilities;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.ModalResponseRunnable;
import com.rsi.idldt.proeditor.ProblemsLabelDecorator;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.profiler.ProfilerStartAction;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.IDLHelpUtilities;
import com.rsi.idldt.ui.IDLViewUtilities;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.jdml.CompileErrorContext;
import com.rsi.jdml.IModalDialogInfo;
import java.util.HashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class GUIHandler
implements IGUIHandler {
    private boolean triedLowerCaseName = false;

    public boolean handleResetConfirm() {
        return true;
    }

    public boolean handleModalResponse(IModalDialogInfo modalInfo) {
        ModalResponseRunnable runnable = new ModalResponseRunnable(modalInfo);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runnable);
        return runnable.getAnswer();
    }

    public void handleOpenFile(final String nativeFilePath) {
        String fullPath = nativeFilePath;
        IFileStore fs = EFS.getLocalFileSystem().getStore((IPath)new Path(fullPath));
        IFileInfo info = fs.fetchInfo();
        if (!info.exists() && !this.triedLowerCaseName) {
            this.triedLowerCaseName = true;
            String fileName = info.getName().toLowerCase();
            SilentExecuteStringCommand cmd = new SilentExecuteStringCommand(".EDIT " + fileName);
            IDLProcessManager.getActiveProcess().getCommandManager().queueCommand((AbstractIDLCommand)cmd);
            return;
        }
        this.triedLowerCaseName = false;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IDLEditorUtilities.openNativeFileInEditor(nativeFilePath);
            }
        });
    }

    public void handleCompileError(ICompilerError error) {
        CompileErrorContext ctx = error.getContext();
        String nfp = ctx.getNativeFilePath();
        IFile resource = WorkspaceUtilities.getWorkspaceFileByOSPath((String)nfp);
        if (resource != null) {
            try {
                HashMap<String, Object> attributes = new HashMap<String, Object>(6);
                attributes.put("message", error.getErrorMessage());
                attributes.put("severity", new Integer(2));
                attributes.put("priority", new Integer(2));
                int line = ctx.getLineNumber();
                if (line > 0) {
                    attributes.put("lineNumber", new Integer(line));
                    int charStart = ctx.getCharNumber();
                    if (charStart >= 0) {
                        int count;
                        int offset = ProEditorUtilities.getOffsetAtLine(nfp, line - 1);
                        int charEnd = (charStart += offset - 1) + 2;
                        if (charEnd >= (count = ProEditorUtilities.getCharCount(nfp))) {
                            charEnd = count - 1;
                        }
                        if (charStart >= charEnd) {
                            charStart = charEnd - 2;
                        }
                        attributes.put("charStart", new Integer(charStart));
                        attributes.put("charEnd", new Integer(charEnd));
                    }
                }
                String location = String.valueOf(Messages.IDLStackFrame_LineNumber) + ' ' + Integer.toString(line);
                attributes.put("location", location);
                MarkerUtilities.createMarker((IResource)resource, attributes, (String)"org.eclipse.core.resources.problemmarker");
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IDLViewUtilities.highlightView("org.eclipse.ui.views.ProblemView", true);
                    }
                });
                ProblemsLabelDecorator.update();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void alertCompileFile(String filePath) {
        IFile res = WorkspaceUtilities.getWorkspaceFileByOSPath((String)filePath);
        if (res != null && this.resourceHasAProblemDecorator(res)) {
            try {
                res.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                ProblemsLabelDecorator.update();
            }
            catch (CoreException coreException) {}
        }
    }

    protected boolean resourceHasAProblemDecorator(IFile resource) {
        try {
            int severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
            if (severity >= 2) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void handleDeathHint() {
        IDLDTCorePlugin.performIDEExit();
    }

    public void handleIDLProcessGone() {
        if (!UIPlugin.isSuppressFatalDialogSet() && !IDLProcessManager.getActiveProcess().getResponseManager().exitDoneSeen()) {
            IModalDialogInfo info = new IModalDialogInfo(){

                public String getMessage() {
                    return Messages.IDLProcessGoneText;
                }

                public String getTitle() {
                    return Messages.IDLProcessGoneTitle;
                }

                public int getSeverity() {
                    return 2;
                }

                public boolean isQuestion() {
                    return false;
                }

                public boolean hasCancel() {
                    return false;
                }
            };
            ModalResponseRunnable runnable = new ModalResponseRunnable(info);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runnable);
        }
        IDLDTCorePlugin.performIDEExit();
    }

    public void handleHelpTopic(final String topic) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IDLHelpUtilities.helpTopic(topic);
            }
        });
    }

    public void handleWorkingDirChanged(String newDir) {
        OpenLocalFileAction.setFilterPath(newDir);
    }

    public void handleReset() {
        ProfilerStartAction.handleReset();
    }
}

