/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.internal.ui.IComboFilterer;
import com.rsi.idldt.internal.ui.Messages;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FilteredTextContributionItem
extends ControlContribution {
    IComboFilterer m_filterer;
    Text m_text;
    private Font m_font;
    boolean m_isNull;
    private Color m_gray;
    private Point m_size;
    private String m_helpContext;

    public FilteredTextContributionItem(IComboFilterer filterer) {
        super("com.rsi.idldt.internal.ui.FilteredTextContributionItem");
        this.m_filterer = filterer;
    }

    protected int computeWidth(Control control) {
        if (this.m_size == null) {
            GC gc = new GC((Drawable)control);
            FontMetrics fm = gc.getFontMetrics();
            this.m_size = new Point(15 * fm.getAverageCharWidth(), fm.getHeight());
            gc.dispose();
        }
        return this.m_size.x;
    }

    protected Control createControl(Composite parent) {
        Composite myparent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        myparent.setLayout((Layout)layout);
        Composite borderControl = new Composite(myparent, 2048);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1024;
        borderControl.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        borderControl.setLayout((Layout)layout);
        this.m_text = new Text(borderControl, 4);
        FontData[] f = parent.getDisplay().getSystemFont().getFontData();
        this.m_font = new Font((Device)parent.getDisplay(), f[0].getName(), f[0].getHeight(), f[0].getStyle());
        this.m_text.setFont(this.m_font);
        this.m_text.setToolTipText(Messages.ComboFilterTooltip);
        this.setDefaultFilterText(true);
        if (this.m_helpContext != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.m_text, this.m_helpContext);
        }
        this.computeWidth((Control)this.m_text);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.m_size.x;
        this.m_text.setLayoutData((Object)data);
        this.m_text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (FilteredTextContributionItem.this.m_isNull) {
                    FilteredTextContributionItem.this.setDefaultFilterText(false);
                    FilteredTextContributionItem.this.m_text.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                String text = FilteredTextContributionItem.this.m_text.getText();
                if (text.length() == 0) {
                    FilteredTextContributionItem.this.setDefaultFilterText(true);
                }
            }
        });
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FilteredTextContributionItem.this.m_isNull) {
                    String text = FilteredTextContributionItem.this.m_text.getText();
                    FilteredTextContributionItem.this.m_filterer.updateFilter(text);
                }
            }
        });
        return myparent;
    }

    public void setHelp(String helpContext) {
        this.m_helpContext = helpContext;
    }

    void setDefaultFilterText(boolean setDefault) {
        this.m_isNull = setDefault;
        if (setDefault) {
            if (this.m_gray == null) {
                this.m_gray = Display.getCurrent().getSystemColor(33);
            }
            this.m_text.setForeground(this.m_gray);
            this.m_text.setText(Messages.ComboFilterText);
        } else {
            this.m_text.setForeground(null);
        }
    }

    public void setText(String text) {
        this.setDefaultFilterText(false);
        this.m_text.setText(text);
        this.m_text.setFocus();
        int len = this.m_text.getText().length();
        this.m_text.setSelection(len);
    }

    public void dispose() {
        if (this.m_font != null) {
            this.m_font.dispose();
        }
        super.dispose();
    }
}

