/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.internal.ui.IComboFilterer;
import com.rsi.idldt.internal.ui.Messages;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FilteredComboContributionItem
extends ControlContribution {
    IComboFilterer m_filterer;
    Combo m_combo;

    public FilteredComboContributionItem(IComboFilterer filterer) {
        super("combo");
        this.m_filterer = filterer;
    }

    protected Control createControl(Composite parent) {
        this.m_combo = new Combo(parent, 4);
        this.m_combo.setToolTipText(Messages.ComboFilterTooltip);
        this.m_combo.add("", 0);
        this.m_combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredComboContributionItem.this.m_filterer.updateFilter(FilteredComboContributionItem.this.m_combo.getText());
            }
        });
        this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = FilteredComboContributionItem.this.m_combo.getSelectionIndex();
                if (index == -1) {
                    index = 0;
                    FilteredComboContributionItem.this.m_combo.select(0);
                }
                FilteredComboContributionItem.this.m_filterer.updateFilter(FilteredComboContributionItem.this.m_combo.getItem(index));
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                int index;
                String text = FilteredComboContributionItem.this.m_combo.getText();
                if (text == null || text.length() == 0) {
                    index = 0;
                } else {
                    index = FilteredComboContributionItem.this.m_combo.getItemCount() - 1;
                    while (index >= 0) {
                        if (text.equalsIgnoreCase(FilteredComboContributionItem.this.m_combo.getItem(index))) break;
                        --index;
                    }
                    if (index < 0) {
                        FilteredComboContributionItem.this.m_combo.add(text);
                        index = FilteredComboContributionItem.this.m_combo.getItemCount() - 1;
                    }
                }
                FilteredComboContributionItem.this.m_combo.select(index);
                FilteredComboContributionItem.this.m_filterer.updateFilter(FilteredComboContributionItem.this.m_combo.getItem(index));
            }
        });
        return this.m_combo;
    }

    public void setText(String text) {
        this.m_combo.setText(text);
        this.m_combo.setFocus();
        int len = this.m_combo.getText().length();
        this.m_combo.setSelection(new Point(len, len));
    }
}

