/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.ui.IWorkbenchWindow;

public class DebugUtilities {
    private static final String INDENT = "    ";

    public static void dumpAllActionBars() {
        IWorkbenchWindow ww = UIPlugin.getActiveWorkbenchWindow();
        if (ww instanceof ApplicationWindow) {
            CoolBarManager tools = ((ApplicationWindow)ww).getCoolBarManager();
            IContributionItem[] items = tools.getItems();
            try {
                System.out.println("==================================Dumping toolbars ");
                int i = 0;
                while (i < items.length) {
                    System.out.println(items[i].getId());
                    ++i;
                }
            }
            catch (Exception exception) {
                System.out.println("Error dumping toolbar");
            }
            System.out.println("==================================");
        }
    }

    public static void dumpMenu(String menuID) {
        IWorkbenchWindow ww = UIPlugin.getActiveWorkbenchWindow();
        if (ww instanceof ApplicationWindow) {
            MenuManager mm = ((ApplicationWindow)ww).getMenuBarManager();
            IMenuManager menu = mm.findMenuUsingPath(menuID);
            try {
                System.out.println("==================================Dumping menu '" + menuID + "'");
                System.out.println(menu.getId());
                DebugUtilities.dumpMenuStructure(INDENT, menu);
            }
            catch (Exception exception) {
                System.out.println("Error dumping menu");
            }
            System.out.println("==================================");
        }
    }

    public static void dumpMenuStructure(String indent, IMenuManager menu0) {
        IContributionItem[] children = menu0.getItems();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IMenuManager) {
                IMenuManager menu = (IMenuManager)children[i];
                System.out.println(String.valueOf(indent) + "menu: '" + menu.getId() + "' of type '" + children[i].getClass().getName() + "'");
                DebugUtilities.dumpMenuStructure(String.valueOf(indent) + INDENT, menu);
            } else if (children[i] instanceof SubContributionItem) {
                SubContributionItem sci = (SubContributionItem)children[i];
                System.out.println(String.valueOf(indent) + "subContributionItem of: " + sci.getInnerItem());
            } else {
                System.out.println(String.valueOf(indent) + children[i]);
            }
            ++i;
        }
    }
}

