/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.ui.UIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class CompileOrderTreeLabelProvider
implements ILabelProvider {
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
    private Image proIcon = CompileOrderTreeLabelProvider.createImage("icons/pro_file.gif");
    private Image savIcon = CompileOrderTreeLabelProvider.createImage("icons/sav_file.gif");

    public Image getImage(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (file.getName().endsWith(".pro")) {
                return this.proIcon;
            }
            if (file.getName().endsWith(".sav")) {
                return this.savIcon;
            }
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        return ((IFile)element).getName();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.proIcon.dispose();
        this.savIcon.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private static Image createImage(String location) {
        ImageDescriptor id = UIPlugin.getImageDescriptor(location);
        Image image = id.createImage();
        return image;
    }
}

