/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.core.IDLProjectCompileProperties;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CompileOrderTreeContentProvider
implements ITreeContentProvider {
    private IProject project;
    private Vector<IFile> allFiles;
    private Vector<IFile> buildFileList;

    public CompileOrderTreeContentProvider(IAdaptable selected) {
        if (selected instanceof IProject) {
            this.project = (IProject)selected;
            this.refreshPageData();
        } else {
            this.allFiles = new Vector();
            this.buildFileList = new Vector();
        }
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.allFiles.toArray();
    }

    public Object[] getSelectedElements() {
        return this.buildFileList.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void moveElementUp(IFile file) {
        int index = this.allFiles.indexOf(file);
        this.moveElement(file, index - 1);
    }

    public void moveElementToTop(IFile file) {
        this.moveElement(file, 0);
    }

    public void moveElementDown(IFile file) {
        int index = this.allFiles.indexOf(file);
        this.moveElement(file, index + 1);
    }

    public void moveElementToBottom(IFile file) {
        this.moveElement(file, this.allFiles.size() - 1);
    }

    public void moveElement(IFile file, int newIndex) {
        this.allFiles.remove(file);
        this.allFiles.insertElementAt(file, newIndex);
    }

    public boolean canMoveUp(IFile file) {
        return this.allFiles.indexOf(file) > 0;
    }

    public boolean canMoveDown(IFile file) {
        return this.allFiles.indexOf(file) < this.allFiles.size() - 1;
    }

    public void refreshPageData() {
        if (this.project != null) {
            this.allFiles = IDLProjectCompileProperties.getAllProjectFilesInCompileOrder((IProject)this.project);
            this.buildFileList = IDLProjectCompileProperties.removeExcludedFiles(this.allFiles);
        }
    }

    public void restoreDefaults() {
        Collections.sort(this.allFiles, new Comparator<IFile>(){

            @Override
            public int compare(IFile arg0, IFile arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        this.buildFileList = (Vector)this.allFiles.clone();
    }
}

