/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.internal.ui;

import com.rsi.idldt.internal.ui.IDLBrowserInformationControl;
import com.rsi.idldt.internal.ui.views.CommandLineView;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.proeditor.ProEditorServices;
import com.rsi.idldt.proeditor.pro.ProCodeScanner;
import com.rsi.idldt.proeditor.pro.ProCompletionProcessor;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class CommandLineSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    CommandLineView m_cmdLineView;
    private boolean enableColoring = true;
    private static boolean m_bContentAssistAutoInsert = true;
    private static ContentAssistant m_contentAssistant = null;

    public CommandLineSourceViewerConfiguration(CommandLineView cmdLineView) {
        this.m_cmdLineView = cmdLineView;
    }

    public void enableContentAssistAutoInsert(boolean value) {
        m_bContentAssistAutoInsert = value;
        if (m_contentAssistant != null) {
            m_contentAssistant.enableAutoInsert(value);
        }
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.addCompletionListener((ICompletionListener)this.m_cmdLineView);
        assistant.setRestoreCompletionProposalSize(this.getSettings("command_line_completion_proposal_size"));
        ProCompletionProcessor processor = new ProCompletionProcessor(1);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "pro_code");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoInsert(m_bContentAssistAutoInsert);
        m_contentAssistant = assistant;
        return assistant;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = UIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = UIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (!this.enableColoring) {
            return null;
        }
        PresentationReconciler reconciler = new PresentationReconciler();
        ProCodeScanner scanner = ProEditorServices.getProCodeScanner();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "pro_code");
        reconciler.setRepairer((IPresentationRepairer)dr, "pro_code");
        return reconciler;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                if (ProEditor.isFullHTMLSupported()) {
                    return new IDLBrowserInformationControl(parent, "org.eclipse.jface.dialogfont", false);
                }
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    public boolean getEnableColoring() {
        return this.enableColoring;
    }

    public void setEnableColoring(boolean enable) {
        this.enableColoring = enable;
    }
}

