/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.historyview;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IHistoricalCommand;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.historyview.CmdGroup;
import com.rsi.idldt.historyview.CommandHistoryFilter;
import com.rsi.idldt.historyview.CommandHistorySorter;
import com.rsi.idldt.historyview.CommandHistoryTreeContentProvider;
import com.rsi.idldt.historyview.CommandHistoryTreeLabelProvider;
import com.rsi.idldt.historyview.HistoricalCmd;
import com.rsi.idldt.internal.ui.FilteredTextContributionItem;
import com.rsi.idldt.internal.ui.IComboFilterer;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.ui.UIPlugin;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class CommandHistoryView
extends ViewPart
implements IIDLProcessListener,
Listener,
IComboFilterer {
    private CommandHistoryView m_view = this;
    TreeViewer m_trviewer;
    TextViewer m_textViewer;
    private CommandHistoryTreeContentProvider m_cp;
    FilteredTextContributionItem m_filter;
    static final int MIN_WIDTH = 200;
    IMemento m_memento = null;
    static final String STATE_COLUMNWIDTH = "columnWidth0";
    static final String STATE_TREEVIEW = "showTreeView";
    static final String STATE_SORTCOLUMN = "sortColumn";
    static final String STATE_SORTDIRECTION = "sortDirection";
    private Action m_treeviewAction;
    Action m_copyAction;

    public CommandHistoryView() {
        IDLProcessManager.addProcessListener((IIDLProcessListener)this);
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        this.setInputFromIDL(idl);
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }

    void restoreExpandCollapseState() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CommandHistoryTreeContentProvider cp = (CommandHistoryTreeContentProvider)CommandHistoryView.this.m_trviewer.getContentProvider();
                if (cp.getTreeView() && CommandHistoryView.this.m_memento != null) {
                    cp.restoreExpandCollapseStateOfGroups(CommandHistoryView.this.m_memento);
                }
            }
        });
    }

    private void setInputFromIDL(final IIDLProcessProxy idl) {
        if (idl != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CommandHistoryView.this.m_trviewer.setInput((Object)idl.getCommandHistory());
                    CommandHistoryView.this.m_trviewer.expandAll();
                    Timer t = new Timer();
                    t.schedule(new TimerTask(){

                        public void run() {
                            CommandHistoryView.this.restoreExpandCollapseState();
                        }
                    }, 500L);
                }
            });
        }
    }

    public void setTreeView(boolean bTreeView) {
        CommandHistorySorter sorter = (CommandHistorySorter)this.m_trviewer.getSorter();
        sorter.setSortContext(bTreeView);
        CommandHistoryTreeContentProvider cp = (CommandHistoryTreeContentProvider)this.m_trviewer.getContentProvider();
        cp.setTreeView(bTreeView);
        Tree tree = this.m_trviewer.getTree();
        tree.setSortColumn(tree.getColumn(sorter.getSortByDate() ? 1 : 0));
        tree.setSortDirection(sorter.getDirection());
        this.m_treeviewAction.setChecked(bTreeView);
        if (tree.isVisible()) {
            tree.setRedraw(false);
            this.m_trviewer.refresh();
            if (bTreeView) {
                this.m_trviewer.expandAll();
            }
            this.scrollToMostRecent();
            tree.setRedraw(true);
        }
    }

    private void scrollToMostRecent() {
        CommandHistoryTreeContentProvider cp = (CommandHistoryTreeContentProvider)this.m_trviewer.getContentProvider();
        cp.scrollToMostRecent();
    }

    public void flipDateColumnOrder() {
        int direction = ((CommandHistorySorter)this.m_trviewer.getSorter()).flipDateColumnOrder();
        Tree tree = this.m_trviewer.getTree();
        tree.setSortColumn(tree.getColumn(1));
        tree.setSortDirection(direction);
        tree.setRedraw(false);
        this.m_trviewer.refresh();
        this.scrollToMostRecent();
        tree.setRedraw(true);
    }

    public void flipCmdColumnOrder() {
        CommandHistoryTreeContentProvider cp = (CommandHistoryTreeContentProvider)this.m_trviewer.getContentProvider();
        if (cp.getTreeView()) {
            return;
        }
        int direction = ((CommandHistorySorter)this.m_trviewer.getSorter()).flipCmdColumnOrder();
        Tree tree = this.m_trviewer.getTree();
        tree.setSortColumn(tree.getColumn(0));
        tree.setSortDirection(direction);
        tree.setRedraw(false);
        this.m_trviewer.refresh();
        tree.setRedraw(true);
    }

    String getSortedSelection() {
        boolean bTreeViewSortedByDate;
        Tree tree = this.m_trviewer.getTree();
        boolean bl = bTreeViewSortedByDate = tree.getSortColumn() != tree.getColumn(0);
        if (bTreeViewSortedByDate) {
            return this.getSelectionSortByCommandDate();
        }
        return this.getSelectionSortByDisplayOrder();
    }

    private String getSelectionSortByDisplayOrder() {
        StringBuffer buff = new StringBuffer();
        int nCommands = 0;
        Tree tree = this.m_trviewer.getTree();
        TreeItem[] selection = tree.getSelection();
        int lenSelection = selection.length;
        int cTreeItems = tree.getItemCount();
        int[] ndxs = new int[cTreeItems];
        int j = 0;
        while (j < cTreeItems) {
            ndxs[j] = -1;
            ++j;
        }
        if (this.m_cp.getTreeView()) {
            TreeItem iparent;
            int i = 0;
            while (i < lenSelection) {
                TreeItem selTreeItem = selection[i];
                int ndxSelection = tree.indexOf(selTreeItem);
                if (ndxSelection == -1) {
                    iparent = selTreeItem.getParentItem();
                    int ndxParent = tree.indexOf(iparent);
                    if (ndxs[ndxParent] >= 0) {
                        int n = ndxParent;
                        ndxs[n] = ndxs[n] + 1;
                    } else {
                        ndxs[ndxParent] = 1;
                    }
                }
                ++i;
            }
            int[][] ndxsChildren = new int[cTreeItems][];
            i = 0;
            while (i < cTreeItems) {
                int numChildren = ndxs[i] == -1 ? 1 : ndxs[i];
                ndxsChildren[i] = new int[numChildren];
                j = 0;
                while (j < numChildren) {
                    ndxsChildren[i][j] = -1;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lenSelection) {
                TreeItem selTreeItem = selection[i];
                Object obj = selTreeItem.getData();
                if (!(obj instanceof CmdGroup)) {
                    TreeItem iparent2 = selTreeItem.getParentItem();
                    int ndxParent = tree.indexOf(iparent2);
                    int ndxChild = iparent2.indexOf(selTreeItem);
                    int numChildren = ndxs[ndxParent];
                    j = 0;
                    while (j < numChildren) {
                        if (ndxsChildren[ndxParent][j] == -1) {
                            ndxsChildren[ndxParent][j] = ndxChild;
                            break;
                        }
                        if (ndxChild < ndxsChildren[ndxParent][j]) {
                            int k = numChildren - 1;
                            while (k > j) {
                                ndxsChildren[ndxParent][k] = ndxsChildren[ndxParent][k - 1];
                                --k;
                            }
                            ndxsChildren[ndxParent][j] = ndxChild;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < cTreeItems) {
                int numChildren = ndxs[i];
                if (numChildren >= 1) {
                    iparent = tree.getItem(i);
                    j = 0;
                    while (j < numChildren) {
                        int ndxChild = ndxsChildren[i][j];
                        TreeItem child = iparent.getItem(ndxChild);
                        String strChild = child.getText();
                        if (nCommands == 1) {
                            buff.append('\n');
                        }
                        buff.append(strChild);
                        if (++nCommands >= 2) {
                            buff.append('\n');
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < lenSelection) {
                int ndxTreeItem = tree.indexOf(selection[i]);
                ndxs[ndxTreeItem] = i++;
            }
            j = 0;
            while (j < cTreeItems) {
                if (ndxs[j] != -1) {
                    int ndxSel = ndxs[j];
                    if (nCommands == 1) {
                        buff.append('\n');
                    }
                    buff.append(selection[ndxSel].getText());
                    if (++nCommands >= 2) {
                        buff.append('\n');
                    }
                }
                ++j;
            }
        }
        return buff.toString();
    }

    private String getSelectionSortByCommandDate() {
        StringBuffer buff = new StringBuffer();
        Tree tree = this.m_trviewer.getTree();
        TreeItem[] selection = tree.getSelection();
        int lenSelection = selection.length;
        IHistoricalCommand[] selCommands = new IHistoricalCommand[lenSelection];
        int numCmds = 0;
        int ndx = 0;
        int i = 0;
        while (i < lenSelection) {
            Object obj = selection[i].getData();
            if (obj instanceof HistoricalCmd) {
                selCommands[ndx++] = ((HistoricalCmd)obj).getCommand();
                ++numCmds;
            } else if (obj instanceof IHistoricalCommand) {
                selCommands[ndx++] = (IHistoricalCommand)obj;
                ++numCmds;
            }
            ++i;
        }
        boolean bRescan = true;
        block1: while (bRescan) {
            bRescan = false;
            i = 0;
            while (i < numCmds - 1) {
                Date cmdDate2;
                IHistoricalCommand cmd1 = selCommands[i];
                IHistoricalCommand cmd2 = selCommands[i + 1];
                Date cmdDate1 = cmd1.getDate();
                int icmp = cmdDate1.compareTo(cmdDate2 = cmd2.getDate());
                if (icmp > 0) {
                    IHistoricalCommand tmp = selCommands[i];
                    selCommands[i] = selCommands[i + 1];
                    selCommands[i + 1] = tmp;
                    bRescan = true;
                    continue block1;
                }
                ++i;
            }
        }
        i = 0;
        while (i < numCmds) {
            buff.append(selCommands[i].getText());
            if (numCmds >= 2) {
                buff.append('\n');
            }
            ++i;
        }
        return buff.toString();
    }

    public void createPartControl(Composite parent) {
        this.m_trviewer = new TreeViewer(parent, 66306);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.m_trviewer.getControl(), "com.rsi.idldt.ui.view_command_history");
        this.m_trviewer.setAutoExpandLevel(-1);
        Tree tree = this.m_trviewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        SelectionAdapter CmdColumnHeaderListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandHistoryView.this.flipCmdColumnOrder();
            }
        };
        SelectionAdapter DateColumnHeaderListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandHistoryView.this.flipDateColumnOrder();
            }
        };
        TreeColumn tc = new TreeColumn(tree, 0, 0);
        tc.setResizable(true);
        tc.setText(Messages.CommandHistoryView_CommandColumnHeading);
        tc.setWidth(200);
        tc.addSelectionListener((SelectionListener)CmdColumnHeaderListener);
        tc = new TreeColumn(tree, 0, 1);
        tc.setResizable(false);
        tc.setText("12/31/00 12:59 PM");
        tc.pack();
        tc.setText(Messages.CommandHistoryView_DateColumnHeading);
        tc.addSelectionListener((SelectionListener)DateColumnHeaderListener);
        this.m_trviewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character >= ' ' && e.character <= '~') {
                    if (CommandHistoryView.this.m_filter != null) {
                        CommandHistoryView.this.m_filter.setText(String.valueOf(e.character));
                        e.doit = false;
                    }
                    return;
                }
            }
        });
        this.m_cp = new CommandHistoryTreeContentProvider();
        this.m_trviewer.setContentProvider((IContentProvider)this.m_cp);
        this.m_trviewer.setLabelProvider((IBaseLabelProvider)new CommandHistoryTreeLabelProvider());
        this.m_trviewer.setSorter((ViewerSorter)new CommandHistorySorter());
        this.m_trviewer.addFilter((ViewerFilter)new CommandHistoryFilter());
        TreeColumn treecol1 = tree.getColumn(1);
        tree.setSortColumn(treecol1);
        tree.setSortDirection(((CommandHistorySorter)this.m_trviewer.getSorter()).getDirection());
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)this.m_trviewer.getTree(), 3);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){
            private Object data = null;

            public void dragStart(DragSourceEvent event) {
                this.data = CommandHistoryView.this.getSortedSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.data;
            }
        });
        this.m_trviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String cmd;
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object elm = sel.getFirstElement();
                if (elm instanceof IHistoricalCommand) {
                    cmd = ((IHistoricalCommand)elm).getText();
                } else if (elm instanceof HistoricalCmd) {
                    cmd = ((HistoricalCmd)elm).getText();
                } else {
                    return;
                }
                IDLProcessManager.queueExecuteString((String)cmd);
            }
        });
        IViewSite site = this.getViewSite();
        Shell shell = site.getShell();
        IActionBars bars = site.getActionBars();
        IToolBarManager mgr = bars.getToolBarManager();
        this.m_filter = new FilteredTextContributionItem(this.m_view);
        this.m_filter.setHelp("com.rsi.idldt.ui.view_command_history");
        mgr.add((IContributionItem)this.m_filter);
        this.m_textViewer = new TextViewer((Composite)shell, 10);
        this.m_textViewer.setDocument((IDocument)new Document());
        site.setSelectionProvider((ISelectionProvider)this.m_textViewer);
        this.m_copyAction = new Action(){

            public void run() {
                CommandHistoryView.this.m_textViewer.doOperation(4);
            }
        };
        ISharedImages images = this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.m_copyAction.setText(Messages.CommandLineView_CopyText);
        this.m_copyAction.setToolTipText(Messages.CommandLineView_CopyText);
        this.m_copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.m_copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.m_copyAction);
        this.m_trviewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String select = CommandHistoryView.this.getSortedSelection();
                StyledText text = CommandHistoryView.this.m_textViewer.getTextWidget();
                if (text != null && !text.isDisposed()) {
                    text.setText(select);
                    CommandHistoryView.this.m_textViewer.doOperation(7);
                    boolean canCopy = CommandHistoryView.this.m_textViewer.canDoOperation(4);
                    CommandHistoryView.this.m_copyAction.setEnabled(canCopy);
                }
            }
        });
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.hookContextMenu((Viewer)this.m_trviewer);
        this.restoreState();
        this.setInputFromIDL(IDLProcessManager.getActiveProcess());
    }

    private void hookContextMenu(Viewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommandHistoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.m_copyAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void createActions() {
        this.m_treeviewAction = new Action(Messages.CommandHistoryView_TreeViewAction){

            public void run() {
                CommandHistoryView.this.setTreeView(this.isChecked());
            }
        };
        this.m_treeviewAction.setImageDescriptor(UIPlugin.getImageDescriptor("icons/treeview.gif"));
        this.m_treeviewAction.setChecked(true);
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.m_treeviewAction);
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.m_treeviewAction);
    }

    public void updateFilter(String filter) {
        CommandHistoryFilter filterer = (CommandHistoryFilter)this.m_trviewer.getFilters()[0];
        String oldFilter = filterer.getFilter();
        if (oldFilter == null || oldFilter.compareToIgnoreCase(filter) != 0) {
            filterer.setFilter(filter);
            this.m_trviewer.getTree().setRedraw(false);
            this.m_trviewer.refresh();
            this.m_trviewer.getTree().setRedraw(true);
        }
    }

    public void dispose() {
        IViewSite site = this.getViewSite();
        if (site != null) {
            site.setSelectionProvider(null);
        }
        if (this.m_cp != null) {
            this.m_cp.dispose();
        }
    }

    public void setFocus() {
    }

    public void handleEvent(Event event) {
        Tracer.warning((String)("CommandLineHistory::handleEvent event=" + event));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.m_memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.m_trviewer != null) {
            CommandHistoryTreeContentProvider cp;
            Tree tree = this.m_trviewer.getTree();
            if (!tree.isDisposed()) {
                TreeColumn treeColumn;
                TreeColumn treeColumn0 = tree.getColumn(0);
                if (treeColumn0 != null) {
                    memento.putInteger(STATE_COLUMNWIDTH, treeColumn0.getWidth());
                }
                if ((treeColumn = tree.getSortColumn()) != null) {
                    memento.putInteger(STATE_SORTCOLUMN, treeColumn == treeColumn0 ? 0 : 1);
                    memento.putInteger(STATE_SORTDIRECTION, tree.getSortDirection());
                }
                CommandHistoryTreeContentProvider cp2 = (CommandHistoryTreeContentProvider)this.m_trviewer.getContentProvider();
                cp2.saveExpandCollapseStateOfGroups(memento);
            }
            if ((cp = (CommandHistoryTreeContentProvider)this.m_trviewer.getContentProvider()) != null) {
                memento.putInteger(STATE_TREEVIEW, cp.getTreeView() ? 1 : 0);
            }
        }
    }

    private void restoreState() {
        Integer iTreeView;
        int width;
        if (this.m_memento == null) {
            return;
        }
        Integer iWidth = this.m_memento.getInteger(STATE_COLUMNWIDTH);
        if (iWidth != null && (width = iWidth.intValue()) > 0) {
            this.m_trviewer.getTree().getColumn(0).setWidth(width);
        }
        if ((iTreeView = this.m_memento.getInteger(STATE_TREEVIEW)) != null) {
            boolean isTreeView = iTreeView != 0;
            this.setTreeView(isTreeView);
        }
        Integer iSortColumn = this.m_memento.getInteger(STATE_SORTCOLUMN);
        Integer iSortDirection = this.m_memento.getInteger(STATE_SORTDIRECTION);
        Tree tree = this.m_trviewer.getTree();
        if (tree != null && iSortColumn != null && iSortDirection != null) {
            int sortColumn = iSortColumn;
            int sortDirection = iSortDirection;
            tree.setSortColumn(tree.getColumn(sortColumn));
            tree.setSortDirection(sortDirection);
            CommandHistorySorter sorter = (CommandHistorySorter)this.m_trviewer.getSorter();
            sorter.setSortByDate(sortColumn == 1);
            sorter.setDirection(sortDirection);
        }
    }
}

