/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.historyview;

import com.rsi.idldt.core.ICommandHistory;
import com.rsi.idldt.core.ICommandHistoryListener;
import com.rsi.idldt.core.IHistoricalCommand;
import com.rsi.idldt.historyview.CmdGroup;
import com.rsi.idldt.historyview.CmdGroups;
import com.rsi.idldt.historyview.HistoricalCmd;
import com.rsi.idldt.internal.ui.Messages;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;

class CommandHistoryTreeContentProvider
implements ITreeContentProvider,
IBasicPropertyConstants,
ICommandHistoryListener {
    private static final int GRP_TODAY = 0;
    private static final int GRP_YESTERDAY = 1;
    private static final int GRP_THISWEEK = 2;
    private static final int GRP_LASTWEEK = 3;
    private static final int GRP_THISMONTH = 4;
    private static final int GRP_LASTMONTH = 5;
    private static final int GRP_OLDER = 6;
    private static final int GRP_NODATE = 7;
    private final String[] m_grpDesc = new String[]{Messages.CommandHistory_Today, Messages.CommandHistory_Yesterday, Messages.CommandHistory_ThisWeek, Messages.CommandHistory_LastWeek, Messages.CommandHistory_ThisMonth, Messages.CommandHistory_LastMonth, Messages.CommandHistory_Older, Messages.CommandHistory_NoDate};
    private ICommandHistory m_flatmodel;
    private CmdGroups m_treemodel = new CmdGroups(10, 2);
    Viewer m_viewer;
    private boolean m_bCurrentViewIsTreeView = true;
    private boolean m_bUpdateIsCommandAdded = false;

    public boolean getTreeView() {
        return this.m_bCurrentViewIsTreeView;
    }

    public void setTreeView(boolean bTreeView) {
        this.m_bCurrentViewIsTreeView = bTreeView;
    }

    public void scrollToMostRecent() {
        Control ctrl = this.m_viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        TreeViewer tv = (TreeViewer)this.m_viewer;
        Object cmd = null;
        if (this.m_bCurrentViewIsTreeView) {
            CmdGroup grp = this.m_treemodel.getFirstGroup();
            if (grp != null && grp.size() > 0) {
                tv.reveal((Object)grp);
                cmd = grp.elementAt(grp.size() - 1);
            }
        } else {
            cmd = this.m_flatmodel.getLastCommand();
        }
        if (cmd != null) {
            tv.reveal(cmd);
        }
    }

    public void commandHistoryChanged() {
        if (this.m_flatmodel == null) {
            return;
        }
        this.m_bUpdateIsCommandAdded = this.m_flatmodel.IsUpdateCommandAdded();
        if (this.m_bUpdateIsCommandAdded) {
            this.UpdateWithNewCommand();
        } else {
            this.RebuildInternalModel();
        }
        this.m_viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CommandHistoryTreeContentProvider.this.m_viewer.refresh();
            }
        });
    }

    private void UpdateWithNewCommand() {
        if (this.m_flatmodel == null) {
            return;
        }
        IHistoricalCommand cmd = this.m_flatmodel.getLastCommand();
        CmdGroup grpToday = this.m_treemodel.getGroupFromID(0);
        if (grpToday == null) {
            grpToday = new CmdGroup(this.m_treemodel, 0, this.m_grpDesc[0]);
            this.m_treemodel.insertElementAt(grpToday, 0);
        }
        grpToday.addCmd(cmd);
    }

    private void RebuildInternalModel() {
        this.m_treemodel.clear();
        if (this.m_flatmodel == null) {
            return;
        }
        int nCmds = this.m_flatmodel.getSize();
        if (nCmds == 0) {
            return;
        }
        IHistoricalCommand[] cmds = this.m_flatmodel.getCommands();
        CmdGroup grpToday = new CmdGroup(this.m_treemodel, 0, this.m_grpDesc[0]);
        CmdGroup grpYesterday = new CmdGroup(this.m_treemodel, 1, this.m_grpDesc[1]);
        CmdGroup grpThisWeek = new CmdGroup(this.m_treemodel, 2, this.m_grpDesc[2]);
        CmdGroup grpLastWeek = new CmdGroup(this.m_treemodel, 3, this.m_grpDesc[3]);
        CmdGroup grpThisMonth = new CmdGroup(this.m_treemodel, 4, this.m_grpDesc[4]);
        CmdGroup grpLastMonth = new CmdGroup(this.m_treemodel, 5, this.m_grpDesc[5]);
        CmdGroup grpOlder = new CmdGroup(this.m_treemodel, 6, this.m_grpDesc[6]);
        CmdGroup grpNoDate = new CmdGroup(this.m_treemodel, 7, this.m_grpDesc[7]);
        GregorianCalendar calCmd = new GregorianCalendar();
        Calendar calToday = Calendar.getInstance();
        int currYear = calToday.get(1);
        int currDOY = calToday.get(6);
        int currWOY = calToday.get(3);
        int currMonth = calToday.get(2);
        int i = 0;
        while (i < nCmds) {
            IHistoricalCommand cmd = cmds[i];
            calCmd.setTime(cmd.getDate());
            int cmdYear = calCmd.get(1);
            int cmdDOY = calCmd.get(6);
            int cmdWOY = calCmd.get(3);
            int cmdMonth = calCmd.get(2);
            boolean bAdded = false;
            if (!cmd.haveDate()) {
                grpNoDate.addCmd(cmd);
                bAdded = true;
            } else if (cmdYear == currYear) {
                if (currDOY == cmdDOY) {
                    grpToday.addCmd(cmd);
                    bAdded = true;
                } else if (currDOY - cmdDOY == 1) {
                    grpYesterday.addCmd(cmd);
                    bAdded = true;
                } else if (currWOY == cmdWOY) {
                    grpThisWeek.addCmd(cmd);
                    bAdded = true;
                } else if (currWOY - cmdWOY == 1) {
                    grpLastWeek.addCmd(cmd);
                    bAdded = true;
                } else if (currMonth == cmdMonth) {
                    grpThisMonth.addCmd(cmd);
                    bAdded = true;
                } else if (currMonth - cmdMonth == 1) {
                    grpLastMonth.addCmd(cmd);
                    bAdded = true;
                }
            }
            if (!bAdded) {
                grpOlder.addCmd(cmd);
            }
            ++i;
        }
        if (grpToday.size() > 0) {
            this.m_treemodel.addGroup(grpToday);
        }
        if (grpYesterday.size() > 0) {
            this.m_treemodel.addGroup(grpYesterday);
        }
        if (grpThisWeek.size() > 0) {
            this.m_treemodel.addGroup(grpThisWeek);
        }
        if (grpLastWeek.size() > 0) {
            this.m_treemodel.addGroup(grpLastWeek);
        }
        if (grpThisMonth.size() > 0) {
            this.m_treemodel.addGroup(grpThisMonth);
        }
        if (grpLastMonth.size() > 0) {
            this.m_treemodel.addGroup(grpLastMonth);
        }
        if (grpOlder.size() > 0) {
            this.m_treemodel.addGroup(grpOlder);
        }
        if (grpNoDate.size() > 0) {
            this.m_treemodel.addGroup(grpNoDate);
        }
    }

    public Object[] getChildren(Object element) {
        if (this.m_bCurrentViewIsTreeView) {
            if (element instanceof CmdGroup) {
                CmdGroup cmdgrp = (CmdGroup)element;
                return cmdgrp.getChildren();
            }
            return null;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (this.m_bCurrentViewIsTreeView) {
            if (element instanceof CmdGroup) {
                return ((CmdGroup)element).getParent();
            }
            if (element instanceof HistoricalCmd) {
                return ((HistoricalCmd)element).getParent();
            }
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.m_bCurrentViewIsTreeView) {
            return element instanceof CmdGroup;
        }
        return false;
    }

    public Object[] getElements(Object arg) {
        Object[] elms = this.m_bCurrentViewIsTreeView ? this.m_treemodel.getElements() : this.m_flatmodel.getCommands();
        return elms;
    }

    public void dispose() {
        if (this.m_flatmodel != null) {
            this.m_flatmodel.removeCommandHistoryListener((ICommandHistoryListener)this);
        }
        this.m_treemodel.clear();
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (oldInput != null) {
            ((ICommandHistory)oldInput).removeCommandHistoryListener((ICommandHistoryListener)this);
        }
        if (newInput != null) {
            ((ICommandHistory)newInput).addCommandHistoryListener((ICommandHistoryListener)this);
        }
        this.m_viewer = newViewer;
        this.m_flatmodel = (ICommandHistory)newInput;
        this.RebuildInternalModel();
    }

    public void restoreExpandCollapseStateOfGroups(IMemento memento) {
        this.restoreGroupState(5, memento);
        this.restoreGroupState(3, memento);
        this.restoreGroupState(7, memento);
        this.restoreGroupState(6, memento);
        this.restoreGroupState(4, memento);
        this.restoreGroupState(2, memento);
        this.restoreGroupState(0, memento);
        this.restoreGroupState(1, memento);
    }

    public void saveExpandCollapseStateOfGroups(IMemento memento) {
        this.saveGroupState(5, memento);
        this.saveGroupState(3, memento);
        this.saveGroupState(7, memento);
        this.saveGroupState(6, memento);
        this.saveGroupState(4, memento);
        this.saveGroupState(2, memento);
        this.saveGroupState(0, memento);
        this.saveGroupState(1, memento);
    }

    protected void saveGroupState(int groupId, IMemento memento) {
        TreeViewer tv = (TreeViewer)this.m_viewer;
        CmdGroup g = this.m_treemodel.getGroupFromID(groupId);
        if (g != null) {
            boolean b = tv.getExpandedState((Object)g);
            String key = "grp" + Integer.toString(200 + groupId);
            memento.putInteger(key, b ? 1 : 0);
        }
    }

    protected void restoreGroupState(int groupId, IMemento memento) {
        Integer state;
        TreeViewer tv = (TreeViewer)this.m_viewer;
        CmdGroup g = this.m_treemodel.getGroupFromID(groupId);
        if (g != null && (state = memento.getInteger("grp" + Integer.toString(200 + groupId))) != null) {
            boolean bExpanded = state != 0;
            tv.setExpandedState((Object)g, bExpanded);
        }
    }
}

