/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.historyview;

import com.rsi.idldt.core.IHistoricalCommand;
import com.rsi.idldt.historyview.CmdGroup;
import com.rsi.idldt.historyview.CommandHistoryTreeContentProvider;
import com.rsi.idldt.historyview.HistoricalCmd;
import java.util.Date;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class CommandHistorySorter
extends ViewerSorter {
    private int m_dat_iorder = 1;
    private int m_cmd_iorder = 1;
    private boolean m_sorting_on_date = true;

    public void setSortContext(boolean bTreeView) {
        if (bTreeView) {
            this.m_sorting_on_date = true;
        }
    }

    public boolean getSortByDate() {
        return this.m_sorting_on_date;
    }

    public void setSortByDate(boolean sortByDate) {
        this.m_sorting_on_date = sortByDate;
    }

    public int getDirection() {
        if (this.m_sorting_on_date) {
            return this.m_dat_iorder == 1 ? 128 : 1024;
        }
        return this.m_cmd_iorder == 1 ? 128 : 1024;
    }

    public void setDirection(int direction) {
        if (this.m_sorting_on_date) {
            this.m_dat_iorder = direction == 128 ? 1 : -1;
        } else {
            this.m_cmd_iorder = direction == 128 ? 1 : -1;
        }
    }

    public int flipDateColumnOrder() {
        this.m_sorting_on_date = true;
        this.m_dat_iorder *= -1;
        return this.getDirection();
    }

    public int flipCmdColumnOrder() {
        if (this.m_sorting_on_date) {
            this.m_sorting_on_date = false;
            this.m_cmd_iorder = 1;
        } else {
            this.m_cmd_iorder *= -1;
        }
        return this.getDirection();
    }

    public int category(Object element) {
        if (element instanceof CmdGroup) {
            return ((CmdGroup)element).getID();
        }
        return 0;
    }

    private int compareCommands(String c1, String c2) {
        String c1t = c1.trim();
        String c2t = c2.trim();
        int iorder = c1t.compareToIgnoreCase(c2t);
        return iorder *= this.m_cmd_iorder;
    }

    private int compareDates(Date d1, Date d2) {
        int iorder = d1.compareTo(d2);
        return iorder *= this.m_dat_iorder;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        CommandHistoryTreeContentProvider cp = null;
        boolean bTreeView = false;
        if (viewer != null && viewer instanceof TreeViewer) {
            cp = (CommandHistoryTreeContentProvider)((TreeViewer)viewer).getContentProvider();
            bTreeView = cp.getTreeView();
        }
        if (!bTreeView) {
            if (!(e1 instanceof IHistoricalCommand) || !(e2 instanceof IHistoricalCommand)) {
                return 0;
            }
            IHistoricalCommand hc1 = (IHistoricalCommand)e1;
            IHistoricalCommand hc2 = (IHistoricalCommand)e2;
            if (this.m_sorting_on_date) {
                return this.compareDates(hc1.getDate(), hc2.getDate());
            }
            return this.compareCommands(hc1.getText(), hc2.getText());
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            if (this.m_dat_iorder == 1) {
                return cat2 - cat1;
            }
            return cat1 - cat2;
        }
        HistoricalCmd hc1 = (HistoricalCmd)e1;
        HistoricalCmd hc2 = (HistoricalCmd)e2;
        return this.compareDates(hc1.getDate(), hc2.getDate());
    }
}

