/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.featurewizard;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectPluginProperties;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.ui.ArchiveUtils;
import com.rsi.idldt.ui.DOMWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteBuilder {
    private String outputDir;
    private IProject mainProject;
    private IDLProjectPluginProperties mainProjectProps;
    String outputFolderName;
    private boolean isObjectValid = true;
    private static String INSTALL_HANDLER_JAR_NAME = "com.rsi.idldt.idl.plugin.install.handler.jar";
    private static String INSTALL_HANDLER_CLASSPATH = "com.rsi.idldt.plugin.install.handler.IDLPluginInstallHandler";
    private Exception exception = null;
    private Vector<String> nonIDLProjRefs = new Vector();

    public UpdateSiteBuilder(IProject mainProject1) {
        this.mainProject = mainProject1;
        this.mainProjectProps = this.getFeatureProperties(this.mainProject);
        if (this.mainProjectProps == null) {
            this.isObjectValid = false;
        }
        try {
            if (this.isValid()) {
                File outputDirFile = new File(this.mainProjectProps.getFeatureOutputLocation());
                this.outputDir = outputDirFile.getCanonicalPath();
                if (!this.outputDir.endsWith(File.separator)) {
                    this.outputDir = String.valueOf(this.outputDir) + File.separator;
                }
                this.outputFolderName = String.valueOf(this.mainProjectProps.getFeatureID()) + "_updatesite";
                this.outputDir = String.valueOf(this.outputDir) + this.outputFolderName + File.separator;
            }
        }
        catch (IOException iOException) {
            this.outputDir = "";
            this.isObjectValid = false;
        }
    }

    public boolean isValid() {
        return this.isObjectValid;
    }

    private boolean isIDLProject(IProject project) {
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
        }
        catch (CoreException coreException) {
        }
        catch (Exception exception) {
            nature = null;
        }
        return nature != null;
    }

    private IDLProjectPluginProperties getFeatureProperties(IProject proj) {
        IDLProjectPluginProperties props;
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)proj.getNature("com.rsi.idldt.core.IDLNature");
            props = nature.getIDLProjectFeatureProperties();
        }
        catch (CoreException coreException) {
            props = null;
        }
        catch (Exception exception) {
            props = null;
        }
        return props;
    }

    public String buildFeatureFolderName(IDLProjectPluginProperties props, String outputDir1) {
        return String.valueOf(outputDir1) + (outputDir1.endsWith(File.separator) ? "" : File.separator) + "features" + File.separator + props.getFeatureID() + ".feature_" + props.getFeatureVersion();
    }

    public String buildPluginFolderName(IProject workingProject, String outputDir1) {
        return String.valueOf(outputDir1) + "plugins" + File.separator + this.getFeatureProperties(workingProject).getFeatureID() + "_" + this.getFeatureProperties(workingProject).getFeatureVersion();
    }

    public void createUpdateSite(IProgressMonitor monitor, IProject project) {
        try {
            if (!this.isValid()) {
                return;
            }
            try {
                monitor.beginTask(Messages.UpdateSiteBuilder_CreateSiteLabel, 3);
                this.checkCancel(monitor);
                this.createFeature(project, this.outputDir);
                monitor.worked(1);
                this.checkCancel(monitor);
                this.createAllPlugins(project, this.outputDir, monitor);
                monitor.worked(1);
                this.checkCancel(monitor);
                this.createSiteXML(project, this.outputDir);
                monitor.worked(1);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (Exception e) {
                Status status = new Status(4, "com.rsi.idldt.core", 0, e.getMessage(), (Throwable)e);
                IDLDTCorePlugin.getDefault().getLog().log((IStatus)status);
                this.exception = e;
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean success() {
        return this.exception == null;
    }

    public Exception getException() {
        return this.exception;
    }

    private void addNonIDLProjectToList(String projectName) {
        this.nonIDLProjRefs.add(projectName);
    }

    public String getNonIDLProjectList() {
        String returnValue = "";
        Iterator<String> iterator = this.nonIDLProjRefs.iterator();
        while (iterator.hasNext()) {
            returnValue = String.valueOf(returnValue) + "\n" + iterator.next();
        }
        return returnValue;
    }

    public void createFeature(IProject project, String siteOutputDir) throws FileNotFoundException, IllegalArgumentException, CoreException, Exception {
        IDLProjectPluginProperties props = this.getFeatureProperties(project);
        String featureFolder = this.buildFeatureFolderName(props, siteOutputDir);
        File featuresFolder = new File(featureFolder);
        if (!featuresFolder.exists()) {
            featuresFolder.mkdirs();
        }
        this.createFeatureXML(project, siteOutputDir);
        this.createInstallHandlerJAR(project, siteOutputDir);
        ArchiveUtils.createJarFromDirectory(String.valueOf(featureFolder) + File.separator, String.valueOf(featureFolder) + ".jar");
        this.deleteDirTree(new File(featureFolder), true, true);
    }

    public void createFeatureXML(IProject project, String siteOutputDir) throws ParserConfigurationException, TransformerException, CoreException, IOException {
        IDLProjectPluginProperties props = this.getFeatureProperties(project);
        String updateURL = props.getFeatureUpdateURL();
        String siteName = props.getFeatureUpdateSiteName();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element featureElement = document.createElement("feature");
        featureElement.setAttribute("id", String.valueOf(props.getFeatureID()) + ".feature");
        featureElement.setAttribute("label", props.getFeatureName());
        featureElement.setAttribute("version", props.getFeatureVersion());
        String providerName = props.getFeatureProvider();
        if (!providerName.equals("")) {
            featureElement.setAttribute("provider-name", props.getFeatureProvider());
        }
        document.appendChild(featureElement);
        Element installHandlerElement = document.createElement("install-handler");
        installHandlerElement.setAttribute("library", INSTALL_HANDLER_JAR_NAME);
        installHandlerElement.setAttribute("handler", INSTALL_HANDLER_CLASSPATH);
        featureElement.appendChild(installHandlerElement);
        Element descriptionElement = document.createElement("description");
        descriptionElement.appendChild(document.createTextNode(props.getFeatureDescription()));
        if (!updateURL.equals("")) {
            descriptionElement.setAttribute("url", props.getFeatureUpdateURL());
        }
        featureElement.appendChild(descriptionElement);
        Element copyrightElement = document.createElement("copyright");
        copyrightElement.appendChild(document.createTextNode(props.getFeatureCopyright()));
        featureElement.appendChild(copyrightElement);
        Element licenseElement = document.createElement("license");
        licenseElement.appendChild(document.createTextNode(props.getFeatureLicense()));
        featureElement.appendChild(licenseElement);
        if (!updateURL.equals("")) {
            Element urlElement = document.createElement("url");
            Element updateElement = document.createElement("update");
            updateElement.setAttribute("url", updateURL);
            if (!siteName.equals("")) {
                updateElement.setAttribute("label", siteName);
            }
            urlElement.appendChild(updateElement);
            featureElement.appendChild(urlElement);
        }
        featureElement.appendChild(this.createPluginElement(document, project));
        IProject[] references = project.getReferencedProjects();
        int count = 0;
        while (count < references.length) {
            if (this.isIDLProject(references[count])) {
                featureElement.appendChild(this.createPluginElement(document, references[count]));
            } else {
                this.addNonIDLProjectToList(references[count].getName());
            }
            ++count;
        }
        document.getDocumentElement().normalize();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        this.writeXMLElementToFile(featureElement, String.valueOf(this.buildFeatureFolderName(props, siteOutputDir)) + File.separator + "feature.xml");
    }

    private Element createPluginElement(Document document, IProject project) {
        Element pluginElement = document.createElement("plugin");
        pluginElement.setAttribute("id", this.getFeatureProperties(project).getFeatureID());
        pluginElement.setAttribute("version", this.getFeatureProperties(project).getFeatureVersion());
        return pluginElement;
    }

    public void createAllPlugins(IProject project, String outputDir1, IProgressMonitor monitor) throws CoreException, Exception {
        this.createSinglePlugin(project, project, outputDir1, monitor);
        IProject[] references = project.getReferencedProjects();
        int count = 0;
        while (count < references.length) {
            if (this.isIDLProject(references[count])) {
                this.createSinglePlugin(references[count], project, outputDir1, monitor);
            }
            ++count;
        }
    }

    public void createSinglePlugin(IProject workingProject, IProject mainProject1, String outputDir1, IProgressMonitor monitor) throws Exception {
        String pluginFolderName = this.buildPluginFolderName(workingProject, outputDir1);
        this.checkCancel(monitor);
        File pluginFolder = new File(String.valueOf(pluginFolderName) + File.separator + "META-INF");
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        this.createPluginManifestFile(workingProject, mainProject1, outputDir1);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(String.valueOf(pluginFolderName) + ".jar"));
        File manifest = new File(String.valueOf(pluginFolderName) + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
        ArchiveUtils.addFileEntry((ZipOutputStream)jos, "META-INF/MANIFEST.MF", manifest.lastModified());
        ArchiveUtils.addFileToArchive((ZipOutputStream)jos, manifest);
        jos.closeEntry();
        this.deleteDirTree(new File(pluginFolderName), true, true);
        Vector<IResource> filesToCopy = this.getPluginCopyList(workingProject, outputDir1, monitor);
        this.copyProjectFilesToPluginJar(filesToCopy, jos, monitor);
        jos.close();
    }

    private Vector<IResource> getPluginCopyList(IProject workingProject, final String outputDir1, final IProgressMonitor monitor) throws CoreException, IOException {
        final Vector<IResource> list = new Vector<IResource>();
        final String workingProjectDir = String.valueOf(new File(workingProject.getLocation().toOSString()).getCanonicalPath()) + File.separator;
        workingProject.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                boolean continueVisit = true;
                UpdateSiteBuilder.this.checkCancel(monitor);
                if (resource.getType() == 2) {
                    continueVisit = this.visitDirectory(resource);
                }
                if (resource.getType() == 1 && this.okToAddFile(resource)) {
                    list.add(resource);
                }
                return continueVisit;
            }

            private boolean okToAddFile(IResource resource) {
                return !resource.getName().equals(".project");
            }

            private boolean visitDirectory(IResource resource) {
                String dir;
                block4: {
                    String name = resource.getName();
                    try {
                        dir = String.valueOf(new File(resource.getLocation().toOSString()).getCanonicalPath()) + File.separator;
                        if (!this.isOutputDirSameAsProject() || !name.equals(UpdateSiteBuilder.this.outputFolderName)) break block4;
                        return false;
                    }
                    catch (IOException iOException) {}
                }
                if (dir.equals(outputDir1)) {
                    return false;
                }
                return true;
            }

            private boolean isOutputDirSameAsProject() {
                return outputDir1.equals(workingProjectDir);
            }
        });
        return list;
    }

    public void createPluginManifestFile(IProject workingProject, IProject mainProject1, String outputDir1) throws IOException, Exception {
        String pluginFolderName = this.buildPluginFolderName(workingProject, outputDir1);
        IDLProjectPluginProperties props = this.getFeatureProperties(workingProject);
        Vector<String> lines = new Vector<String>();
        lines.add("Manifest-Version: 1.0");
        lines.add("Bundle-ManifestVersion: 2");
        lines.add("Bundle-Name: " + props.getFeatureName());
        lines.add("Bundle-SymbolicName: " + props.getFeatureID());
        lines.add("Bundle-Version: " + props.getFeatureVersion());
        lines.add("Bundle-Vendor: " + props.getFeatureProvider());
        File pluginManifest = new File(String.valueOf(pluginFolderName) + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
        this.writeStringCollectionToFile(pluginManifest, lines, "UTF8");
    }

    public void deleteDirTree(File dir, boolean delete_dir, boolean delete_root) throws FileNotFoundException, IllegalArgumentException {
        File[] filelist = dir.listFiles();
        File tmpFile = null;
        if (filelist != null) {
            int count = 0;
            while (count < filelist.length) {
                tmpFile = filelist[count];
                if (tmpFile.isDirectory()) {
                    this.deleteDirTree(tmpFile, delete_dir, true);
                } else if (tmpFile.isFile()) {
                    tmpFile.delete();
                }
                ++count;
            }
        }
        if (delete_dir && delete_root) {
            dir.delete();
        }
    }

    public void writeStringCollectionToFile(File file, AbstractCollection<String> collection, String charsetName) throws IOException, Exception {
        Iterator<String> iterator = collection.iterator();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName));
        PrintWriter pw = new PrintWriter(bw);
        while (iterator.hasNext()) {
            pw.println(iterator.next());
        }
        pw.close();
    }

    /*
     * Unable to fully structure code
     */
    public void copyProjectFilesToPluginJar(Vector<IResource> fileList, JarOutputStream jos, IProgressMonitor monitor) throws IOException {
        iterator = fileList.iterator();
        if (fileList.size() != 0) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            obj = iterator.next();
            if (!(obj instanceof IResource)) continue;
            this.checkCancel(monitor);
            current = obj;
            if (current.getType() != 1) continue;
            file = new File(current.getLocation().toOSString());
            ArchiveUtils.addFileEntry((ZipOutputStream)jos, current.getProjectRelativePath().toString(), file.lastModified());
            ArchiveUtils.addFileToArchive((ZipOutputStream)jos, file);
            jos.closeEntry();
lbl13:
            // 4 sources

            ** while (iterator.hasNext())
        }
lbl14:
        // 1 sources

        jos.close();
    }

    public void copyDirectory(File source, File destination, File excludeDir) throws IOException {
        File[] list = source.listFiles();
        int count = 0;
        while (count < list.length) {
            if (list[count].isDirectory() && !list[count].getCanonicalPath().equals(excludeDir.getCanonicalPath()) && !list[count].getName().toLowerCase().equals("features") && !list[count].getName().toLowerCase().equals("plugins")) {
                File newDir = new File(String.valueOf(destination.getCanonicalPath()) + File.separator + list[count].getName());
                newDir.mkdirs();
                this.copyDirectory(list[count], newDir, excludeDir);
            } else if (!(list[count].isDirectory() || list[count].getName().equals(".project") || list[count].getName().toLowerCase().equals("site.xml"))) {
                File sourceFile = new File(list[count].getCanonicalPath());
                File destFile = new File(String.valueOf(destination.getCanonicalPath()) + File.separator + sourceFile.getName());
                this.copyFile(sourceFile, destFile);
            }
            ++count;
        }
    }

    public void copyFile(File source, File destination) throws IOException {
        int nRead;
        FileOutputStream fos = new FileOutputStream(destination);
        FileInputStream fis = new FileInputStream(source);
        byte[] buffer = new byte[8196];
        while ((nRead = fis.read(buffer, 0, buffer.length)) > 0) {
            fos.write(buffer, 0, nRead);
        }
        fis.close();
        fos.close();
    }

    protected void checkCancel(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void createSiteXML(IProject project, String outputDir1) throws ParserConfigurationException, IOException {
        IDLProjectPluginProperties props = this.getFeatureProperties(project);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element rootElement = document.createElement("site");
        document.appendChild(rootElement);
        Element descriptionElement = document.createElement("description");
        descriptionElement.appendChild(document.createTextNode(props.getFeatureDescription()));
        if (!props.getFeatureUpdateURL().equals("")) {
            descriptionElement.setAttribute("url", props.getFeatureUpdateURL());
        }
        Element featureElement = document.createElement("feature");
        featureElement.setAttribute("url", "features/" + props.getFeatureID() + ".feature_" + props.getFeatureVersion() + ".jar");
        featureElement.setAttribute("id", String.valueOf(props.getFeatureID()) + ".feature");
        featureElement.setAttribute("version", props.getFeatureVersion());
        Element categoryElement = document.createElement("category");
        categoryElement.setAttribute("name", "IDLWorkbenchPlugins");
        Element catDefElement = document.createElement("category-def");
        catDefElement.setAttribute("name", "IDLWorkbenchPlugins");
        catDefElement.setAttribute("label", "IDL Workbench Plugins");
        rootElement.appendChild(descriptionElement);
        rootElement.appendChild(featureElement);
        featureElement.appendChild(categoryElement);
        rootElement.appendChild(catDefElement);
        document.getDocumentElement().normalize();
        this.writeXMLElementToFile(rootElement, String.valueOf(outputDir1) + File.separator + "site.xml");
    }

    private void writeXMLElementToFile(Element element, String filename) throws IOException {
        OutputStreamWriter osw = null;
        PrintWriter domWriter = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8");
            domWriter = new DOMWriter(osw);
            ((DOMWriter)domWriter).print(element);
            osw.flush();
        }
        finally {
            if (domWriter != null) {
                domWriter.close();
            }
            if (osw != null) {
                osw.close();
            }
        }
    }

    protected void createInstallHandlerJAR(IProject project, String siteOutputDir) throws FileNotFoundException, IOException {
        String[] identifiers = new String[]{"com/rsi/idldt/plugin/install/handler/IDLPluginInstallHandler.class", "com/rsi/idldt/plugin/install/handler/IDLPluginInstallHandlerFileFilter.class"};
        String prefix = "";
        String featureFolderName = this.buildFeatureFolderName(this.getFeatureProperties(project), this.outputDir);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(String.valueOf(featureFolderName) + File.separator + INSTALL_HANDLER_JAR_NAME));
        Bundle bundle = Platform.getBundle((String)"com.rsi.idldt.ui");
        if (!FileLocator.getBundleFile((Bundle)bundle).getName().endsWith(".jar")) {
            prefix = "bin/";
        }
        int index = 0;
        while (index < identifiers.length) {
            Path path = new Path(String.valueOf(prefix) + identifiers[index]);
            URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
            if (fileURL != null) {
                Date date = new Date();
                InputStream is = fileURL.openStream();
                ArchiveUtils.addFileEntry((ZipOutputStream)jos, identifiers[index], date.getTime());
                ArchiveUtils.addFileToArchive((ZipOutputStream)jos, is);
                jos.closeEntry();
            }
            ++index;
        }
        jos.close();
    }
}

