/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.featurewizard;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectPluginProperties;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.ui.UIPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.framework.Version;

public class PluginPropertiesGUI {
    public static int PLUGIN_PROPERTIES_PAGE = 0;
    public static int PLUGIN_WIZARD_PAGE = 1;
    static int TEXT_CHAR_LIMIT = 2048;
    private IDLProjectPluginProperties props;
    private Text featureID;
    private Text featureName;
    private Text featureVersion;
    private Text featureProvider;
    private Text updateSiteURL;
    private Text updateSiteName;
    Text featureDescription;
    Text featureCopyright;
    Text featureLicense;
    Text outputLocation;
    Composite composite;
    CTabFolder tabFolder;
    Button browseButton;
    Button importButton;
    private int pageType;
    private DialogPage parentPage;
    IDialogSettings dialogSettings;
    public static String PPG_IMPORT_DIR = "PPG_IMPORT_DIR";
    public static String PPG_SECTION_NAME = "PLUGIN_PROPERTIES_GUI";

    public PluginPropertiesGUI(IProject project, int pageType1, DialogPage parentPage1) {
        this.props = this.getFeatureProperties(project);
        this.parentPage = parentPage1;
        if (pageType1 == 0) {
            this.pageType = PLUGIN_PROPERTIES_PAGE;
        } else {
            this.pageType = PLUGIN_WIZARD_PAGE;
            this.parentPage.setTitle(Messages.IDLPluginWizard_Page1Title);
            this.parentPage.setDescription(Messages.IDLPluginWizard_Description);
        }
        this.dialogSettings = UIPlugin.getDefault().getDialogSettings();
        this.dialogSettings.addNewSection(PPG_SECTION_NAME);
    }

    protected IDLProjectPluginProperties getFeatureProperties(IProject proj) {
        IDLProjectPluginProperties props1;
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)proj.getNature("com.rsi.idldt.core.IDLNature");
            props1 = nature.getIDLProjectFeatureProperties();
        }
        catch (CoreException coreException) {
            props1 = null;
        }
        catch (Exception exception) {
            props1 = null;
        }
        return props1;
    }

    public Composite createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        if (this.isPluginWizardPage()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.rsi.idldt.ui.wizard_plugin");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.rsi.idldt.ui.plugin_properties_idl_project");
        }
        GridLayout overallLayout = new GridLayout();
        overallLayout.marginHeight = 5;
        overallLayout.marginWidth = 5;
        this.composite.setLayout((Layout)overallLayout);
        this.createFeaturePropertiesGroup(this.composite);
        this.createUpdateSitePropertiesGroup(this.composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.composite.setLayoutData((Object)gridData);
        GridLayout overallLayout1 = new GridLayout();
        overallLayout1.marginHeight = 10;
        overallLayout1.marginWidth = 10;
        this.composite.setLayout((Layout)overallLayout1);
        this.createTabArea(this.composite);
        if (this.isPluginWizardPage()) {
            this.createOutputLocationText(this.composite);
            this.setBrowseButtonListener();
        } else {
            this.outputLocation = null;
        }
        this.populateValues();
        if (this.outputLocation != null) {
            this.setPageComplete(!this.outputLocation.getText().equals(""));
        }
        this.setUpModifyListeners();
        this.setUpFocusListeners();
        this.setUpEnterKeyTraversalListeners();
        return this.composite;
    }

    public int getPageType() {
        return this.pageType;
    }

    public boolean isPluginPropsPage() {
        return this.getPageType() == PLUGIN_PROPERTIES_PAGE;
    }

    public boolean isPluginWizardPage() {
        return this.getPageType() == PLUGIN_WIZARD_PAGE;
    }

    private void setUpEnterKeyTraversalListeners() {
        this.featureID.addTraverseListener((TraverseListener)new EnterKeyToTabTraverseListener());
        this.featureName.addTraverseListener((TraverseListener)new EnterKeyToTabTraverseListener());
        this.featureVersion.addTraverseListener((TraverseListener)new EnterKeyToTabTraverseListener());
        this.featureProvider.addTraverseListener((TraverseListener)new EnterKeyToTabTraverseListener());
        this.updateSiteName.addTraverseListener((TraverseListener)new EnterKeyToTabTraverseListener());
        this.updateSiteURL.addTraverseListener((TraverseListener)new EnterKeyToTabTraverseListener());
    }

    private void setUpModifyListeners() {
        this.featureID.addModifyListener((ModifyListener)new CallValidateListener());
        this.featureVersion.addModifyListener((ModifyListener)new CallValidateListener());
        this.featureDescription.addModifyListener((ModifyListener)new CallValidateListener());
        this.featureCopyright.addModifyListener((ModifyListener)new CallValidateListener());
        this.featureLicense.addModifyListener((ModifyListener)new CallValidateListener());
        if (this.outputLocation != null) {
            this.outputLocation.addModifyListener((ModifyListener)new CallValidateListener());
        }
    }

    private void setUpFocusListeners() {
        this.featureID.addFocusListener((FocusListener)new GUIFocusListener());
        this.featureName.addFocusListener((FocusListener)new GUIFocusListener());
        this.featureVersion.addFocusListener((FocusListener)new GUIFocusListener());
        this.featureProvider.addFocusListener((FocusListener)new GUIFocusListener());
        this.updateSiteURL.addFocusListener((FocusListener)new GUIFocusListener());
        this.updateSiteName.addFocusListener((FocusListener)new GUIFocusListener());
        this.featureDescription.addFocusListener((FocusListener)new GUIFocusListener());
        this.featureCopyright.addFocusListener((FocusListener)new GUIFocusListener());
        this.featureLicense.addFocusListener((FocusListener)new GUIFocusListener());
        if (this.outputLocation != null) {
            this.outputLocation.addFocusListener((FocusListener)new GUIFocusListener());
        }
    }

    private void setPageComplete(boolean complete) {
        if (this.parentPage instanceof WizardPage) {
            ((WizardPage)this.parentPage).setPageComplete(complete);
        }
    }

    public void setMessage(String message, int type) {
        this.parentPage.setMessage(message, type);
    }

    public void setValid(boolean valid) {
        if (this.parentPage instanceof PropertyPage) {
            ((PropertyPage)this.parentPage).setValid(valid);
        }
    }

    void performPageValidation() {
        String filename;
        File file;
        if (!this.isFeatureIDValid()) {
            this.setMessage(Messages.IDLProjectFeaturePage_IDLInvalidFeatureId, 3);
            this.setPageComplete(false);
            this.setValid(false);
            return;
        }
        if (!this.isFeatureVersionValid()) {
            this.setMessage(Messages.IDLProjectFeaturePage_IDLInvalidFeatureVersion, 3);
            this.setPageComplete(false);
            this.setValid(false);
            return;
        }
        if (this.featureDescription.getText().trim().equals("")) {
            this.setMessage(Messages.IDLPluginWizard_DescriptionErrorMsg, 3);
            this.setPageComplete(false);
            this.setValid(false);
            return;
        }
        if (this.featureCopyright.getText().trim().equals("")) {
            this.setMessage(Messages.IDLPluginWizard_CopyrightErrorMsg, 3);
            this.setPageComplete(false);
            this.setValid(false);
            return;
        }
        if (this.featureLicense.getText().trim().equals("")) {
            this.setMessage(Messages.IDLPluginWizard_LicenseErrorMsg, 3);
            this.setPageComplete(false);
            this.setValid(false);
            return;
        }
        if (!(this.outputLocation == null || (file = new File(filename = this.outputLocation.getText())).exists() && file.isDirectory())) {
            this.setMessage(Messages.IDLPluginWizard_IDLInvalidDir, 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(null, 0);
        this.setPageComplete(true);
        this.setValid(true);
    }

    private boolean isFeatureIDValid() {
        String regex = "([a-zA-Z0-9_]+)(\\.[a-zA-Z0-9_]+)*";
        String id = this.featureID.getText();
        return id.matches(regex);
    }

    private boolean isFeatureVersionValid() {
        boolean valid;
        try {
            Version.parseVersion((String)this.featureVersion.getText());
            valid = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            valid = false;
        }
        if (this.featureVersion.getText().equals("")) {
            valid = false;
        }
        return valid;
    }

    private int convertWidthOfCharToPixels(Font font, int chars) {
        GC gc = new GC((Drawable)font.getDevice());
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)chars);
    }

    private void createTabArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData tabData = new GridData(1808);
        tabData.widthHint = this.convertWidthOfCharToPixels(group.getFont(), 45);
        this.tabFolder = new CTabFolder((Composite)group, 0);
        this.tabFolder.setLayoutData((Object)tabData);
        this.tabFolder.setSimple(false);
        CTabItem tabItem1 = new CTabItem(this.tabFolder, 0);
        tabItem1.setText(Messages.IDLProjectFeaturePropertyPage_DescriptionLabel);
        Composite composite1 = new Composite((Composite)this.tabFolder, 0);
        composite1.setLayout((Layout)new FillLayout());
        this.featureDescription = new Text(composite1, 19010);
        this.featureDescription.setTextLimit(TEXT_CHAR_LIMIT);
        tabItem1.setControl((Control)composite1);
        CTabItem tabItem2 = new CTabItem(this.tabFolder, 0);
        tabItem2.setText(Messages.IDLProjectFeaturePropertyPage_CopyrightLabel);
        Composite composite2 = new Composite((Composite)this.tabFolder, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.featureCopyright = new Text(composite2, 19010);
        this.featureCopyright.setTextLimit(TEXT_CHAR_LIMIT);
        tabItem2.setControl((Control)composite2);
        CTabItem tabItem3 = new CTabItem(this.tabFolder, 0);
        tabItem3.setText(Messages.IDLProjectFeaturePropertyPage_LicenseLabel);
        Composite composite3 = new Composite((Composite)this.tabFolder, 0);
        composite3.setLayout((Layout)new FillLayout());
        this.featureLicense = new Text(composite3, 19010);
        this.featureLicense.setTextLimit(TEXT_CHAR_LIMIT);
        tabItem3.setControl((Control)composite3);
        this.tabFolder.setSelection(0);
        this.importButton = new Button((Composite)group, 0);
        this.importButton.setText(Messages.PluginProperties_ImportButtonText);
        this.importButton.setLayoutData((Object)new GridData(128));
        this.setImportButtonListener();
        GridData gd = new GridData(768);
        gd.heightHint = this.getTextFontHeight(this.featureLicense) * 14;
        group.setLayoutData((Object)gd);
    }

    public void populateValues() {
        if (this.props != null) {
            if (this.outputLocation != null) {
                this.outputLocation.setText(this.props.getFeatureOutputLocation());
            }
            this.featureID.setText(this.props.getFeatureID());
            this.featureName.setText(this.props.getFeatureName());
            this.featureVersion.setText(this.props.getFeatureVersion());
            this.featureProvider.setText(this.props.getFeatureProvider());
            this.updateSiteURL.setText(this.props.getFeatureUpdateURL());
            this.updateSiteName.setText(this.props.getFeatureUpdateSiteName());
            this.featureDescription.setText(this.props.getFeatureDescription());
            this.featureCopyright.setText(this.props.getFeatureCopyright());
            this.featureLicense.setText(this.props.getFeatureLicense());
        }
    }

    private int getTextFontHeight(Text text) {
        GC gc = new GC((Drawable)text);
        gc.setFont(text.getFont());
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        return metrics.getHeight();
    }

    private void createFeaturePropertiesGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.IDLProjectFeaturePropertyPage_FeatureLabel);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        GridLayout overallLayout = new GridLayout();
        overallLayout.numColumns = 3;
        overallLayout.marginHeight = 5;
        overallLayout.marginWidth = 5;
        group.setLayout((Layout)overallLayout);
        this.featureID = this.createStringPropertyGUI((Composite)group, Messages.IDLProjectFeaturePropertyPage_IdLabel);
        this.featureName = this.createStringPropertyGUI((Composite)group, Messages.IDLProjectFeaturePropertyPage_NameLabel);
        this.featureVersion = this.createStringPropertyGUI((Composite)group, Messages.IDLProjectFeaturePropertyPage_VersionLabel);
        this.featureProvider = this.createStringPropertyGUI((Composite)group, Messages.IDLProjectFeaturePropertyPage_ProviderLabel);
    }

    private void createUpdateSitePropertiesGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.IDLProjectFeaturePropertyPage_UpdateSiteLabel);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        GridLayout overallLayout = new GridLayout();
        overallLayout.numColumns = 3;
        overallLayout.marginHeight = 5;
        overallLayout.marginWidth = 5;
        group.setLayout((Layout)overallLayout);
        this.updateSiteName = this.createStringPropertyGUI((Composite)group, Messages.IDLProjectFeaturePropertyPage_UpdateSiteNameLabel);
        this.updateSiteURL = this.createStringPropertyGUI((Composite)group, Messages.IDLProjectFeaturePropertyPage_UpdateSiteUrlLabel);
    }

    private Text createStringPropertyGUI(Composite parent, String labelText) {
        GridData singleLineFill = new GridData();
        singleLineFill.horizontalAlignment = 4;
        singleLineFill.horizontalSpan = 2;
        singleLineFill.grabExcessHorizontalSpace = true;
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Text text = new Text(parent, 18436);
        text.setLayoutData((Object)singleLineFill);
        return text;
    }

    private void createOutputLocationText(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.IDLPluginWizard_OuputLocationLabel);
        GridData groupData = new GridData(272);
        groupData.horizontalSpan = 4;
        group.setLayoutData((Object)groupData);
        group.setLayout((Layout)new GridLayout(5, true));
        GridData textGridData = new GridData(768);
        textGridData.horizontalSpan = 4;
        this.outputLocation = new Text((Composite)group, 18436);
        this.outputLocation.setLayoutData((Object)textGridData);
        GridData buttonGridData = new GridData(768);
        this.browseButton = new Button((Composite)group, 0);
        this.browseButton.setText(Messages.IDLProjectPropertyPage_Browse);
        this.browseButton.setLayoutData((Object)buttonGridData);
    }

    private void setImportButtonListener() {
        this.importButton.addListener(13, new Listener(){
            private String selectedFile = "";
            private String data;

            public void handleEvent(Event event) {
                this.selectFile();
                this.importFile();
                this.setText();
            }

            private void importFile() {
                File file = new File(this.selectedFile);
                if (file.exists() && file.isFile()) {
                    try {
                        StringWriter sw = new StringWriter();
                        FileInputStream fis = new FileInputStream(file);
                        InputStreamReader isr = new InputStreamReader(fis);
                        int nRead = 0;
                        char[] buffer = new char[TEXT_CHAR_LIMIT];
                        nRead = isr.read(buffer, 0, buffer.length);
                        if (nRead > 0) {
                            sw.write(buffer, 0, nRead);
                        }
                        this.data = sw.toString();
                        isr.close();
                    }
                    catch (IOException e) {
                        Status status = new Status(4, "com.rsi.idldt.core", 0, String.valueOf(Messages.PluginProperties_FileReadError) + ": " + this.selectedFile + "\n" + e.getLocalizedMessage(), (Throwable)e);
                        IDLDTCorePlugin.getDefault().getLog().log((IStatus)status);
                        ErrorDialog.openError((Shell)PluginPropertiesGUI.this.composite.getShell(), (String)Messages.PluginProperties_FileReadError, (String)Messages.PluginProperties_ImportErrorMessage, (IStatus)status);
                    }
                }
            }

            private void setText() {
                if (this.data != null) {
                    switch (PluginPropertiesGUI.this.tabFolder.getSelectionIndex()) {
                        case 0: {
                            PluginPropertiesGUI.this.featureDescription.setText(this.data);
                            break;
                        }
                        case 1: {
                            PluginPropertiesGUI.this.featureCopyright.setText(this.data);
                            break;
                        }
                        case 2: {
                            PluginPropertiesGUI.this.featureLicense.setText(this.data);
                        }
                    }
                }
            }

            private void selectFile() {
                FileDialog dialog = new FileDialog(PluginPropertiesGUI.this.importButton.getShell());
                String[] extensions = new String[]{"*.txt", "*.*"};
                String initialDir = PluginPropertiesGUI.this.dialogSettings.getSection(PPG_SECTION_NAME).get(PPG_IMPORT_DIR);
                dialog.setText(Messages.PPC_FileBrowse_SelectFile);
                dialog.setFilterExtensions(extensions);
                if (initialDir != null) {
                    dialog.setFilterPath(initialDir);
                } else {
                    dialog.setFilterPath(System.getProperty("user.home"));
                }
                String path = dialog.open();
                if (path != null) {
                    this.selectedFile = path;
                    PluginPropertiesGUI.this.dialogSettings.getSection(PPG_SECTION_NAME).put(PPG_IMPORT_DIR, new File(path).getParent());
                }
            }
        });
    }

    private void setBrowseButtonListener() {
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                this.selectDirectory();
            }

            private void selectDirectory() {
                DirectoryDialog dialog = new DirectoryDialog(PluginPropertiesGUI.this.browseButton.getShell());
                dialog.setText(Messages.PPC_DirectoryBrowse_TitleSelectDirectory);
                dialog.setMessage(Messages.PPC_DirectoryBrowse_MessageSelectDirectory);
                dialog.setFilterPath(PluginPropertiesGUI.this.outputLocation.getText());
                String path = dialog.open();
                if (path != null) {
                    PluginPropertiesGUI.this.outputLocation.setText(path);
                }
            }
        });
    }

    public void savePropertyChanges() {
        if (this.props != null) {
            this.props.setFeatureID(this.featureID.getText());
            this.props.setFeatureName(this.featureName.getText());
            this.props.setFeatureVersion(this.featureVersion.getText());
            this.props.setFeatureProvider(this.featureProvider.getText());
            this.props.setFeatureUpdateURL(this.updateSiteURL.getText());
            this.props.setFeatureUpdateSiteName(this.updateSiteName.getText());
            this.props.setFeatureDescription(this.featureDescription.getText());
            this.props.setFeatureCopyright(this.featureCopyright.getText());
            this.props.setFeatureLicense(this.featureLicense.getText());
            if (this.outputLocation != null) {
                this.props.setFeatureOutputLocation(this.outputLocation.getText());
            }
        }
    }

    public void populateDefaultValues() {
        if (this.props != null) {
            this.featureID.setText(this.props.getDefaultFeatureID());
            this.featureName.setText(this.props.getDefaultFeatureName());
            this.featureVersion.setText(this.props.getDefaultFeatureVersion());
            this.featureProvider.setText(this.props.getDefaultFeatureProvider());
            this.featureDescription.setText(this.props.getDefaultFeatureDescription());
            this.featureCopyright.setText(this.props.getDefaultFeatureCopyright());
            this.featureLicense.setText(this.props.getDefaultFeatureLicense());
            this.updateSiteURL.setText(this.props.getDefaultFeatureUpdateURL());
            this.updateSiteName.setText(this.props.getDefaultFeatureUpdateSiteName());
            if (this.outputLocation != null) {
                this.outputLocation.setText(this.props.getDefaultFeatureOutputLocation());
            }
        }
    }

    class CallValidateListener
    implements ModifyListener {
        CallValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            PluginPropertiesGUI.this.performPageValidation();
        }
    }

    class EnterKeyToTabTraverseListener
    implements TraverseListener {
        EnterKeyToTabTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4 && e.stateMask == 0) {
                e.detail = 16;
            }
        }
    }

    class GUIFocusListener
    implements FocusListener {
        GUIFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof Text) {
                Text text = (Text)e.getSource();
                text.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

