/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.featurewizard;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.featurewizard.IDLPluginWizardPage;
import com.rsi.idldt.featurewizard.UpdateSiteBuilder;
import com.rsi.idldt.internal.ui.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDLExportPluginWizard
extends Wizard {
    IDLPluginWizardPage pluginWizardPageOne;
    IProject project;

    public void init(IProject project1) {
        this.project = project1;
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("IDLPluginWizard");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("IDLPluginWizard");
        }
        this.setDialogSettings(wizardSettings);
        this.setWindowTitle(Messages.IDLPluginWizard_WizardTitle);
    }

    public void addPages() {
        this.pluginWizardPageOne = new IDLPluginWizardPage(Messages.IDLPluginWizard_Page1Title, this.project);
        this.addPage((IWizardPage)this.pluginWizardPageOne);
    }

    public boolean performFinish() {
        this.pluginWizardPageOne.savePropertyChanges();
        final UpdateSiteBuilder usb = new UpdateSiteBuilder(this.project);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                usb.createUpdateSite(monitor, IDLExportPluginWizard.this.project);
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        Shell shell = win != null ? win.getShell() : null;
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (!usb.success()) {
            Status statusLocalized = new Status(4, "com.rsi.idldt.core", 0, usb.getException().getLocalizedMessage(), (Throwable)usb.getException());
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.UpdateSiteBuilder_ErrorDialogTitle, (String)usb.getException().getLocalizedMessage(), (IStatus)statusLocalized);
        }
        String nonIDLProjs = usb.getNonIDLProjectList();
        if (usb.success() && !nonIDLProjs.equals("")) {
            Exception ej = new Exception(String.valueOf(Messages.IDLExportPluginWizard_NonIDLProject) + nonIDLProjs);
            Status s = new Status(2, "com.rsi.idldt.core", ej.getMessage());
            IDLDTCorePlugin.getDefault().getLog().log((IStatus)s);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.IDLExportPluginWizard_PluginsNotIncludedTitle, (String)Messages.IDLExportPluginWizard_PluginsNotIncludedMessage, (IStatus)s);
        }
        return usb.success();
    }
}

