/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.ui;

import com.rsi.idldt.debug.internal.model.IDLValue;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import com.rsi.idldt.debug.ui.DebugLabelDecorator;
import com.rsi.idldt.debug.ui.DebugLabelProvider;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class DebugModelPresentation
extends DecoratingLabelProvider
implements IDebugModelPresentation {
    public DebugModelPresentation() {
        super((ILabelProvider)new DebugLabelProvider(), (ILabelDecorator)new DebugLabelDecorator());
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof IDLValue) {
            listener.detailComputed(value, ((IDLValue)value).getDetailPaneString());
        } else {
            listener.detailComputed(value, value.toString());
        }
    }

    public void setAttribute(String attribute, Object value) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof IFile || element instanceof ILineBreakpoint || element instanceof LocalFileStorage) {
            return UIPlugin.ID_PRO_EDITOR;
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        IFileStore file;
        Object path;
        FileEditorInput retVal = null;
        if (element instanceof IFile) {
            retVal = new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            IResource res = ((ILineBreakpoint)element).getMarker().getResource();
            if (res instanceof IFile) {
                retVal = new FileEditorInput((IFile)res);
            }
            if (element instanceof IIDLBreakpoint && (path = ((IIDLBreakpoint)element).getExternalPath()) != null) {
                file = EFS.getLocalFileSystem().getStore((IPath)new Path((String)path));
                retVal = IDLEditorUtilities.getEditorInput(file);
            }
        }
        if (element instanceof LocalFileStorage) {
            LocalFileStorage lfs = (LocalFileStorage)element;
            path = lfs.getFullPath();
            file = EFS.getLocalFileSystem().getStore(path);
            retVal = IDLEditorUtilities.getEditorInput(file);
        }
        return retVal;
    }
}

