/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.ui;

import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLThread;
import com.rsi.idldt.debug.internal.model.IDLValue;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.ui.UIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DebugLabelProvider
extends LabelProvider
implements IColorProvider {
    private static Image m_imageLocalVariable;
    private static Image m_imageSystemVariable;
    private static Image m_imageCategoryVariable;
    private static Image m_imageCommonBlockVariable;
    private static Image m_imageStructureVariable;

    public void dispose() {
        super.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getImage(Object element) {
        if (element instanceof IDLVariable) {
            IDLVariable v = (IDLVariable)element;
            if (v.isCategory()) {
                return this.getCategoryVariableImage();
            }
            if (v.getName().startsWith("!")) {
                return this.getSystemVariableImage();
            }
            if (v.isCommonBlock()) {
                return this.getCommonBlockVariableImage();
            }
            int type = v.getType();
            if (type == 8 || type == 10 || type == 11) {
                return this.getStructureVariableImage();
            }
            return this.getLocalVariableImage();
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IDLVariable) {
            return this.getVariableText((IDLVariable)element);
        }
        if (element instanceof IStackFrame) {
            StringBuffer label = new StringBuffer(this.getStackFrameText((IStackFrame)element));
            return label.toString();
        }
        StringBuffer label = new StringBuffer();
        if (element instanceof IDLThread) {
            label.append(this.getThreadText((IDLThread)element));
        } else if (element instanceof IDLDebugTarget) {
            label.append(this.getDebugTargetText((IDLDebugTarget)element));
        } else if (element instanceof IDLValue) {
            label.append(this.getValueText((IDLValue)element));
        }
        if (label.length() > 0) {
            return label.toString();
        }
        return super.getText(element);
    }

    protected String getVariableText(IDLVariable var) {
        String varLabel = var.getName();
        return varLabel;
    }

    protected String getStackFrameText(IStackFrame stackFrame) {
        IDLStackFrame frame = (IDLStackFrame)stackFrame.getAdapter(IDLStackFrame.class);
        if (frame != null) {
            StringBuffer label = new StringBuffer();
            label.append(frame.getName());
            int lineNumber = frame.getLineNumber();
            int frameLevel = frame.getLevel();
            if (lineNumber > 0 || frameLevel > 1) {
                label.append(", " + Messages.IDLStackFrame_LineNumber + ": ");
                if (lineNumber > 0) {
                    label.append(lineNumber);
                } else {
                    label.append(Messages.IDLStackFrame_LineNotAvailable);
                }
            }
            return label.toString();
        }
        return null;
    }

    protected String getThreadText(IDLThread t) {
        String s = null;
        switch (t.getThreadState()) {
            case 1: {
                s = Messages.IDLStackFrame_InterpIdle;
                break;
            }
            case 2: {
                s = t.isStepping() ? Messages.IDLStackFrame_InterpStepping : Messages.IDLStackFrame_InterpRunning;
                break;
            }
            case 3: {
                s = Messages.IDLStackFrame_InterpSuspended;
                break;
            }
            default: {
                s = "";
            }
        }
        return String.valueOf(Messages.IDLStackFrame_Interpreter) + " (" + s + ")";
    }

    protected String getDebugTargetText(IDLDebugTarget debugTarget) {
        String labelString = "";
        try {
            labelString = debugTarget.getName();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return labelString;
    }

    protected String getValueText(IDLValue value) {
        return value.getValueString();
    }

    private static Image createImage(String location) {
        ImageDescriptor id = UIPlugin.getImageDescriptor(location);
        Image image = id.createImage();
        return image;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    private Image getLocalVariableImage() {
        if (m_imageLocalVariable == null || m_imageLocalVariable.isDisposed()) {
            m_imageLocalVariable = DebugLabelProvider.createImage("icons/localvariable.gif");
        }
        return m_imageLocalVariable;
    }

    private Image getSystemVariableImage() {
        if (m_imageSystemVariable == null || m_imageSystemVariable.isDisposed()) {
            m_imageSystemVariable = DebugLabelProvider.createImage("icons/system_variable.gif");
        }
        return m_imageSystemVariable;
    }

    private Image getCategoryVariableImage() {
        if (m_imageCategoryVariable == null || m_imageCategoryVariable.isDisposed()) {
            m_imageCategoryVariable = DebugLabelProvider.createImage("icons/prj_obj.gif");
        }
        return m_imageCategoryVariable;
    }

    private Image getCommonBlockVariableImage() {
        if (m_imageCommonBlockVariable == null || m_imageCommonBlockVariable.isDisposed()) {
            m_imageCommonBlockVariable = DebugLabelProvider.createImage("icons/commonblockvariable.gif");
        }
        return m_imageCommonBlockVariable;
    }

    private Image getStructureVariableImage() {
        if (m_imageStructureVariable == null || m_imageStructureVariable.isDisposed()) {
            m_imageStructureVariable = DebugLabelProvider.createImage("icons/structure_variable.gif");
        }
        return m_imageStructureVariable;
    }
}

