/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.debug.ui;

import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.ui.UIPlugin;
import java.util.Vector;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DebugLabelDecorator
implements ILabelDecorator {
    static final ImageDescriptor lockDescriptor = UIPlugin.getImageDescriptor("icons/lock_overlay.gif");
    static final ImageDescriptor paramDescriptor = UIPlugin.getImageDescriptor("icons/parameter_overlay.gif");
    static final ImageDescriptor arrayDescriptor = UIPlugin.getImageDescriptor("icons/array_overlay.gif");
    private static final int KEY_READONLY = 1;
    private static final int KEY_PARAMETER = 2;
    private static final int KEY_ARRAY = 3;

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        if (image != null && element instanceof IDLVariable) {
            IDLVariable v = (IDLVariable)element;
            Vector<Integer> decoratorKeys = new Vector<Integer>();
            if (v.isReadOnly()) {
                decoratorKeys.add(new Integer(1));
            }
            if (v.isArray() && !v.isStructure()) {
                decoratorKeys.add(new Integer(3));
            }
            if (v.isParam() && !"SELF".equals(v.getName())) {
                decoratorKeys.add(new Integer(2));
            }
            if (decoratorKeys.size() > 0) {
                DebugImageDescriptor desc = new DebugImageDescriptor(image, decoratorKeys);
                Image newImage = desc.getImage();
                return newImage;
            }
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DebugImageDescriptor
    extends CompositeImageDescriptor {
        private static final int TOP_LEFT = 1;
        private static final int TOP_RIGHT = 2;
        private static final int BOTTOM_LEFT = 3;
        private static final int BOTTOM_RIGHT = 4;
        private static final int LEFT = 5;
        private Image m_image;
        private Point m_size;
        private Vector<Integer> m_imageKeys;

        public DebugImageDescriptor(Image image, Vector<Integer> imageKey) {
            this.m_image = image;
            this.m_imageKeys = imageKey;
            this.m_size = this.m_image != null ? new Point(image.getBounds().width, image.getBounds().height) : new Point(0, 0);
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.m_image == null) {
                return;
            }
            this.drawImage(this.m_image.getImageData(), 0, 0);
            int i = 0;
            while (i < this.m_imageKeys.size()) {
                int key = this.m_imageKeys.get(i);
                ImageData imageData = this.getImageDataByKey(key);
                int location = this.getLocationByKey(key);
                switch (location) {
                    case 1: {
                        this.drawImage(imageData, 0, 0);
                        break;
                    }
                    case 5: {
                        this.drawImage(imageData, 0, (this.m_size.y - imageData.height) / 2);
                        break;
                    }
                    case 2: {
                        this.drawImage(imageData, this.m_size.x - imageData.width, 0);
                        break;
                    }
                    case 3: {
                        this.drawImage(imageData, 0, this.m_size.y - imageData.height);
                        break;
                    }
                    case 4: {
                        this.drawImage(imageData, this.m_size.x - imageData.width, this.m_size.y - imageData.height);
                    }
                }
                ++i;
            }
        }

        private ImageData getImageDataByKey(int key) {
            if (key == 1) {
                return lockDescriptor.getImageData();
            }
            if (key == 2) {
                return paramDescriptor.getImageData();
            }
            if (key == 3) {
                return arrayDescriptor.getImageData();
            }
            return null;
        }

        private int getLocationByKey(int key) {
            if (key == 1) {
                return 4;
            }
            if (key == 2) {
                return 3;
            }
            if (key == 3) {
                return 1;
            }
            return 0;
        }

        protected Point getSize() {
            return this.m_size;
        }

        public Image getImage() {
            return this.createImage();
        }
    }
}

