/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import com.rsi.idldt.core.IDLProcessManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ToggleExcludeFromBuildAction
implements IViewActionDelegate,
IObjectActionDelegate {
    protected final QualifiedName propertyKey = new QualifiedName("", "EXCLUDE_FROM_BUILD");
    private IStructuredSelection m_selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void init(IViewPart viewPart) {
    }

    public void run(IAction action) {
        for (Object item : this.m_selection) {
            if (item instanceof IFile) {
                IFile file = (IFile)item;
                if (this.isExcludedFromBuild(file)) {
                    this.includeInBuild(file);
                    continue;
                }
                this.excludeFromBuild(file);
                continue;
            }
            if (!(item instanceof IFolder)) continue;
            this.toggleFilesInFolder((IFolder)item);
        }
        ToggleExcludeFromBuildAction.update();
    }

    protected void toggleFilesInFolder(IFolder folder) {
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile) {
                    IFile file = (IFile)members[i];
                    if (this.isExcludedFromBuild(file)) {
                        this.includeInBuild(file);
                    } else {
                        this.excludeFromBuild(file);
                    }
                } else if (members[i] instanceof IFolder) {
                    this.toggleFilesInFolder((IFolder)members[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected boolean isExcludedFromBuild(IFile file) {
        boolean bExcluded = false;
        try {
            String sval = file.getPersistentProperty(this.propertyKey);
            if (sval != null && sval.equals("true")) {
                bExcluded = true;
            }
        }
        catch (CoreException coreException) {}
        return bExcluded;
    }

    protected void excludeFromBuild(IFile file) {
        try {
            file.setPersistentProperty(this.propertyKey, "true");
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {}
    }

    protected void includeInBuild(IFile file) {
        try {
            file.setPersistentProperty(this.propertyKey, "false");
            boolean bAutoBuilding = file.getProject().getWorkspace().isAutoBuilding();
            if (bAutoBuilding) {
                String command = ".COMPILE '" + file.getRawLocation().toOSString() + "'";
                IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
            }
        }
        catch (CoreException coreException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_selection = null;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss;
            this.m_selection = ss = (IStructuredSelection)selection;
        }
    }

    public static void update() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IDecoratorManager decoratorManager = workbench.getDecoratorManager();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                decoratorManager.update("com.rsi.idldt.core.ui.excludedFromBuildDecorator");
            }
        });
    }
}

