/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.internal.ui.NonExistentProEditorInput;
import com.rsi.idldt.proeditor.ProEditor;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SaveToExternalLocationAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow m_window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    public void run(IAction action) {
        final IEditorPart activeEditor = this.getActiveEditor();
        if (!(activeEditor instanceof AbstractTextEditor)) {
            return;
        }
        final IEditorInput input = this.getFileSystemSaveAsInput();
        if (input == null) {
            return;
        }
        final String saveToExternalLocation = Messages.SaveToExternalLocationAction_SaveToExternalLocation;
        Job job = new Job(saveToExternalLocation){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(saveToExternalLocation, -1);
                try {
                    SaveToExternalLocationAction.this.performSaveOperation((AbstractTextEditor)activeEditor, input, monitor);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected void performSaveOperation(AbstractTextEditor activeEditor, IEditorInput newInput, IProgressMonitor progressMonitor) {
        boolean success;
        block11: {
            IDocumentProvider provider = activeEditor.getDocumentProvider();
            if (newInput == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    IEditorInput input = this.getActiveEditor().getEditorInput();
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException e) {
                    final IStatus status = e.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        final String title = Messages.ProEditor_ErrorSavingTitle;
                        final String msg = e.getLocalizedMessage();
                        final Shell shell = this.getShell();
                        Runnable r = new Runnable(){

                            public void run() {
                                if (status != null) {
                                    switch (status.getSeverity()) {
                                        case 1: {
                                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                            break;
                                        }
                                        case 2: {
                                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                            break;
                                        }
                                        default: {
                                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                            break;
                                        }
                                    }
                                } else {
                                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                }
                            }
                        };
                        PlatformUI.getWorkbench().getDisplay().asyncExec(r);
                    }
                    if (success) {
                        this.updateGUI(provider, newInput);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (success) {
                    this.updateGUI(provider, newInput);
                }
                throw throwable;
            }
            if (success) {
                this.updateGUI(provider, newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected void updateGUI(final IDocumentProvider provider, final IEditorInput newInput) {
        Runnable r = new Runnable(){

            public void run() {
                provider.changed((Object)newInput);
                AbstractTextEditor ate = (AbstractTextEditor)SaveToExternalLocationAction.this.getActiveEditor();
                ate.setInput(newInput);
                if (ate instanceof ProEditor) {
                    ((ProEditor)ate).editorSaved();
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(r);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IEditorPart activeEditor = this.getActiveEditor();
        if (!(activeEditor instanceof AbstractTextEditor)) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }

    IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = null;
        IEditorPart activeEditor = null;
        activePage = this.m_window.getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) != null) {
            return activeEditor;
        }
        return null;
    }

    private Shell getShell() {
        IWorkbenchPage page = this.m_window.getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part != null) {
            return part.getSite().getShell();
        }
        return null;
    }

    private IEditorInput getFileSystemSaveAsInput() {
        IFileStore fileStore;
        File localFile;
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        Shell shell = this.getShell();
        if (shell == null) {
            return null;
        }
        IEditorInput input = this.getActiveEditor().getEditorInput();
        FileDialog dialog = new FileDialog(shell, 8192);
        String defaultName = editorPart instanceof ProEditor && this.isUntitledProFile(input) ? ((ProEditor)editorPart).generateAutoPopulateName(input) : input.getName();
        dialog.setFileName(defaultName);
        boolean bDone = false;
        do {
            String path;
            if ((path = dialog.open()) == null) {
                return null;
            }
            localFile = new File(path);
            if (localFile.exists()) {
                MessageDialog overwriteDialog = new MessageDialog(shell, Messages.SaveAction_OverwriteMsgBoxText, null, Messages.bind(Messages.SaveAction_OverwriteMsgBoxMessage, path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                if (overwriteDialog.open() != 0) continue;
                bDone = true;
                continue;
            }
            bDone = true;
        } while (!bDone);
        try {
            fileStore = EFS.getStore((URI)localFile.toURI());
        }
        catch (CoreException ex) {
            String title = Messages.ProEditor_ErrorSavingTitle;
            String msg = ex.getLocalizedMessage();
            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            return null;
        }
        return new FileStoreEditorInput(fileStore);
    }

    public boolean isUntitledProFile(IEditorInput input) {
        return input instanceof NonExistentProEditorInput;
    }
}

