/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.internal.interp.commands.SilentExecuteStringCommand;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.ICommandListener;
import com.rsi.idldt.core.interp.SimpleCommandListener;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.proeditor.ProEditor;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public class RunIDLProjectAction
implements IWorkbenchWindowActionDelegate,
IPropertyListener {
    protected static final String SAVE_DIR_VAR_NAME = "_IDLDT$_RUN$_CURRENT_DIR";
    private IWorkbenchWindow m_window;
    private IStructuredSelection m_selection;
    protected ProEditor m_editor;
    protected IAction m_action;

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.m_selection = null;
        this.m_action = action;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss;
            this.m_selection = ss = (IStructuredSelection)selection;
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
        this.doSetActiveEditor();
        this.setMenuTextAndActionEnablement(action);
    }

    protected boolean isRunBeginsWithReset(IProject project) {
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            return nature.getIDLProjectProperties().isRunBeginsWithReset();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected boolean isBuildInSeparateProcess(IProject project) {
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            return nature.getIDLProjectProperties().isBuildInSeparateSession();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected boolean getRunBeginsWithBuild(IProject project) {
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            return nature.getIDLProjectProperties().getRunBeginsWithBuild();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected String getRunCommand(IProject project) {
        String runCommand = null;
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            runCommand = nature.getIDLProjectProperties().getRunCommand();
            if (runCommand != null && (runCommand = runCommand.trim()).length() == 0) {
                runCommand = null;
            }
        }
        catch (CoreException coreException) {}
        return runCommand;
    }

    public void run(IAction action) {
        IProject project = this.getSelectedProject();
        RunIDLProjectJob job = new RunIDLProjectJob(Messages.RunIDLProjectAction_RunProject, project);
        job.schedule();
    }

    protected void preRunLogic(IProject project) {
        boolean runBeginsWithBuild = this.getRunBeginsWithBuild(project);
        if (runBeginsWithBuild) {
            boolean buildCreatedSaveFile;
            boolean runBeginsWithReset;
            String jobName = String.valueOf(Messages.RunIDLProjectAction_BuildProject) + project.getName();
            BuildIDLProjectJob job = new BuildIDLProjectJob(jobName, project);
            job.schedule();
            try {
                while (job.getResult() == null) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {}
            boolean buildInSeparateProcess = this.isBuildInSeparateProcess(project);
            if (buildInSeparateProcess && (runBeginsWithReset = this.isRunBeginsWithReset(project))) {
                RunIDLProjectAction.executeAndWaitForFinish(IDLProcessManager.getActiveProcess(), ".RESET_SESSION");
                this.writeToConsole(Messages.RunIDLProjectAction_IssuedCommandReset);
            }
            if (buildCreatedSaveFile = this.getBuildCreatesSaveFile(project)) {
                String saveFileName = this.getSaveFileName(project);
                saveFileName = saveFileName.replaceAll("'", "''");
                String command = "RESTORE, '" + saveFileName + "'";
                RunIDLProjectAction.executeAndWaitForFinish(IDLProcessManager.getActiveProcess(), command);
            }
        } else {
            boolean runBeginsWithReset = this.isRunBeginsWithReset(project);
            if (runBeginsWithReset) {
                RunIDLProjectAction.executeAndWaitForFinish(IDLProcessManager.getActiveProcess(), ".RESET_SESSION");
                this.writeToConsole(Messages.RunIDLProjectAction_IssuedCommandReset);
            }
        }
    }

    protected String getSaveFileName(IProject project) {
        String fname = null;
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            fname = nature.getIDLProjectProperties().getSaveFileOutputPath();
        }
        catch (CoreException coreException) {}
        return fname;
    }

    protected boolean getBuildCreatesSaveFile(IProject project) {
        boolean result = false;
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            result = nature.getIDLProjectProperties().isCreateSaveFile();
        }
        catch (CoreException coreException) {}
        return result;
    }

    public static void executeAndWaitForFinish(IIDLProcessProxy idl, String s) {
        SilentExecuteStringCommand cmd = new SilentExecuteStringCommand(s);
        RunIDLProjectAction.executeAndWaitForFinish(idl, (AbstractIDLCommand)cmd);
    }

    public static void executeAndWaitForFinish(IIDLProcessProxy idl, AbstractIDLCommand cmd) {
        SimpleCommandListener l = new SimpleCommandListener();
        cmd.addCommandListener((ICommandListener)l);
        idl.queueCommand(cmd);
        while (!l.hasFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
    }

    protected void executeRunCommand(IProject project, String run_command) {
        String command = "RETALL";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        command = "CD, CURRENT=_IDLDT$_RUN$_CURRENT_DIR";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        command = "DEFSYSV, '!IDLDT_TEMPDIR', ''";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        command = "!IDLDT_TEMPDIR=_IDLDT$_RUN$_CURRENT_DIR";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        command = "DELVAR,_IDLDT$_RUN$_CURRENT_DIR";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        IPath path = project.getLocation();
        String projectDir = path.toOSString();
        projectDir = projectDir.replaceAll("'", "''");
        command = "CD, '" + projectDir + "'";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(run_command);
        command = "CD, !IDLDT_TEMPDIR";
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IProject getSelectedProject() {
        IProject result = null;
        try {
            if (this.m_selection != null && !this.m_selection.isEmpty()) {
                if (this.m_selection.size() > 1) {
                    return null;
                }
                Iterator iterator = this.m_selection.iterator();
                if (!iterator.hasNext()) return result;
                Object item = iterator.next();
                if (!(item instanceof IProject)) return result;
                IProject project = (IProject)item;
                IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
                if (nature == null) return result;
                return project;
            }
            if (this.m_editor == null) return result;
            if (!(this.m_editor.getEditorInput() instanceof FileEditorInput)) return result;
            IFile file = ((FileEditorInput)this.m_editor.getEditorInput()).getFile();
            return file.getProject();
        }
        catch (CoreException coreException) {}
        return result;
    }

    protected void setMenuTextAndActionEnablement(IAction action) {
        IProject project = this.getSelectedProject();
        action.setText(String.valueOf(Messages.RunIDLProjectAction_RunProject) + (project == null ? "" : " " + project.getName()));
        String runCommand = null;
        if (project != null) {
            runCommand = this.getRunCommand(project);
        }
        action.setEnabled(runCommand != null);
    }

    private void doSetActiveEditor() {
        IEditorPart activeEditor;
        if (this.m_window == null) {
            this.m_editor = null;
            return;
        }
        IWorkbenchPage activePage = this.m_window.getActivePage();
        IEditorPart iEditorPart = activeEditor = activePage != null ? activePage.getActiveEditor() : null;
        if (!(activeEditor instanceof ProEditor)) {
            if (this.m_editor != null) {
                this.m_editor.removePropertyListener(this);
            }
            this.m_editor = null;
            return;
        }
        if (activeEditor != this.m_editor) {
            if (this.m_editor != null) {
                this.m_editor.removePropertyListener(this);
            }
            this.m_editor = (ProEditor)activeEditor;
            this.m_editor.addPropertyListener(this);
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            this.setMenuTextAndActionEnablement(this.m_action);
        }
    }

    protected void writeToConsole(String consoleOutput) {
        String newline = System.getProperty("line.separator");
        IDLProcessManager.getLogWindowHandler().idlOutput(null, 0, String.valueOf(consoleOutput) + newline);
    }

    private class BuildIDLProjectJob
    extends Job {
        protected IProject m_project;

        public BuildIDLProjectJob(String name, IProject project) {
            super(name);
            this.m_project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.m_project.build(6, monitor);
            }
            catch (CoreException coreException) {}
            return Status.OK_STATUS;
        }
    }

    private class RunIDLProjectJob
    extends Job {
        IProject m_project;

        public RunIDLProjectJob(String name, IProject project) {
            super(name);
            this.m_project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.m_project == null) {
                return Status.OK_STATUS;
            }
            String command = RunIDLProjectAction.this.getRunCommand(this.m_project);
            if (command == null) {
                return Status.OK_STATUS;
            }
            RunIDLProjectAction.this.preRunLogic(this.m_project);
            RunIDLProjectAction.this.executeRunCommand(this.m_project, command);
            return Status.OK_STATUS;
        }
    }
}

