/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import com.rsi.idldt.actions.CompileRunAction;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.proeditor.utils.ProEditorUtilities;
import com.rsi.idldt.ui.IDLEditorUtilities;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class RunAction
extends CompileRunAction {
    protected String getCanonicalName(String in_name) {
        if (in_name.length() == 0) {
            return in_name;
        }
        try {
            File file = new File(in_name);
            String canonical_name = file.getCanonicalFile().getAbsolutePath();
            return canonical_name;
        }
        catch (IOException iOException) {
            return in_name;
        }
    }

    public void run(IAction action) {
        super.run(action);
        if (this.m_editor == null) {
            return;
        }
        File file = this.getEditorsFile(this.m_editor);
        if (file == null) {
            return;
        }
        boolean needsCompile = true;
        if (file.canRead()) {
            String command = null;
            if (needsCompile) {
                IPath path = null;
                path = this.getEditorsPath(this.m_editor);
                if (path == null) {
                    return;
                }
                String filename = this.getCanonicalName(path.toOSString());
                char quote = filename.indexOf(39) >= 0 ? (char)'\"' : '\'';
                command = ".COMPILE " + quote + filename + quote;
                IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
            }
            command = this.isMainProgram() ? ".GO" : this.getProcedureNameFromTitle(this.m_editor);
            IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        }
    }

    private boolean isMainProgram() {
        String contents;
        IEditorInput input = this.m_editor.getEditorInput();
        IIDLCompilationUnit cu = IDLEditorUtilities.getEditorsCompilationUnit(input);
        if (cu == null && (contents = ProEditorUtilities.getEditorsText(this.m_editor)) != null) {
            cu = IDLDOMManager.temporaryParseString((String)contents);
        }
        return cu != null && cu.hasMainProg();
    }

    protected void setMenuText() {
        if (this.m_action == null || this.m_editor == null) {
            return;
        }
        String procedureName = this.getProcedureNameFromTitle(this.m_editor);
        this.m_action.setText(String.valueOf(Messages.RunAction_MenuItem) + (procedureName == null ? "" : " " + procedureName));
        this.m_action.setEnabled(procedureName != null);
    }

    private IPath getEditorsPath(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        return editorInput != null ? IDLEditorUtilities.getEditorsAbsolutePath(editorInput) : null;
    }

    private File getEditorsFile(IEditorPart activeEditor) {
        IPath path = this.getEditorsPath(activeEditor);
        return path != null ? path.toFile() : null;
    }

    private String getProcedureNameFromTitle(IEditorPart activeEditor) {
        String fileName = activeEditor.getTitle();
        int dot = fileName.lastIndexOf(46);
        return dot == -1 ? fileName : fileName.substring(0, dot);
    }
}

