/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.actions.RulerBreakpointAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RulerRemoveAllBreakpointsAction
extends RulerBreakpointAction
implements IUpdate,
IBreakpointsListener {
    public RulerRemoveAllBreakpointsAction(ITextEditor editor, IVerticalRulerInfo info) {
        super(editor, info);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void run() {
        final IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        final IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        if (breakpoints.length < 1) {
            return;
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("org.eclipse.debug.ui.remove_all_breakpoints_prompt");
        boolean proceed = true;
        if (prompt) {
            MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ActionMessages.RemoveAllBreakpointsAction_0, (String)ActionMessages.RemoveAllBreakpointsAction_1, (String)ActionMessages.RemoveAllBreakpointsAction_3, (!prompt ? 1 : 0) != 0, null, null);
            if (mdwt.getReturnCode() != 2) {
                proceed = false;
            } else {
                store.setValue("org.eclipse.debug.ui.remove_all_breakpoints_prompt", !mdwt.getToggleState());
            }
        }
        if (proceed) {
            new Job(ActionMessages.RemoveAllBreakpointsAction_2){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        breakpointManager.removeBreakpoints(breakpoints, true);
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log((Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        this.update();
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.update();
    }

    public void update() {
        this.setEnabled(DebugPlugin.getDefault().getBreakpointManager().hasBreakpoints());
        this.setText(ActionMessages.RemoveAllBreakpointsAction_0);
    }
}

