/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import com.rsi.idldt.internal.ui.Messages;
import com.rsi.jdml.PlatformSupport;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenLocalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow m_window;
    private static boolean m_bActionInitialized = false;
    private static String m_filterPath = null;
    private static String[] m_filterExtensions;
    private static String[] m_filterNames;

    public OpenLocalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.m_window = null;
        m_filterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    private void verifyInit() {
        if (m_bActionInitialized) {
            return;
        }
        m_bActionInitialized = true;
        m_filterExtensions = new String[2];
        m_filterNames = new String[2];
        OpenLocalFileAction.m_filterExtensions[0] = "*.pro;*.sav;*.isv";
        OpenLocalFileAction.m_filterNames[0] = "IDL Files (*.pro;*.sav;*.isv)";
        OpenLocalFileAction.m_filterExtensions[1] = "*.*";
        OpenLocalFileAction.m_filterNames[1] = "All Files (*.*)";
        ArrayList<String> buffer_filter = new ArrayList<String>();
        ArrayList<String> buffer_filterNames = new ArrayList<String>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("com.rsi.idldt.ui.openFilterStrings");
        if (extensions.length > 0) {
            int i = 0;
            while (i < extensions.length) {
                if (extensions[i] != null) {
                    int cutoff;
                    String filterName = extensions[i].getAttribute("name");
                    String filterValue = extensions[i].getAttribute("value");
                    if (i == 0) {
                        int j = i + 1;
                        while (j < extensions.length) {
                            String filterValue1;
                            if (extensions[j] != null && !"*.*".equals(filterValue1 = extensions[j].getAttribute("value")) && filterValue.indexOf(filterValue1) < 0) {
                                filterValue = String.valueOf(filterValue) + ';' + filterValue1;
                            }
                            ++j;
                        }
                    }
                    String fv = filterValue;
                    if (!PlatformSupport.isWindows() && fv.length() > 40 && (cutoff = fv.indexOf(59, 40)) > 0) {
                        fv = String.valueOf(fv.substring(0, cutoff + 1)) + " ...";
                    }
                    filterName = String.valueOf(filterName) + " (" + fv + ")";
                    buffer_filterNames.add(filterName);
                    if (!"*.*".equals(filterValue)) {
                        filterValue = String.valueOf(filterValue) + ';' + filterValue.toUpperCase();
                    }
                    buffer_filter.add(filterValue);
                }
                ++i;
            }
            m_filterExtensions = buffer_filter.toArray(new String[buffer_filter.size()]);
            m_filterNames = buffer_filterNames.toArray(new String[buffer_filterNames.size()]);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        this.verifyInit();
        FileDialog dialog = new FileDialog(this.m_window.getShell(), 4098);
        dialog.setText(Messages.OpenLocalFileAction_OpenFileTitle);
        dialog.setFilterPath(m_filterPath);
        dialog.setFilterExtensions(m_filterExtensions);
        dialog.setFilterNames(m_filterNames);
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            m_filterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(m_filterPath));
                if (!(fileStore = fileStore.getChild(names[i])).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    IWorkbenchPage page = this.m_window.getActivePage();
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException partInitException) {
                        String msg = NLS.bind((String)Messages.OpenLocalFileAction_ErrorOnOpen, (Object)fileStore.getName());
                        MessageDialog.openError((Shell)this.m_window.getShell(), (String)Messages.OpenLocalFileAction_OpenFileTitle, (String)msg);
                    }
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(fileStore.getName());
                }
                ++i;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? Messages.OpenLocalFileAction_FileNotFound : Messages.OpenLocalFileAction_FilesNotFound;
                String msg = NLS.bind((String)msgFmt, (Object)notFound.toString());
                MessageDialog.openError((Shell)this.m_window.getShell(), (String)Messages.OpenLocalFileAction_OpenFileTitle, (String)msg);
            }
        }
    }

    public static String getFilterPath() {
        return m_filterPath;
    }

    public static void setFilterPath(String path) {
        m_filterPath = path;
    }
}

