/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.actions;

import com.rsi.idldt.actions.CompileRunAction;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.ui.IDLEditorUtilities;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;

public class CompileAction
extends CompileRunAction {
    protected String getCanonicalName(String in_name) {
        if (in_name.length() == 0) {
            return in_name;
        }
        try {
            File file = new File(in_name);
            String canonical_name = file.getCanonicalFile().getAbsolutePath();
            return canonical_name;
        }
        catch (IOException iOException) {
            return in_name;
        }
    }

    public void run(IAction action) {
        super.run(action);
        if (this.m_editor == null) {
            return;
        }
        IEditorInput editorInput = this.m_editor.getEditorInput();
        IPath path = IDLEditorUtilities.getEditorsAbsolutePath(editorInput);
        if (path != null && path.toFile().canRead()) {
            String filename = this.getCanonicalName(path.toOSString());
            char quote = filename.indexOf(39) >= 0 ? (char)'\"' : '\'';
            String command = ".COMPILE -v " + quote + filename + quote;
            IDLProcessManager.getActiveProcess().queueSilentExecuteString(command);
        }
    }

    protected void setMenuText() {
        if (this.m_action == null || this.m_editor == null) {
            return;
        }
        IEditorInput editorInput = this.m_editor.getEditorInput();
        String title = editorInput.getName();
        this.m_action.setText(String.valueOf(Messages.CompileAction_MenuItem) + " " + title);
    }
}

