/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class DBCS_IBM_EBCDIC_Encoder
extends CharsetEncoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    private byte b1;
    private byte b2;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private int currentState;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
    }

    protected void implReset() {
        this.currentState = 0;
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.currentState == 1) {
            if (byteBuffer.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
        }
        this.implReset();
        return CoderResult.UNDERFLOW;
    }

    public boolean canEncode(char c) {
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        char c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000);
        if (c2 != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n5 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n5 < 15000 ? this.index2.charAt(n5) : this.index2a.charAt(n5 - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    byArray[n3++] = 15;
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    byArray[n3++] = 14;
                }
                int n6 = this.currentState == 1 ? 2 : 1;
                if (n4 - n3 < n6) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    byArray[n3++] = this.b2;
                    continue;
                }
                byArray[n3++] = this.b1;
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n2 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n2 < 15000 ? this.index2.charAt(n2) : this.index2a.charAt(n2 - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    byteBuffer.put((byte)15);
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    byteBuffer.put((byte)14);
                }
                int n3 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n3) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += n3;
                if (this.currentState == 0) {
                    byteBuffer.put(this.b2);
                    continue;
                }
                byteBuffer.put(this.b1);
                byteBuffer.put(this.b2);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

