/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.views;

import com.rsi.idldt.core.IDLNotifyListener;
import com.rsi.idldt.core.ResponseManager;
import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolCatalogParser;
import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.ActionBar;
import com.rsi.idldt.toolpalette.internal.ui.ActionBarComposite;
import com.rsi.idldt.toolpalette.internal.ui.ActionBarCopyTransfer;
import com.rsi.idldt.toolpalette.internal.ui.ControlRearrangeTransfer;
import com.rsi.idldt.toolpalette.internal.ui.ExportVisToolDialog;
import com.rsi.idldt.toolpalette.internal.ui.ImportVisToolDialog;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.internal.ui.VisPaletteImportOperation;
import com.rsi.idldt.toolpalette.internal.ui.VisToolControl;
import com.rsi.idldt.toolpalette.internal.ui.VisToolEditDialog;
import com.rsi.idldt.toolpalette.views.IDLPluginVexpImporter;
import com.rsi.idldt.ui.TreeUtils;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.ui.UIPreferenceManager;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.PlatformSupport;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPaletteView
extends ViewPart
implements IPropertyChangeListener,
ISelectionListener {
    private static final int ACTION_COMPOSITE_INITIAL_WIDTH = 225;
    public static final String ID_TOOLPALETTE_VIEW = "com.rsi.idldt.toolpalette.views.ToolPaletteView";
    public static final String HELP_ID = "com.rsi.idldt.toolpalette.views_ToolPaletteView_view_help";
    public static Font MONO_FONT;
    protected ToolPaletteView m_instance;
    protected static HashMap<IWorkbenchWindow, ToolPaletteView> m_instances;
    protected Vector<IDLNotifyListener> m_idlListeners = new Vector();
    protected boolean m_firstTimeViewActivated = true;
    protected boolean m_bVisToolsDirty = false;
    protected Color m_descBackgroundColor = null;
    protected IDLVisTool m_currentVisToolRearrangeDropTarget = null;
    protected boolean m_bToolPaletteEditMode = false;
    protected static final String CD_VISTOOL_SHOW_INDEX = "visToolShowIndex";
    protected IDLVisTool m_visToolRearrangeDragSource = null;
    public static final String CD_VISTOOL = "visTool";
    protected Composite m_newVisComposite;
    protected ActionBarComposite m_actionComposite;
    protected Hashtable<DropTarget, DropTargetAdapter> m_visToolDropListenerClearList = new Hashtable();
    protected boolean m_bJustDropped = false;
    protected IDLVisTool m_currentVisTool = null;
    protected Vector<IDLVisTool> m_visTools = null;
    protected Vector<Integer> m_visToolShowOrder = new Vector();
    protected Vector<Integer> m_visToolShowOrderBackup = null;
    protected Vector<IDLVisTool> m_visToolsBackup = null;
    protected Image m_dragPlotCmdImage32 = null;
    protected Image m_closeImage16 = null;
    protected Image m_moveImage16 = null;
    protected Image m_dragPlotCmdImage16 = null;
    protected Image m_addActionBarFromExistingImage16 = null;
    protected int m_autoScrollCompositeCount = 0;
    protected Composite m_parent;
    protected boolean m_bViewIsActivated = false;
    private ToolBar m_paletteToolBar;
    private Image m_argSwapIcon = null;
    private Image m_plotCmdDragImage32 = null;
    private ITextSelection m_selection = null;
    private IPerspectiveListener m_perspectiveListener = null;
    private Button m_acceptEditsButton;
    private MyComposite m_visToolControlArea;
    protected ToolItem m_menuOpenOnItem;
    protected IDLVisTool m_registeredToolToStartEditing = null;
    protected Action m_editVisToolAction;
    protected int m_autoLayoutOnResizeOccurred = 0;
    private Image m_addUserDefinedImage;
    String m_registeredImportFilename = null;
    boolean m_registeredToEditAVisToolsActions = false;

    static {
        m_instances = new HashMap();
    }

    public ToolPaletteView() {
        this.m_instance = this;
    }

    protected void checkView() {
        if (this.m_newVisComposite == null || this.m_newVisComposite.isDisposed()) {
            this.m_newVisComposite = null;
            this.m_visTools = null;
            this.m_instance = null;
        }
    }

    public static ToolPaletteView getInstance() {
        try {
            IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ToolPaletteView instance = m_instances.get(wbWindow);
            instance.checkView();
            return instance;
        }
        catch (Exception exception) {
            if (m_instances.size() > 0) {
                Collection<ToolPaletteView> views = m_instances.values();
                ToolPaletteView instance = (ToolPaletteView)((Object)views.toArray()[0]);
                instance.checkView();
                return instance;
            }
            return null;
        }
    }

    public void createPartControl(Composite parent) {
        IWorkbenchWindow wbWindow = this.getWorkbenchWindow(parent);
        m_instances.put(wbWindow, this.m_instance);
        MONO_FONT = PlatformSupport.isMac() ? new Font((Device)parent.getDisplay(), "Courier New", 12, 0) : new Font((Device)parent.getDisplay(), "Courier New", 10, 0);
        this.m_parent = parent;
        this.m_parent.setLayout((Layout)new FormLayout());
        this.createPartControlInternals();
        UIPreferenceManager.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.initializeToggleButtons(parent.getDisplay());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.hookPartListenerToPartService();
        this.hookToSelectionService();
        this.hookViewMenu();
        this.registerIDLNotifications();
        this.registerPerspectiveListener();
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Composite && !ToolPaletteView.this.m_bToolPaletteEditMode && !ToolPaletteView.this.m_actionComposite.isInEditMode()) {
                    Composite c = (Composite)event.widget;
                    Point bestSize = c.computeSize(-1, -1);
                    Point currSize = c.getSize();
                    if (ToolPaletteView.this.isShowingActionBars()) {
                        if (currSize.x < bestSize.x / 2) {
                            ToolPaletteView.this.m_autoLayoutOnResizeOccurred = 1;
                            IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
                            pref_store.setValue("IDLDT_VISMGR_LAYOUT_FULL", false);
                        }
                    } else {
                        bestSize.x = 85;
                        if (currSize.x > bestSize.x * 2) {
                            ToolPaletteView.this.m_autoLayoutOnResizeOccurred = 2;
                            IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
                            pref_store.setValue("IDLDT_VISMGR_LAYOUT_FULL", true);
                        }
                    }
                }
            }
        });
    }

    protected IWorkbenchWindow getWorkbenchWindow(Composite parent) {
        IWorkbenchWindow[] wbws;
        Shell ourShell = parent.getShell();
        IWorkbenchWindow[] iWorkbenchWindowArray = wbws = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = wbws.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbw = iWorkbenchWindowArray[n2];
            if (wbw.getShell() == ourShell) {
                return wbw;
            }
            ++n2;
        }
        return wbws[wbws.length - 1];
    }

    private void hookViewMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("layout"));
                manager.add((IContributionItem)new Separator("sharing"));
            }
        });
    }

    private void unregisterPerspectiveListener() {
        if (this.m_perspectiveListener != null) {
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ww.removePerspectiveListener(this.m_perspectiveListener);
        }
    }

    private void registerPerspectiveListener() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.m_perspectiveListener = new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                if (changeId.equalsIgnoreCase("resetComplete") && ToolPaletteView.this.m_parent != null && !ToolPaletteView.this.m_parent.isDisposed() && ToolPaletteView.this.m_parent.isVisible()) {
                    IWorkbenchWindow ww1 = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IViewReference myView = ww1.getActivePage().findViewReference(ToolPaletteView.ID_TOOLPALETTE_VIEW);
                    int partState = ww1.getActivePage().getPartState((IWorkbenchPartReference)myView);
                    if (partState != 0) {
                        ToolPaletteView.this.m_instance.resizeView();
                    }
                }
            }
        };
        ww.addPerspectiveListener(this.m_perspectiveListener);
    }

    private void hookToSelectionService() {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void createPartControlInternals() {
        if (this.m_parent.isDisposed()) {
            return;
        }
        if (this.m_actionComposite != null && this.m_actionComposite.isInEditMode()) {
            this.m_actionComposite.cancelActionBarEditMode(true);
        }
        this.clearComposite(this.m_newVisComposite);
        if (this.m_actionComposite != null) {
            this.m_actionComposite.clear();
        }
        Control[] kids = this.m_parent.getChildren();
        int i = 0;
        while (i < kids.length) {
            kids[i].dispose();
            ++i;
        }
        int paletteDockSide = 16384;
        IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
        if (pref_store != null) {
            int dockSide = pref_store.getInt("IDLDT_VISMGR_LAYOUT_PALETE_SIDE");
            paletteDockSide = dockSide == 0 ? 16384 : 131072;
        }
        boolean bShowingActionBars = this.isShowingActionBars();
        Composite adjacentComposite = this.createToolPalette(this.m_parent, paletteDockSide, bShowingActionBars);
        this.createMainActionBarComposite(this.m_parent, adjacentComposite, paletteDockSide);
        this.m_actionComposite.setMinWidth(225);
        if (!bShowingActionBars) {
            this.m_actionComposite.hide();
        }
        this.setLayoutSimpleActionTooltipTextAndEnablement();
        this.setLeftRightLayoutRadioActionEnablement();
        this.setEditActionBarsActionEnablement();
        this.setEditVisToolsActionEnablement();
        this.schedulePopulateToolPaletteJob();
        this.m_parent.layout(true);
        this.resizeView();
    }

    public void schedulePopulateToolPaletteJob() {
        PopulateToolPaletteJob j = new PopulateToolPaletteJob();
        j.setPriority(20);
        j.schedule();
    }

    private void setImportExportActionEnablement() {
        IContributionItem[] menu_items;
        IMenuManager mm = this.getViewSite().getActionBars().getMenuManager();
        IContributionItem[] iContributionItemArray = menu_items = mm.getItems();
        int n = menu_items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (item.getId().equals("com.rsi.idldt.toolpalette.actions.ImportVisToolsAction") || item.getId().equals("com.rsi.idldt.toolpalette.actions.ExportVisToolsAction"))) {
                IAction action = ((ActionContributionItem)item).getAction();
                if (this.m_bToolPaletteEditMode || this.m_actionComposite.isInEditMode()) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
            }
            ++n2;
        }
    }

    private void setLeftRightLayoutRadioActionEnablement() {
        IMenuManager mm = this.getViewSite().getActionBars().getMenuManager();
        IContributionItem[] items = mm.getItems();
        if (items != null) {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (item.getId().equals("com.rsi.idldt.toolpalette.actions.LayoutIconsOnRightRadioAction") || item.getId().equals("com.rsi.idldt.toolpalette.actions.LayoutIconsOnLeftRadioAction") || item.getId().equals("com.rsi.idldt.toolpalette.actions.HideShowKeywordsToggleAction"))) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    if (this.isShowingActionBars() && !this.m_bToolPaletteEditMode && !this.m_actionComposite.isInEditMode()) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                }
                ++n2;
            }
        }
    }

    private void setEditActionBarsActionEnablement() {
        IContributionItem[] menu_items;
        IMenuManager mm = this.getViewSite().getActionBars().getMenuManager();
        IContributionItem[] iContributionItemArray = menu_items = mm.getItems();
        int n = menu_items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && item.getId().equals("com.rsi.idldt.toolpalette.actions.EditActionBarsAction")) {
                IAction action = ((ActionContributionItem)item).getAction();
                if (this.m_bToolPaletteEditMode || this.m_actionComposite.isInEditMode() || !this.isShowingActionBars() || this.m_visToolShowOrder == null || this.m_visToolShowOrder.size() == 0) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
            }
            ++n2;
        }
    }

    private void setEditVisToolsActionEnablement() {
        IContributionItem[] menu_items;
        IMenuManager mm = this.getViewSite().getActionBars().getMenuManager();
        IContributionItem[] iContributionItemArray = menu_items = mm.getItems();
        int n = menu_items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && item.getId().equals("com.rsi.idldt.toolpalette.actions.EditVisToolsAction")) {
                IAction action = ((ActionContributionItem)item).getAction();
                if (this.m_bToolPaletteEditMode || this.m_actionComposite.isInEditMode()) {
                    action.setEnabled(false);
                    break;
                }
                action.setEnabled(true);
                break;
            }
            ++n2;
        }
    }

    void setLayoutSimpleActionTooltipTextAndEnablement() {
        IContributionItem[] toolbar_items;
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = toolbar_items = tbm.getItems();
        int n = toolbar_items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && item.getId().equals("com.rsi.idldt.toolpalette.actions.SimpleFullToggleAction")) {
                IAction action = ((ActionContributionItem)item).getAction();
                if (this.isShowingActionBars()) {
                    action.setToolTipText(Messages.VisPaletteView_HideTheActions);
                } else {
                    action.setToolTipText(Messages.VisPaletteView_ShowTheActions);
                }
                if (this.m_actionComposite.isInEditMode() || this.m_bToolPaletteEditMode) {
                    action.setEnabled(false);
                    break;
                }
                action.setEnabled(true);
                break;
            }
            ++n2;
        }
    }

    public boolean isShowingActionBars() {
        IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
        boolean bShowingActionBars = pref_store.getBoolean("IDLDT_VISMGR_LAYOUT_FULL");
        return bShowingActionBars;
    }

    protected void initActionState(IAction action) {
        String id = action.getId();
        if (id != null && action.isEnabled()) {
            String prefKey = this.generatePreferenceKey(id);
            if (prefKey == null) {
                return;
            }
            if (prefKey.equals("IDLDT_VISMGR_LAYOUT_PALETE_SIDE")) {
                int value = UIPreferenceManager.getPreferenceStore().getInt("IDLDT_VISMGR_LAYOUT_PALETE_SIDE");
                if (action.getId().equals("com.rsi.idldt.toolpalette.actions.LayoutIconsOnLeftRadioAction") && value == 0) {
                    action.setChecked(true);
                } else if (action.getId().equals("com.rsi.idldt.toolpalette.actions.LayoutIconsOnRightRadioAction") && value == 1) {
                    action.setChecked(true);
                }
            } else {
                boolean checked = UIPreferenceManager.getPreferenceStore().getBoolean(prefKey);
                action.setChecked(checked);
            }
        }
    }

    protected String generatePreferenceKey(String id) {
        if (id.equalsIgnoreCase("com.rsi.idldt.toolpalette.actions.SimpleFullToggleAction")) {
            return "IDLDT_VISMGR_LAYOUT_FULL";
        }
        if (id.equalsIgnoreCase("com.rsi.idldt.toolpalette.actions.HideShowKeywordsToggleAction")) {
            return "IDLDT_VISMGR_showing_KEYWORDS";
        }
        if (id.equalsIgnoreCase("com.rsi.idldt.toolpalette.actions.LayoutIconsOnLeftRadioAction")) {
            return "IDLDT_VISMGR_LAYOUT_PALETE_SIDE";
        }
        if (id.equalsIgnoreCase("com.rsi.idldt.toolpalette.actions.LayoutIconsOnRightRadioAction")) {
            return "IDLDT_VISMGR_LAYOUT_PALETE_SIDE";
        }
        return null;
    }

    private void initializeToggleButtons(Display display) {
        final IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        final IMenuManager mm = this.getViewSite().getActionBars().getMenuManager();
        Runnable r = new Runnable(){

            public void run() {
                IContributionItem[] toolbar_items = tbm.getItems();
                IContributionItem[] menubar_items = mm.getItems();
                IContributionItem[] items = this.mergeItems(toolbar_items, menubar_items);
                this.processItems(items);
                ToolPaletteView.this.setLayoutSimpleActionTooltipTextAndEnablement();
            }

            private void processItems(IContributionItem[] items) {
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] instanceof ActionContributionItem) {
                            IAction action = ((ActionContributionItem)items[i]).getAction();
                            if (action.getStyle() == 2 || action.getStyle() == 8) {
                                ToolPaletteView.this.initActionState(action);
                            }
                        } else if (items[i] instanceof IMenuManager) {
                            IMenuManager sub_mm = (IMenuManager)items[i];
                            IContributionItem[] sub_items = sub_mm.getItems();
                            this.processItems(sub_items);
                        }
                        ++i;
                    }
                }
            }

            private IContributionItem[] mergeItems(IContributionItem[] toolbar_items, IContributionItem[] menubar_items) {
                IContributionItem[] items = new IContributionItem[toolbar_items.length + menubar_items.length];
                int destPos = toolbar_items.length;
                System.arraycopy(toolbar_items, 0, items, 0, toolbar_items.length);
                System.arraycopy(menubar_items, 0, items, destPos, menubar_items.length);
                return items;
            }
        };
        display.asyncExec(r);
    }

    public void dispose() {
        super.dispose();
        if (this.m_moveImage16 != null) {
            this.m_moveImage16.dispose();
            this.m_moveImage16 = null;
        }
        if (this.m_dragPlotCmdImage32 != null) {
            this.m_dragPlotCmdImage32.dispose();
            this.m_dragPlotCmdImage32 = null;
        }
        if (this.m_closeImage16 != null) {
            this.m_closeImage16.dispose();
            this.m_closeImage16 = null;
        }
        if (this.m_dragPlotCmdImage16 != null) {
            this.m_dragPlotCmdImage16.dispose();
            this.m_dragPlotCmdImage16 = null;
        }
        if (this.m_argSwapIcon != null) {
            this.m_argSwapIcon.dispose();
            this.m_argSwapIcon = null;
        }
        if (this.m_plotCmdDragImage32 != null) {
            this.m_plotCmdDragImage32.dispose();
            this.m_plotCmdDragImage32 = null;
        }
        if (this.m_addActionBarFromExistingImage16 != null) {
            this.m_addActionBarFromExistingImage16.dispose();
            this.m_addActionBarFromExistingImage16 = null;
        }
        this.unregisterIDLNotifications();
        this.unregisterPerspectiveListener();
        this.m_visTools = null;
        this.m_visToolShowOrder = null;
        this.removeInstance();
    }

    protected void removeInstance() {
        Collection<ToolPaletteView> views = m_instances.values();
        Set<IWorkbenchWindow> windows = m_instances.keySet();
        int i = 0;
        IWorkbenchWindow foundWindow = null;
        for (ToolPaletteView v : views) {
            if (v == this.m_instance) {
                foundWindow = (IWorkbenchWindow)windows.toArray()[i];
                break;
            }
            ++i;
        }
        if (foundWindow != null) {
            m_instances.remove(foundWindow);
        }
    }

    public Composite createToolPalette(Composite parent, int paletteDockSide, boolean bShowingActionBars) {
        GridLayout glayout;
        MouseListener ml = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Composite c = (Composite)e.widget;
                c.setFocus();
            }

            public void mouseDown(MouseEvent e) {
                Composite c = (Composite)e.widget;
                c.setFocus();
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        Composite borderComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        borderComposite.setLayout((Layout)gridLayout);
        Object paintListener = null;
        if (paletteDockSide == 131072) {
            paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Composite sc = (Composite)e.widget;
                    GC gc = e.gc;
                    gc.setForeground(sc.getDisplay().getSystemColor(1));
                    Rectangle rect = sc.getClientArea();
                    gc.drawLine(0, 0, 0, rect.height);
                }
            };
        } else if (paletteDockSide == 16384) {
            paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Composite sc = (Composite)e.widget;
                    GC gc = e.gc;
                    gc.setForeground(sc.getDisplay().getSystemColor(1));
                    Rectangle rect = sc.getClientArea();
                    gc.drawLine(rect.width - 1, 0, rect.width - 1, rect.height);
                }
            };
        }
        if (bShowingActionBars && paintListener != null) {
            borderComposite.addPaintListener(paintListener);
        }
        this.m_visToolControlArea = new MyComposite(borderComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 2;
        this.m_visToolControlArea.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.m_visToolControlArea.setLayoutData(gd);
        this.m_visToolControlArea.setSize(0, 0);
        this.createToolPaletteEditButtons(paletteDockSide);
        ScrolledComposite scrollComposite = new ScrolledComposite(borderComposite, 512);
        gd = new GridData(0x1000000, 4, true, true, 1, 1);
        gd.verticalIndent = 1;
        scrollComposite.setLayoutData((Object)gd);
        scrollComposite.setAlwaysShowScrollBars(false);
        FormData fd = new FormData();
        if (this.isShowingActionBars()) {
            if (paletteDockSide == 16384) {
                fd.top = new FormAttachment(0);
                fd.bottom = new FormAttachment(100);
                fd.left = new FormAttachment(0);
            } else if (paletteDockSide == 131072) {
                fd.top = new FormAttachment(0);
                fd.bottom = new FormAttachment(100);
                fd.right = new FormAttachment(100);
            } else if (paletteDockSide == 128) {
                fd.top = new FormAttachment(0);
                fd.left = new FormAttachment(0);
                fd.right = new FormAttachment(100);
            } else {
                fd.bottom = new FormAttachment(100);
                fd.left = new FormAttachment(0);
                fd.right = new FormAttachment(100);
            }
        } else {
            fd.top = new FormAttachment(0);
            fd.bottom = new FormAttachment(100);
            fd.left = new FormAttachment(0);
            fd.right = new FormAttachment(100);
        }
        borderComposite.setLayoutData((Object)fd);
        this.makeCompositeADropSiteForAutoScrolling((Composite)scrollComposite, false);
        this.m_newVisComposite = new Composite((Composite)scrollComposite, 0);
        this.m_newVisComposite.addMouseListener(ml);
        this.makeCompositeADropSiteForAutoScrolling(this.m_newVisComposite, false);
        if (paletteDockSide == 16384 || paletteDockSide == 131072) {
            glayout = new GridLayout(1, true);
            glayout.verticalSpacing = 1;
            glayout.horizontalSpacing = 0;
            glayout.marginHeight = 1;
            glayout.marginWidth = 0;
            if (paletteDockSide == 131072) {
                glayout.marginLeft = 5;
            }
        } else {
            glayout = new GridLayout(8, true);
            glayout.verticalSpacing = 1;
            glayout.horizontalSpacing = 5;
            glayout.marginHeight = 1;
            glayout.marginWidth = 2;
        }
        this.m_newVisComposite.setLayout((Layout)glayout);
        scrollComposite.setContent((Control)this.m_newVisComposite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.getVerticalBar().setIncrement(20);
        scrollComposite.getVerticalBar().setPageIncrement(200);
        return borderComposite;
    }

    public void redrawToolPalette() {
        this.clearComposite(this.m_newVisComposite);
        this.clearComposite(this.m_visToolControlArea);
        GridLayout gl = (GridLayout)this.m_newVisComposite.getLayout();
        int paletteDockSide = gl.numColumns == 1 ? 16384 : 128;
        this.createToolPaletteEditButtons(paletteDockSide);
        this.populateToolsPalette();
        this.m_newVisComposite.layout(true);
        this.m_newVisComposite.getParent().getParent().layout(true);
        this.m_newVisComposite.getParent().getParent().getParent().layout(true);
        this.setupCurrentVisTool();
        if (this.m_currentVisTool != null) {
            this.showToolActions(this.m_currentVisTool, true, true);
            int i = 0;
            while (i < this.m_visToolShowOrder.size()) {
                Integer idx = this.m_visToolShowOrder.get(i);
                IDLVisTool vt = this.m_visTools.get(idx);
                if (vt == this.m_currentVisTool && this.m_paletteToolBar != null && !this.m_paletteToolBar.isDisposed()) {
                    this.m_paletteToolBar.getItem(i).setSelection(true);
                    break;
                }
                ++i;
            }
        }
        this.setImportExportActionEnablement();
        this.setLayoutSimpleActionTooltipTextAndEnablement();
        this.setLeftRightLayoutRadioActionEnablement();
        this.setEditActionBarsActionEnablement();
        this.setEditVisToolsActionEnablement();
        this.resizeView();
        if (this.m_registeredToolToStartEditing != null) {
            IDLVisTool toolToEdit = IDLVisTool.findTool(this.m_visTools, this.m_registeredToolToStartEditing.getToolName());
            this.m_registeredToolToStartEditing = null;
            toolToEdit.getVisToolControl().showVisToolEditDialog();
        }
    }

    protected void setupCurrentVisTool() {
        if (this.m_visToolShowOrder == null || this.m_visToolShowOrder.size() == 0) {
            this.m_currentVisTool = null;
        } else if (this.m_currentVisTool == null) {
            IDLVisTool vt;
            Integer idx = this.m_visToolShowOrder.get(0);
            this.m_currentVisTool = vt = this.m_visTools.get(idx);
        } else {
            IDLVisTool vt;
            this.m_currentVisTool = vt = IDLVisTool.findTool(this.m_visTools, this.m_currentVisTool.getToolName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSystemVisToolsIntact() {
        try {
            Vector<IDLVisTool> systemToolsVector = ToolCatalogParser.getInstance().getSystemVisTools();
            if (this.m_visToolShowOrder.size() < systemToolsVector.size()) {
                return false;
            }
            int i = 0;
            while (true) {
                IDLVisTool svt;
                if (i >= systemToolsVector.size()) {
                    return true;
                }
                Integer idx = this.m_visToolShowOrder.get(i);
                IDLVisTool vt = this.m_visTools.get(idx);
                if (!vt.equals(svt = systemToolsVector.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void restoreSystemDefinedTools() {
        boolean bDone = false;
        block0: while (!bDone) {
            bDone = true;
            if (this.m_visToolShowOrder != null) {
                int i = 0;
                while (i < this.m_visToolShowOrder.size()) {
                    Integer idx = this.m_visToolShowOrder.get(i);
                    IDLVisTool vt = this.m_visTools.get(idx);
                    if (vt.isSystemDefined()) {
                        this.m_visToolShowOrder.remove(i);
                        bDone = false;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            this.m_visToolShowOrder = new Vector();
        }
        Vector<IDLVisTool> systemToolsVector = ToolCatalogParser.getInstance().getSystemVisTools();
        int numSysTools = systemToolsVector.size();
        int i = numSysTools - 1;
        while (i > -1) {
            this.m_visToolShowOrder.add(0, new Integer(i));
            --i;
        }
        this.setVisToolsDirty(true);
    }

    protected void enableActionBars(boolean value) {
        if (this.m_actionComposite == null) {
            return;
        }
        if (this.m_actionComposite.isDisposed()) {
            return;
        }
        if (value && this.isShowingActionBars()) {
            this.m_actionComposite.show();
            this.showToolActions(this.m_currentVisTool, false, true);
        } else {
            this.m_actionComposite.hide();
            this.m_currentVisTool = null;
            this.resizeView();
        }
    }

    public void updateVisTool(IDLVisTool existing_vt, IDLVisTool updated_vt) {
        if (!existing_vt.getToolName().equalsIgnoreCase(updated_vt.getToolName())) {
            existing_vt.setToolName(updated_vt.getToolName(), true);
            this.setVisToolsDirty(true);
        }
        if (updated_vt.getIconFilename() == null && existing_vt.getIconFilename() != null || existing_vt.getIconFilename() == null && updated_vt.getIconFilename() != null) {
            existing_vt.setIconFilename(updated_vt.getIconFilename(), true);
            this.setVisToolsDirty(true);
        } else if (!(updated_vt.getIconFilename() == null && existing_vt.getIconFilename() == null || existing_vt.getIconFilename().equalsIgnoreCase(updated_vt.getIconFilename()))) {
            existing_vt.setIconFilename(updated_vt.getIconFilename(), true);
            this.setVisToolsDirty(true);
        }
        this.redrawToolPalette();
    }

    protected void createToolPaletteEditButtons(int paletteDockSide) {
        if (this.m_bToolPaletteEditMode) {
            this.enableActionBars(false);
            Composite linksComposite = new Composite((Composite)this.m_visToolControlArea, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 1;
            gridLayout.marginWidth = 1;
            linksComposite.setLayout((Layout)gridLayout);
            GridData gd = new GridData();
            if (paletteDockSide == 16384 || paletteDockSide == 131072) {
                gd.horizontalAlignment = 0x1000000;
            } else {
                GridLayout parentGridLayout = (GridLayout)this.m_newVisComposite.getLayout();
                gd.horizontalAlignment = 16384;
                gd.horizontalSpan = parentGridLayout.numColumns;
            }
            linksComposite.setLayoutData((Object)gd);
            Button cancelEditsButton = new Button(linksComposite, 0);
            cancelEditsButton.setText(Messages.VisPaletteView_CancelEdits);
            cancelEditsButton.setToolTipText(Messages.VisPaletteView_CancelEditsTooltipText);
            Listener cancelListener = new Listener(){

                public void handleEvent(Event event) {
                    ToolPaletteView.this.cancelToolPaletteEditMode();
                }
            };
            cancelEditsButton.addListener(13, cancelListener);
            this.m_acceptEditsButton = new Button(linksComposite, 0);
            this.m_acceptEditsButton.setText(Messages.VisPaletteView_AcceptEdits);
            this.m_acceptEditsButton.setToolTipText(Messages.VisPaletteView_AcceptEditsTooltipText);
            if (this.m_bVisToolsDirty) {
                this.m_acceptEditsButton.setEnabled(true);
            } else {
                this.m_acceptEditsButton.setEnabled(false);
            }
            Listener acceptListener = new Listener(){

                public void handleEvent(Event event) {
                    ToolPaletteView.this.acceptToolPaletteEditMode();
                }
            };
            this.m_acceptEditsButton.addListener(13, acceptListener);
            if (!this.isSystemVisToolsIntact()) {
                Link restoreSystemToolsLink = new Link((Composite)this.m_visToolControlArea, 0);
                restoreSystemToolsLink.setText("<a>" + Messages.VisPaletteView_RestoreSystemDefinedTools + "</a>");
                restoreSystemToolsLink.setToolTipText(Messages.VisPaletteView_RestoreSystemDefinedTools);
                Listener restoreListener = new Listener(){

                    public void handleEvent(Event event) {
                        ToolPaletteView.this.restoreSystemDefinedTools();
                        ToolPaletteView.this.redrawToolPalette();
                    }
                };
                restoreSystemToolsLink.addListener(13, restoreListener);
                gd = new GridData();
                gd.horizontalSpan = 2;
                gd.horizontalAlignment = 0x1000000;
                restoreSystemToolsLink.setLayoutData((Object)gd);
            }
            Button createVisToolBtn = new Button((Composite)this.m_visToolControlArea, 0);
            createVisToolBtn.setImage(this.getAddUserDefinedToolImage());
            createVisToolBtn.setText(Messages.VisPaletteView_NewTool);
            createVisToolBtn.setToolTipText(Messages.VisPaletteView_CreateANewToolInTheToolPalette);
            Listener createVisToolListener = new Listener(){

                public void handleEvent(Event event) {
                    VisToolEditDialog dlg = new VisToolEditDialog(Display.getCurrent().getActiveShell(), Messages.VisPaletteView_AddNewTool, null, true);
                    if (dlg.open() == 0) {
                        ToolPaletteView.this.setVisToolsDirty(true);
                        IDLVisTool vt = dlg.getNewVisTool();
                        ToolPaletteView.this.m_visTools.add(vt);
                        Integer vt_index = new Integer(ToolPaletteView.this.m_visTools.size() - 1);
                        ToolPaletteView.this.m_visToolShowOrder.insertElementAt(vt_index, 0);
                        ToolPaletteView.this.redrawToolPalette();
                    }
                }
            };
            createVisToolBtn.addListener(13, createVisToolListener);
            gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            gd.horizontalSpan = 2;
            createVisToolBtn.setLayoutData((Object)gd);
        } else {
            this.clearComposite(this.m_visToolControlArea);
            this.m_visToolControlArea.setSize(0, 0);
            this.enableActionBars(true);
        }
        this.m_visToolControlArea.layout(true);
    }

    public void cancelToolPaletteEdits() {
        if (!this.m_bToolPaletteEditMode) {
            return;
        }
        if (!this.m_bVisToolsDirty) {
            this.cancelToolPaletteEditMode();
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getDisplay().getShells()[0];
        MessageBox msgBox = new MessageBox(shell, 196);
        msgBox.setMessage(Messages.VisPaletteView_SaveToolPaletteModifications);
        msgBox.setText(Messages.ActionBarComposite_Question);
        int rc = msgBox.open();
        if (rc == 128) {
            this.cancelToolPaletteEditMode();
        } else {
            this.acceptToolPaletteEditMode();
        }
    }

    protected void cancelToolPaletteEditMode() {
        this.m_bToolPaletteEditMode = false;
        this.m_visToolShowOrder = this.m_visToolShowOrderBackup;
        this.m_visTools = this.m_visToolsBackup;
        this.m_visToolShowOrderBackup = null;
        this.m_visToolsBackup = null;
        this.setVisToolsDirty(false);
        if (this.m_visTools != null) {
            int i = 0;
            while (i < this.m_visTools.size()) {
                IDLVisTool vt = this.m_visTools.get(i);
                vt.revertToBackup();
                ++i;
            }
        }
        this.redrawToolPalette();
    }

    protected void acceptToolPaletteEditMode() {
        try {
            this.writeUserCatalog();
            this.m_bToolPaletteEditMode = false;
            this.setVisToolsDirty(false);
            this.m_visToolShowOrderBackup = null;
            this.m_visToolsBackup = null;
            int i = 0;
            while (i < this.m_visTools.size()) {
                IDLVisTool vt = this.m_visTools.get(i);
                vt.releaseBackupData();
                ++i;
            }
            this.redrawToolPalette();
        }
        catch (Exception exception) {}
    }

    private Image getAddUserDefinedToolImage() {
        if (this.m_addUserDefinedImage == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/addUserDefinedAction16.png"), null);
            this.m_addUserDefinedImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_addUserDefinedImage;
    }

    public void startVisPaletteEditMode() {
        this.m_bToolPaletteEditMode = true;
        this.m_visToolShowOrderBackup = this.m_visToolShowOrder != null ? (Vector)this.m_visToolShowOrder.clone() : new Vector();
        this.m_visToolsBackup = this.m_visTools != null ? (Vector)this.m_visTools.clone() : new Vector();
        this.redrawToolPalette();
    }

    public void startActionBarEditMode() {
        this.m_actionComposite.startActionBarEditMode(this.m_currentVisTool);
    }

    public void autoScrollComposite(ScrolledComposite scrollComposite, int ypoint) {
        if (++this.m_autoScrollCompositeCount < 2) {
            return;
        }
        this.m_autoScrollCompositeCount = 0;
        Rectangle sc_area = scrollComposite.getBounds();
        Point transP = new Point(sc_area.x, sc_area.y);
        transP = scrollComposite.getParent().toDisplay(transP);
        sc_area.x = transP.x;
        sc_area.y = transP.y;
        if (ypoint >= sc_area.y + sc_area.height - 25) {
            Point origin = scrollComposite.getOrigin();
            origin.y += 6;
            scrollComposite.setOrigin(origin);
        } else if (ypoint <= sc_area.y + 25) {
            Point origin = scrollComposite.getOrigin();
            origin.y -= 6;
            scrollComposite.setOrigin(origin);
        }
    }

    protected void setupActionBarScrollAreaAttachments(ScrolledComposite scrollComposite, Composite adjacentComposite, Composite titleArea, int paletteDockSide) {
        assert (paletteDockSide != 128) : "setupActionBarScrollAreaAttachments() paletteDockSide is TOP";
        assert (paletteDockSide != 1024) : "setupActionBarScrollAreaAttachments() paletteDockSide is BOTTOM";
        FormData fd = new FormData();
        if (paletteDockSide == 16384) {
            fd.top = new FormAttachment((Control)titleArea, 3);
            fd.bottom = new FormAttachment(100);
            fd.left = new FormAttachment((Control)adjacentComposite, 3);
            fd.right = new FormAttachment(100);
        } else if (paletteDockSide == 131072) {
            fd.left = new FormAttachment(0, 3);
            fd.right = new FormAttachment((Control)adjacentComposite);
            fd.top = new FormAttachment((Control)titleArea, 3);
            fd.bottom = new FormAttachment(100);
        }
        scrollComposite.setLayoutData((Object)fd);
    }

    protected void setupActionBarTitleAreaAttachments(Composite titleArea, Composite adjacentComposite, int paletteDockSide) {
        assert (paletteDockSide != 128) : "setupActionBarScrollAreaAttachments() paletteDockSide is TOP";
        assert (paletteDockSide != 1024) : "setupActionBarScrollAreaAttachments() paletteDockSide is BOTTOM";
        FormData fd = new FormData();
        if (paletteDockSide == 16384) {
            fd.top = new FormAttachment(0, 3);
            fd.left = new FormAttachment((Control)adjacentComposite, 3);
            fd.right = new FormAttachment(100);
        } else if (paletteDockSide == 131072) {
            fd.left = new FormAttachment(0, 3);
            fd.right = new FormAttachment((Control)adjacentComposite);
            fd.top = new FormAttachment(0);
        }
        titleArea.setLayoutData((Object)fd);
    }

    protected void addPaintForABottomBorder(Composite composite) {
        PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite c = (Composite)e.widget;
                GC gc = e.gc;
                gc.setForeground(c.getDisplay().getSystemColor(1));
                Rectangle rect = c.getClientArea();
                gc.drawLine(0, rect.height - 1, rect.width, rect.height - 1);
            }
        };
        composite.addPaintListener(paintListener);
    }

    public void createMainActionBarComposite(Composite parent, Composite adjacentComposite, int paletteDockSide) {
        Composite titleArea = new Composite(parent, 0);
        this.setupActionBarTitleAreaAttachments(titleArea, adjacentComposite, paletteDockSide);
        this.addPaintForABottomBorder(titleArea);
        MyScrolledComposite scrollComposite = new MyScrolledComposite(parent, 768);
        this.setupActionBarScrollAreaAttachments(scrollComposite, adjacentComposite, titleArea, paletteDockSide);
        this.makeCompositeADropSiteForAutoScrolling((Composite)scrollComposite, true);
        scrollComposite.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Composite c = (Composite)e.widget;
                c.setFocus();
            }

            public void mouseDown(MouseEvent e) {
                Composite c = (Composite)e.widget;
                c.setFocus();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.m_actionComposite = new ActionBarComposite((Composite)scrollComposite, titleArea, 0);
        scrollComposite.setContent((Control)this.m_actionComposite);
        scrollComposite.getVerticalBar().setIncrement(20);
        scrollComposite.getVerticalBar().setPageIncrement(200);
        this.makeCompositeADropSiteForAutoScrolling(this.m_actionComposite, true);
    }

    public void hideToolAtIndex(int tool_index) {
        Integer toolIndex = this.m_visToolShowOrder.get(tool_index);
        IDLVisTool vt = this.m_visTools.get(toolIndex);
        if (!vt.isSystemDefined()) {
            int indexOfToolRemoved = toolIndex;
            this.m_visTools.remove(vt);
            Vector<Integer> newShowOrder = new Vector<Integer>();
            for (Integer index : this.m_visToolShowOrder) {
                if (index > indexOfToolRemoved) {
                    int i = index - 1;
                    newShowOrder.add(new Integer(i));
                    continue;
                }
                newShowOrder.add(index);
            }
            this.m_visToolShowOrder = newShowOrder;
        }
        this.m_visToolShowOrder.remove(tool_index);
        this.writeUserCatalog();
        this.redrawToolPalette();
    }

    public void writeUserCatalog() {
        ToolCatalogParser.getInstance().writeUserCatalog(null, this.m_visTools, this.m_visToolShowOrder);
    }

    protected void populateToolsPalette() {
        this.cleanupToolPaletteInPreparationForNewPopulation();
        boolean isMac = PlatformSupport.isMac();
        if (!this.m_bToolPaletteEditMode && !isMac) {
            this.populateToolsPaletteInOperationMode();
            return;
        }
        IDLVisTool firstTool = this.m_currentVisTool;
        int i = 0;
        while (i < this.m_visToolShowOrder.size()) {
            Integer idx = this.m_visToolShowOrder.get(i);
            IDLVisTool visTool = this.m_visTools.get(idx);
            if (firstTool == null) {
                firstTool = visTool;
            }
            VisToolControl visToolControl = new VisToolControl(visTool, this.m_bToolPaletteEditMode, i, this.m_newVisComposite, 0);
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            visToolControl.setLayoutData(gd);
            this.makeVisButtonADropSite(visToolControl.getToolButton(), visTool);
            visTool.setVisToolControl(visToolControl);
            this.makeVisControlARearrangeDropSite(visToolControl);
            visToolControl.getToolButton().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Button b = (Button)event.widget;
                    IDLVisTool visTool1 = (IDLVisTool)b.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.visToolSelected(visTool1);
                }
            });
            if (!this.m_bToolPaletteEditMode) {
                this.addContextMenuToVisToolControl(visToolControl.getToolButton());
            }
            ++i;
        }
        if (!this.m_bToolPaletteEditMode && !this.m_actionComposite.isInEditMode() && firstTool != null) {
            this.showToolActions(firstTool, true, true);
        }
        if (this.m_bToolPaletteEditMode) {
            this.hookVisToolDragSupport();
        }
        this.m_newVisComposite.layout(true);
        this.m_newVisComposite.pack();
        this.m_newVisComposite.getParent().layout(true);
        this.m_newVisComposite.getParent().pack();
    }

    protected void clearComposite(Composite c) {
        if (c == null || c.isDisposed()) {
            return;
        }
        Control[] kids = c.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (!kids[i].isDisposed()) {
                kids[i].dispose();
            }
            ++i;
        }
        c.layout();
        if (c == this.m_newVisComposite) {
            Enumeration<DropTarget> e = this.m_visToolDropListenerClearList.keys();
            while (e.hasMoreElements()) {
                DropTarget dt = e.nextElement();
                DropTargetAdapter dta = this.m_visToolDropListenerClearList.get(dt);
                if (dt.isDisposed()) continue;
                dt.removeDropListener((DropTargetListener)dta);
            }
            this.m_visToolDropListenerClearList.clear();
        }
    }

    public void showToolActions(IDLVisTool visTool, boolean bForceShowingActions, boolean bResizeView) {
        if (bForceShowingActions) {
            this.m_currentVisTool = null;
        }
        if (visTool == this.m_currentVisTool) {
            return;
        }
        if (!this.m_actionComposite.isEnabled()) {
            return;
        }
        try {
            this.m_actionComposite.setLayoutDeferred(true);
            this.m_currentVisTool = visTool;
            this.m_actionComposite.clear();
            this.m_actionComposite.clearArgID2plotBarArgHash();
            this.m_actionComposite.createTitleArea(visTool);
            if (this.m_actionComposite.isInEditMode()) {
                this.m_actionComposite.createDropAreaToCreateANewActionBar(visTool);
            }
            String[] sigIds = visTool.getActionSignatureIdsInShowOrder();
            this.m_actionComposite.clearActionBarsVector();
            int i = 0;
            while (i < sigIds.length) {
                ActionSig sig = visTool.getActionSig(sigIds[i]);
                if (sig != null) {
                    this.m_actionComposite.createActionBar(i, visTool, sig);
                }
                ++i;
            }
            this.m_actionComposite.setSize(this.m_actionComposite.computeSize(-1, -1));
            if (this.m_actionComposite.isInEditMode()) {
                this.m_actionComposite.hookActionBarDragSupport(visTool);
            }
            if (this.m_bViewIsActivated) {
                try {
                    this.m_actionComposite.setFocusOnActionBar(visTool.getFocusIndex());
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.m_actionComposite.setLayoutDeferred(false);
            this.setLayoutSimpleActionTooltipTextAndEnablement();
            this.setEditActionBarsActionEnablement();
            this.setEditVisToolsActionEnablement();
            this.setImportExportActionEnablement();
            if (bResizeView) {
                this.resizeView();
            }
        }
    }

    public Image getCloseImage() {
        if (this.m_closeImage16 == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/close.gif"), null);
            this.m_closeImage16 = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_closeImage16;
    }

    public Image getPlotCmdDragImage() {
        if (this.m_plotCmdDragImage32 == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/dragPlotCmd16.png"), null);
            this.m_plotCmdDragImage32 = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_plotCmdDragImage32;
    }

    public Image getArgSwapIcon() {
        if (this.m_argSwapIcon == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/argSwap16.png"), null);
            this.m_argSwapIcon = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_argSwapIcon;
    }

    public Image getReorderImage() {
        if (this.m_moveImage16 == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/reorderPlotBars.png"), null);
            this.m_moveImage16 = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_moveImage16;
    }

    private RGB lighten(RGB color, float amount) {
        float[] hsb = color.getHSB();
        float b = hsb[2] + hsb[2] * amount;
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new RGB(hsb[0], hsb[1], b);
    }

    protected Color getDescBackgroundColor() {
        if (this.m_descBackgroundColor == null) {
            Color color;
            Display d = this.m_actionComposite.getDisplay();
            Color orig = d.getSystemColor(22);
            this.m_descBackgroundColor = color = new Color((Device)d, this.lighten(orig.getRGB(), 0.05f));
        }
        return this.m_descBackgroundColor;
    }

    public void fillActionBar(int visBarIndex, ActionSig sig, String idlVariableNames) {
        ActionBar bar = sig.getActionBar();
        ArrayList argLabels = (ArrayList)bar.getData("argLabels");
        String[] var_names = idlVariableNames.split(",");
        int i = 0;
        while (i < var_names.length) {
            Label argLabel = (Label)argLabels.get(i + 2);
            ActionBarComposite.setArgValue(argLabel, var_names[i].trim());
            argLabel.getParent().getParent().pack(true);
            ++i;
        }
        IDLVisTool vt = (IDLVisTool)bar.getData(CD_VISTOOL);
        vt.setActionBarDropState(visBarIndex, var_names);
        ActionBarComposite.configurePlotBarActivationButton(argLabels);
        Control[] kids = bar.getChildren();
        if (kids[0] instanceof Composite) {
            Composite c = (Composite)kids[0];
            Control[] kids2 = c.getChildren();
            c.layout(true);
            c.pack(true);
            if (kids2[1] instanceof Composite && this.m_actionComposite != null) {
                this.m_actionComposite.possiblyGrowParmComposite((Composite)kids2[1]);
            }
        }
        bar.layout(true);
        bar.pack();
        bar.setFocus();
    }

    protected void highlightCurrentVisToolDropTarget(IDLVisTool visTool, Point displayPoint) {
        if (this.m_currentVisToolRearrangeDropTarget != null && this.m_currentVisToolRearrangeDropTarget != this.m_visToolRearrangeDragSource) {
            this.m_currentVisToolRearrangeDropTarget.getVisToolControl().highlightAsRearrangeTarget(false, displayPoint, 0);
        }
        int force = 0;
        if (this.m_visToolRearrangeDragSource != null && this.m_currentVisToolRearrangeDropTarget != null) {
            int sourceIndex = this.m_visToolRearrangeDragSource.getVisToolControl().getShowIndex();
            int dragTargetIndex = this.m_currentVisToolRearrangeDropTarget.getVisToolControl().getShowIndex();
            if (dragTargetIndex == sourceIndex + 1) {
                force = 1024;
            } else if (dragTargetIndex == sourceIndex - 1) {
                force = 128;
            }
        }
        visTool.getVisToolControl().highlightAsRearrangeTarget(true, displayPoint, force);
        this.m_currentVisToolRearrangeDropTarget = visTool;
    }

    protected void makeCompositeADropSiteForAutoScrolling(Composite composite, boolean bAddToDropListenerClearList) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                int cfr_ignored_0 = event.detail;
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (ControlRearrangeTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 8;
                DropTarget dt = (DropTarget)event.widget;
                Composite c = (Composite)dt.getControl();
                ScrolledComposite scrollComposite = null;
                while (c != null) {
                    if (c instanceof ScrolledComposite) {
                        scrollComposite = (ScrolledComposite)c;
                        break;
                    }
                    c = c.getParent();
                }
                if (scrollComposite != null) {
                    ToolPaletteView.this.autoScrollComposite(scrollComposite, event.y);
                }
            }

            public void drop(DropTargetEvent event) {
            }
        };
        int style = 17;
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance(), ControlRearrangeTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)composite, style);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        if (bAddToDropListenerClearList) {
            ActionBarComposite.addToActionBarsDropListenerClearList(target, targetAdapter);
        }
    }

    protected void makeVisControlARearrangeDropSite(VisToolControl visToolControl) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (ToolPaletteView.this.m_actionComposite.isInEditMode()) {
                    return;
                }
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (ControlRearrangeTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        event.detail = 2;
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                VisToolControl vtc;
                Button swtButton;
                IDLVisTool targetVisTool;
                event.feedback = 8;
                if (ToolPaletteView.this.m_actionComposite.isInEditMode()) {
                    return;
                }
                DropTarget dt = (DropTarget)event.widget;
                VisToolControl b = (VisToolControl)dt.getControl();
                ScrolledComposite scrollComposite = null;
                Composite c = b.getParent();
                while (c != null) {
                    if (c instanceof ScrolledComposite) {
                        scrollComposite = (ScrolledComposite)c;
                        break;
                    }
                    c = c.getParent();
                }
                if (scrollComposite != null) {
                    ToolPaletteView.this.autoScrollComposite(scrollComposite, event.y);
                }
                if (ControlRearrangeTransfer.getInstance().isSupportedType(event.currentDataType) && (targetVisTool = (IDLVisTool)(swtButton = (vtc = (VisToolControl)dt.getControl()).getToolButton()).getData(ToolPaletteView.CD_VISTOOL)) != ToolPaletteView.this.m_visToolRearrangeDragSource) {
                    ToolPaletteView.this.highlightCurrentVisToolDropTarget(targetVisTool, new Point(event.x, event.y));
                }
            }

            public void drop(DropTargetEvent event) {
                if (ControlRearrangeTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    DropTarget dt;
                    VisToolControl vtc;
                    Button targetButton;
                    IDLVisTool targetVisTool;
                    int targetVisToolIndexNumber;
                    if (!(event.data instanceof String)) {
                        return;
                    }
                    String strSourceVisToolIndexNumber = (String)event.data;
                    int sourceVisToolIndexNumber = Integer.parseInt(strSourceVisToolIndexNumber);
                    if (sourceVisToolIndexNumber != (targetVisToolIndexNumber = (targetVisTool = (IDLVisTool)(targetButton = (vtc = (VisToolControl)(dt = (DropTarget)event.widget).getControl()).getToolButton()).getData(ToolPaletteView.CD_VISTOOL)).getVisToolControl().getShowIndex())) {
                        if (targetVisTool.getVisToolControl().isInsertAbove()) {
                            Integer o1 = ToolPaletteView.this.m_visToolShowOrder.get(sourceVisToolIndexNumber);
                            ToolPaletteView.this.m_visToolShowOrder.remove(sourceVisToolIndexNumber);
                            if (targetVisToolIndexNumber > sourceVisToolIndexNumber) {
                                --targetVisToolIndexNumber;
                            }
                            ToolPaletteView.this.m_visToolShowOrder.insertElementAt(o1, targetVisToolIndexNumber);
                        } else {
                            Integer o1 = ToolPaletteView.this.m_visToolShowOrder.remove(sourceVisToolIndexNumber);
                            if (++targetVisToolIndexNumber > sourceVisToolIndexNumber) {
                                --targetVisToolIndexNumber;
                            }
                            ToolPaletteView.this.m_visToolShowOrder.insertElementAt(o1, targetVisToolIndexNumber);
                        }
                        ToolPaletteView.this.setVisToolsDirty(true);
                    }
                }
            }
        };
        int style = 19;
        Transfer[] types = new Transfer[]{ControlRearrangeTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)visToolControl, style);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        this.m_visToolDropListenerClearList.put(target, targetAdapter);
    }

    protected void makeVisButtonADropSite(Button button, IDLVisTool visTool) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){
            protected IDLVisTool m_visTool = null;

            public void dragEnter(DropTargetEvent event) {
                boolean bLocalSelectionTransfer = false;
                event.detail = event.detail == 16 ? ((event.operations & 1) != 0 ? 1 : 0) : 1;
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (ActionBarCopyTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bLocalSelectionTransfer = true;
                        break;
                    }
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bLocalSelectionTransfer = true;
                        break;
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        bLocalSelectionTransfer = true;
                        break;
                    }
                    if (ControlRearrangeTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    ++i;
                }
                if (ToolPaletteView.this.m_actionComposite.isInEditMode() || !this.allowThisActionBarDrop(event)) {
                    event.detail = 0;
                    return;
                }
                if (ToolPaletteView.this.m_bToolPaletteEditMode && bLocalSelectionTransfer) {
                    event.detail = 0;
                    return;
                }
                DropTarget dt = (DropTarget)event.getSource();
                if (!ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    Button visButton = (Button)dt.getControl();
                    IDLVisTool visTool1 = (IDLVisTool)visButton.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.m_actionComposite.cancelActionBarEditMode(true);
                    ToolPaletteView.this.showToolActions(visTool1, false, false);
                }
            }

            public void dragOver(DropTargetEvent event) {
                Button swtButton;
                IDLVisTool targetVisTool;
                event.feedback = 8;
                if (ToolPaletteView.this.m_actionComposite.isInEditMode()) {
                    return;
                }
                DropTarget dt = (DropTarget)event.widget;
                Button b = (Button)dt.getControl();
                ScrolledComposite scrollComposite = null;
                Composite c = b.getParent();
                while (c != null) {
                    if (c instanceof ScrolledComposite) {
                        scrollComposite = (ScrolledComposite)c;
                        break;
                    }
                    c = c.getParent();
                }
                if (scrollComposite != null) {
                    ToolPaletteView.this.autoScrollComposite(scrollComposite, event.y);
                }
                if (ControlRearrangeTransfer.getInstance().isSupportedType(event.currentDataType) && (targetVisTool = (IDLVisTool)(swtButton = (Button)dt.getControl()).getData(ToolPaletteView.CD_VISTOOL)) != ToolPaletteView.this.m_visToolRearrangeDragSource) {
                    ToolPaletteView.this.highlightCurrentVisToolDropTarget(targetVisTool, new Point(event.x, event.y));
                }
            }

            public void drop(DropTargetEvent event) {
                if (ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    DropTarget dt = (DropTarget)event.getSource();
                    Button visButton = (Button)dt.getControl();
                    IDLVisTool visTool1 = (IDLVisTool)visButton.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.copyActionBarToTool(visTool1);
                } else if (ControlRearrangeTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    DropTarget dt;
                    Button targetButton;
                    IDLVisTool targetVisTool;
                    int targetVisToolIndexNumber;
                    if (!(event.data instanceof String)) {
                        return;
                    }
                    String strSourceVisToolIndexNumber = (String)event.data;
                    int sourceVisToolIndexNumber = Integer.parseInt(strSourceVisToolIndexNumber);
                    if (sourceVisToolIndexNumber != (targetVisToolIndexNumber = (targetVisTool = (IDLVisTool)(targetButton = (Button)(dt = (DropTarget)event.widget).getControl()).getData(ToolPaletteView.CD_VISTOOL)).getVisToolControl().getShowIndex())) {
                        if (targetVisTool.getVisToolControl().isInsertAbove()) {
                            Integer o1 = ToolPaletteView.this.m_visToolShowOrder.get(sourceVisToolIndexNumber);
                            ToolPaletteView.this.m_visToolShowOrder.remove(sourceVisToolIndexNumber);
                            if (targetVisToolIndexNumber > sourceVisToolIndexNumber) {
                                --targetVisToolIndexNumber;
                            }
                            ToolPaletteView.this.m_visToolShowOrder.insertElementAt(o1, targetVisToolIndexNumber);
                        } else {
                            Integer o1 = ToolPaletteView.this.m_visToolShowOrder.remove(sourceVisToolIndexNumber);
                            if (++targetVisToolIndexNumber > sourceVisToolIndexNumber) {
                                --targetVisToolIndexNumber;
                            }
                            ToolPaletteView.this.m_visToolShowOrder.insertElementAt(o1, targetVisToolIndexNumber);
                        }
                        ToolPaletteView.this.setVisToolsDirty(true);
                    }
                } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) || TextTransfer.getInstance().isSupportedType(event.currentDataType) || FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String idlVariables = TreeUtils.convertTransferDataToString((Object)event.data);
                    if (idlVariables == null) {
                        return;
                    }
                    DropTarget dt = (DropTarget)event.getSource();
                    Button visButton = (Button)dt.getControl();
                    IDLVisTool visTool1 = (IDLVisTool)visButton.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.m_actionComposite.setLayoutDeferred(true);
                    ToolPaletteView.this.m_actionComposite.cancelActionBarEditMode(true);
                    visButton.setFocus();
                    visTool1.createNewVisUsingFirstMatchingActionSignature(idlVariables);
                    ToolPaletteView.this.m_actionComposite.setLayoutDeferred(false);
                    ToolPaletteView.this.m_actionComposite.layout(true);
                }
            }

            private boolean allowThisActionBarDrop(DropTargetEvent event) {
                ActionSig sig;
                DropTarget dt = (DropTarget)event.getSource();
                Button visButton = (Button)dt.getControl();
                this.m_visTool = (IDLVisTool)visButton.getData(ToolPaletteView.CD_VISTOOL);
                if (this.m_visTool == null) {
                    return false;
                }
                return !ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType) || (sig = IDLVisTool.getHandleToActionBeingDrug()) == null || this.m_visTool == null || !this.m_visTool.containsSig(sig);
            }
        };
        int style = 1;
        Transfer[] types = new Transfer[]{ActionBarCopyTransfer.getInstance(), TextTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), ControlRearrangeTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)button, style);
        button.setData(CD_VISTOOL, (Object)visTool);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        this.m_visToolDropListenerClearList.put(target, targetAdapter);
    }

    protected void copyActionBarToTool(IDLVisTool visTool) {
        ActionSig actionSig = IDLVisTool.getHandleToActionBeingDrug();
        visTool.addActionSignature(actionSig.m_actionType, 1, actionSig.m_procName, actionSig.m_overplotCmd, actionSig.m_argNames, actionSig.m_staticArgs, actionSig.m_desc, visTool.generateUniqueActionTitle(actionSig.m_title), null);
        WriteCatalogAndShowActionsJob j = new WriteCatalogAndShowActionsJob(visTool);
        j.setPriority(20);
        j.schedule();
    }

    public Image getDragActionBarCmdImage(int _16or32) {
        URL url;
        if (this.m_dragPlotCmdImage16 == null) {
            url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/dragPlotCmd16.png"), null);
            this.m_dragPlotCmdImage16 = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        if (this.m_dragPlotCmdImage32 == null) {
            url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/dragPlotCmd32.png"), null);
            this.m_dragPlotCmdImage32 = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        if (_16or32 == 16) {
            return this.m_dragPlotCmdImage16;
        }
        return this.m_dragPlotCmdImage32;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (("IDLDT_VISMGR_LAYOUT_PALETE_SIDE".equals(prop) || "IDLDT_VISMGR_LAYOUT_FULL".equals(prop)) && this.m_parent != null && !this.m_parent.isDisposed()) {
            if ("IDLDT_VISMGR_LAYOUT_FULL".equals(prop)) {
                this.updateSimpleFullToggleActionOnToolbar();
            }
            this.createPartControlInternals();
        } else if ("IDLDT_VISMGR_showing_KEYWORDS".equals(prop) && this.isShowingActionBars()) {
            this.showToolActions(this.m_currentVisTool, true, true);
        }
        UIPlugin.getDefault().savePluginPreferences();
    }

    private void updateSimpleFullToggleActionOnToolbar() {
        IContributionItem[] items;
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = items = tbm.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String itemId;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (itemId = item.getId()).equalsIgnoreCase("com.rsi.idldt.toolpalette.actions.SimpleFullToggleAction")) {
                PluginActionContributionItem paci = (PluginActionContributionItem)item;
                paci.getAction().setChecked(this.isShowingActionBars());
            }
            ++n2;
        }
    }

    protected void resizeView() {
        Point preferredSize;
        if (this.m_parent == null || this.m_parent.isDisposed()) {
            return;
        }
        if (this.m_autoLayoutOnResizeOccurred > 0) {
            --this.m_autoLayoutOnResizeOccurred;
            return;
        }
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            return;
        }
        IWorkbenchPage iwp = ww.getActivePage();
        if (iwp == null) {
            return;
        }
        WorkbenchPage wp = (WorkbenchPage)iwp;
        IViewReference myView = iwp.findViewReference(ID_TOOLPALETTE_VIEW);
        if (myView == null) {
            return;
        }
        IViewReference fastView = ((WorkbenchPage)this.getSite().getPage()).getActivePerspective().getActiveFastView();
        if (fastView != null && fastView.getId().equalsIgnoreCase(ID_TOOLPALETTE_VIEW)) {
            return;
        }
        Shell viewsShell = this.m_parent.getShell();
        ww.getShell();
        if (viewsShell != ww.getShell()) {
            return;
        }
        Point currentSize = this.m_instance.getViewSite().getShell().getSize();
        if (this.isShowingActionBars() && this.m_actionComposite.isVisible()) {
            preferredSize = this.m_parent.computeSize(-1, -1);
            preferredSize.x += 18;
        } else {
            this.m_newVisComposite.getParent().getParent().layout(true);
            preferredSize = this.m_newVisComposite.getParent().getParent().computeSize(-1, -1);
        }
        try {
            int theWidth = Math.min(viewsShell.getSize().x / 2, preferredSize.x);
            wp.resizeView((IViewPart)this.m_instance, theWidth, currentSize.y);
        }
        catch (Exception exception) {}
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ToolPaletteView.this.m_newVisComposite.getParent().getParent().layout(true);
                ToolPaletteView.this.m_newVisComposite.getParent().getParent().update();
            }
        });
    }

    protected void makeVisToolARearrangeDragSource(Control control, int visToolShowIndexNumber) {
        int operations = 2;
        control.setData(CD_VISTOOL_SHOW_INDEX, (Object)Integer.toString(visToolShowIndexNumber));
        DragSource source = new DragSource(control, operations);
        source.setDragSourceEffect(new DragSourceEffect(control){

            public void dragStart(DragSourceEvent event) {
                event.image = null;
            }
        });
        Transfer[] types = new Transfer[]{ControlRearrangeTransfer.getInstance()};
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IDLVisTool idlVisTool;
                DragSource ds = (DragSource)event.getSource();
                ToolBar sourceControl = (ToolBar)ds.getControl();
                ToolPaletteView.this.m_visToolRearrangeDragSource = idlVisTool = (IDLVisTool)sourceControl.getData(ToolPaletteView.CD_VISTOOL);
                ToolPaletteView.this.m_currentVisToolRearrangeDropTarget = idlVisTool;
                ToolPaletteView.this.m_visToolRearrangeDragSource.getVisToolControl().highlightAsRearrangeSource(true);
            }

            public void dragSetData(DragSourceEvent event) {
                if (ControlRearrangeTransfer.getInstance().isSupportedType(event.dataType)) {
                    DragSource ds = (DragSource)event.getSource();
                    Control control1 = ds.getControl();
                    IDLVisTool idlVisTool = (IDLVisTool)control1.getData(ToolPaletteView.CD_VISTOOL);
                    event.data = Integer.toString(idlVisTool.getVisToolControl().getShowIndex());
                }
            }

            public void dragFinished(DragSourceEvent event) {
                ToolPaletteView.this.m_visToolRearrangeDragSource.getVisToolControl().highlightAsRearrangeSource(false);
                ToolPaletteView.this.redrawToolPalette();
            }
        });
    }

    protected void hookVisToolDragSupport() {
        int i = 0;
        while (i < this.m_visToolShowOrder.size()) {
            Integer idx = this.m_visToolShowOrder.get(i);
            IDLVisTool vt = this.m_visTools.get(idx);
            ToolItem dragToolItem = vt.getVisToolControl().getDragToolItem();
            ToolBar control = dragToolItem.getParent();
            this.makeVisToolARearrangeDragSource((Control)control, i);
            ++i;
        }
    }

    protected void hookPartListenerToPartService() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPartService partService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
                if (partService != null) {
                    partService.addPartListener(new IPartListener(){

                        public void partActivated(IWorkbenchPart part) {
                            if (part instanceof ToolPaletteView) {
                                (this).ToolPaletteView.this.m_bViewIsActivated = true;
                                if ((this).ToolPaletteView.this.m_actionComposite != null) {
                                    (this).ToolPaletteView.this.m_actionComposite.activated();
                                }
                            }
                        }

                        public void partBroughtToTop(IWorkbenchPart part) {
                        }

                        public void partClosed(IWorkbenchPart part) {
                        }

                        public void partDeactivated(IWorkbenchPart part) {
                            if (part instanceof ToolPaletteView) {
                                (this).ToolPaletteView.this.m_bViewIsActivated = false;
                                if ((this).ToolPaletteView.this.m_actionComposite != null) {
                                    (this).ToolPaletteView.this.m_actionComposite.deactivated();
                                }
                            }
                        }

                        public void partOpened(IWorkbenchPart part) {
                        }
                    });
                }
            }
        });
    }

    public void setFocus() {
        this.m_newVisComposite.getParent().setFocus();
    }

    public void setVisToolsDirty(boolean b) {
        this.m_bVisToolsDirty = b;
        this.m_acceptEditsButton.setEnabled(b);
    }

    protected boolean isToolNameInShowOrderVector(String name) {
        int i = 0;
        while (i < this.m_visToolShowOrder.size()) {
            Integer intIndex = this.m_visToolShowOrder.get(i);
            IDLVisTool vt = this.m_visTools.get(intIndex);
            if (name.equalsIgnoreCase(vt.getToolName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isToolNameBeingUsed(String toolName) {
        boolean bUsed = false;
        int i = 0;
        while (i < this.m_visTools.size()) {
            IDLVisTool vt = this.m_visTools.get(i);
            if (toolName.equalsIgnoreCase(vt.getToolName())) {
                if (vt.isSystemDefined()) {
                    bUsed = true;
                    break;
                }
                bUsed = this.isToolNameInShowOrderVector(toolName);
                break;
            }
            ++i;
        }
        return bUsed;
    }

    protected void unregisterIDLNotifications() {
        for (IDLNotifyListener listener : this.m_idlListeners) {
            ResponseManager.removeIDLNotifyListener((IDLNotifyListener)listener);
        }
    }

    protected void registerIDLNotifications() {
        IDLNotifyListener listener = new IDLNotifyListener("IDLReset"){

            public void handleIDLNotification(IDLVariable parm1, IDLVariable parm2) {
                int i = 0;
                while (i < ToolPaletteView.this.m_visTools.size()) {
                    IDLVisTool vt = ToolPaletteView.this.m_visTools.get(i);
                    vt.clearActionBarDropStates();
                    ++i;
                }
                if (ToolPaletteView.this.m_currentVisTool != null) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).ToolPaletteView.this.m_actionComposite.setMinWidth(225);
                            IDLVisTool vt = (this).ToolPaletteView.this.m_currentVisTool;
                            ToolPaletteView.this.showToolActions(vt, true, true);
                        }
                    });
                }
            }
        };
        ResponseManager.addIDLNotifyListener((IDLNotifyListener)listener);
        this.m_idlListeners.add(listener);
    }

    private ToolItem createToolItem(ToolBar parent, IDLVisTool visTool) {
        String toolTipText;
        int type;
        if (ToolPaletteView.getInstance().isShowingActionBars()) {
            type = 16;
            toolTipText = Messages.VisPaletteView_DropDataOnToolToInvokeAction;
        } else {
            type = 8;
            toolTipText = Messages.VisPaletteView_DropDataToInvokeActionOrSelectToInvokeNoArgAction;
        }
        ToolItem item = new ToolItem(parent, type);
        item.setImage(visTool.getLargeImage());
        item.setHotImage(visTool.getLargeImage());
        String limitedChars = this.limitChars(item, visTool.getToolName());
        String dupedAmps = this.duplicateAmpersands(limitedChars);
        item.setText(dupedAmps);
        item.setToolTipText(String.valueOf(Messages.VisPaletteView_Tool) + ":" + this.duplicateAmpersands(visTool.getToolName()) + "\n" + toolTipText);
        return item;
    }

    public String duplicateAmpersands(String limitedChars) {
        char[] charArray = limitedChars.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '&') {
                sb.append(c);
                sb.append(c);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    private String limitChars(ToolItem item, String theToolName) {
        String toolName = theToolName;
        Font font = item.getParent().getFont();
        GC gc = new GC((Drawable)Display.getCurrent());
        gc.setFont(font);
        String newToolName = toolName;
        Point size = gc.stringExtent(newToolName);
        while (size.x > 71) {
            int newLength = toolName.length() - 1;
            toolName = toolName.substring(0, newLength);
            newToolName = String.valueOf(toolName) + "...";
            size = gc.stringExtent(newToolName);
        }
        gc.dispose();
        return newToolName;
    }

    protected void cleanupToolPaletteInPreparationForNewPopulation() {
        if (this.m_visTools == null) {
            this.m_visTools = ToolCatalogParser.getInstance().getVisTools();
            this.m_visToolShowOrder = ToolCatalogParser.getInstance().getVisToolShowOrder();
        }
        if (this.m_actionComposite != null && this.m_actionComposite.isInEditMode()) {
            this.m_actionComposite.cancelActionBarEditMode(true);
        }
        this.clearComposite(this.m_newVisComposite);
        if (this.m_actionComposite != null) {
            this.m_actionComposite.clear();
        }
    }

    public void populateToolsPaletteInOperationMode() {
        this.m_paletteToolBar = new ToolBar(this.m_newVisComposite, 512);
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.m_paletteToolBar.setLayoutData((Object)gd);
        this.addContextMenuToToolBar(this.m_paletteToolBar);
        IDLVisTool firstTool = this.m_currentVisTool;
        int i = 0;
        while (i < this.m_visToolShowOrder.size()) {
            Integer idx = this.m_visToolShowOrder.get(i);
            IDLVisTool visTool = this.m_visTools.get(idx);
            ToolItem item = this.createToolItem(this.m_paletteToolBar, visTool);
            item.setData(CD_VISTOOL, (Object)visTool);
            if (firstTool == null) {
                firstTool = visTool;
                item.setSelection(true);
            } else if (visTool == this.m_currentVisTool) {
                item.setSelection(true);
            }
            item.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ToolItem b = (ToolItem)event.widget;
                    IDLVisTool visTool1 = (IDLVisTool)b.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.visToolSelected(visTool1);
                }
            });
            ++i;
        }
        this.makePaletteToolbarADropSite();
        if (!this.m_bToolPaletteEditMode && !this.m_actionComposite.isInEditMode() && firstTool != null) {
            this.showToolActions(firstTool, true, true);
        }
        if (this.m_bToolPaletteEditMode) {
            this.hookVisToolDragSupport();
        }
        this.m_newVisComposite.layout(true);
        this.m_newVisComposite.pack();
        this.m_newVisComposite.getParent().layout(true);
        this.m_newVisComposite.getParent().pack();
    }

    private void addContextMenuToVisToolControl(Button toolButton) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu((Control)toolButton);
        IDLVisTool visTool = (IDLVisTool)toolButton.getData(CD_VISTOOL);
        menu.setData(CD_VISTOOL, (Object)visTool);
        toolButton.setMenu(menu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Menu menu1 = ((MenuManager)manager).getMenu();
                IDLVisTool visTool1 = (IDLVisTool)menu1.getData(ToolPaletteView.CD_VISTOOL);
                Button toolButton1 = visTool1.getVisToolControl().getToolButton();
                EditVisToolAction editVisToolAction = new EditVisToolAction(toolButton1);
                manager.add((IAction)editVisToolAction);
                manager.add((IAction)new EditVisToolActionsAction(toolButton1));
                if (visTool1.isSystemDefined()) {
                    editVisToolAction.setEnabled(false);
                } else {
                    editVisToolAction.setEnabled(true);
                }
            }
        });
    }

    private void addContextMenuToToolBar(ToolBar toolBar) {
        MenuManager menuMgr = new MenuManager();
        this.m_editVisToolAction = new EditVisToolOnToolbarAction(toolBar);
        menuMgr.add((IAction)this.m_editVisToolAction);
        menuMgr.add((IAction)new EditVisToolActionsOnToolbarAction(toolBar));
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu((Control)toolBar);
        toolBar.setMenu(menu);
        toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ToolBar toolBar1 = (ToolBar)event.widget;
                Point location = new Point(event.x, event.y);
                ToolItem item = toolBar1.getItem(location);
                if (item != null && item.getBounds().contains(event.x, event.y)) {
                    ToolPaletteView.this.m_menuOpenOnItem = item;
                    IDLVisTool visTool = (IDLVisTool)ToolPaletteView.this.m_menuOpenOnItem.getData(ToolPaletteView.CD_VISTOOL);
                    if (visTool.isSystemDefined()) {
                        ToolPaletteView.this.m_editVisToolAction.setEnabled(false);
                    } else {
                        ToolPaletteView.this.m_editVisToolAction.setEnabled(true);
                    }
                }
            }
        });
    }

    protected void visToolSelected(IDLVisTool visTool) {
        if (this.isShowingActionBars()) {
            this.m_actionComposite.cancelActionBarEditMode(true);
            this.showToolActions(visTool, false, false);
        } else {
            visTool.invokeFirstNoArgumentActionBar();
        }
    }

    protected void makePaletteToolbarADropSite() {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){
            IDLVisTool m_visTool = null;

            public void dragEnter(DropTargetEvent event) {
                if (ToolPaletteView.this.m_actionComposite.isInEditMode()) {
                    event.detail = 0;
                    return;
                }
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (ActionBarCopyTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    ++i;
                }
                DropTarget dt = (DropTarget)event.getSource();
                ToolBar paletteToolbar = (ToolBar)dt.getControl();
                Point location = new Point(event.x, event.y);
                ToolItem item = paletteToolbar.getItem(paletteToolbar.getDisplay().map(null, (Control)paletteToolbar, location));
                if (item == null) {
                    return;
                }
                if (!ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IDLVisTool visTool = (IDLVisTool)item.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.m_actionComposite.cancelActionBarEditMode(true);
                    ToolPaletteView.this.showToolActions(visTool, false, false);
                    ToolPaletteView.this.updatePaletteToolbarSelection();
                }
            }

            public void dragOver(DropTargetEvent event) {
                if (ToolPaletteView.this.m_actionComposite.isInEditMode()) {
                    return;
                }
                DropTarget dt = (DropTarget)event.getSource();
                ToolBar paletteToolbar = (ToolBar)dt.getControl();
                Point location = new Point(event.x, event.y);
                ToolItem item = paletteToolbar.getItem(paletteToolbar.getDisplay().map(null, (Control)paletteToolbar, location));
                if (item == null) {
                    return;
                }
                ScrolledComposite scrollComposite = null;
                Composite c = paletteToolbar.getParent();
                while (c != null) {
                    if (c instanceof ScrolledComposite) {
                        scrollComposite = (ScrolledComposite)c;
                        break;
                    }
                    c = c.getParent();
                }
                if (scrollComposite != null) {
                    ToolPaletteView.this.autoScrollComposite(scrollComposite, event.y);
                }
                if (!ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IDLVisTool visTool = (IDLVisTool)item.getData(ToolPaletteView.CD_VISTOOL);
                    ToolPaletteView.this.m_actionComposite.cancelActionBarEditMode(true);
                    ToolPaletteView.this.showToolActions(visTool, false, false);
                    ToolPaletteView.this.updatePaletteToolbarSelection();
                }
            }

            private boolean allowThisActionBarDrop(DropTargetEvent event) {
                ActionSig sig;
                DropTarget dt = (DropTarget)event.getSource();
                ToolBar paletteToolbar = (ToolBar)dt.getControl();
                Point location = new Point(event.x, event.y);
                ToolItem item = paletteToolbar.getItem(paletteToolbar.getDisplay().map(null, (Control)paletteToolbar, location));
                if (item == null) {
                    return false;
                }
                this.m_visTool = (IDLVisTool)item.getData(ToolPaletteView.CD_VISTOOL);
                if (this.m_visTool == null) {
                    return false;
                }
                return !ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType) || (sig = IDLVisTool.getHandleToActionBeingDrug()) == null || this.m_visTool == null || !this.m_visTool.containsSig(sig);
            }

            public void drop(DropTargetEvent event) {
                if (!this.allowThisActionBarDrop(event)) {
                    return;
                }
                if (ActionBarCopyTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    ToolPaletteView.this.copyActionBarToTool(this.m_visTool);
                } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) || TextTransfer.getInstance().isSupportedType(event.currentDataType) || FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String idlVariables = TreeUtils.convertTransferDataToString((Object)event.data);
                    if (idlVariables == null) {
                        return;
                    }
                    ToolPaletteView.this.m_actionComposite.setLayoutDeferred(true);
                    ToolPaletteView.this.m_actionComposite.cancelActionBarEditMode(true);
                    this.m_visTool.createNewVisUsingFirstMatchingActionSignature(idlVariables);
                    ToolPaletteView.this.m_actionComposite.setLayoutDeferred(false);
                    ToolPaletteView.this.m_actionComposite.layout(true);
                }
            }
        };
        int style = 17;
        Transfer[] types = new Transfer[]{ActionBarCopyTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.m_paletteToolBar, style);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        this.m_visToolDropListenerClearList.put(target, targetAdapter);
    }

    public void updatePaletteToolbarSelection() {
        if (this.m_paletteToolBar == null) {
            return;
        }
        ToolItem[] items = this.m_paletteToolBar.getItems();
        int i = 0;
        while (i < items.length) {
            IDLVisTool vt = (IDLVisTool)items[i].getData(CD_VISTOOL);
            if (vt == this.m_currentVisTool) {
                items[i].setSelection(true);
            } else {
                items[i].setSelection(false);
            }
            ++i;
        }
    }

    public void setVisPaletteEnabled(boolean value) {
        if (this.m_paletteToolBar != null) {
            this.m_paletteToolBar.setEnabled(value);
        } else {
            this.m_newVisComposite.setVisible(value);
        }
        this.setLeftRightLayoutRadioActionEnablement();
    }

    public Image getAddActionBarFromExistingImage() {
        if (this.m_addActionBarFromExistingImage16 == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/addActionBar16.png"), null);
            this.m_addActionBarFromExistingImage16 = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_addActionBarFromExistingImage16;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.m_selection = (ITextSelection)selection;
        }
    }

    public ITextSelection getTextSelection() {
        return this.m_selection;
    }

    public void startVisToolExport() {
        ExportVisToolDialog dlg = new ExportVisToolDialog(Display.getCurrent().getActiveShell(), Messages.VisPaletteView_ExportActions, this.m_visTools, this.m_visToolShowOrder);
        dlg.open();
    }

    public void startVisToolImport() {
        ImportVisToolDialog dlg = new ImportVisToolDialog(Display.getCurrent().getActiveShell(), 4096);
        String importFilename = dlg.open();
        this.performToolImport(importFilename);
    }

    public boolean performToolImport(String importFilename) {
        if (importFilename == null || importFilename.trim().length() == 0) {
            return false;
        }
        boolean success = this.executeImportOperation(new VisPaletteImportOperation(this, importFilename));
        return success;
    }

    protected boolean executeImportOperation(VisPaletteImportOperation op) {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        try {
            ProgressMonitorDialog importWorker = new ProgressMonitorDialog(shell);
            importWorker.run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            MessageBox box = new MessageBox(shell, 33);
            box.setMessage(e.getTargetException().getLocalizedMessage());
            box.setText(Messages.VisPaletteView_ImportProblems);
            box.open();
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)shell, (String)Messages.VisPaletteView_ImportProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public Vector<IDLVisTool> getVisTools() {
        return this.m_visTools;
    }

    public Vector<Integer> getVisToolShowOrder() {
        return this.m_visToolShowOrder;
    }

    public void clearVisTools() {
        this.m_visTools = null;
    }

    public void registerImport(String importFilename) {
        this.m_registeredImportFilename = importFilename;
    }

    protected class EditVisToolAction
    extends Action {
        Button m_toolButton;

        public EditVisToolAction(Button toolButton) {
            this.setText(String.valueOf(Messages.VisPaletteView_EditTool) + "...");
            this.m_toolButton = toolButton;
        }

        public void run() {
            IDLVisTool visTool;
            ToolPaletteView.this.m_currentVisTool = visTool = (IDLVisTool)this.m_toolButton.getData(ToolPaletteView.CD_VISTOOL);
            ToolPaletteView.this.m_registeredToolToStartEditing = visTool;
            ToolPaletteView.getInstance().startVisPaletteEditMode();
        }
    }

    protected class EditVisToolActionsAction
    extends Action {
        Button m_button;

        public EditVisToolActionsAction(Button button) {
            this.setText(String.valueOf(Messages.VisPaletteView_EditActions) + "...");
            this.m_button = button;
        }

        public void run() {
            IDLVisTool visTool = (IDLVisTool)this.m_button.getData(ToolPaletteView.CD_VISTOOL);
            if (ToolPaletteView.this.isShowingActionBars()) {
                if (visTool != null) {
                    ToolPaletteView.this.showToolActions(visTool, true, true);
                    ToolPaletteView.getInstance().startActionBarEditMode();
                }
            } else {
                ToolPaletteView.this.m_currentVisTool = visTool;
                ToolPaletteView.this.m_registeredToEditAVisToolsActions = true;
                IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
                pref_store.setValue("IDLDT_VISMGR_LAYOUT_FULL", true);
            }
        }
    }

    protected class EditVisToolActionsOnToolbarAction
    extends Action {
        ToolBar m_toolBar;

        public EditVisToolActionsOnToolbarAction(ToolBar toolBar) {
            this.setText(String.valueOf(Messages.VisPaletteView_EditActions) + "...");
            this.m_toolBar = toolBar;
        }

        public void run() {
            if (ToolPaletteView.this.m_menuOpenOnItem != null) {
                IDLVisTool visTool = (IDLVisTool)ToolPaletteView.this.m_menuOpenOnItem.getData(ToolPaletteView.CD_VISTOOL);
                if (ToolPaletteView.this.isShowingActionBars()) {
                    ToolPaletteView.this.showToolActions(visTool, true, true);
                    ToolPaletteView.getInstance().startActionBarEditMode();
                } else {
                    ToolPaletteView.this.m_currentVisTool = visTool;
                    ToolPaletteView.this.m_registeredToEditAVisToolsActions = true;
                    IPreferenceStore pref_store = UIPreferenceManager.getPreferenceStore();
                    pref_store.setValue("IDLDT_VISMGR_LAYOUT_FULL", true);
                }
            }
        }
    }

    protected class EditVisToolOnToolbarAction
    extends Action {
        ToolBar m_toolBar;

        public EditVisToolOnToolbarAction(ToolBar toolBar) {
            this.setText(String.valueOf(Messages.VisPaletteView_EditTool) + "...");
            this.m_toolBar = toolBar;
        }

        public void run() {
            if (ToolPaletteView.this.m_menuOpenOnItem != null) {
                IDLVisTool visTool;
                ToolPaletteView.this.m_currentVisTool = visTool = (IDLVisTool)ToolPaletteView.this.m_menuOpenOnItem.getData(ToolPaletteView.CD_VISTOOL);
                ToolPaletteView.this.m_registeredToolToStartEditing = visTool;
                ToolPaletteView.getInstance().startVisPaletteEditMode();
            }
        }
    }

    protected class MyComposite
    extends Composite {
        public MyComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Control[] kids = this.getChildren();
            if (kids == null || kids.length == 0) {
                return new Point(0, 0);
            }
            return super.computeSize(wHint, hHint, changed);
        }
    }

    protected class MyScrolledComposite
    extends ScrolledComposite {
        public MyScrolledComposite(Composite parent, int style) {
            super(parent, style);
            this.setExpandHorizontal(true);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Control[] kids = this.getChildren();
            if (kids == null || kids.length == 0) {
                return new Point(0, 0);
            }
            if (kids.length == 1) {
                return kids[0].computeSize(wHint, hHint, changed);
            }
            return super.computeSize(wHint, hHint, changed);
        }
    }

    private class PopulateToolPaletteJob
    extends Job {
        public PopulateToolPaletteJob() {
            super(Messages.VisPaletteView_PopulatingToolPalette);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ToolPalette2IDLComms.waitForIDLToBecomeActive();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (((PopulateToolPaletteJob)PopulateToolPaletteJob.this).ToolPaletteView.this.m_bToolPaletteEditMode) {
                        ToolPaletteView.this.cancelToolPaletteEdits();
                    }
                    ToolPaletteView.this.populateToolsPalette();
                    if (((PopulateToolPaletteJob)PopulateToolPaletteJob.this).ToolPaletteView.this.m_registeredImportFilename != null) {
                        final String vexpFile = ((PopulateToolPaletteJob)PopulateToolPaletteJob.this).ToolPaletteView.this.m_registeredImportFilename;
                        ((PopulateToolPaletteJob)PopulateToolPaletteJob.this).ToolPaletteView.this.m_registeredImportFilename = null;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ToolPaletteView.this.performToolImport(vexpFile);
                            }
                        });
                    }
                    IDLPluginVexpImporter vexpImporter = new IDLPluginVexpImporter();
                    vexpImporter.consumeNewBundleVexpFiles();
                    if (((PopulateToolPaletteJob)PopulateToolPaletteJob.this).ToolPaletteView.this.m_registeredToEditAVisToolsActions) {
                        ((PopulateToolPaletteJob)PopulateToolPaletteJob.this).ToolPaletteView.this.m_registeredToEditAVisToolsActions = false;
                        ToolPaletteView.this.startActionBarEditMode();
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    private class WriteCatalogAndShowActionsJob
    extends Job {
        IDLVisTool m_visTool;

        public WriteCatalogAndShowActionsJob(IDLVisTool visTool) {
            super(Messages.VisPaletteView_PopulatingToolPalette);
            this.setSystem(true);
            this.m_visTool = visTool;
        }

        protected IStatus run(IProgressMonitor monitor) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ((WriteCatalogAndShowActionsJob)WriteCatalogAndShowActionsJob.this).ToolPaletteView.this.m_actionComposite.cancelActionBarEditMode(true);
                    ToolPaletteView.this.showToolActions(WriteCatalogAndShowActionsJob.this.m_visTool, false, false);
                    ToolPaletteView.this.updatePaletteToolbarSelection();
                }
            });
            ToolPaletteView.this.writeUserCatalog();
            return Status.OK_STATUS;
        }
    }
}

