/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.views;

import com.rsi.idldt.toolpalette.ExistingVisDataModel;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.actions.ShowVisMgrGettingStartedAction;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.internal.ui.PlotOverlayCommandTransfer;
import com.rsi.idldt.toolpalette.internal.ui.ScrolledCompositeWithGradientBackground;
import com.rsi.idldt.toolpalette.internal.ui.VisToolControl;
import com.rsi.idldt.ui.TreeUtils;
import com.rsi.jdml.PlatformSupport;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class ExistingVisView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID_EXISTINGVIS_VIEW = "com.rsi.idldt.toolpalette.views.ExistingVisView";
    public static final String VIEW_HELP_ID = "com.rsi.idldt.toolpalette.views_ExistingVisView_view_help";
    protected static final String CD_IMAGE_DISPOSE = "imageDispose";
    protected static final String CD_PLOTID = "plotID";
    protected static final String CD_DROP_TARGET = "dropTarget";
    protected ExistingVisView m_instance;
    protected static HashMap<IWorkbenchWindow, ExistingVisView> m_instances = new HashMap();
    protected Composite m_existingVisComposite;
    protected Hashtable<String, VisToolControl> m_plotId2VisButtonHash = new Hashtable();
    private ScrolledComposite m_scrolledComposite;
    private GridLayout m_mainGridLayout;
    Composite m_gettingStartedComposite;
    private VisToolControl m_currentTool = null;
    protected Hashtable<DropTarget, DropTargetAdapter> m_dropListenerClearList = new Hashtable();
    private Image bulletImage;

    public ExistingVisView() {
        this.m_instance = this;
    }

    public static ExistingVisView[] getInstances() {
        Collection<ExistingVisView> views = m_instances.values();
        ExistingVisView[] arrayViews = new ExistingVisView[views.size()];
        return views.toArray(arrayViews);
    }

    public static ExistingVisView getInstance() {
        try {
            IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ExistingVisView instance = m_instances.get(wbWindow);
            return instance;
        }
        catch (Exception exception) {
            if (m_instances.size() > 0) {
                Collection<ExistingVisView> views = m_instances.values();
                ExistingVisView instance = (ExistingVisView)((Object)views.toArray()[0]);
                return instance;
            }
            return null;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
        }
        this.m_gettingStartedComposite = null;
        this.m_plotId2VisButtonHash.clear();
        this.removeInstance();
        this.m_instance = null;
    }

    protected void removeInstance() {
        Collection<ExistingVisView> views = m_instances.values();
        Set<IWorkbenchWindow> windows = m_instances.keySet();
        int i = 0;
        IWorkbenchWindow foundWindow = null;
        for (ExistingVisView v : views) {
            if (v == this.m_instance) {
                foundWindow = (IWorkbenchWindow)windows.toArray()[i];
                break;
            }
            ++i;
        }
        if (foundWindow != null) {
            m_instances.remove(foundWindow);
        }
    }

    public void createPartControl(Composite parent) {
        IWorkbenchWindow wbWindow = this.getWorkbenchWindow(parent);
        m_instances.put(wbWindow, this.m_instance);
        parent.setLayout((Layout)new FillLayout());
        this.createExistingVisComposite(parent);
        ToolPalettePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, VIEW_HELP_ID);
        this.populateView();
    }

    protected IWorkbenchWindow getWorkbenchWindow(Composite parent) {
        IWorkbenchWindow[] wbws;
        Shell ourShell = parent.getShell();
        IWorkbenchWindow[] iWorkbenchWindowArray = wbws = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = wbws.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbw = iWorkbenchWindowArray[n2];
            if (wbw.getShell() == ourShell) {
                return wbw;
            }
            ++n2;
        }
        return wbws[wbws.length - 1];
    }

    protected void populateView() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ExistingVisDataModel evdm = ToolPalettePlugin.getDefault().getExistingVisDataModel();
                if (evdm != null) {
                    evdm.populateView();
                }
                ExistingVisView.this.showOrHideGettingStartedComposite();
            }
        });
    }

    public void createExistingVisComposite(Composite parent) {
        this.m_scrolledComposite = new ScrolledCompositeWithGradientBackground(parent, 768);
        this.m_scrolledComposite.setExpandHorizontal(true);
        this.m_scrolledComposite.setMinWidth(VisToolControl.getMinWidth() + 55);
        this.m_scrolledComposite.getVerticalBar().setIncrement(20);
        this.m_existingVisComposite = new Composite((Composite)this.m_scrolledComposite, 0);
        this.m_mainGridLayout = new GridLayout(1, false);
        this.m_existingVisComposite.setLayout((Layout)this.m_mainGridLayout);
        this.m_scrolledComposite.setContent((Control)this.m_existingVisComposite);
        this.recomputeSize();
        Listener resizeListener = new Listener(){

            public void handleEvent(Event event) {
                ExistingVisView.this.recomputeSize();
            }
        };
        this.m_scrolledComposite.addListener(11, resizeListener);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)new CloseAllExistingVisToolAction(true));
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu((Control)this.m_existingVisComposite);
        this.m_existingVisComposite.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.m_scrolledComposite);
        this.m_scrolledComposite.setMenu(menu);
    }

    protected void recomputeSize() {
        int parentWidth = this.m_scrolledComposite.getSize().x;
        this.m_mainGridLayout.numColumns = this.m_plotId2VisButtonHash.size() <= 1 ? 1 : Math.max(1, parentWidth / (VisToolControl.getMinWidth() + 6));
        this.showOrHideGettingStartedComposite();
        if (this.m_gettingStartedComposite != null) {
            GridData gd = (GridData)this.m_gettingStartedComposite.getLayoutData();
            gd.widthHint = parentWidth - 20;
            this.m_gettingStartedComposite.layout(true);
        }
        this.m_existingVisComposite.layout(true);
        this.m_existingVisComposite.pack(true);
        this.m_scrolledComposite.layout(true);
    }

    protected void showOrHideGettingStartedComposite() {
        if (this.m_plotId2VisButtonHash.size() == 0) {
            if (this.m_gettingStartedComposite == null) {
                this.showGettingStartedComposite();
            }
        } else if (this.m_gettingStartedComposite != null) {
            this.m_gettingStartedComposite.dispose();
            this.m_gettingStartedComposite = null;
        }
        this.m_instance.setCloseAllActionEnablement();
    }

    private void setCloseAllActionEnablement() {
        IContributionItem[] menu_items;
        boolean bEnabled = false;
        if (this.m_plotId2VisButtonHash.size() > 0) {
            bEnabled = true;
        }
        IToolBarManager mm = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = menu_items = mm.getItems();
        int n = menu_items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && item.getId().equals("com.rsi.idldt.toolpalette.actions.CloseAllVisAction")) {
                IAction action = ((ActionContributionItem)item).getAction();
                action.setEnabled(bEnabled);
            }
            ++n2;
        }
    }

    protected void showGettingStartedComposite() {
        this.m_gettingStartedComposite = new Composite(this.m_existingVisComposite, 0);
        this.m_gettingStartedComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.grabExcessHorizontalSpace = true;
        this.m_gettingStartedComposite.setLayoutData((Object)gd);
        Label label0 = new Label(this.m_gettingStartedComposite, 16448);
        label0.setText(Messages.ExistingVisView_ToLearnMore);
        Composite comp = new Composite(this.m_gettingStartedComposite, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 15;
        comp.setLayout((Layout)gl);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalIndent = 5;
        gd2.horizontalIndent = 20;
        gd2.grabExcessHorizontalSpace = true;
        comp.setLayoutData((Object)gd2);
        URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/bullet.png"), null);
        this.bulletImage = ImageDescriptor.createFromURL((URL)url).createImage();
        Label bullet0 = new Label(comp, 16384);
        bullet0.setImage(this.bulletImage);
        Link videoLink = new Link(comp, 16448);
        StringBuilder videoLinkText = new StringBuilder("<a>" + Messages.ExistingVisView_WatchVideos.trim() + "</a>");
        if (PlatformSupport.isLinux()) {
            videoLinkText.append("  ");
        }
        videoLink.setText(videoLinkText.toString());
        videoLink.setToolTipText(Messages.ExistingVisView_ClickHereToSeeAQuickStartVideo);
        Label bullet1 = new Label(comp, 16384);
        bullet1.setImage(this.bulletImage);
        Link gettingStartedLink = new Link(comp, 16448);
        StringBuilder gettingStartedLinkText = new StringBuilder("<a>" + Messages.ExistingVisView_ReadOnlineHelp.trim() + "</a>");
        if (PlatformSupport.isLinux()) {
            gettingStartedLinkText = new StringBuilder("<a>" + Messages.ExistingVisView_ReadOnlineHelp.trim() + " </a>  ");
        }
        gettingStartedLink.setText(gettingStartedLinkText.toString());
        gettingStartedLink.setToolTipText(Messages.ExistingVisView_ClickHereForHelpOnGettingStarted);
        Listener videoLinkListener = new Listener(){

            public void handleEvent(Event event) {
                ShowVisMgrGettingStartedAction.showGettingStartedVideo();
            }
        };
        videoLink.addListener(13, videoLinkListener);
        Listener gettingStartedLinkListener = new Listener(){

            public void handleEvent(Event event) {
                ShowVisMgrGettingStartedAction.showGettingStartedHelpTopic();
            }
        };
        gettingStartedLink.addListener(13, gettingStartedLinkListener);
        this.m_existingVisComposite.layout(true);
    }

    public void removeAllVisualizations() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ExistingVisView.this.m_plotId2VisButtonHash.clear();
                ExistingVisView.this.clearComposite(ExistingVisView.this.m_existingVisComposite);
                ExistingVisView.this.m_gettingStartedComposite = null;
                ExistingVisView.this.showOrHideGettingStartedComposite();
            }
        });
    }

    protected void clearComposite(Composite c) {
        Enumeration<DropTarget> e = this.m_dropListenerClearList.keys();
        while (e.hasMoreElements()) {
            DropTarget dt = e.nextElement();
            DropTargetAdapter dta = this.m_dropListenerClearList.get(dt);
            if (dt.isDisposed()) continue;
            dt.removeDropListener((DropTargetListener)dta);
        }
        this.m_dropListenerClearList.clear();
        Control[] kids = c.getChildren();
        int i = 0;
        while (i < kids.length) {
            kids[i].dispose();
            ++i;
        }
        c.layout();
    }

    public void handleCurrentItoolChanged(String plotID) {
        VisToolControl vtc = this.m_plotId2VisButtonHash.get(plotID);
        if (vtc == null) {
            return;
        }
        SetCurrentToolRunnable runable = new SetCurrentToolRunnable(vtc);
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)runable);
    }

    public void handleVisToolIconChange(String plotID, String plotTitle, ImageData imageData) {
        ExistingVisView[] evvs = ExistingVisView.getInstances();
        if (evvs == null || evvs.length < 1) {
            return;
        }
        VisToolControl visButton = this.m_plotId2VisButtonHash.get(plotID);
        Runnable runable = visButton == null ? new CreateNewVisButtonRunnable(plotID, plotTitle, imageData) : new ChangeVisIconRunnable(visButton, imageData);
        PlatformUI.getWorkbench().getDisplay().asyncExec(runable);
    }

    public void handleRemovalOfVisToolButton(String plotID) {
        if (this.m_instance == null) {
            return;
        }
        RemoveVisButtonRunnable runable = new RemoveVisButtonRunnable(plotID);
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)runable);
    }

    protected void removeExistingVisToolButton(String plotID) {
        if (this.m_instance == null) {
            return;
        }
        VisToolControl vtc = this.m_plotId2VisButtonHash.get(plotID);
        if (vtc == null) {
            return;
        }
        this.possiblyDisposeImage(vtc);
        DropTarget dt = (DropTarget)vtc.getToolButton().getData(CD_DROP_TARGET);
        DropTargetAdapter dta = this.m_dropListenerClearList.get(dt);
        if (!dt.isDisposed()) {
            dt.removeDropListener((DropTargetListener)dta);
        }
        this.m_dropListenerClearList.remove(dt);
        vtc.dispose();
        this.m_plotId2VisButtonHash.remove(plotID);
        this.recomputeSize();
    }

    protected void markImageForDispose(VisToolControl vtc) {
        vtc.setData(CD_IMAGE_DISPOSE, new Boolean(true));
    }

    public void possiblyDisposeImage(VisToolControl vtc) {
        Boolean bDispose = (Boolean)vtc.getData(CD_IMAGE_DISPOSE);
        if (bDispose == null) {
            return;
        }
        if (bDispose.booleanValue()) {
            vtc.getImage().dispose();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        ToolPalettePlugin.getDefault().savePluginPreferences();
    }

    public void addVisToExistingVisComposite(String plotID, String plotTitle, ImageData imageData) {
        Image image = new Image((Device)this.m_existingVisComposite.getDisplay(), imageData);
        VisToolControl vtc = new VisToolControl(plotTitle, plotID, image, this.m_existingVisComposite, 0);
        this.markImageForDispose(vtc);
        vtc.setData(CD_PLOTID, plotID);
        vtc.getToolButton().setData(CD_PLOTID, (Object)plotID);
        vtc.setLayoutData(new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        vtc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisToolControl vtc1 = (VisToolControl)((Object)e.getSource());
                String plotID1 = (String)vtc1.getData(ExistingVisView.CD_PLOTID);
                String command = "iSetCurrent, '" + plotID1 + "', /SHOW";
                ToolPalette2IDLComms.executeString(command);
                ExistingVisView.this.setCurrentTool(vtc1);
            }
        });
        this.m_plotId2VisButtonHash.put(plotID, vtc);
        this.setCurrentTool(vtc);
        this.makeButtonADropSiteForOverplot(vtc, plotID);
        this.recomputeSize();
        int ypos = vtc.getBounds().y;
        this.m_scrolledComposite.setOrigin(0, ypos);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)new CloseExistingVisToolAction(plotID, true));
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu((Control)vtc.getToolButton());
        vtc.getToolButton().setMenu(menu);
    }

    protected void setCurrentTool(VisToolControl vtc) {
        this.deSelectCurrentTool();
        vtc.setSelected(true);
        this.m_currentTool = vtc;
    }

    protected void deSelectCurrentTool() {
        if (this.m_currentTool != null && !this.m_currentTool.isDisposed()) {
            this.m_currentTool.setSelected(false);
        }
        this.m_currentTool = null;
    }

    protected void makeButtonADropSiteForOverplot(VisToolControl vtc, String visID) {
        DropTargetAdapter targetAdapter = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (PlotOverlayCommandTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    ++i;
                }
                DropTarget dt = (DropTarget)event.getSource();
                Button visButton = (Button)dt.getControl();
                if (PlotOverlayCommandTransfer.getInstance().isSupportedType(event.currentDataType) && IDLVisTool.getOverplotDragData() == null) {
                    event.detail = 0;
                } else {
                    visButton.setFocus();
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (PlotOverlayCommandTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    DropTarget dt = (DropTarget)event.getSource();
                    Button visButton = (Button)dt.getControl();
                    String plotID = (String)visButton.getData(ExistingVisView.CD_PLOTID);
                    String plotCommand = IDLVisTool.getOverplotDragData();
                    if (plotID != null) {
                        IDLVisTool.overplotVisUsingCommand(plotCommand, plotID);
                    }
                } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType) || LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) || FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String idlVariables = TreeUtils.convertTransferDataToString((Object)event.data);
                    if (idlVariables == null) {
                        return;
                    }
                    DropTarget dt = (DropTarget)event.getSource();
                    Button visButton = (Button)dt.getControl();
                    String plotID = (String)visButton.getData(ExistingVisView.CD_PLOTID);
                    if (plotID != null) {
                        IDLVisTool.overplotVisUsingVariables(idlVariables, plotID);
                    }
                }
            }
        };
        int style = 17;
        Transfer[] types = new Transfer[]{PlotOverlayCommandTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance()};
        Button button = vtc.getToolButton();
        DropTarget target = new DropTarget((Control)button, style);
        button.setData(CD_DROP_TARGET, (Object)target);
        button.setData(CD_PLOTID, (Object)visID);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)targetAdapter);
        this.m_dropListenerClearList.put(target, targetAdapter);
    }

    public void closeAllVisualizations(boolean bPrompt) {
        Enumeration<String> keys = this.m_plotId2VisButtonHash.keys();
        while (keys.hasMoreElements()) {
            String plotID = keys.nextElement();
            String command = "idelete, '" + plotID + "'";
            if (!bPrompt) {
                command = String.valueOf(command) + ", /NO_PROMPT";
            }
            ToolPalette2IDLComms.executeString(command);
        }
    }

    public void setFocus() {
        this.m_scrolledComposite.setFocus();
    }

    protected class ChangeVisIconRunnable
    implements Runnable {
        VisToolControl m_visButton;
        ImageData m_imageData;

        public ChangeVisIconRunnable(VisToolControl visButton, ImageData imageData) {
            this.m_visButton = visButton;
            this.m_imageData = imageData;
        }

        public void run() {
            Image image = new Image((Device)this.m_visButton.getDisplay(), this.m_imageData);
            ExistingVisView.this.m_instance.possiblyDisposeImage(this.m_visButton);
            this.m_visButton.setImage(image);
            ExistingVisView.this.m_instance.markImageForDispose(this.m_visButton);
        }
    }

    protected class CloseAllExistingVisToolAction
    extends Action {
        String m_plotID;
        boolean m_bPrompt;

        public CloseAllExistingVisToolAction(boolean bPromptToSaveChanges) {
            if (bPromptToSaveChanges) {
                this.setText(Messages.ExistingVisView_CloseAll);
                this.setToolTipText(Messages.ExistingVisView_CloseAllTooltipText);
            } else {
                this.setText(Messages.ExistingVisView_CloseAllAbandoningChanges);
                this.setToolTipText(Messages.ExistingVisView_CloseAllBypass);
            }
            this.m_bPrompt = bPromptToSaveChanges;
        }

        public void run() {
            ExistingVisView.this.closeAllVisualizations(this.m_bPrompt);
        }
    }

    protected class CloseExistingVisToolAction
    extends Action {
        String m_plotID;
        boolean m_bPrompt;

        public CloseExistingVisToolAction(String plotID, boolean bPromptToSaveChanges) {
            if (bPromptToSaveChanges) {
                this.setText(Messages.ExistingVisView_Close);
                this.setToolTipText(Messages.ExistingVisView_CloseTooltipText);
            } else {
                this.setText(Messages.ExistingVisView_CloseAbandoningChanges);
                this.setToolTipText(Messages.ExistingVisView_CloseBypass);
            }
            this.m_plotID = plotID;
            this.m_bPrompt = bPromptToSaveChanges;
        }

        public void run() {
            String command = "idelete, '" + this.m_plotID + "'";
            if (!this.m_bPrompt) {
                command = String.valueOf(command) + ", /NO_PROMPT";
            }
            ToolPalette2IDLComms.executeString(command);
        }
    }

    protected class CreateNewVisButtonRunnable
    implements Runnable {
        String m_plotID;
        String m_plotTitle;
        ImageData m_imageData;

        public CreateNewVisButtonRunnable(String plotID, String plotTitle, ImageData imageData) {
            this.m_plotID = plotID;
            this.m_plotTitle = plotTitle;
            this.m_imageData = imageData;
        }

        public void run() {
            if (ExistingVisView.this.m_instance != null) {
                ExistingVisView.this.m_instance.addVisToExistingVisComposite(this.m_plotID, this.m_plotTitle, this.m_imageData);
            }
        }
    }

    protected class RemoveVisButtonRunnable
    implements Runnable {
        String m_plotID;

        public RemoveVisButtonRunnable(String plotID) {
            this.m_plotID = plotID;
        }

        public void run() {
            if (ExistingVisView.this.m_instance != null) {
                ExistingVisView.this.m_instance.removeExistingVisToolButton(this.m_plotID);
            }
        }
    }

    protected class SetCurrentToolRunnable
    implements Runnable {
        VisToolControl m_vtc;

        public SetCurrentToolRunnable(VisToolControl vtc) {
            this.m_vtc = vtc;
        }

        public void run() {
            ExistingVisView.this.setCurrentTool(this.m_vtc);
        }
    }
}

