/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.LabelUtils;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.views.ToolPaletteView;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class VisToolEditDialog
extends Dialog {
    protected static final String HELP_ID = "com.rsi.idldt.toolpalette.tool_edit_dialog_help";
    public final int MASK_TOOL_NAME = 0;
    public final int MASK_TOOL_ICON = 1;
    public final String MSG_NORMAL_TEXT = Messages.VisToolEditDialog_DefineToolData;
    public final String MSG_INVALID_DATA_TEXT = Messages.VisToolEditDialog_InvalidData;
    public final String MSG_REQUIRED_DATA_TEXT = Messages.VisToolEditDialog_RequiredData;
    protected final String DEFAULT_ICON_FILENAME = Messages.VisToolEditDialog_DefaultIcon;
    protected Image m_errorIcon = null;
    protected Image m_titleImage = null;
    protected boolean m_isForNewTool = false;
    Composite m_titleAreaComposite;
    protected static String m_filterPath = System.getProperty("user.home");
    protected static String m_fileSep = System.getProperty("file.separator");
    protected String m_appFolderImagesName = String.valueOf(ToolPalette2IDLComms.getAppUserDirectory()) + m_fileSep + "images";
    protected BitSet m_validator = new BitSet(2);
    protected BitSet m_receivedData = new BitSet(2);
    static final String CD_FIELD_NAME = "fieldName";
    static final String TOOL_NAME = "toolName";
    static final String TOOL_VERSION = "toolVersion";
    static final String TOOL_ICON = "toolIcon";
    protected String m_dialogTitle;
    protected Label m_messageLabel;
    protected Label m_messageImageLabel;
    protected Text m_toolNameText;
    protected Label m_toolNameLabel;
    protected Text m_toolIconText;
    protected Label m_toolIconLabel;
    protected Button m_okButton;
    protected IDLVisTool m_visTool;
    private String m_toolNameValue;
    private String m_iconFileValue;
    private Label m_iconCanvas;
    private String m_additionalErrorNote = "";
    private Shell m_parentShell;

    public VisToolEditDialog(Shell parentShell, String dialogTitle, IDLVisTool visTool, boolean bEditingNewTool) {
        super(parentShell);
        this.m_parentShell = parentShell;
        this.m_dialogTitle = dialogTitle;
        this.m_visTool = visTool;
        this.m_isForNewTool = bEditingNewTool;
        if (bEditingNewTool) {
            this.m_validator.set(0, 2, true);
            this.m_receivedData.set(0, 2, true);
            this.m_validator.set(1, false);
            this.m_receivedData.set(1, false);
        }
    }

    protected void disposeImages() {
        if (this.m_errorIcon != null) {
            this.m_errorIcon.dispose();
        }
        if (this.m_titleImage != null) {
            this.m_titleImage.dispose();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_dialogTitle != null) {
            shell.setText(this.m_dialogTitle);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VisToolEditDialog.this.disposeImages();
            }
        });
    }

    protected void removeErrNote(String errNote) {
        String newNote;
        int idx = this.m_additionalErrorNote.indexOf(errNote);
        if (idx == -1) {
            return;
        }
        if (idx > 0) {
            newNote = this.m_additionalErrorNote.substring(0, idx);
            newNote = String.valueOf(newNote) + this.m_additionalErrorNote.substring(idx + errNote.length());
        } else {
            newNote = this.m_additionalErrorNote.substring(idx + errNote.length());
        }
        this.m_additionalErrorNote = newNote;
    }

    protected boolean validToolName(String tool_name) {
        String addErrNote = "\n" + Messages.VisToolEditDialog_ToolNameBeingUsedChooseAnother;
        this.removeErrNote(addErrNote);
        char[] chars = tool_name.toCharArray();
        if (chars == null || chars.length == 0) {
            return false;
        }
        boolean valid = false;
        if (this.m_visTool != null) {
            valid = tool_name.equalsIgnoreCase(this.m_visTool.getToolName());
        }
        if (!valid && ToolPaletteView.getInstance().isToolNameBeingUsed(tool_name)) {
            this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + addErrNote;
            valid = false;
        } else {
            valid = true;
        }
        return valid;
    }

    protected boolean validIDLVariableName(String var) {
        char[] chars = var.toCharArray();
        if (chars == null || chars.length == 0) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            boolean valid;
            char c = chars[i];
            if (i == 0) {
                valid = Character.isLetter(c) || c == '_';
            } else {
                boolean bl = valid = Character.isLetter(c) || Character.isDigit(c) || c == '$' || c == '_';
            }
            if (!valid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validToolVersion(String version) {
        boolean valid = true;
        try {
            Float.parseFloat(version);
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        return valid;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validToolIconFilename(String fname) {
        block10: {
            block9: {
                errNote2 = "\n" + Messages.VisToolEditDialog_UnableToReadImageFile;
                this.removeErrNote(errNote2);
                errNote3 = "\n" + Messages.VisToolEditDialog_NotValidImageFile;
                this.removeErrNote(errNote3);
                valid = true;
                if (fname == null || fname.trim().length() == 0) {
                    this.m_iconCanvas.setImage(IDLVisTool.getDefaultImage());
                    return true;
                }
                if (fname.equalsIgnoreCase(this.DEFAULT_ICON_FILENAME)) {
                    return true;
                }
                display = this.m_parentShell.getDisplay();
                busyCursor = new Cursor((Device)display, 1);
                this.m_parentShell.setCursor(busyCursor);
                file = new File(fname);
                valid = file.canRead();
                if (!valid) ** GOTO lbl31
                image = ImageIO.read(file);
                if (image != null) break block9;
                this.m_parentShell.setCursor(null);
                busyCursor.dispose();
                busyCursor = null;
                return false;
            }
            try {
                try {
                    imgHeight = image.getHeight();
                    imgWidth = image.getWidth();
                    valid = imgHeight != 32 && imgWidth != 32 ? this.resizeSelectedIconFileAction(image) : this.copyImageWithCorrectDimsToAppsImagesDir(fname);
                    break block10;
lbl31:
                    // 1 sources

                    this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + errNote2;
                }
                catch (Exception v0) {
                    valid = false;
                    this.m_additionalErrorNote = String.valueOf(this.m_additionalErrorNote) + errNote3;
                    this.m_parentShell.setCursor(null);
                    busyCursor.dispose();
                    busyCursor = null;
                }
            }
            catch (Throwable var11_11) {
                this.m_parentShell.setCursor(null);
                busyCursor.dispose();
                busyCursor = null;
                throw var11_11;
            }
        }
        this.m_parentShell.setCursor(null);
        busyCursor.dispose();
        busyCursor = null;
        if (valid) {
            image = this.getToolImage();
            this.m_iconCanvas.setImage(image);
        } else {
            this.m_iconCanvas.setImage(IDLVisTool.getDefaultImage());
        }
        return valid;
    }

    protected boolean copyImageWithCorrectDimsToAppsImagesDir(String srcName) {
        String targetName = "";
        boolean bSuccess = false;
        try {
            if (!this.ensureExistenceOfAppDirImagesFolder()) {
                return false;
            }
            try {
                String baseFname = null;
                File f = new File(srcName);
                baseFname = f.getName();
                targetName = String.valueOf(this.m_appFolderImagesName) + m_fileSep + baseFname;
                bSuccess = this.copyFileToFolder(srcName, this.m_appFolderImagesName);
            }
            catch (Exception exception) {}
        }
        finally {
            if (bSuccess) {
                this.setIconTextBypassingModifyListener(targetName);
                int pos = targetName.length();
                this.m_toolIconText.setSelection(pos, pos);
            }
        }
        return bSuccess;
    }

    private boolean copyFileToFolder(String iconFilename, String strImageFolder) throws IOException {
        File dst;
        File src;
        String outFname;
        block8: {
            block7: {
                block6: {
                    outFname = "";
                    if (iconFilename != null) break block6;
                    return false;
                }
                src = new File(iconFilename);
                outFname = String.valueOf(strImageFolder) + m_fileSep + src.getName();
                dst = new File(outFname);
                if (src.compareTo(dst) != 0) break block7;
                return true;
            }
            if (!this.fileExists(outFname)) break block8;
            String title = Messages.VisToolEditDialog_ConfirmationToOverwrite;
            String message = String.valueOf(Messages.VisToolEditDialog_OkayToOverwrite) + outFname;
            boolean ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
            if (ok) break block8;
            return false;
        }
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.VisToolEditDialog_Error, (String)(String.valueOf(Messages.VisToolEditDialog_UnableToCreateFile) + outFname));
            return false;
        }
        return true;
    }

    protected Image getToolImage() {
        String fname = this.m_toolIconText.getText().trim();
        Image image = null;
        try {
            URL url = new URL("file:" + fname);
            image = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (MalformedURLException malformedURLException) {}
        return image;
    }

    protected void validateInput(Text text) {
        String fieldName = (String)text.getData(CD_FIELD_NAME);
        if (fieldName.equalsIgnoreCase(TOOL_NAME)) {
            String value = text.getText().trim();
            this.m_validator.set(0, !this.validToolName(value));
            this.m_receivedData.set(0, false);
        } else if (fieldName.equalsIgnoreCase(TOOL_ICON)) {
            String value = text.getText().trim();
            this.m_validator.set(1, !this.validToolIconFilename(value));
            this.m_receivedData.set(1, false);
        }
        this.setOkayButtonEnablement();
    }

    protected Image getErrorIcon() {
        if (this.m_errorIcon == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/stop.png"), null);
            this.m_errorIcon = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_errorIcon;
    }

    protected void updateMessage(boolean bAllGood) {
        this.m_messageLabel.setForeground(this.m_messageLabel.getDisplay().getSystemColor(2));
        if (bAllGood) {
            this.m_messageLabel.setText(this.MSG_NORMAL_TEXT);
            this.m_messageImageLabel.setImage(null);
        } else {
            if (this.m_isForNewTool && !this.m_receivedData.isEmpty()) {
                this.m_messageLabel.setText(this.MSG_REQUIRED_DATA_TEXT);
                this.m_messageImageLabel.setImage(null);
                this.m_messageLabel.setForeground(this.m_messageLabel.getDisplay().getSystemColor(3));
            } else {
                if (this.m_additionalErrorNote.length() != 0) {
                    this.m_messageLabel.setText(String.valueOf(this.MSG_INVALID_DATA_TEXT) + this.m_additionalErrorNote);
                } else {
                    this.m_messageLabel.setText(this.MSG_INVALID_DATA_TEXT);
                }
                this.m_messageImageLabel.setImage(this.getErrorIcon());
            }
            this.m_messageLabel.getParent().getParent().getParent().layout(true);
        }
        for (Composite parent = this.m_messageImageLabel.getParent(); parent != null; parent = parent.getParent()) {
            parent.layout(true);
            parent.pack();
            if (parent != this.m_titleAreaComposite) continue;
            parent.layout(true);
            parent.getShell().pack();
            break;
        }
    }

    protected void setOkayButtonEnablement() {
        Color normal = this.m_toolNameLabel.getDisplay().getSystemColor(2);
        Color red = this.m_toolNameLabel.getDisplay().getSystemColor(3);
        this.m_toolNameLabel.setForeground(normal);
        this.m_toolIconLabel.setForeground(normal);
        if (this.m_okButton == null || this.m_okButton.isDisposed()) {
            return;
        }
        if (this.m_validator.isEmpty()) {
            this.m_okButton.setEnabled(true);
            this.updateMessage(true);
        } else {
            this.m_okButton.setEnabled(false);
            this.updateMessage(false);
            if (this.m_validator.get(0)) {
                this.m_toolNameLabel.setForeground(red);
            }
            if (this.m_validator.get(1)) {
                this.m_toolIconLabel.setForeground(red);
            }
        }
    }

    protected void addValidateModifier(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VisToolEditDialog.this.validateInput((Text)e.widget);
            }
        });
    }

    protected void createTitleArea(Composite parent) {
        this.m_titleAreaComposite = new Composite(parent, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false, 3, 1);
        this.m_titleAreaComposite.setLayoutData((Object)gd);
        this.m_titleAreaComposite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_titleAreaComposite.setLayout((Layout)gl);
        this.m_titleAreaComposite.setBackgroundMode(2);
        Composite c = new Composite(this.m_titleAreaComposite, 0);
        c.setBackgroundMode(2);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        Label l = new Label(c, 0);
        l.setText(this.m_dialogTitle);
        LabelUtils.makeLabelBold(l);
        LabelUtils.makeLabelHeightChange(l, 2);
        gd = new GridData();
        gd.horizontalIndent = 10;
        gd.verticalIndent = 3;
        l.setLayoutData((Object)gd);
        Composite msgComposite = new Composite(c, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        msgComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.verticalIndent = 5;
        msgComposite.setLayoutData((Object)gd);
        this.m_messageImageLabel = new Label(msgComposite, 0);
        this.m_messageImageLabel.setImage(null);
        this.m_messageLabel = new Label(msgComposite, 0);
        l = new Label(this.m_titleAreaComposite, 0);
        URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/invocation_bar.gif"), null);
        this.m_titleImage = ImageDescriptor.createFromURL((URL)url).createImage();
        l.setImage(this.m_titleImage);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 2));
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite3Col = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        mainComposite3Col.setLayout((Layout)gl);
        mainComposite3Col.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(mainComposite3Col);
        this.m_iconCanvas = new Label(mainComposite3Col, 0);
        this.m_iconCanvas.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 3));
        this.m_iconCanvas.setImage(IDLVisTool.getDefaultImage());
        Composite dataArea = new Composite(mainComposite3Col, 0);
        dataArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        gl = new GridLayout(3, false);
        dataArea.setLayout((Layout)gl);
        this.m_toolNameLabel = new Label(dataArea, 0);
        this.m_toolNameLabel.setText(Messages.VisToolEditDialog_ToolName);
        this.m_toolNameText = new Text(dataArea, 2048);
        this.m_toolNameText.setTextLimit(20);
        this.addValidateModifier(this.m_toolNameText);
        this.m_toolNameText.setData(CD_FIELD_NAME, (Object)TOOL_NAME);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.m_toolNameText.setLayoutData((Object)gd);
        this.m_toolIconLabel = new Label(dataArea, 0);
        this.m_toolIconLabel.setText(Messages.VisToolEditDialog_IconFilename);
        this.m_toolIconText = new Text(dataArea, 2048);
        this.addValidateModifier(this.m_toolIconText);
        this.m_toolIconText.setData(CD_FIELD_NAME, (Object)TOOL_ICON);
        this.m_toolIconText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button browseButton = new Button(dataArea, 8);
        browseButton.setText(Messages.VisToolEditDialog_Browse);
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                VisToolEditDialog.this.browseButtonSelected();
            }
        };
        browseButton.addListener(13, l);
        if (!this.m_isForNewTool) {
            this.m_toolNameText.setText(this.m_visTool.getToolName());
            String iconText = this.m_visTool.getIconFilename();
            if (iconText != null && iconText.trim().length() > 0) {
                this.m_toolIconText.setText(this.m_visTool.getIconFilename());
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite3Col, HELP_ID);
        VisToolEditDialog.applyDialogFont((Control)mainComposite3Col);
        this.setOkayButtonEnablement();
        return mainComposite3Col;
    }

    protected boolean resizeSelectedIconFileAction(BufferedImage image) {
        BufferedImage nbi;
        String newFname;
        block6: {
            int actualHeight;
            String fname = this.m_toolIconText.getText().trim();
            newFname = this.createResizedIconFilename(fname);
            if (newFname == null) {
                return false;
            }
            int actualWidth = image.getWidth();
            int biggestDim = actualWidth > (actualHeight = image.getHeight()) ? actualWidth : actualHeight;
            float ratio = 32.0f / (float)biggestDim;
            int resultWidth = (int)((float)actualWidth * ratio);
            int resultHeight = (int)((float)actualHeight * ratio);
            nbi = new BufferedImage(32, 32, 2);
            Graphics2D g2 = nbi.createGraphics();
            int dest_xorg = 0;
            int dest_yorg = 0;
            if (resultWidth < 32) {
                dest_xorg = (int)((32.0 - (double)resultWidth) / 2.0);
            }
            if (resultHeight < 32) {
                dest_yorg = (int)((32.0 - (double)resultHeight) / 2.0);
            }
            g2.drawImage(image, dest_xorg, dest_yorg, dest_xorg + resultWidth, dest_yorg + resultHeight, 0, 0, actualWidth, actualHeight, null);
            try {
                if (!this.fileExists(newFname)) break block6;
                String title = Messages.VisToolEditDialog_ConfirmationToOverwrite;
                String message = String.valueOf(Messages.VisToolEditDialog_OkayToOverwrite) + newFname;
                boolean ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
                if (ok) break block6;
                return false;
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.VisToolEditDialog_Error, (String)(String.valueOf(Messages.VisToolEditDialog_UnableToCreateFile) + newFname));
                return false;
            }
        }
        File outFile = new File(newFname);
        ImageIO.write((RenderedImage)nbi, "png", outFile);
        this.setIconTextBypassingModifyListener(newFname);
        int pos = newFname.length();
        this.m_toolIconText.setSelection(pos, pos);
        return true;
    }

    protected boolean ensureExistenceOfAppDirImagesFolder() {
        File appFolderImages = new File(this.m_appFolderImagesName);
        try {
            if (!appFolderImages.exists() && !appFolderImages.mkdirs()) {
                String msg = String.valueOf(Messages.VisPaletteImportOperation_UnableToCreate) + appFolderImages.getCanonicalPath();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.VisToolEditDialog_Error, (String)msg);
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void setIconTextBypassingModifyListener(String text) {
        Listener l;
        Listener[] list;
        Listener[] listenerArray = list = this.m_toolIconText.getListeners(24);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.m_toolIconText.removeListener(24, l);
            ++n2;
        }
        this.m_toolIconText.setText(text);
        listenerArray = list;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.m_toolIconText.addListener(24, l);
            ++n2;
        }
    }

    private String createResizedIconFilename(String fname) {
        File f = new File(fname);
        String newFname = f.getName();
        int endIndex = newFname.lastIndexOf(46);
        newFname = String.valueOf(newFname.substring(0, endIndex)) + "_32.png";
        if (!this.ensureExistenceOfAppDirImagesFolder()) {
            return null;
        }
        return String.valueOf(this.m_appFolderImagesName) + m_fileSep + newFname;
    }

    private boolean fileExists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    protected void browseButtonSelected() {
        String fileSep = System.getProperty("file.separator");
        String[] filterExtensions = new String[2];
        String[] filterNames = new String[2];
        filterExtensions[0] = "*.bmp;*.jpg;*.gif;*.png";
        filterNames[0] = "Image (*.bmp;*.jpg;*.gif;*.png)";
        filterExtensions[1] = "*.*";
        filterNames[1] = "All Files (*.*)";
        FileDialog dialog = new FileDialog(this.getShell(), 4100);
        dialog.setText(Messages.VisToolEditDialog_OpenImageIconForTool);
        dialog.setFilterPath(m_filterPath);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterNames(filterNames);
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null && names.length > 0) {
            m_filterPath = dialog.getFilterPath();
            if (!m_filterPath.endsWith(fileSep)) {
                m_filterPath = String.valueOf(m_filterPath) + fileSep;
            }
            this.m_toolIconText.setText(String.valueOf(m_filterPath) + names[0]);
            int pos = this.m_toolIconText.getText().length();
            this.m_toolIconText.setSelection(pos, pos > 0 ? pos - 1 : 0);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public IDLVisTool getNewVisTool() {
        IDLVisTool newTool = new IDLVisTool(this.m_toolNameValue, 1, this.m_iconFileValue);
        return newTool;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.m_iconFileValue = this.m_toolIconText.getText().trim();
        if (this.m_iconFileValue.length() == 0 || this.m_iconFileValue.equalsIgnoreCase(this.DEFAULT_ICON_FILENAME)) {
            this.m_iconFileValue = null;
        }
        this.m_toolNameValue = this.m_toolNameText.getText().trim();
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setOkayButtonEnablement();
    }

    protected Control createButtonBar(Composite parent) {
        Composite compTop = new Composite(parent, 0);
        compTop.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compTop.setLayout((Layout)layout);
        compTop.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            this.createHelpImageButton(compTop, helpImage);
        }
        Composite composite = new Composite(compTop, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        toolBar.setLayoutData((Object)new GridData(32));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisToolEditDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    void helpPressed() {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }
}

