/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.internal.ui.VisToolEditDialog;
import com.rsi.idldt.toolpalette.views.ToolPaletteView;
import com.rsi.jdml.PlatformSupport;
import java.util.ArrayList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class VisToolControl
extends Composite
implements PaintListener {
    protected static final int MIN_CHARS = 16;
    Button m_toolButton;
    ToolItem m_dragToolItem;
    int m_showIndex;
    IDLVisTool m_visTool;
    private boolean m_paintTargetInsertionMarker = false;
    private boolean m_paintRearrangeSourceFocusRing = false;
    private Point m_insertionMarkerPoint = null;
    private int m_forceMarkerLocation = 0;
    private boolean m_insertAbove = true;
    private ArrayList<SelectionListener> m_selectionListeners = new ArrayList();
    private boolean m_showSelectionInPaint = false;
    private boolean m_selected;
    private static int m_ourMinWidth = 87;

    public VisToolControl(IDLVisTool visTool, boolean bEditMode, int showIndex, Composite parent, int style) {
        super(parent, style);
        this.m_visTool = visTool;
        this.m_showIndex = showIndex;
        this.createControl(visTool, bEditMode);
        if (bEditMode) {
            this.addPaintListener(this);
        }
    }

    public VisToolControl(String plotTitle, String plotID, Image image, Composite parent, int style) {
        super(parent, style);
        this.createControl(plotTitle, plotID, image);
        this.addPaintListener(this);
    }

    public void setShowIndex(int showIndex) {
        this.m_showIndex = showIndex;
    }

    public int getShowIndex() {
        return this.m_showIndex;
    }

    public Button getToolButton() {
        return this.m_toolButton;
    }

    public ToolItem getDragToolItem() {
        return this.m_dragToolItem;
    }

    public boolean isInsertAbove() {
        return this.m_insertAbove;
    }

    public void highlightAsRearrangeTarget(boolean bHighlight, Point displayPoint, int force) {
        Point controlPoint = this.toControl(displayPoint);
        this.m_paintTargetInsertionMarker = bHighlight;
        this.m_insertionMarkerPoint = controlPoint;
        this.m_forceMarkerLocation = force;
        this.redraw();
    }

    public void highlightAsRearrangeSource(boolean bHighlight) {
        this.m_paintRearrangeSourceFocusRing = bHighlight;
        this.redraw();
    }

    protected void createControl(IDLVisTool visTool, boolean bEditMode) {
        this.setBackgroundMode(2);
        GridLayout layout = bEditMode ? new GridLayout(3, false) : new GridLayout(1, false);
        this.setupControlFont();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        if (bEditMode) {
            Link editLink;
            if (!this.m_visTool.isSystemDefined()) {
                editLink = new Link((Composite)this, 0);
                editLink.setText("<a>" + Messages.VisToolControl_Edit + "</a>");
                editLink.setToolTipText(Messages.VisToolControl_EditThisTool);
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        VisToolControl.this.showVisToolEditDialog();
                    }
                };
                editLink.addListener(13, listener);
            } else {
                editLink = new Link((Composite)this, 0);
                editLink.setText("      ");
                editLink.setEnabled(false);
            }
        }
        this.m_toolButton = new Button((Composite)this, 0x800000);
        this.m_toolButton.setImage(visTool.getLargeImage());
        this.m_toolButton.setToolTipText(String.valueOf(Messages.VisToolControl_Show) + visTool.getToolName() + " " + Messages.VisToolControl_ActionBars + "\n" + Messages.VisToolControl_DropVariablesOrFilenames);
        GridData gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        this.m_toolButton.setLayoutData((Object)gd);
        this.m_toolButton.setData("visTool", (Object)this.m_visTool);
        if (bEditMode) {
            ToolBar toolBar = new ToolBar((Composite)this, 0x800200);
            toolBar.setData("visTool", (Object)this.m_visTool);
            gd = new GridData(131072, 1024, true, true, 1, 1);
            toolBar.setLayoutData((Object)gd);
            ToolItem closeToolItem = new ToolItem(toolBar, 0x800000);
            closeToolItem.setData("visTool", (Object)visTool);
            closeToolItem.setImage(ToolPaletteView.getInstance().getCloseImage());
            closeToolItem.setToolTipText(String.valueOf(Messages.VisToolControl_Remove) + this.m_visTool.getToolName());
            Listener closeListener = new Listener(){

                public void handleEvent(Event event) {
                    ToolPaletteView.getInstance().hideToolAtIndex(VisToolControl.this.m_showIndex);
                    ToolPaletteView.getInstance().setVisToolsDirty(true);
                    ToolPaletteView.getInstance().redrawToolPalette();
                }
            };
            closeToolItem.addListener(13, closeListener);
            this.m_dragToolItem = new ToolItem(toolBar, 0x800000);
            this.m_dragToolItem.setData("visTool", (Object)visTool);
            this.m_dragToolItem.setImage(ToolPaletteView.getInstance().getReorderImage());
            this.m_dragToolItem.setToolTipText(String.valueOf(Messages.VisToolControl_DragToRelocate) + this.m_visTool.getToolName());
        }
        Label lbl = new Label((Composite)this, 0x1000000);
        String toolName = visTool.getToolName();
        String dupedAmps = ToolPaletteView.getInstance().duplicateAmpersands(toolName);
        lbl.setText(dupedAmps);
        gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        if (bEditMode) {
            gd.horizontalSpan = 3;
        }
        lbl.setLayoutData((Object)gd);
        lbl.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Label l = (Label)e.widget;
                Composite c = l.getParent().getParent();
                c.setFocus();
            }

            public void mouseDown(MouseEvent e) {
                Label l = (Label)e.widget;
                Composite c = l.getParent().getParent();
                c.setFocus();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void showVisToolEditDialog() {
        VisToolEditDialog dlg = new VisToolEditDialog(Display.getCurrent().getActiveShell(), Messages.VisToolControl_EditExistingTool, this.m_visTool, false);
        if (dlg.open() == 0) {
            IDLVisTool updated_vt = dlg.getNewVisTool();
            ToolPaletteView.getInstance().updateVisTool(this.m_visTool, updated_vt);
        }
    }

    protected void createControl(String plotTitle, String plotID, Image image) {
        this.setBackgroundMode(2);
        this.m_showSelectionInPaint = true;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setupControlFont();
        this.m_toolButton = new Button((Composite)this, 0x800000);
        this.m_toolButton.setImage(image);
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(Messages.VisToolControl_Title) + plotTitle + "\n");
        sb.append("ID: " + plotID);
        this.m_toolButton.setToolTipText(sb.toString());
        GridData gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        this.m_toolButton.setLayoutData((Object)gd);
        this.m_toolButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                VisToolControl.this.toolSelected(event);
            }
        });
        Label lbl = new Label((Composite)this, 0x1000000);
        lbl.setText(this.trimPlotTitle(plotTitle));
        gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        lbl.setLayoutData((Object)gd);
        lbl.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Label l = (Label)e.widget;
                Composite c = l.getParent().getParent();
                c.setFocus();
            }

            public void mouseDown(MouseEvent e) {
                Label l = (Label)e.widget;
                Composite c = l.getParent().getParent();
                c.setFocus();
            }

            public void mouseUp(MouseEvent e) {
                Event evt = new Event();
                evt.widget = e.widget;
                evt.button = e.button;
                evt.count = e.count;
                evt.display = e.display;
                VisToolControl.this.toolSelected(evt);
            }
        });
    }

    private void setupControlFont() {
        Font font = this.getFont();
        FontData[] fontdata = font.getFontData();
        String fontname = fontdata[0].getName();
        int fontheight = fontdata[0].getHeight();
        if (PlatformSupport.isLinux() && fontheight > 8) {
            fontheight = 8;
        }
        if (PlatformSupport.isMac() && fontheight > 10) {
            fontheight = 10;
        }
        int style = fontdata[0].getStyle();
        Font newfont = new Font((Device)this.getDisplay(), fontname, fontheight, style);
        this.setFont(newfont);
        this.setControlMinWidth(newfont);
    }

    private void setControlMinWidth(Font newfont) {
        GC gc = new GC((Drawable)this.getDisplay());
        gc.setFont(newfont);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 16) {
            sb.append("n");
            ++i;
        }
        Point size = this.getTextExtent(gc, sb.toString());
        m_ourMinWidth = size.x;
        gc.dispose();
    }

    private int getMaxNumChars(String cleanTitle) {
        GC gc = new GC((Drawable)this.getDisplay());
        gc.setFont(this.getFont());
        StringBuilder sb = new StringBuilder();
        sb.append(cleanTitle.charAt(0));
        Point size = this.getTextExtent(gc, sb.toString());
        int numChars = cleanTitle.length();
        int j = 0;
        while (size.x < m_ourMinWidth && j + 1 <= numChars - 1) {
            sb.append(cleanTitle.charAt(++j));
            size = this.getTextExtent(gc, sb.toString());
        }
        size = this.getTextExtent(gc, sb.toString());
        if (size.x > m_ourMinWidth) {
            --j;
        }
        gc.dispose();
        if (!PlatformSupport.isWindows()) {
            j = Math.max(0, j - 4);
        }
        return j;
    }

    private Point getTextExtent(GC gc, String val) {
        Point p = gc.textExtent(val);
        if (PlatformSupport.isMac()) {
            p.x += 2;
        }
        return p;
    }

    public void paintControl(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        GC gc = e.gc;
        if (this.m_paintTargetInsertionMarker && this.m_insertionMarkerPoint != null) {
            gc.setForeground(this.getDisplay().getSystemColor(3));
            this.m_insertAbove = this.m_forceMarkerLocation == 128 ? true : (this.m_forceMarkerLocation == 1024 ? false : this.m_insertionMarkerPoint.y <= rect.y + rect.height / 2);
            int x1 = rect.x;
            int y1 = this.m_insertAbove ? rect.y + 2 : rect.y + rect.height - 1;
            int x2 = x1 + rect.width;
            int y2 = y1;
            gc.drawLine(x1, y1, x2, y2);
            gc.drawLine(x1, --y1, x2, --y2);
        } else if (this.m_paintRearrangeSourceFocusRing || this.m_showSelectionInPaint && this.m_selected) {
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
    }

    protected String trimPlotTitle(String plotTitle) {
        String cleanTitle = plotTitle.replaceAll("\\\\", "/");
        String[] parts = cleanTitle.split("/");
        if (parts.length > 1) {
            cleanTitle = parts[parts.length - 1];
        }
        int maxChars = this.getMaxNumChars(cleanTitle);
        if (cleanTitle.length() > maxChars) {
            cleanTitle = String.valueOf(cleanTitle.substring(0, maxChars - 2)) + "...";
        }
        return cleanTitle;
    }

    public Image getImage() {
        return this.m_toolButton.getImage();
    }

    public void setImage(Image image) {
        this.m_toolButton.setImage(image);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.m_selectionListeners.add(selectionListener);
    }

    protected void toolSelected(Event e) {
        e.widget = this;
        for (SelectionListener l : this.m_selectionListeners) {
            SelectionEvent se = new SelectionEvent(e);
            l.widgetSelected(se);
        }
    }

    public void setSelected(boolean value) {
        if (this.isDisposed()) {
            return;
        }
        this.m_selected = value;
        if (this.m_showSelectionInPaint) {
            this.redraw();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint == -1) {
            return super.computeSize(m_ourMinWidth, hHint, changed);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public Point computeSize(int wHint, int hHint) {
        if (wHint == -1) {
            return super.computeSize(m_ourMinWidth, hHint);
        }
        return super.computeSize(wHint, hHint);
    }

    public static int getMinWidth() {
        return m_ourMinWidth;
    }
}

