/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.ToolCatalogParser;
import com.rsi.idldt.toolpalette.ToolPalette2IDLComms;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.views.ToolPaletteView;
import com.rsi.idldt.ui.ArchiveUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class VisPaletteImportOperation
implements IRunnableWithProgress {
    private ToolPaletteView m_visPaletteView;
    private String m_importFilename;
    String m_fileSep = System.getProperty("file.separator");
    private File m_workFolder;
    private ArrayList<Status> m_errorTable = new ArrayList(1);

    public VisPaletteImportOperation(ToolPaletteView visPaletteView, String importFilename) {
        this.m_visPaletteView = visPaletteView;
        this.m_importFilename = importFilename;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int nStepsToImport = 3;
        monitor.beginTask(Messages.VisPaletteImportOperation_ImportingToolPaletteItems, nStepsToImport);
        try {
            try {
                this.checkCancelled(monitor);
                this.m_workFolder = this.createTempFolder();
                ArchiveUtils.extractJarResourcesIntoDirectory((String)this.m_workFolder.getCanonicalPath(), (String)this.m_importFilename);
                monitor.worked(1);
                this.checkCancelled(monitor);
                this.copyImagesToAppDir();
                monitor.worked(1);
                this.checkCancelled(monitor);
                String xmlCatalogFilename = this.m_workFolder + this.m_fileSep + "export_catalog.xml";
                ToolCatalogParser.getInstance().importFromFile(this.m_visPaletteView.getVisTools(), this.m_visPaletteView.getVisToolShowOrder(), xmlCatalogFilename);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ToolPaletteView.getInstance().clearVisTools();
                        ToolPaletteView.getInstance().redrawToolPalette();
                    }
                });
                monitor.worked(1);
            }
            catch (Exception e) {
                this.addError(Messages.VisPaletteImportOperation_ErrorImportingActions, e);
                this.removeTempFolder(this.m_workFolder);
                monitor.done();
            }
        }
        finally {
            this.removeTempFolder(this.m_workFolder);
            monitor.done();
        }
    }

    private void copyImagesToAppDir() {
        String tmpFolderImagesName = this.m_workFolder + this.m_fileSep + "images";
        String appFolderImagesName = String.valueOf(ToolPalette2IDLComms.getAppUserDirectory()) + this.m_fileSep + "images";
        File tmpFolderImages = new File(tmpFolderImagesName);
        File appFolderImages = new File(appFolderImagesName);
        try {
            if (!appFolderImages.exists() && !appFolderImages.mkdirs()) {
                this.addError(String.valueOf(Messages.VisPaletteImportOperation_UnableToCreate) + appFolderImages.getCanonicalPath(), null);
                return;
            }
            String[] files = tmpFolderImages.list();
            if (files == null) {
                return;
            }
            int numberFiles = files.length;
            int i = 0;
            while (i < numberFiles) {
                String currentFile = String.valueOf(tmpFolderImages.getPath()) + this.m_fileSep + files[i];
                this.copyFileToFolder(currentFile, appFolderImagesName);
                ++i;
            }
        }
        catch (IOException e) {
            this.addError(Messages.VisPaletteImportOperation_ImportError, e);
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.m_errorTable.size()];
        this.m_errorTable.toArray(errors);
        return new MultiStatus("com.rsi.idldt.toolpalette", 0, errors, Messages.VisPaletteImportOperation_ProblemsImportingToolPalette, null);
    }

    protected void addError(String message, Throwable e) {
        this.m_errorTable.add(new Status(4, "com.rsi.idldt.toolpalette", 0, message, e));
    }

    private File createTempFolder() throws Exception {
        String appDir = ToolPalette2IDLComms.getAppUserDirectory();
        File tempFolder = null;
        boolean bDone = false;
        int n = 0;
        while (!bDone) {
            String tmpFolderName = String.valueOf(appDir) + this.m_fileSep + ".vis_tmp_" + n++;
            tempFolder = new File(tmpFolderName);
            if (tempFolder.exists()) continue;
            if (!tempFolder.mkdir()) {
                this.addError(String.valueOf(Messages.VisPaletteImportOperation_UnableToCreate) + tmpFolderName, null);
                throw new Exception();
            }
            bDone = true;
        }
        return tempFolder;
    }

    private void removeTempFolder(File tempFolder) {
        if (tempFolder == null) {
            return;
        }
        try {
            this.deleteDirectory(tempFolder);
        }
        catch (IOException e) {
            this.addError(e.getLocalizedMessage(), e);
        }
    }

    protected boolean deleteDirectory(File directoryToDelete) throws IOException {
        if (directoryToDelete.isDirectory()) {
            String[] filesAndDirs = directoryToDelete.list();
            int numberFiles = filesAndDirs.length;
            int i = 0;
            while (i < numberFiles) {
                File currentFile = new File(String.valueOf(directoryToDelete.getPath()) + this.m_fileSep + filesAndDirs[i]);
                if (currentFile.isDirectory()) {
                    if (!this.deleteDirectory(currentFile)) {
                        return false;
                    }
                } else if (!currentFile.delete()) {
                    throw new IOException(String.valueOf(Messages.VisPaletteImportOperation_CantDeleteFileOrDirectory) + currentFile.getAbsolutePath());
                }
                ++i;
            }
            return directoryToDelete.delete();
        }
        throw new IOException(String.valueOf(Messages.VisPaletteImportOperation_CouldntDeleteDirectoryBecause) + directoryToDelete.getAbsolutePath());
    }

    private void checkCancelled(IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            this.addError(Messages.VisPaletteImportOperation_ImportWasCancelled, null);
            throw new Exception();
        }
    }

    private void copyFileToFolder(String iconFilename, String strImageFolder) throws IOException {
        try {
            int len;
            if (iconFilename == null) {
                return;
            }
            File src = new File(iconFilename);
            File dst = new File(String.valueOf(strImageFolder) + this.m_fileSep + src.getName());
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            this.addError(e.getLocalizedMessage(), e);
            throw e;
        }
        catch (IOException e) {
            this.addError(e.getLocalizedMessage(), e);
            throw e;
        }
    }
}

