/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolCatalogParser;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.ui.ArchiveUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPaletteExportOperation
implements IRunnableWithProgress {
    public static final String EXPORT_CATALOG_XML = "export_catalog.xml";
    protected static final String IMAGES = "images";
    Vector<IDLVisTool> m_visTools;
    String m_exportFilename;
    private ArrayList<Status> m_errorTable = new ArrayList(1);
    protected File m_workFolder;
    String m_fileSep = System.getProperty("file.separator");

    public ToolPaletteExportOperation(Vector<IDLVisTool> visTools, String exportFilename) {
        this.m_visTools = visTools;
        this.m_exportFilename = exportFilename;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int nStepsToExport = 4;
        monitor.beginTask(Messages.VisPaletteExportOperation_ExportingToolPaletteItems, nStepsToExport);
        try {
            try {
                this.m_workFolder = this.createTempFolder(monitor);
                this.copyIconsToTempArea(monitor);
                this.createExportCatalogFile(monitor);
                this.createTheExportFile(monitor);
            }
            catch (Exception exception) {
                this.removeTempFolder(this.m_workFolder);
                monitor.done();
            }
        }
        finally {
            this.removeTempFolder(this.m_workFolder);
            monitor.done();
        }
    }

    private void createTheExportFile(IProgressMonitor monitor) throws IOException, Exception {
        ArchiveUtils.createJarFromDirectory((String)this.m_workFolder.getCanonicalPath(), (String)this.m_exportFilename);
        monitor.worked(1);
    }

    private void copyIconsToTempArea(IProgressMonitor monitor) throws Exception {
        this.checkCancelled(monitor);
        String strImageFolder = this.m_workFolder + this.m_fileSep + IMAGES;
        File imageFolder = new File(strImageFolder);
        if (!imageFolder.mkdir()) {
            this.addError(String.valueOf(Messages.VisPaletteExportOperation_UnableToCreateDirectory) + strImageFolder, null);
            throw new Exception();
        }
        for (IDLVisTool vt : this.m_visTools) {
            if (vt.isSystemDefined()) continue;
            String iconFilename = vt.getIconFilename();
            this.copyFileToFolder(iconFilename, strImageFolder);
        }
        monitor.worked(1);
    }

    private void copyFileToFolder(String iconFilename, String strImageFolder) throws IOException {
        try {
            int len;
            if (iconFilename == null) {
                return;
            }
            File src = new File(iconFilename);
            File dst = new File(String.valueOf(strImageFolder) + this.m_fileSep + src.getName());
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private void removeTempFolder(File tempFolder) {
        if (tempFolder == null) {
            return;
        }
        try {
            this.deleteDirectory(tempFolder);
        }
        catch (IOException iOException) {}
    }

    protected boolean deleteDirectory(File directoryToDelete) throws IOException {
        if (directoryToDelete.isDirectory()) {
            String fileSep = System.getProperty("file.separator");
            String[] filesAndDirs = directoryToDelete.list();
            int numberFiles = filesAndDirs.length;
            int i = 0;
            while (i < numberFiles) {
                File currentFile = new File(String.valueOf(directoryToDelete.getPath()) + fileSep + filesAndDirs[i]);
                if (currentFile.isDirectory()) {
                    if (!this.deleteDirectory(currentFile)) {
                        return false;
                    }
                } else if (!currentFile.delete()) {
                    throw new IOException(String.valueOf(Messages.VisPaletteExportOperation_CantDeleteFileOrDirectory) + currentFile.getAbsolutePath());
                }
                ++i;
            }
            return directoryToDelete.delete();
        }
        throw new IOException(String.valueOf(Messages.VisPaletteExportOperation_CouldntDeleteDirectoryBecause) + directoryToDelete.getAbsolutePath());
    }

    private void createExportCatalogFile(IProgressMonitor monitor) throws Exception {
        this.checkCancelled(monitor);
        String catalogFileName = this.m_workFolder + this.m_fileSep + EXPORT_CATALOG_XML;
        File f = new File(catalogFileName);
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            this.addError(String.valueOf(Messages.VisPaletteExportOperation_UnableToOpenFileForWrite) + catalogFileName, e);
            throw e;
        }
        for (IDLVisTool vt : this.m_visTools) {
            try {
                File ifname = new File(vt.getIconFilename());
                String fileSep = System.getProperty("file.separator");
                String fname = IMAGES + fileSep + ifname.getName();
                vt.setIconFilename(fname, false);
            }
            catch (Exception exception) {}
        }
        ToolCatalogParser.getInstance().writeUserCatalog(f, this.m_visTools, null);
        monitor.worked(1);
    }

    private void checkCancelled(IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            this.addError(Messages.VisPaletteExportOperation_ExportWasCancelled, null);
            throw new Exception();
        }
    }

    private File createTempFolder(IProgressMonitor monitor) throws Exception {
        this.checkCancelled(monitor);
        String homeDir = System.getProperty("user.home");
        File tempFolder = null;
        try {
            boolean bDone = false;
            int n = 0;
            while (!bDone) {
                String tmpFolderName = String.valueOf(homeDir) + this.m_fileSep + ".vis_tmp_" + n++;
                tempFolder = new File(tmpFolderName);
                if (tempFolder.exists()) continue;
                if (!tempFolder.mkdir()) {
                    this.addError(String.valueOf(Messages.VisPaletteExportOperation_UnableToCreateDirectory) + tmpFolderName, null);
                    tempFolder = null;
                    throw new Exception();
                }
                bDone = true;
            }
        }
        catch (Exception exception) {}
        monitor.worked(1);
        return tempFolder;
    }

    protected void addError(String message, Throwable e) {
        this.m_errorTable.add(new Status(4, "com.rsi.idldt.toolpalette", 0, message, e));
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.m_errorTable.size()];
        this.m_errorTable.toArray(errors);
        return new MultiStatus("com.rsi.idldt.toolpalette", 0, errors, Messages.VisPaletteExportOperation_ProblemsExportingToolPalette, null);
    }
}

