/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ScrolledCompositeWithGradientBackground
extends ScrolledComposite {
    Image m_oldBackgroundImage = null;
    Composite m_instance = null;

    public ScrolledCompositeWithGradientBackground(Composite parent, int style) {
        super(parent, style);
        this.addCompositeBackground();
        this.m_instance = this;
    }

    protected void addCompositeBackground() {
        this.setBackgroundMode(2);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Composite comp = (Composite)event.widget;
                Display display = comp.getDisplay();
                Rectangle rect = comp.getClientArea();
                Image newImage = new Image((Device)display, 1, Math.max(1, rect.height));
                GC gc = new GC((Drawable)newImage);
                gc.setForeground(display.getSystemColor(22));
                gc.setBackground(display.getSystemColor(1));
                gc.fillGradientRectangle(rect.x, rect.y, 1, rect.height, true);
                gc.dispose();
                ScrolledCompositeWithGradientBackground.this.m_instance.setBackgroundImage(newImage);
                if (ScrolledCompositeWithGradientBackground.this.m_oldBackgroundImage != null) {
                    ScrolledCompositeWithGradientBackground.this.m_oldBackgroundImage.dispose();
                }
                ScrolledCompositeWithGradientBackground.this.m_oldBackgroundImage = newImage;
            }
        });
    }

    public void dispose() {
        if (this.m_oldBackgroundImage != null) {
            this.m_oldBackgroundImage.dispose();
        }
    }
}

