/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLKeyword;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.proeditor.utils.ProWordDetector;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldWithAssist {
    protected static final String CTRL_PLUS_SPACE = "Ctrl+Space";
    protected ControlDecoration m_controlDecoration;
    protected FieldDecoration m_fieldDecoration;
    protected Text m_text;
    protected ContentAssistType m_proposalType;
    protected Text m_procNameText = null;
    protected Text m_positionalArgText = null;
    int m_proposalRangeEnd;
    int m_proposalRangeStart;
    private String m_contentAssistKeySeq;

    public FieldWithAssist(Text text) {
        this.m_text = text;
        this.m_proposalType = ContentAssistType.PROCEDURE_NAME;
        this.installContentProposalAdapter((IControlContentAdapter)new TextContentAdapter());
    }

    public FieldWithAssist(Text text, Text procNameText, Text positionalArgText) {
        this.m_text = text;
        this.m_proposalType = ContentAssistType.KEYWORDS;
        this.m_procNameText = procNameText;
        this.m_positionalArgText = positionalArgText;
        this.installContentProposalAdapter((IControlContentAdapter)new TextContentAdapter());
    }

    protected String getContentAssistKeySequence() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        String seq = bindingService.getBestActiveBindingFormattedFor("com.rsi.idldt.ui.commands.cmdLine.ContentAssist");
        if (seq == null) {
            seq = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
        if (seq == null || "(null)".equals(seq)) {
            seq = "";
        }
        return seq;
    }

    void installContentProposalAdapter(IControlContentAdapter contentAdapter) {
        KeyStroke keyStroke;
        try {
            this.m_contentAssistKeySeq = this.getContentAssistKeySequence();
            keyStroke = KeyStroke.getInstance((String)this.m_contentAssistKeySeq);
        }
        catch (Exception exception) {
            try {
                keyStroke = KeyStroke.getInstance((String)CTRL_PLUS_SPACE);
                this.m_contentAssistKeySeq = keyStroke.format();
            }
            catch (Exception exception2) {
                keyStroke = KeyStroke.getInstance((int)0x1000013);
                this.m_contentAssistKeySeq = keyStroke.format();
            }
        }
        char[] autoActivationCharacters = null;
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.m_text, contentAdapter, this.getContentProposalProvider(), keyStroke, autoActivationCharacters);
        adapter.setAutoActivationDelay(500);
        adapter.setPropagateKeys(true);
        adapter.setFilterStyle(1);
        adapter.setPopupSize(new Point(200, 300));
        if (this.m_proposalType == ContentAssistType.PROCEDURE_NAME) {
            adapter.setProposalAcceptanceStyle(2);
        } else {
            adapter.setProposalAcceptanceStyle(3);
            adapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    try {
                        String textInWidget = FieldWithAssist.this.m_text.getText();
                        String proposalText = proposal.getContent();
                        if (textInWidget == null || textInWidget.length() == 0) {
                            FieldWithAssist.this.m_text.setText(proposalText);
                            int offset = proposalText.length();
                            FieldWithAssist.this.m_text.setSelection(offset, offset);
                        } else {
                            StringBuilder finalText = new StringBuilder();
                            char[] chars = textInWidget.toCharArray();
                            int i = 0;
                            while (i < FieldWithAssist.this.m_proposalRangeStart) {
                                finalText.append(chars[i]);
                                ++i;
                            }
                            finalText.append(proposalText);
                            int cursorOffset = finalText.length();
                            int i2 = FieldWithAssist.this.m_proposalRangeEnd + 1;
                            while (i2 < chars.length) {
                                finalText.append(chars[i2]);
                                ++i2;
                            }
                            FieldWithAssist.this.m_text.setText(finalText.toString());
                            FieldWithAssist.this.m_text.setSelection(cursorOffset, cursorOffset);
                        }
                    }
                    catch (Exception exception) {}
                }
            });
        }
        this.initContentAssistDecoration();
    }

    protected void initContentAssistDecoration() {
        this.m_controlDecoration = new ControlDecoration((Control)this.m_text, 16512);
        this.m_controlDecoration.setShowOnlyOnFocus(true);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        this.m_fieldDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        this.m_controlDecoration.setImage(this.m_fieldDecoration.getImage());
        this.setContentAssistDecorationDescription();
    }

    private void setContentAssistDecorationDescription() {
        String DESC = String.valueOf(Messages.FieldWithAssist_ContentAssistAvailable) + " (" + this.m_contentAssistKeySeq + ")";
        this.m_fieldDecoration.setDescription(DESC);
        this.m_controlDecoration.setDescriptionText(DESC);
    }

    protected IContentProposalProvider getContentProposalProvider() {
        if (this.m_proposalType == ContentAssistType.PROCEDURE_NAME) {
            return new ProcedureNameProposalProvider();
        }
        return new KeywordAndMacroProposalProvider();
    }

    public IContentProposal[] turnProposalTreeIntoProposalArray(TreeSet<IContentProposal> proposalTree) {
        IContentProposal[] result = new IContentProposal[proposalTree.size()];
        int index = 0;
        Iterator<IContentProposal> iterator = proposalTree.iterator();
        while (iterator.hasNext()) {
            IContentProposal p;
            result[index] = p = iterator.next();
            ++index;
        }
        return result;
    }

    protected String getKeywordPrefix(String theContents, int position) {
        if (theContents == null || theContents.length() == 0) {
            return null;
        }
        String contents = theContents;
        try {
            contents = contents.substring(0, position);
            char[] ca = contents.toCharArray();
            int length = ca.length;
            int start = 0;
            this.m_proposalRangeEnd = length - 1;
            this.m_proposalRangeStart = 0;
            int i = length - 1;
            while (i > -1) {
                if (ca[i] != '?' && !ProWordDetector.isIDLIdentifierCharacter((char)ca[i])) {
                    start = ca[i] == '%' ? i : i + 1;
                    this.m_proposalRangeStart = start;
                    break;
                }
                --i;
            }
            String keyword = contents.substring(start);
            return keyword.toUpperCase();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContentAssistType {
        PROCEDURE_NAME,
        KEYWORDS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KeywordAndMacroProposalProvider
    implements IContentProposalProvider {
        protected KeywordAndMacroProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            String newline = System.getProperty("line.separator");
            String ACTION_MACRO = String.valueOf(Messages.FieldWithAssist_ActionMacro) + newline + "  ";
            TreeSet<IContentProposal> proposalTree = new TreeSet<IContentProposal>();
            IIDLDOMManager dm = IDLDOMManager.getActiveManager();
            if (dm == null) {
                IContentProposal[] zeroLengthResult = new IContentProposal[]{};
                return zeroLengthResult;
            }
            String keywordPrefix = FieldWithAssist.this.getKeywordPrefix(contents, position);
            IIDLRoutine routine = this.findRoutineInDOM(FieldWithAssist.this.m_procNameText.getText().trim());
            if (routine != null) {
                this.addRoutineKeywordsToProposals(proposalTree, routine, keywordPrefix);
            }
            String[] macros = IDLVisTool.MACRO_VARIABLES;
            String[] descriptions = IDLVisTool.MACRO_DESCRIPTIONS;
            int i = 0;
            while (i < macros.length) {
                String macro = macros[i].toUpperCase();
                if (keywordPrefix == null || keywordPrefix.length() <= 0 || macro.startsWith(keywordPrefix)) {
                    Proposal p = new Proposal(macro, String.valueOf(ACTION_MACRO) + descriptions[i]);
                    proposalTree.add(p);
                }
                ++i;
            }
            String posArgs = FieldWithAssist.this.m_positionalArgText.getText();
            if (posArgs != null && posArgs.trim().length() > 0) {
                String[] args = posArgs.split(",");
                int i2 = 0;
                while (i2 < args.length) {
                    String macro = "%" + Integer.toString(i2 + 1);
                    if (keywordPrefix == null || keywordPrefix.length() <= 0 || macro.startsWith(keywordPrefix)) {
                        String description = String.valueOf(Messages.FieldWithAssist_SubstitutePositionalArgument) + " " + Integer.toString(i2 + 1);
                        Proposal p = new Proposal(macro, String.valueOf(ACTION_MACRO) + description);
                        proposalTree.add(p);
                    }
                    ++i2;
                }
            }
            IContentProposal[] finalProposalArray = FieldWithAssist.this.turnProposalTreeIntoProposalArray(proposalTree);
            return finalProposalArray;
        }

        private void addRoutineKeywordsToProposals(TreeSet<IContentProposal> proposalTree, IIDLRoutine routine, String keywordPrefix) {
            String newline = System.getProperty("line.separator");
            IIDLKeyword[] keywords = routine.getKeywords();
            String KEYWORD_DESC = String.valueOf(routine.getElementName()) + " " + Messages.FieldWithAssist_Keyword + newline + "  ";
            if (keywordPrefix == null || !keywordPrefix.startsWith("%")) {
                int i = 0;
                while (i < keywords.length) {
                    String keyword = keywords[i].getElementName().toUpperCase();
                    if (!(keyword.equalsIgnoreCase("_REF_EXTRA") || keyword.equalsIgnoreCase("_EXTRA") || keywordPrefix != null && keywordPrefix.length() > 0 && !keyword.startsWith(keywordPrefix))) {
                        Proposal p = new Proposal(keyword, KEYWORD_DESC);
                        proposalTree.add(p);
                    }
                    ++i;
                }
            }
        }

        protected IIDLRoutine findRoutineInDOM(String procName) {
            if (procName == null || procName.length() == 0) {
                return null;
            }
            IIDLDOMManager dm = IDLDOMManager.getActiveManager();
            if (dm == null) {
                return null;
            }
            int flags = 117;
            IIDLRoutine[] routines = dm.findRoutines(procName, flags);
            if (routines == null || routines.length == 0) {
                return null;
            }
            IIDLRoutine routine = null;
            if (routines.length > 1) {
                int i = 0;
                while (i < routines.length) {
                    IIDLRoutine r = routines[i];
                    if (r.getFilename() == null) {
                        routine = r;
                        break;
                    }
                    ++i;
                }
            }
            if (routine == null) {
                routine = routines[0];
            }
            return routine;
        }
    }

    protected class ProcedureNameProposalProvider
    implements IContentProposalProvider {
        protected ProcedureNameProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            TreeSet<IContentProposal> proposalTree = new TreeSet<IContentProposal>();
            String token = contents.substring(0, position);
            IIDLDOMManager dm = IDLDOMManager.getActiveManager();
            if (dm == null) {
                IContentProposal[] zeroLengthResult = new IContentProposal[]{};
                return zeroLengthResult;
            }
            int flags = 565;
            if (token.length() == 0) {
                flags |= 0x800;
            }
            Object[] routines = dm.findRoutines(token, flags);
            Arrays.sort(routines);
            int i = 0;
            while (i < routines.length) {
                String rname = routines[i].getRoutineName();
                if (!rname.startsWith(".") && rname.indexOf("...") <= -1 && rname.length() != 0) {
                    Proposal p = new Proposal(rname.toUpperCase(), null);
                    proposalTree.add(p);
                }
                ++i;
            }
            IContentProposal[] finalProposalArray = FieldWithAssist.this.turnProposalTreeIntoProposalArray(proposalTree);
            return finalProposalArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Proposal
    implements IContentProposal,
    Comparable<Object> {
        protected String m_value;
        protected String m_doc;

        public Proposal(String value, String doc) {
            this.m_value = value;
            this.m_doc = doc;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Proposal)) {
                return false;
            }
            Proposal p = (Proposal)obj;
            return p.getContent().equalsIgnoreCase(this.getContent());
        }

        @Override
        public int compareTo(Object obj) {
            if (!(obj instanceof Proposal)) {
                return -1;
            }
            Proposal p = (Proposal)obj;
            return this.getContent().compareToIgnoreCase(p.getContent());
        }

        public String getContent() {
            return this.m_value;
        }

        public int getCursorPosition() {
            return this.m_value.length();
        }

        public String getDescription() {
            return this.m_doc;
        }

        public String getLabel() {
            return this.m_value;
        }
    }
}

