/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import com.rsi.idldt.toolpalette.ActionSig;
import com.rsi.idldt.toolpalette.IDLVisTool;
import com.rsi.idldt.toolpalette.ToolPalettePlugin;
import com.rsi.idldt.toolpalette.internal.ui.LabelUtils;
import com.rsi.idldt.toolpalette.internal.ui.Messages;
import com.rsi.idldt.toolpalette.internal.ui.ToolPaletteExportOperation;
import com.rsi.idldt.ui.UIPlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportVisToolDialog
extends Dialog {
    protected static final String HELP_ID = "com.rsi.idldt.toolpalette.export_tool_dialog_help";
    protected static final String INVALID_OUTPUT_FILENAME = Messages.ExportVisToolDialog_InvalidOutputFilename;
    private static final String MSG_SELECT_AT_LEAST_ONE_ACTION_FOR_EXPORT = Messages.ExportVisToolDialog_SelectAtLeastOneActionForExport;
    public static final String MSG_SUPPLY_OUTPUT_FNAME = Messages.ExportVisToolDialog_SupplyAValidOutputFilename;
    private static final String EXPORT_FILE_EXTENSION = "vexp";
    private static final String DEFAULT_EXPORT_FILENAME = "toolpalette.vexp";
    private static final String FILTER_PATH = "filter_path";
    protected static final String CD_VISTOOL = "visTool";
    public final String MSG_NORMAL_TEXT = Messages.ExportVisToolDialog_SelectActionsForExportAndExportFilename;
    public final int MASK_ACTIONS = 0;
    public final int MASK_OUTPUT_FILE = 1;
    protected Image m_errorIcon = null;
    protected Image m_titleImage = null;
    protected String m_dialogTitle;
    protected Label m_messageLabel;
    protected Label m_messageImageLabel;
    protected Button m_okButton;
    Vector<MyToolControl> m_visToolsOnDisplay = new Vector();
    private Vector<IDLVisTool> m_visTools;
    private Vector<Integer> m_visToolShowOrder;
    protected BitSet m_validator = new BitSet(2);
    private String OUTPUT_FILENAME = "outputFilename";
    private String SELECTED_VISTOOLS = "selectedVisTools";
    private String CD_FIELD_NAME = "fieldName";
    private boolean m_inputReceived = false;
    private HashMap<String, String> m_messageMap = new HashMap();
    protected Label m_itemSelectedText;
    protected Text m_exportFilenameText;
    protected Composite m_actionsComposite;
    protected Composite m_toolsComposite;
    protected MyToolControl m_activeToolControl = null;

    public ExportVisToolDialog(Shell parentShell, String dialogTitle, Vector<IDLVisTool> visTools, Vector<Integer> showOrder) {
        super(parentShell);
        this.m_dialogTitle = dialogTitle;
        this.m_visTools = visTools;
        this.m_visToolShowOrder = showOrder;
        this.m_validator.set(0, 2, true);
        this.m_messageMap.put(this.OUTPUT_FILENAME, MSG_SUPPLY_OUTPUT_FNAME);
        this.m_messageMap.put(this.SELECTED_VISTOOLS, MSG_SELECT_AT_LEAST_ONE_ACTION_FOR_EXPORT);
    }

    protected IDialogSettings getSettings() {
        String sectionName = "export_vistool_dialog_settings";
        IDialogSettings settings = UIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = UIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected void disposeImages() {
        if (this.m_errorIcon != null) {
            this.m_errorIcon.dispose();
        }
        if (this.m_titleImage != null) {
            this.m_titleImage.dispose();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_dialogTitle != null) {
            shell.setText(this.m_dialogTitle);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExportVisToolDialog.this.disposeImages();
            }
        });
    }

    protected void validateTotalActionExportCount() {
        this.m_inputReceived = true;
        int totalCount = 0;
        for (MyToolControl tc : this.m_visToolsOnDisplay) {
            totalCount += tc.getNumActionsToExport();
        }
        if (totalCount > 0) {
            this.m_validator.set(0, false);
            if (this.m_messageMap.containsKey(this.SELECTED_VISTOOLS)) {
                this.m_messageMap.remove(this.SELECTED_VISTOOLS);
            }
        } else {
            this.m_validator.set(0, true);
            this.m_messageMap.put(this.SELECTED_VISTOOLS, MSG_SELECT_AT_LEAST_ONE_ACTION_FOR_EXPORT);
        }
        this.setOkayButtonEnablement();
    }

    protected void validateInput(Text text) {
        this.m_inputReceived = true;
        String fieldName = (String)text.getData(this.CD_FIELD_NAME);
        String value = text.getText().trim();
        if (fieldName.equalsIgnoreCase(this.OUTPUT_FILENAME)) {
            this.m_validator.set(1, !this.validOutputFilename(value));
        }
        this.setOkayButtonEnablement();
    }

    private void removeAllMessagesAboutOutputDestination() {
        if (this.m_messageMap.containsKey(this.OUTPUT_FILENAME)) {
            this.m_messageMap.remove(this.OUTPUT_FILENAME);
        }
    }

    private boolean validOutputFilename(String value) {
        File file;
        block8: {
            block7: {
                block6: {
                    this.removeAllMessagesAboutOutputDestination();
                    try {
                        file = new File(value);
                        if (!file.isDirectory()) break block6;
                        this.m_messageMap.put(this.OUTPUT_FILENAME, INVALID_OUTPUT_FILENAME);
                        return false;
                    }
                    catch (Exception e) {
                        this.m_messageMap.put(this.OUTPUT_FILENAME, e.getLocalizedMessage());
                        return false;
                    }
                }
                if (!file.exists()) break block7;
                return true;
            }
            String s = file.getName();
            if (s != null) break block8;
            this.m_messageMap.put(this.OUTPUT_FILENAME, INVALID_OUTPUT_FILENAME);
            return false;
        }
        if (file.createNewFile()) {
            file.delete();
            return true;
        }
        this.m_messageMap.put(this.OUTPUT_FILENAME, INVALID_OUTPUT_FILENAME);
        return false;
    }

    protected Image getErrorIcon() {
        if (this.m_errorIcon == null) {
            URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/stop.png"), null);
            this.m_errorIcon = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.m_errorIcon;
    }

    protected void updateMessage(boolean bAllGood) {
        this.m_messageLabel.setForeground(this.m_messageLabel.getDisplay().getSystemColor(2));
        if (bAllGood || !this.m_inputReceived) {
            this.m_messageLabel.setText(this.MSG_NORMAL_TEXT);
            this.m_messageImageLabel.setImage(null);
        } else {
            this.m_messageLabel.setText(this.getErrorMessage());
            this.m_messageImageLabel.setImage(this.getErrorIcon());
        }
        this.m_messageLabel.getParent().getParent().getParent().layout(true);
    }

    protected String getErrorMessage() {
        String message = "";
        Iterator<String> iterator = this.m_messageMap.values().iterator();
        if (iterator.hasNext()) {
            String m;
            message = m = iterator.next();
        }
        return message;
    }

    protected void setOkayButtonEnablement() {
        if (this.m_okButton == null || this.m_okButton.isDisposed()) {
            return;
        }
        if (this.m_validator.isEmpty()) {
            this.m_okButton.setEnabled(true);
            this.updateMessage(true);
        } else {
            this.m_okButton.setEnabled(false);
            this.updateMessage(false);
        }
    }

    protected void addValidateModifier(Object obj) {
        if (obj instanceof Text) {
            Text text = (Text)obj;
            text.addListener(24, new Listener(){

                public void handleEvent(Event e) {
                    ExportVisToolDialog.this.validateInput((Text)e.widget);
                }
            });
        }
    }

    protected void createTitleArea(Composite parent) {
        Composite titleAreaComposite = new Composite(parent, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        titleAreaComposite.setLayoutData((Object)gd);
        titleAreaComposite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        titleAreaComposite.setLayout((Layout)gl);
        titleAreaComposite.setBackgroundMode(2);
        Composite c = new Composite(titleAreaComposite, 0);
        c.setBackgroundMode(2);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        Label l = new Label(c, 0);
        l.setText(this.m_dialogTitle);
        LabelUtils.makeLabelBold(l);
        LabelUtils.makeLabelHeightChange(l, 2);
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.verticalIndent = 3;
        l.setLayoutData((Object)gd);
        Composite msgComposite = new Composite(c, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        msgComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalIndent = 3;
        gd.verticalIndent = 5;
        msgComposite.setLayoutData((Object)gd);
        this.m_messageImageLabel = new Label(msgComposite, 0);
        this.m_messageImageLabel.setImage(null);
        this.m_messageLabel = new Label(msgComposite, 0);
        l = new Label(titleAreaComposite, 0);
        URL url = FileLocator.find((Bundle)ToolPalettePlugin.getDefault().getBundle(), (IPath)new Path("icons/export_dialog.png"), null);
        this.m_titleImage = ImageDescriptor.createFromURL((URL)url).createImage();
        l.setImage(this.m_titleImage);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 2));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTitleArea(composite);
        this.createActionSelectionGroup(composite);
        this.createExportFileDestinationGroup(composite);
        ExportVisToolDialog.applyDialogFont((Control)composite);
        this.setOkayButtonEnablement();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_ID);
        return composite;
    }

    private void createExportFileDestinationGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.ExportVisToolDialog_ExportFileName);
        GridLayout gl = new GridLayout(1, false);
        group.setLayout((Layout)gl);
        GridData gd = new GridData(4, 0, true, false, 2, 1);
        group.setLayoutData((Object)gd);
        Composite c = new Composite((Composite)group, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        gd = new GridData(4, 0, true, false, 1, 1);
        gd.horizontalIndent = 0;
        c.setLayoutData((Object)gd);
        this.m_exportFilenameText = new Text(c, 2048);
        this.addValidateModifier(this.m_exportFilenameText);
        this.m_exportFilenameText.setData(this.CD_FIELD_NAME, (Object)this.OUTPUT_FILENAME);
        this.m_exportFilenameText.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.m_exportFilenameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        final Button browse = new Button(c, 8);
        browse.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        browse.setText(Messages.ExportVisToolDialog_Browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(browse.getShell(), 8192);
                dialog.setText(Messages.ExportVisToolDialog_Save);
                dialog.setFilterExtensions(new String[]{"*.*", "*.vexp"});
                dialog.setFilterNames(new String[]{Messages.ExportVisToolDialog_AllFiles, String.valueOf(ExportVisToolDialog.EXPORT_FILE_EXTENSION.toUpperCase()) + " (*." + ExportVisToolDialog.EXPORT_FILE_EXTENSION + ")"});
                dialog.setFilterPath(ExportVisToolDialog.this.getFilterpathForBrowseDialog());
                dialog.setFileName(this.getFilenameForBrowseDialog());
                String file = dialog.open();
                if (file != null && file.length() > 0) {
                    ExportVisToolDialog.this.m_exportFilenameText.setText(file);
                }
                String filterPath = dialog.getFilterPath();
                ExportVisToolDialog.this.getSettings().put(ExportVisToolDialog.FILTER_PATH, filterPath);
            }

            private String getFilenameForBrowseDialog() {
                String fileName;
                String possName = ExportVisToolDialog.this.m_exportFilenameText.getText().trim();
                if (possName != null) {
                    File f = new File(possName);
                    if ((possName = f.getName()) == null || possName.trim().length() == 0) {
                        possName = ExportVisToolDialog.DEFAULT_EXPORT_FILENAME;
                    }
                    if (!possName.toLowerCase().endsWith(".vexp")) {
                        possName = String.valueOf(possName) + ".vexp";
                    }
                    fileName = possName;
                } else {
                    fileName = ExportVisToolDialog.DEFAULT_EXPORT_FILENAME;
                }
                return fileName;
            }
        });
        String fileSep = System.getProperty("file.separator");
        String defaultName = String.valueOf(this.getFilterpathForBrowseDialog()) + fileSep + DEFAULT_EXPORT_FILENAME;
        this.m_exportFilenameText.setText(defaultName);
        this.validateInput(this.m_exportFilenameText);
        this.m_inputReceived = false;
    }

    protected String getFilterpathForBrowseDialog() {
        String filterPath = this.getSettings().get(FILTER_PATH);
        if (filterPath == null) {
            filterPath = System.getProperty("user.home");
        }
        return filterPath;
    }

    protected void createScrolledCompositeOfActions(Group parentGroup) {
        ScrolledComposite sc = new ScrolledComposite((Composite)parentGroup, 2816);
        sc.setLayout((Layout)new GridLayout(1, false));
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Color listBg = sc.getDisplay().getSystemColor(25);
        sc.setBackground(listBg);
        this.m_actionsComposite = new Composite((Composite)sc, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        this.m_actionsComposite.setLayout((Layout)gl);
        this.m_actionsComposite.setBackground(listBg);
        this.m_actionsComposite.setBackgroundMode(2);
        sc.setContent((Control)this.m_actionsComposite);
    }

    protected void createSelectAllDeselectAllComposite(Group parentGroup) {
        Composite c = new Composite((Composite)parentGroup, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Button b = new Button(c, 0);
        b.setText(Messages.ExportVisToolDialog_SelectAll);
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (MyToolControl tc : ExportVisToolDialog.this.m_visToolsOnDisplay) {
                    tc.setSelection(true);
                }
            }
        });
        b = new Button(c, 0);
        b.setText(Messages.ExportVisToolDialog_DeselectAll);
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (MyToolControl tc : ExportVisToolDialog.this.m_visToolsOnDisplay) {
                    tc.setSelection(false);
                }
            }
        });
    }

    protected void createScrolledCompositeOfTools(Group parentGroup) {
        MyScrolledComposite sc = new MyScrolledComposite((Composite)parentGroup, 2560);
        sc.setLayout((Layout)new GridLayout(1, false));
        this.m_toolsComposite = new Composite((Composite)sc, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        this.m_toolsComposite.setLayout((Layout)gl);
        Color listBg = sc.getDisplay().getSystemColor(25);
        this.m_toolsComposite.setBackground(listBg);
        sc.setBackground(listBg);
        sc.setLayoutData(new GridData(16384, 4, false, true, 1, 1));
        this.populateToolsComposite();
        sc.setContent((Control)this.m_toolsComposite);
    }

    protected void createActionSelectionGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.ExportVisToolDialog_SelectActionsToExport);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        group.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        group.setLayoutData((Object)gd);
        this.createScrolledCompositeOfTools(group);
        this.createScrolledCompositeOfActions(group);
        this.createSelectAllDeselectAllComposite(group);
        if (this.m_visToolsOnDisplay.size() > 0) {
            MyToolControl vt = this.m_visToolsOnDisplay.get(0);
            vt.showActions();
        }
    }

    protected void populateToolsComposite() {
        int i = 0;
        while (i < this.m_visToolShowOrder.size()) {
            Integer idx = this.m_visToolShowOrder.get(i);
            IDLVisTool vt = this.m_visTools.get(idx);
            if (vt.getUserDefinedActions().size() > 0) {
                MyToolControl tc = new MyToolControl(this.m_toolsComposite, vt);
                tc.setLayoutData(new GridData(4, 0, true, false, 1, 1));
                this.m_visToolsOnDisplay.add(tc);
            }
            ++i;
        }
        this.m_toolsComposite.setSize(this.m_toolsComposite.computeSize(-1, -1));
    }

    protected void createSelectAllComposite(Group parentGroup) {
        Composite c = new Composite((Composite)parentGroup, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        Button b = new Button(c, 8);
        b.setText(Messages.ExportVisToolDialog_SelectAll);
        b = new Button(c, 8);
        b.setText(Messages.ExportVisToolDialog_DeselectAll);
        Composite c2 = new Composite(c, 0);
        c2.setLayoutData((Object)new GridData(131072, 0, true, false, 1, 1));
        gl = new GridLayout(2, false);
        gl.marginWidth = 2;
        c2.setLayout((Layout)gl);
    }

    void clearActionComposite() {
        Control[] kids = this.m_actionsComposite.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (!kids[i].isDisposed()) {
                kids[i].dispose();
            }
            ++i;
        }
        this.m_actionsComposite.layout();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        boolean exportSuccess = this.doArchiveExport();
        if (exportSuccess) {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected boolean doArchiveExport() {
        File file;
        boolean success = true;
        Vector<IDLVisTool> toolsToExport = this.getVectorOfToolsToExport();
        String outFileName = this.m_exportFilenameText.getText().trim();
        if (!outFileName.toLowerCase().endsWith(".vexp")) {
            outFileName = String.valueOf(outFileName) + ".vexp";
        }
        if ((file = new File(outFileName)).exists()) {
            Shell shell = this.m_exportFilenameText.getShell();
            if (file.canWrite()) {
                MessageBox box = new MessageBox(shell, 196);
                box.setMessage(Messages.ExportVisToolDialog_OkayToOverwriteQuestion);
                box.setText(Messages.ExportVisToolDialog_FileExists);
                int response = box.open();
                if (response == 128) {
                    return false;
                }
                file.delete();
            } else {
                MessageBox box = new MessageBox(shell, 33);
                box.setMessage(Messages.ExportVisToolDialog_UnableToWriteToOutputFileChooseAnother);
                box.setText(Messages.ExportVisToolDialog_UnableToCreateOutputFile);
                box.open();
                return false;
            }
        }
        success = this.executeExportOperation(new ToolPaletteExportOperation(toolsToExport, outFileName));
        return success;
    }

    private Vector<IDLVisTool> getVectorOfToolsToExport() {
        Vector<IDLVisTool> toolsToExport = new Vector<IDLVisTool>();
        for (MyToolControl t : this.m_visToolsOnDisplay) {
            if (t.getNumActionsToExport() <= 0) continue;
            IDLVisTool vt = new IDLVisTool(t.getToolName(), t.getType(), t.getIconFile());
            Vector<ActionSig> actionsToExport = t.getActionsToExport();
            for (ActionSig sig : actionsToExport) {
                vt.addActionSignature(sig.m_actionType, sig.m_sigSystemOrUser, sig.m_procName, sig.m_overplotCmd, sig.m_argNames, sig.m_staticArgs, sig.m_desc, sig.m_title, null);
            }
            toolsToExport.add(vt);
        }
        return toolsToExport;
    }

    protected boolean executeExportOperation(ToolPaletteExportOperation op) {
        try {
            ProgressMonitorDialog exportWorker = new ProgressMonitorDialog(this.getShell());
            exportWorker.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            MessageBox box = new MessageBox(this.getShell(), 33);
            box.setMessage(e.getTargetException().getLocalizedMessage());
            box.setText(Messages.ExportVisToolDialog_ExportProblems);
            box.open();
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ExportVisToolDialog_ExportProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.m_okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setOkayButtonEnablement();
    }

    protected Control createButtonBar(Composite parent) {
        Composite compTop = new Composite(parent, 0);
        compTop.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compTop.setLayout((Layout)layout);
        compTop.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            this.createHelpImageButton(compTop, helpImage);
        }
        Composite composite = new Composite(compTop, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        toolBar.setLayoutData((Object)new GridData(32));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportVisToolDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    void helpPressed() {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    protected class MyScrolledComposite
    extends ScrolledComposite {
        public MyScrolledComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Control[] kids = this.getChildren();
            if (kids == null || kids.length == 0) {
                return new Point(0, 0);
            }
            Point size = super.computeSize(wHint, hHint, changed);
            size.y = size.y > 600 ? 600 : size.x;
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyToolControl
    extends Composite {
        private static final String INDEX = "Index";
        IDLVisTool m_vt;
        Button m_checkBox;
        ToolItem m_toolItem;
        Vector<ActionSig> m_userDefinedActions;
        boolean[] m_actionState;

        public MyToolControl(Composite parent, IDLVisTool vt) {
            super(parent, 0);
            GridLayout gl = new GridLayout(3, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.horizontalSpacing = 0;
            this.setLayout((Layout)gl);
            this.m_vt = vt;
            this.m_userDefinedActions = this.m_vt.getUserDefinedActions();
            this.m_actionState = new boolean[this.m_userDefinedActions.size()];
            this.createControl();
        }

        public void setSelection(boolean b) {
            this.m_checkBox.setSelection(b);
            this.selectedCheckboxAction(b);
            this.showActions();
        }

        public Vector<ActionSig> getActionsToExport() {
            Vector<ActionSig> vec = new Vector<ActionSig>();
            int i = 0;
            while (i < this.m_actionState.length) {
                if (this.m_actionState[i]) {
                    vec.add(this.m_userDefinedActions.get(i));
                }
                ++i;
            }
            return vec;
        }

        public String getIconFile() {
            return this.m_vt.getIconFilename();
        }

        public int getType() {
            int type = 1;
            if (this.m_vt.isSystemDefined()) {
                type = 0;
            }
            return type;
        }

        public String getToolName() {
            return this.m_vt.getToolName();
        }

        public int getNumActionsToExport() {
            int count = 0;
            int i = 0;
            while (i < this.m_actionState.length) {
                if (this.m_actionState[i]) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        protected void createControl() {
            ToolBar tb = new ToolBar((Composite)this, 256);
            tb.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.m_toolItem = new ToolItem(tb, 8);
            this.m_toolItem.setImage(this.m_vt.getLargeImage());
            this.m_toolItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MyToolControl.this.showActions();
                }
            });
            this.m_checkBox = new Button((Composite)this, 32);
            this.m_checkBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.m_checkBox.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MyToolControl.this.selectedCheckboxAction(MyToolControl.this.m_checkBox.getSelection());
                    MyToolControl.this.showActions();
                }
            });
            Label checkBoxLabel = new Label((Composite)this, 0);
            GridData gd = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd.horizontalIndent = 3;
            checkBoxLabel.setLayoutData((Object)gd);
            checkBoxLabel.setText(this.m_vt.getToolName());
            checkBoxLabel.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    MyToolControl.this.showActions();
                }
            });
            this.setBackgroundMode(2);
            this.unhighlight();
        }

        protected void selectedCheckboxAction(boolean checkBoxSelection) {
            int i = 0;
            while (i < this.m_actionState.length) {
                this.m_actionState[i] = checkBoxSelection;
                ++i;
            }
            ExportVisToolDialog.this.validateTotalActionExportCount();
        }

        protected void updateMasterCheckboxIfNeeded() {
            this.m_checkBox.setSelection(false);
            int i = 0;
            while (i < this.m_actionState.length) {
                if (this.m_actionState[i]) {
                    this.m_checkBox.setSelection(true);
                    break;
                }
                ++i;
            }
            ExportVisToolDialog.this.validateTotalActionExportCount();
        }

        protected void unhighlight() {
            this.setBackground(this.getDisplay().getSystemColor(25));
        }

        protected void highlight() {
            this.setBackground(this.getDisplay().getSystemColor(26));
        }

        public void showActions() {
            if (ExportVisToolDialog.this.m_activeToolControl != null) {
                ExportVisToolDialog.this.m_activeToolControl.unhighlight();
            }
            ExportVisToolDialog.this.m_activeToolControl = this;
            this.highlight();
            ExportVisToolDialog.this.clearActionComposite();
            int i = 0;
            for (ActionSig action : this.m_userDefinedActions) {
                Button b = this.createActionItemInScrolledComposite(action, i);
                b.setSelection(this.m_actionState[i++]);
            }
            ExportVisToolDialog.this.m_actionsComposite.setSize(ExportVisToolDialog.this.m_actionsComposite.computeSize(-1, -1));
            ExportVisToolDialog.this.m_actionsComposite.layout(true);
        }

        protected Button createActionItemInScrolledComposite(ActionSig action, int index) {
            Composite c = new Composite(ExportVisToolDialog.this.m_actionsComposite, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            c.setLayout((Layout)gl);
            c.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Button b = new Button(c, 32);
            b.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            String actionTitle = action.m_title;
            if (actionTitle == null || actionTitle.length() == 0) {
                actionTitle = "No Title";
            }
            b.setText(actionTitle);
            c.setSize(c.computeSize(-1, -1));
            b.setData(INDEX, (Object)new Integer(index));
            b.setToolTipText(this.buildToolTip(action));
            b.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Button b1 = (Button)event.widget;
                    Integer index1 = (Integer)b1.getData(MyToolControl.INDEX);
                    MyToolControl.this.m_actionState[index1.intValue()] = b1.getSelection();
                    MyToolControl.this.updateMasterCheckboxIfNeeded();
                }
            });
            return b;
        }

        private String buildToolTip(ActionSig action) {
            String sargs;
            StringBuilder sb = new StringBuilder();
            sb.append(action.m_procName);
            String parms = action.getCommaDelimitedArgNames();
            if (parms != null && parms.trim().length() > 0) {
                sb.append(", " + parms);
            }
            if ((sargs = action.m_staticArgs) != null && sargs.trim().length() > 0) {
                sb.append(", " + sargs);
            }
            return sb.toString();
        }
    }
}

