/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.toolpalette.internal.ui;

import java.io.IOException;
import java.net.URL;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AniGifPlayer {
    static Display display;
    static GC shellGC;
    static Color shellBackground;
    static ImageLoader loader;
    static ImageData[] imageDataArray;
    static Thread animateThread;
    static Image image;
    static final boolean useGIFBackground = false;
    static boolean stop;

    public static synchronized void play(final Control parent, URL url, int iw, int ih) {
        stop = false;
        display = parent.getDisplay();
        shellGC = new GC((Drawable)parent);
        shellBackground = parent.getBackground();
        loader = new ImageLoader();
        final int y = (parent.getBounds().height - ih) / 2;
        final int x = (parent.getBounds().width - iw) / 2;
        try {
            imageDataArray = loader.load(url.openStream());
            if (imageDataArray.length > 1) {
                animateThread = new Thread("Animation"){

                    public void run() {
                        Image image1 = null;
                        Image offScreenImage = new Image((Device)display, AniGifPlayer.loader.logicalScreenWidth, AniGifPlayer.loader.logicalScreenHeight);
                        GC offScreenImageGC = new GC((Drawable)offScreenImage);
                        offScreenImageGC.setBackground(shellBackground);
                        offScreenImageGC.fillRectangle(0, 0, AniGifPlayer.loader.logicalScreenWidth, AniGifPlayer.loader.logicalScreenHeight);
                        try {
                            try {
                                int imageDataIndex = 0;
                                ImageData imageData = imageDataArray[imageDataIndex];
                                image1 = new Image((Device)display, imageData);
                                offScreenImageGC.drawImage(image1, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                int repeatCount = AniGifPlayer.loader.repeatCount;
                                while (AniGifPlayer.loader.repeatCount == 0 || repeatCount > 0) {
                                    if (parent.isDisposed() || AniGifPlayer.isStopped()) break;
                                    switch (imageData.disposalMethod) {
                                        case 2: {
                                            offScreenImageGC.setBackground(shellBackground);
                                            offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                                            break;
                                        }
                                        case 3: {
                                            offScreenImageGC.drawImage(image1, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                        }
                                    }
                                    imageDataIndex = (imageDataIndex + 1) % imageDataArray.length;
                                    imageData = imageDataArray[imageDataIndex];
                                    image1.dispose();
                                    image1 = new Image((Device)display, imageData);
                                    offScreenImageGC.drawImage(image1, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                    shellGC.drawImage(offScreenImage, x, y);
                                    try {
                                        int ms = imageData.delayTime * 10;
                                        if (ms < 20) {
                                            ms += 30;
                                        }
                                        if (ms < 30) {
                                            ms += 10;
                                        }
                                        Thread.sleep(ms);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    if (imageDataIndex != imageDataArray.length - 1) continue;
                                    --repeatCount;
                                }
                                stop = false;
                            }
                            catch (SWTException sWTException) {
                                System.out.println("There was an error animating the GIF");
                                if (!offScreenImage.isDisposed()) {
                                    offScreenImage.dispose();
                                }
                                if (!offScreenImageGC.isDisposed()) {
                                    offScreenImageGC.dispose();
                                }
                                if (image1 != null && !image1.isDisposed()) {
                                    image1.dispose();
                                }
                            }
                        }
                        finally {
                            if (!offScreenImage.isDisposed()) {
                                offScreenImage.dispose();
                            }
                            if (!offScreenImageGC.isDisposed()) {
                                offScreenImageGC.dispose();
                            }
                            if (image1 != null && !image1.isDisposed()) {
                                image1.dispose();
                            }
                        }
                    }
                };
                animateThread.setDaemon(true);
                animateThread.start();
            }
        }
        catch (SWTException ex) {
            System.out.println("There was an error loading the GIF");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("There was an error loading the GIF");
            ex.printStackTrace();
        }
    }

    public static synchronized void stop() {
        stop = true;
    }

    public static boolean isStopped() {
        return stop;
    }
}

